/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.em.irbs.dialog;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import se.ericsson.lte.rbs.omf.em.ImageHelper;
import se.ericsson.lte.rbs.omf.em.component.AbstractLteDialog;
import se.ericsson.lte.rbs.omf.em.component.LteButton;
import se.ericsson.lte.rbs.omf.em.component.panel.InputDataException;
import se.ericsson.lte.rbs.omf.em.component.panel.ValidatedFieldPanel;
import se.ericsson.lte.rbs.omf.em.irbs.IrbsLogger;
import se.ericsson.lte.rbs.omf.em.validator.EmptyValidator;
import se.ericsson.lte.rbs.omf.em.validator.ValidListener;
import se.ericsson.lte.rbs.omf.em.validator.Validator;

public class RicErrorDialog
extends AbstractLteDialog
implements ValidListener {
    private static final ResourceBundle irbsBundle = ResourceBundle.getBundle("se.ericsson.lte.rbs.omf.em.resources.Irbs", Locale.getDefault());
    private final transient LteButton closeButton;
    private final transient LteButton okButton;
    private final transient ValidatedFieldPanel ricFieldPanel;
    private final JLabel errorMessageLabel;

    public RicErrorDialog(String errorHeader, String errorMessage, Frame parent) throws ImageHelper.ResourceException, InputDataException {
        super(irbsBundle.getString("ricErrorHeader"), parent, true);
        IrbsLogger.logEntering(this.getClass());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.anchor = 17;
        constraints.insets = new Insets(10, 10, 5, 10);
        constraints.gridy = 0;
        constraints.weightx = 0.0;
        JPanel mainPanel = this.getComponentPanel();
        mainPanel.setLayout(new GridBagLayout());
        JPanel ricPanel = new JPanel(new GridBagLayout());
        JPanel headerPanel = new JPanel(new GridBagLayout());
        headerPanel.setBorder(new EtchedBorder());
        headerPanel.setBackground(Color.WHITE);
        ImageIcon iconImage = new ImageIcon(ImageHelper.getImage("icon_LTE_32.gif"));
        JLabel iconLabel = new JLabel(iconImage);
        headerPanel.add((Component)iconLabel, constraints);
        JLabel headerLabel = new JLabel(irbsBundle.getString("ricErrorHeader"));
        Font headerFont = new Font("*Helvetica*", 3, 18);
        headerLabel.setFont(headerFont);
        constraints.weightx = 1.0;
        constraints.anchor = 10;
        headerPanel.add((Component)headerLabel, constraints);
        this.errorMessageLabel = new JLabel(errorHeader);
        Font errorMessageFont = new Font("faultInformation", 1, 14);
        this.errorMessageLabel.setFont(errorMessageFont);
        constraints.gridx = 0;
        constraints.gridwidth = 3;
        constraints.anchor = 17;
        constraints.weightx = 0.0;
        ricPanel.add((Component)this.errorMessageLabel, constraints);
        constraints.weightx = 1.0;
        ricPanel.add((Component)new JLabel(), constraints);
        if (errorMessage.length() > 0) {
            JTextPane errorMessagePane = new JTextPane();
            errorMessagePane.setEditable(false);
            errorMessagePane.setFont(new Font("Courier", 0, 12));
            errorMessagePane.setText(errorMessage);
            errorMessagePane.setBackground(this.getBackground());
            errorMessagePane.setCaretPosition(0);
            errorMessagePane.setPreferredSize(new Dimension(490, 90));
            errorMessagePane.setBorder(BorderFactory.createEmptyBorder());
            constraints.gridx = 0;
            constraints.gridwidth = 3;
            constraints.anchor = 17;
            ++constraints.gridy;
            constraints.weightx = 1.0;
            constraints.weighty = 1.0;
            JScrollPane errorMessageScroll = new JScrollPane(errorMessagePane);
            errorMessageScroll.setBorder(new EtchedBorder());
            errorMessageScroll.setPreferredSize(new Dimension(500, 100));
            ricPanel.add((Component)errorMessageScroll, constraints);
        }
        ricPanel.setBorder(new TitledBorder(new EtchedBorder(), irbsBundle.getString("ricErrorPanelHeader")));
        constraints.gridwidth = 1;
        constraints.gridx = 0;
        ++constraints.gridy;
        constraints.insets = new Insets(10, 5, 5, 5);
        constraints.weightx = 0.0;
        JLabel ricTitleLabel = new JLabel(irbsBundle.getString("ricErrorRIC"));
        ricPanel.add((Component)ricTitleLabel, constraints);
        this.ricFieldPanel = new ValidatedFieldPanel(new EmptyValidator(false), true);
        this.ricFieldPanel.addValidityListener(this);
        constraints.gridx = 1;
        constraints.insets = new Insets(10, 0, 5, 5);
        constraints.weightx = 0.5;
        ricPanel.add((Component)this.ricFieldPanel, constraints);
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        constraints.gridx = 0;
        buttonPanel.add((Component)new JLabel(), constraints);
        String okButtonText = irbsBundle.getString("ricErrorOkButton");
        this.okButton = new LteButton(okButtonText);
        this.okButton.setMnemonic(okButtonText.charAt(0));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent notUsed) {
                RicErrorDialog.this.close();
            }
        });
        String closeButtonText = irbsBundle.getString("ricErrorClose");
        this.closeButton = new LteButton(closeButtonText);
        this.closeButton.setMnemonic(closeButtonText.charAt(0));
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent notUsed) {
                RicErrorDialog.this.close();
            }
        });
        constraints.weightx = 0.0;
        constraints.gridx = 1;
        constraints.insets = new Insets(10, 10, 10, 10);
        buttonPanel.add((Component)this.okButton, constraints);
        constraints.weightx = 0.0;
        constraints.gridx = 2;
        buttonPanel.add((Component)this.closeButton, constraints);
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.gridy = 0;
        constraints.insets = new Insets(2, 2, 0, 2);
        mainPanel.add((Component)headerPanel, constraints);
        ++constraints.gridy;
        constraints.weighty = 1.0;
        constraints.insets = new Insets(2, 2, 0, 2);
        mainPanel.add((Component)ricPanel, constraints);
        ++constraints.gridy;
        constraints.weighty = 0.0;
        mainPanel.add((Component)buttonPanel, constraints);
        this.setLocationRelativeTo(parent);
        this.pack();
        this.okButton.setEnabled(false);
        IrbsLogger.logExiting(this.getClass());
    }

    public void close() {
        this.dispose();
    }

    public void validityChanged(Component component, Validator validator) {
        if (this.ricFieldPanel.validValue()) {
            this.okButton.setEnabled(true);
        } else {
            this.okButton.setEnabled(false);
        }
    }

    public LteButton getCloseButton() {
        return this.closeButton;
    }

    public LteButton getOkButton() {
        return this.okButton;
    }

    protected JLabel getErrorMessage() {
        return this.errorMessageLabel;
    }

    public ValidatedFieldPanel getRicFieldPanel() {
        return this.ricFieldPanel;
    }
}

