/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.em.irbs.dialog;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import se.ericsson.lte.rbs.omf.em.ImageHelper;
import se.ericsson.lte.rbs.omf.em.component.AbstractLteDialog;
import se.ericsson.lte.rbs.omf.em.component.LteButton;
import se.ericsson.lte.rbs.omf.em.component.panel.InputDataException;
import se.ericsson.lte.rbs.omf.em.component.panel.ValidatedFieldPanel;
import se.ericsson.lte.rbs.omf.em.irbs.IrbsLogger;
import se.ericsson.lte.rbs.omf.em.validator.EmptyValidator;
import se.ericsson.lte.rbs.omf.em.validator.RegExpValidator;
import se.ericsson.lte.rbs.omf.em.validator.RemoteFilePathValidator;
import se.ericsson.lte.rbs.omf.em.validator.ValidListener;
import se.ericsson.lte.rbs.omf.em.validator.Validator;

public class SmrsErrorDialog
extends AbstractLteDialog
implements ValidListener {
    private static final ResourceBundle irbsBundle = ResourceBundle.getBundle("se.ericsson.lte.rbs.omf.em.resources.Irbs", Locale.getDefault());
    private final transient LteButton closeButton;
    private final transient LteButton okButton;
    private final transient ValidatedFieldPanel summaryFilePathPanel;
    private final transient ValidatedFieldPanel serverPanel;
    private final transient ValidatedFieldPanel passwordPanel;
    private final transient ValidatedFieldPanel userNamePanel;
    private final JLabel errorMessageLabel;

    public SmrsErrorDialog(String errorHeader, String userName, String server, String summaryFilePath, String errorMessage, Frame parent) throws ImageHelper.ResourceException, InputDataException {
        super(irbsBundle.getString("progressErrorHeader"), parent, true);
        IrbsLogger.logEntering(this.getClass());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.anchor = 17;
        constraints.insets = new Insets(10, 10, 5, 10);
        constraints.gridy = 0;
        constraints.weightx = 0.0;
        JPanel mainPanel = this.getComponentPanel();
        mainPanel.setLayout(new GridBagLayout());
        JPanel userPasswordPanel = new JPanel(new GridBagLayout());
        JPanel headerPanel = new JPanel(new GridBagLayout());
        headerPanel.setBorder(new EtchedBorder());
        headerPanel.setBackground(Color.WHITE);
        ImageIcon iconImage = new ImageIcon(ImageHelper.getImage("icon_LTE_32.gif"));
        JLabel iconLabel = new JLabel(iconImage);
        headerPanel.add((Component)iconLabel, constraints);
        JLabel headerLabel = new JLabel(irbsBundle.getString("progressErrorHeader"));
        Font headerFont = new Font("*Helvetica*", 3, 18);
        headerLabel.setFont(headerFont);
        constraints.weightx = 1.0;
        constraints.anchor = 10;
        headerPanel.add((Component)headerLabel, constraints);
        this.errorMessageLabel = new JLabel(errorHeader);
        Font errorMessageFont = new Font("faultInformation", 1, 14);
        this.errorMessageLabel.setFont(errorMessageFont);
        constraints.gridx = 0;
        constraints.gridwidth = 3;
        constraints.anchor = 17;
        constraints.weightx = 0.0;
        userPasswordPanel.add((Component)this.errorMessageLabel, constraints);
        constraints.weightx = 1.0;
        userPasswordPanel.add((Component)new JLabel(), constraints);
        if (errorMessage.length() > 0) {
            JTextPane errorMessagePane = new JTextPane();
            errorMessagePane.setEditable(false);
            errorMessagePane.setFont(new Font("Courier", 0, 12));
            errorMessagePane.setText(errorMessage);
            errorMessagePane.setBackground(this.getBackground());
            errorMessagePane.setCaretPosition(0);
            errorMessagePane.setPreferredSize(new Dimension(490, 90));
            errorMessagePane.setBorder(BorderFactory.createEmptyBorder());
            constraints.gridx = 0;
            constraints.gridwidth = 3;
            constraints.anchor = 17;
            ++constraints.gridy;
            constraints.weightx = 1.0;
            constraints.weighty = 1.0;
            JScrollPane errorMessageScroll = new JScrollPane(errorMessagePane);
            errorMessageScroll.setBorder(new EtchedBorder());
            errorMessageScroll.setPreferredSize(new Dimension(500, 100));
            userPasswordPanel.add((Component)errorMessageScroll, constraints);
        }
        userPasswordPanel.setBorder(new TitledBorder(new EtchedBorder(), irbsBundle.getString("progressErrorPanelHeader")));
        JLabel userNameTitleLabel = new JLabel(irbsBundle.getString("progressErrorUserName"));
        constraints.gridwidth = 1;
        constraints.gridx = 0;
        ++constraints.gridy;
        constraints.weighty = 0.0;
        constraints.insets = new Insets(10, 5, 5, 5);
        constraints.weightx = 0.0;
        userPasswordPanel.add((Component)userNameTitleLabel, constraints);
        this.userNamePanel = new ValidatedFieldPanel(new EmptyValidator(false));
        this.userNamePanel.setText(userName);
        this.userNamePanel.addValidityListener(this);
        constraints.gridx = 1;
        constraints.insets = new Insets(10, 0, 5, 5);
        constraints.weightx = 0.5;
        userPasswordPanel.add((Component)this.userNamePanel, constraints);
        constraints.gridwidth = 1;
        constraints.gridx = 0;
        ++constraints.gridy;
        constraints.insets = new Insets(10, 5, 5, 5);
        constraints.weightx = 0.0;
        JLabel passwordTitleLabel = new JLabel(irbsBundle.getString("progressErrorPassword"));
        userPasswordPanel.add((Component)passwordTitleLabel, constraints);
        this.passwordPanel = new ValidatedFieldPanel(new EmptyValidator(false), true);
        this.passwordPanel.addValidityListener(this);
        constraints.gridx = 1;
        constraints.insets = new Insets(10, 0, 5, 5);
        constraints.weightx = 0.5;
        userPasswordPanel.add((Component)this.passwordPanel, constraints);
        JLabel serverTitleLabel = new JLabel(irbsBundle.getString("progressErrorServer"));
        constraints.gridwidth = 1;
        constraints.gridx = 0;
        ++constraints.gridy;
        constraints.insets = new Insets(10, 5, 5, 5);
        constraints.weightx = 0.0;
        userPasswordPanel.add((Component)serverTitleLabel, constraints);
        this.serverPanel = new ValidatedFieldPanel(new RegExpValidator(RegExpValidator.NON_EMPTY_IP_AND_HOST_PATTERN));
        this.serverPanel.setText(server);
        this.serverPanel.addValidityListener(this);
        constraints.gridx = 1;
        constraints.insets = new Insets(10, 0, 5, 5);
        constraints.weightx = 0.5;
        userPasswordPanel.add((Component)this.serverPanel, constraints);
        JLabel summaryFileTitleLabel = new JLabel(irbsBundle.getString("progressErrorSummaryFile"));
        constraints.gridwidth = 1;
        constraints.gridx = 0;
        ++constraints.gridy;
        constraints.insets = new Insets(10, 5, 5, 5);
        constraints.weightx = 0.0;
        userPasswordPanel.add((Component)summaryFileTitleLabel, constraints);
        this.summaryFilePathPanel = new ValidatedFieldPanel(new RemoteFilePathValidator(false, true, true));
        this.summaryFilePathPanel.setText(summaryFilePath);
        this.summaryFilePathPanel.addValidityListener(this);
        constraints.gridx = 1;
        constraints.insets = new Insets(10, 0, 5, 5);
        constraints.weightx = 0.5;
        userPasswordPanel.add((Component)this.summaryFilePathPanel, constraints);
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        constraints.gridx = 0;
        buttonPanel.add((Component)new JLabel(), constraints);
        String okButtonText = irbsBundle.getString("progressErrorOkButton");
        this.okButton = new LteButton(okButtonText);
        this.okButton.setMnemonic(okButtonText.charAt(0));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent notUsed) {
                SmrsErrorDialog.this.close();
            }
        });
        String closeButtonText = irbsBundle.getString("progressErrorClose");
        this.closeButton = new LteButton(closeButtonText);
        this.closeButton.setMnemonic(closeButtonText.charAt(0));
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent notUsed) {
                SmrsErrorDialog.this.close();
            }
        });
        constraints.weightx = 0.0;
        constraints.gridx = 1;
        constraints.insets = new Insets(10, 10, 10, 10);
        buttonPanel.add((Component)this.okButton, constraints);
        constraints.weightx = 0.0;
        constraints.gridx = 2;
        buttonPanel.add((Component)this.closeButton, constraints);
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.gridy = 0;
        constraints.insets = new Insets(2, 2, 0, 2);
        mainPanel.add((Component)headerPanel, constraints);
        ++constraints.gridy;
        constraints.weighty = 1.0;
        constraints.insets = new Insets(2, 2, 0, 2);
        mainPanel.add((Component)userPasswordPanel, constraints);
        ++constraints.gridy;
        constraints.weighty = 0.0;
        mainPanel.add((Component)buttonPanel, constraints);
        this.setLocationRelativeTo(parent);
        this.pack();
        this.okButton.setEnabled(false);
        IrbsLogger.logExiting(this.getClass());
    }

    public void close() {
        this.dispose();
    }

    public void validityChanged(Component component, Validator validator) {
        if (this.passwordPanel.validValue() && this.userNamePanel.validValue() && this.serverPanel.validValue() && this.summaryFilePathPanel.validValue()) {
            this.okButton.setEnabled(true);
        } else {
            this.okButton.setEnabled(false);
        }
    }

    public LteButton getCloseButton() {
        return this.closeButton;
    }

    public LteButton getOkButton() {
        return this.okButton;
    }

    protected JLabel getErrorMessage() {
        return this.errorMessageLabel;
    }

    public ValidatedFieldPanel getServerPanel() {
        return this.serverPanel;
    }

    public ValidatedFieldPanel getSummaryFilePathPanel() {
        return this.summaryFilePathPanel;
    }

    public ValidatedFieldPanel getUserNamePanel() {
        return this.userNamePanel;
    }

    public ValidatedFieldPanel getPasswordPanel() {
        return this.passwordPanel;
    }
}

