/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.em.irbs.dialog;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.border.EtchedBorder;
import javax.swing.filechooser.FileFilter;
import se.ericsson.lte.rbs.omf.em.ImageHelper;
import se.ericsson.lte.rbs.omf.em.component.AbstractLteFrame;
import se.ericsson.lte.rbs.omf.em.component.LteButton;
import se.ericsson.lte.rbs.omf.em.irbs.IrbsException;
import se.ericsson.lte.rbs.omf.em.irbs.IrbsHelper;
import se.ericsson.lte.rbs.omf.em.irbs.IrbsLogger;
import se.ericsson.lte.rbs.omf.em.irbs.component.menu.MenuBar;

public class ViewFileDialog
extends AbstractLteFrame {
    private static final ResourceBundle irbsBundle = ResourceBundle.getBundle("se.ericsson.lte.rbs.omf.em.resources.Irbs", Locale.getDefault());
    protected transient long fileLength = -1L;
    private final transient File file;
    private final transient JEditorPane textEditPane;
    private transient boolean isAlive = true;
    private final transient LteButton closeButton;

    public ViewFileDialog(Frame parent, String title, String header, String filePath) throws ImageHelper.ResourceException, IOException, IrbsException {
        super(title + " - " + filePath, false);
        IrbsLogger.logEntering(this.getClass());
        ViewFileMenu viewFileMenu = new ViewFileMenu();
        this.setJMenuBar(viewFileMenu);
        this.file = new File(filePath);
        this.fileLength = this.file.length();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.anchor = 17;
        constraints.insets = new Insets(10, 10, 5, 10);
        constraints.gridy = 0;
        constraints.weightx = 0.0;
        JPanel mainPanel = this.getComponentPanel();
        mainPanel.setLayout(new GridBagLayout());
        JPanel headerPanel = new JPanel(new GridBagLayout());
        headerPanel.setBorder(new EtchedBorder());
        headerPanel.setBackground(Color.WHITE);
        ImageIcon iconImage = new ImageIcon(ImageHelper.getImage("icon_LTE_32.gif"));
        JLabel iconLabel = new JLabel(iconImage);
        headerPanel.add((Component)iconLabel, constraints);
        JLabel headerLabel = new JLabel(header);
        Font headerFont = new Font("*Helvetica*", 3, 24);
        headerLabel.setFont(headerFont);
        constraints.weightx = 1.0;
        constraints.anchor = 10;
        headerPanel.add((Component)headerLabel, constraints);
        constraints.anchor = 17;
        this.textEditPane = new JTextPane();
        this.textEditPane.setEditable(false);
        this.textEditPane.setFont(new Font("Courier", 0, 12));
        this.textEditPane.setText(IrbsHelper.getFileContents(this.file).toString());
        this.textEditPane.setMinimumSize(new Dimension(350, 300));
        this.textEditPane.setBorder(new EtchedBorder());
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        String closeButtonText = irbsBundle.getString("reportCloseButton");
        this.closeButton = new LteButton(closeButtonText);
        this.closeButton.setMnemonic(closeButtonText.charAt(0));
        this.closeButton.addActionListener(this.createCloseListener());
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        buttonPanel.add((Component)new JLabel(), constraints);
        constraints.weightx = 0.0;
        constraints.gridx = 1;
        constraints.insets = new Insets(5, 10, 5, 20);
        buttonPanel.add((Component)this.closeButton, constraints);
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.gridy = 0;
        constraints.insets = new Insets(2, 2, 0, 2);
        mainPanel.add((Component)headerPanel, constraints);
        ++constraints.gridy;
        constraints.weighty = 1.0;
        constraints.insets = new Insets(2, 2, 0, 2);
        mainPanel.add((Component)new JScrollPane(this.textEditPane), constraints);
        ++constraints.gridy;
        constraints.weighty = 0.0;
        mainPanel.add((Component)buttonPanel, constraints);
        this.createDocumentListener();
        this.setSize(new Dimension(800, 800));
        this.setLocationRelativeTo(parent);
        IrbsLogger.logExiting(this.getClass());
    }

    protected LteButton getCloseButton() {
        return this.closeButton;
    }

    private ActionListener createCloseListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent notUsed) {
                ViewFileDialog.this.close();
            }
        };
    }

    private ActionListener createSaveListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent notUsed) {
                JFileChooser fileChooser = new JFileChooser(MenuBar.CURRENT_FILE);
                fileChooser.setFileFilter(ViewFileDialog.this.createSaveFilter());
                int returnVal = IrbsHelper.testMode ? 0 : fileChooser.showSaveDialog(ViewFileDialog.this.getParent());
                if (ViewFileDialog.this.file != null && returnVal == 0) {
                    ViewFileDialog.this.saveFile(fileChooser);
                }
            }
        };
    }

    private FileFilter createSaveFilter() {
        return new FileFilter(){

            public boolean accept(File localFile) {
                if (localFile.isDirectory()) {
                    return false;
                }
                MenuBar.CURRENT_FILE = localFile.getParentFile();
                return localFile.isFile();
            }

            public String getDescription() {
                return irbsBundle.getString("allFilesFilter");
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveFile(JFileChooser fileChooser) {
        File file = this.file;
        synchronized (file) {
            String saveLocation = fileChooser.getSelectedFile().getAbsolutePath();
            try {
                FileInputStream fis = new FileInputStream(this.file);
                FileOutputStream fos = new FileOutputStream(new File(saveLocation));
                byte[] bytesIn = new byte[1024];
                int length = fis.read(bytesIn);
                while (length >= 0) {
                    fos.write(bytesIn, 0, length);
                    length = fis.read(bytesIn);
                }
                fis.close();
                fos.close();
                IrbsLogger.logInfo(this.getClass(), "Saved viewed file to location: \"" + saveLocation + "\"");
            }
            catch (Exception e) {
                IrbsLogger.logInfo(this.getClass(), "Could not save viewed file to location: \"" + saveLocation + "\". " + e);
            }
        }
    }

    private void createDocumentListener() {
        Runnable documentListenerRunnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                while (ViewFileDialog.this.isAlive) {
                    try {
                        Thread.sleep(1000L);
                        File file = ViewFileDialog.this.file;
                        synchronized (file) {
                            if (ViewFileDialog.this.file.length() > ViewFileDialog.this.fileLength) {
                                ViewFileDialog.this.textEditPane.setText(IrbsHelper.getFileContents(ViewFileDialog.this.file).toString());
                                ViewFileDialog.this.textEditPane.setCaretPosition(ViewFileDialog.this.textEditPane.getText().length());
                                ViewFileDialog.this.fileLength = ViewFileDialog.this.file.length();
                            } else if (ViewFileDialog.this.file.length() < ViewFileDialog.this.fileLength) {
                                ViewFileDialog.this.textEditPane.setText(IrbsHelper.getFileContents(ViewFileDialog.this.file).toString());
                            }
                        }
                    }
                    catch (Throwable throwable) {
                    }
                }
            }
        };
        Thread documentListenerThread = new Thread(documentListenerRunnable, "Document Listening Thread");
        documentListenerThread.setDaemon(true);
        documentListenerThread.start();
    }

    public final void close() {
        IrbsLogger.logEntering(this.getClass());
        this.isAlive = false;
        this.dispose();
        IrbsLogger.logExiting(this.getClass());
    }

    class ViewFileMenu
    extends JMenuBar {
        ViewFileMenu() {
            IrbsLogger.logEntering(this.getClass());
            JMenu fileMenu = new JMenu(irbsBundle.getString("reportFileMenu"));
            JMenuItem fileSaveMenu = new JMenuItem(irbsBundle.getString("reportSaveMenu"));
            fileSaveMenu.addActionListener(ViewFileDialog.this.createSaveListener());
            fileMenu.add(fileSaveMenu);
            fileMenu.addSeparator();
            JMenuItem fileCloseMenu = new JMenuItem(irbsBundle.getString("reportCloseMenu"));
            fileCloseMenu.addActionListener(ViewFileDialog.this.createCloseListener());
            fileMenu.add(fileCloseMenu);
            this.add(fileMenu);
            IrbsLogger.logExiting(this.getClass());
        }
    }
}

