/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.em.irbs.notifications;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import se.ericsson.lte.rbs.omf.em.irbs.IrbsHelper;
import se.ericsson.lte.rbs.omf.em.irbs.parser.IntegrationGroup;
import se.ericsson.lte.rbs.omf.em.irbs.parser.IntegrationStep;
import se.ericsson.lte.rbs.omf.em.irbs.parser.ProgressReportData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IrbsNotificationEvent {
    private static final String MINUS_SPACE = " - ";
    private static final String EQUALS_SPACE = " = ";
    public final transient String configurationReport;
    public final transient String timeString;
    public final transient ProgressReportData progressReportData;
    private static final ResourceBundle IRBS_BUNDLE = ResourceBundle.getBundle("se.ericsson.lte.rbs.omf.em.resources.Irbs", Locale.getDefault());

    public IrbsNotificationEvent(String inputConfigurationReport, ProgressReportData inputProgressReportData) {
        this.configurationReport = inputConfigurationReport;
        this.progressReportData = inputProgressReportData;
        this.timeString = IrbsHelper.currentDateAndTimeString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.progressReportData.getProgressReportDataIntegrationStep().getCurrentGroupName().equals("")) {
            stringBuffer.append(this.progressReportData.getProgressReportDataIntegrationStep().getCurrentGroupName()).append(MINUS_SPACE).append(IrbsHelper.doubleQuote(this.progressReportData.getProgressReportDataIntegrationStep().getCurrentGroupMessage()));
        }
        if (!this.progressReportData.getProgressReportDataIntegrationStep().getCurrentStepName().equals("")) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append("\n");
            }
            stringBuffer.append("progressInformation").append(EQUALS_SPACE).append(this.progressReportData.getProgressReportDataIntegrationStep().getCurrentStepName());
        }
        if (this.progressReportData.getProgressLevel() != -1) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append("\n");
            }
            stringBuffer.append("progressLevel").append(EQUALS_SPACE).append(this.progressReportData.getProgressLevel());
        }
        return stringBuffer.toString();
    }

    public String[] toStrings() {
        StringBuffer stringBuffer;
        ArrayList<String> stringList = new ArrayList<String>();
        if (!this.progressReportData.getProgressReportDataIntegrationStep().getCurrentGroupName().equals("")) {
            stringBuffer = new StringBuffer();
            stringBuffer.append(this.progressReportData.getProgressReportDataIntegrationStep().getCurrentGroupName()).append(MINUS_SPACE).append(IrbsHelper.doubleQuote(this.progressReportData.getProgressReportDataIntegrationStep().getCurrentGroupMessage()));
            stringList.add(stringBuffer.toString());
        }
        if (!this.progressReportData.getProgressReportDataIntegrationStep().getCurrentStepName().equals("")) {
            stringBuffer = new StringBuffer();
            if (stringBuffer.length() > 0) {
                stringBuffer.append("\n");
            }
            stringBuffer.append("progressInformation").append(EQUALS_SPACE).append(this.progressReportData.getProgressReportDataIntegrationStep().getCurrentStepName());
            stringList.add(stringBuffer.toString());
        }
        if (this.progressReportData.getProgressLevel() != -1) {
            stringBuffer = new StringBuffer();
            if (stringBuffer.length() > 0) {
                stringBuffer.append("\n");
            }
            stringBuffer.append("progressLevel").append(EQUALS_SPACE).append(this.progressReportData.getProgressLevel());
            stringList.add(stringBuffer.toString());
        }
        String[] result = new String[stringList.size()];
        stringList.toArray(result);
        return result;
    }

    public List<String> getTraceInfo(ProgressReportData lastProgressReportData) {
        StringBuffer message = new StringBuffer();
        ArrayList<String> traceInfo = new ArrayList<String>();
        if (lastProgressReportData == null) {
            if (message.length() > 0) {
                message.append(", ");
            }
            message.append(IRBS_BUNDLE.getString("eventNewProgressTree"));
            traceInfo.add(message.toString());
        } else {
            Map<String, IntegrationGroup> lastIntegrationGroup = lastProgressReportData.getIntegrationGroup();
            Map<String, IntegrationGroup> integrationGroup = this.progressReportData.getIntegrationGroup();
            Iterator<String> groupIterator = integrationGroup.keySet().iterator();
            while (groupIterator.hasNext()) {
                IntegrationGroup intGroup = integrationGroup.get(groupIterator.next());
                if (intGroup.equals(lastIntegrationGroup.get(intGroup.getName()))) continue;
                if (message.length() > 0) {
                    message.append(", ");
                }
                message.append(intGroup.getName()).append(MINUS_SPACE).append(intGroup.getMessage());
                traceInfo.add(message.toString());
                message.delete(0, message.length());
            }
            Map<String, IntegrationStep> lastIntegrationStep = lastProgressReportData.getIntegrationStep();
            Map<String, IntegrationStep> integrationStep = this.progressReportData.getIntegrationStep();
            Iterator<String> stepIterator = integrationStep.keySet().iterator();
            while (stepIterator.hasNext()) {
                IntegrationStep intStep = integrationStep.get(stepIterator.next());
                if (intStep.equals(lastIntegrationStep.get(intStep.getName()))) continue;
                message.append(intStep.getTimeStamp()).append(MINUS_SPACE).append(intStep.getName()).append(MINUS_SPACE).append((Object)intStep.getStatus()).append(MINUS_SPACE).append("Progress: ").append(this.progressReportData.getProgressLevel()).append(MINUS_SPACE).append(intStep.getDetailedInformation());
                traceInfo.add(message.toString());
                message.delete(0, message.length());
            }
            if (this.progressReportData.getProgressReportDataSmrsError().getSmrsErrorUserName().length() > 0) {
                traceInfo.add(this.getSmrsError());
            }
            if (this.progressReportData.getProgressReportDataState().isCancelable() != lastProgressReportData.getProgressReportDataState().isCancelable()) {
                message.append(IRBS_BUNDLE.getString("eventCancelable") + " ").append(this.progressReportData.getProgressReportDataState().isCancelable());
            }
            if (this.progressReportData.getProgressReportDataState().isFinished() != lastProgressReportData.getProgressReportDataState().isFinished()) {
                message.append(IRBS_BUNDLE.getString("eventFinished") + " ").append(this.progressReportData.getProgressReportDataState().isFinished());
            }
            if (this.progressReportData.getProgressReportDataState().isCancelled() != lastProgressReportData.getProgressReportDataState().isCancelled()) {
                if (message.length() > 0) {
                    message.append(", ");
                }
                message.append(IRBS_BUNDLE.getString("eventCancelled") + " ").append(this.progressReportData.getProgressReportDataState().isCancelled());
            }
            if (this.progressReportData.getProgressReportDataState().isStartable() != lastProgressReportData.getProgressReportDataState().isStartable()) {
                if (message.length() > 0) {
                    message.append(", ");
                }
                message.append(IRBS_BUNDLE.getString("eventStartable") + " ").append(this.progressReportData.getProgressReportDataState().isStartable());
            }
            if (this.progressReportData.getProgressReportDataState().isStarted() != lastProgressReportData.getProgressReportDataState().isStarted()) {
                if (message.length() > 0) {
                    message.append(", ");
                }
                message.append(IRBS_BUNDLE.getString("eventStarted") + " ").append(this.progressReportData.getProgressReportDataState().isStarted());
            }
            if (message.length() > 0) {
                traceInfo.add(message.toString());
                message.delete(0, message.length());
            }
            if (this.progressReportData.getIpAddress().length() > 0 && !this.progressReportData.getIpAddress().equals(lastProgressReportData.getIpAddress())) {
                message.append("ipAddress").append(MINUS_SPACE).append(this.progressReportData.getIpAddress());
                traceInfo.add(message.toString());
            }
        }
        return traceInfo;
    }

    protected String getSmrsError() {
        StringBuffer message = new StringBuffer();
        if (this.progressReportData.getProgressReportDataSmrsError().getSmrsErrorUserName().length() > 0) {
            message.append("ErroneousInput").append(MINUS_SPACE).append(this.progressReportData.getProgressReportDataSmrsError().getSmrsErrorMessage()).append(MINUS_SPACE).append(this.progressReportData.getProgressReportDataSmrsError().getSmrsErrorUserName()).append(MINUS_SPACE).append(this.progressReportData.getProgressReportDataSmrsError().getSmrsErrorServer()).append(MINUS_SPACE).append(this.progressReportData.getProgressReportDataSmrsError().getSmrsErrorSummaryFilePath());
        }
        return message.toString();
    }
}

