/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.em.irbs.notifications;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.omg.CORBA.SystemException;
import se.ericsson.cello.neal.Node;
import se.ericsson.cello.neal.cm.CmNotificationConsumer;
import se.ericsson.cello.neal.cm.CmService;
import se.ericsson.cello.neal.cm.CmSubscription;
import se.ericsson.cello.neal.cm.Mo;
import se.ericsson.cello.neal.cm.NameValue;
import se.ericsson.lte.rbs.omf.em.irbs.ConnectionListener;
import se.ericsson.lte.rbs.omf.em.irbs.IrbsLogger;
import se.ericsson.lte.rbs.omf.em.irbs.notifications.IrbsNotificationEvent;
import se.ericsson.lte.rbs.omf.em.irbs.notifications.IrbsNotificationHandler;
import se.ericsson.lte.rbs.omf.em.irbs.notifications.IrbsNotificationListener;
import se.ericsson.lte.rbs.omf.em.irbs.parser.ProgressReportData;
import se.ericsson.lte.rbs.omf.em.irbs.parser.ProgressReportParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IrbsNotificationHandlerImpl
implements IrbsNotificationHandler,
CmNotificationConsumer {
    public final transient Object connectionMutex = new Object();
    private static final String[] ALL_UPDATE_COUNTER_ATTRIBUTES = new String[]{"configurationReportUpdateCounter", "progressReportUpdateCounter"};
    private static final String[] CONFIGURATION_REPORT_ATTRIBUTE = new String[]{"configurationReport"};
    private static final String[] PROGRESS_REPORT_ATTRIBUTE = new String[]{"progressReport"};
    private static final String[] ALL_ATTRIBUTES = new String[]{"configurationReport", "progressReport"};
    private static final long POLLING_PERIOD = 2000L;
    private final transient List<IrbsNotificationListener> irbsNotificationListeners;
    private transient Node node = null;
    private transient CmService cmService = null;
    private transient boolean connected = false;
    private IrbsNotificationEvent currentNotificationEvent = null;
    private final ConnectionListener connectionListener;
    private NotificationCollectingThread notificationCollectingThread = null;
    private Integer previousConfigurationReportUpdateCounter = new Integer(-2);
    private Integer previousProgressReportUpdateCounter = new Integer(-2);

    public IrbsNotificationHandlerImpl(IrbsNotificationListener irbsNotificationListener, ConnectionListener inputConnectionListener) {
        this.connectionListener = inputConnectionListener;
        this.irbsNotificationListeners = new ArrayList<IrbsNotificationListener>();
        this.irbsNotificationListeners.add(irbsNotificationListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IrbsNotificationListener> getListeners() {
        List<IrbsNotificationListener> list = this.irbsNotificationListeners;
        synchronized (list) {
            return new ArrayList<IrbsNotificationListener>(this.irbsNotificationListeners);
        }
    }

    @Override
    public void setNode(Node inputNode) {
        this.node = inputNode;
        this.cmService = inputNode.getCmService();
        if (this.notificationCollectingThread != null) {
            this.notificationCollectingThread.killIt();
        }
        this.notificationCollectingThread = new NotificationCollectingThread(this);
        this.notificationCollectingThread.start();
    }

    @Override
    public void update() {
        if (this.currentNotificationEvent != null) {
            this.notifyIrbsNotificationListeners(this.currentNotificationEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectionStateChanged(boolean localConnected) {
        this.connected = localConnected;
        if (!localConnected) {
            if (this.notificationCollectingThread == null) {
                Object object = this.connectionMutex;
                synchronized (object) {
                    this.connectionMutex.notifyAll();
                }
            } else {
                this.notificationCollectingThread.killIt();
            }
        }
    }

    private void retrieveRbsConfigurationMoNotifications() {
        Mo rbsConfigurationMo;
        NameValue[] attributes = new NameValue[]{};
        if (this.connected && this.node != null && (rbsConfigurationMo = this.cmService.getMo("ManagedElement=1,NodeManagementFunction=1,RbsConfiguration=1")) != null) {
            attributes = rbsConfigurationMo.getAttributes(ALL_UPDATE_COUNTER_ATTRIBUTES, null);
            this.attributeValueChanged(rbsConfigurationMo.getFdn(), attributes, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addNotificationListener(IrbsNotificationListener irbsNotificationListener) {
        List<IrbsNotificationListener> list = this.irbsNotificationListeners;
        synchronized (list) {
            this.irbsNotificationListeners.remove(irbsNotificationListener);
            this.irbsNotificationListeners.add(irbsNotificationListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void removeNotificationListener(IrbsNotificationListener irbsNotificationListener) {
        List<IrbsNotificationListener> list = this.irbsNotificationListeners;
        synchronized (list) {
            this.irbsNotificationListeners.remove(irbsNotificationListener);
        }
    }

    public void attributeValueChanged(String fdn, NameValue[] attributes, int generationCount) {
        boolean progressReportUpdated;
        boolean configurationReportUpdated;
        Integer configurationReportUpdateCounter = this.getInteger("configurationReportUpdateCounter", attributes, this.previousConfigurationReportUpdateCounter);
        Integer progressReportUpdateCounter = this.getInteger("progressReportUpdateCounter", attributes, this.previousProgressReportUpdateCounter);
        boolean bl = configurationReportUpdated = configurationReportUpdateCounter.intValue() != this.previousConfigurationReportUpdateCounter.intValue();
        if (configurationReportUpdated) {
            IrbsLogger.logInfo(this.getClass(), "Configuration report updated. Previous value = " + this.previousConfigurationReportUpdateCounter + ", new value = " + configurationReportUpdateCounter);
        }
        boolean bl2 = progressReportUpdated = progressReportUpdateCounter.intValue() != this.previousProgressReportUpdateCounter.intValue();
        if (progressReportUpdated) {
            IrbsLogger.logInfo(this.getClass(), "Progress report updated. Previous value = " + this.previousProgressReportUpdateCounter + ", new value = " + progressReportUpdateCounter);
        }
        if (progressReportUpdated || configurationReportUpdated) {
            this.previousConfigurationReportUpdateCounter = configurationReportUpdateCounter;
            this.previousProgressReportUpdateCounter = progressReportUpdateCounter;
            this.retrieveAndProcessChangedAttributes(configurationReportUpdated, progressReportUpdated);
        }
    }

    private void retrieveAndProcessChangedAttributes(boolean configurationReportUpdated, boolean progressReportUpdated) {
        IrbsLogger.logEntering(this.getClass());
        String[] polledAttributes = this.retireveAttributesFromRbs(configurationReportUpdated, progressReportUpdated);
        if (this.processNotificationEvent(polledAttributes)) {
            String configurationReport = polledAttributes[0];
            String progressReport = polledAttributes[1];
            ProgressReportData progressReportData = this.getProgressReportData(progressReport);
            this.currentNotificationEvent = new IrbsNotificationEvent(configurationReport, progressReportData);
            List<String> logMessage = this.currentNotificationEvent.getTraceInfo(progressReportData);
            if (!logMessage.isEmpty()) {
                Iterator<String> iterator = logMessage.iterator();
                while (iterator.hasNext()) {
                    IrbsLogger.logInfo(this.getClass(), iterator.next());
                }
            }
            this.notifyIrbsNotificationListeners(this.currentNotificationEvent);
        }
        IrbsLogger.logExiting(this.getClass());
    }

    private String[] retireveAttributesFromRbs(boolean configurationReportUpdated, boolean progressReportUpdated) {
        Mo rbsConfigurationMo;
        boolean allAttributes;
        String configurationReport = "";
        String progressReport = "";
        boolean bl = allAttributes = configurationReportUpdated && progressReportUpdated;
        if (allAttributes) {
            Mo rbsConfigurationMo2 = this.cmService.getMo("ManagedElement=1,NodeManagementFunction=1,RbsConfiguration=1");
            if (rbsConfigurationMo2 != null) {
                NameValue[] attributes = rbsConfigurationMo2.getAttributes(ALL_ATTRIBUTES, null);
                configurationReport = this.getConfigurationReport(attributes);
                progressReport = this.getProgressReport(attributes);
            }
        } else if (configurationReportUpdated) {
            Mo rbsConfigurationMo3 = this.cmService.getMo("ManagedElement=1,NodeManagementFunction=1,RbsConfiguration=1");
            if (rbsConfigurationMo3 != null) {
                NameValue[] attributes = rbsConfigurationMo3.getAttributes(CONFIGURATION_REPORT_ATTRIBUTE, null);
                configurationReport = this.getConfigurationReport(attributes);
            }
        } else if (progressReportUpdated && (rbsConfigurationMo = this.cmService.getMo("ManagedElement=1,NodeManagementFunction=1,RbsConfiguration=1")) != null) {
            NameValue[] attributes = rbsConfigurationMo.getAttributes(PROGRESS_REPORT_ATTRIBUTE, null);
            progressReport = this.getProgressReport(attributes);
        }
        return new String[]{configurationReport, progressReport};
    }

    private boolean processNotificationEvent(String[] attributeValues) {
        boolean notificationEventIsOk = false;
        for (int i = 0; i < attributeValues.length; ++i) {
            if (attributeValues[i].equalsIgnoreCase("")) continue;
            notificationEventIsOk = true;
            break;
        }
        return notificationEventIsOk;
    }

    private ProgressReportData getProgressReportData(String progressReport) {
        ProgressReportData progressReportData = this.parseProgressReportData(progressReport);
        return progressReportData;
    }

    private ProgressReportData parseProgressReportData(String progressReport) {
        ProgressReportParser parser = new ProgressReportParser();
        parser.parse(progressReport);
        return parser.getProgressReportData();
    }

    private String getConfigurationReport(NameValue[] attributes) {
        String configurationReport = "";
        for (int i = 0; i < attributes.length; ++i) {
            if (!attributes[i].getName().equals("configurationReport")) continue;
            configurationReport = attributes[i].getStringValue();
            break;
        }
        return configurationReport;
    }

    private String getProgressReport(NameValue[] attributes) {
        String progressReport = "";
        for (int i = 0; i < attributes.length; ++i) {
            if (!attributes[i].getName().equals("progressReport")) continue;
            progressReport = attributes[i].getStringValue();
            break;
        }
        return progressReport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyIrbsNotificationListeners(final IrbsNotificationEvent notificationEvent) {
        List<IrbsNotificationListener> list = this.irbsNotificationListeners;
        synchronized (list) {
            if (!this.irbsNotificationListeners.isEmpty()) {
                Runnable notifier = new Runnable(){

                    public void run() {
                        for (int index = 0; index < IrbsNotificationHandlerImpl.this.irbsNotificationListeners.size(); ++index) {
                            ((IrbsNotificationListener)IrbsNotificationHandlerImpl.this.irbsNotificationListeners.get(index)).notificationReceived(notificationEvent);
                        }
                    }
                };
                Thread notificationThread = new Thread(notifier, "Notification Received Thread");
                notificationThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isConnectedAfterWaitingForNextRetry(long waitingPeriod) {
        try {
            Object object = this.connectionMutex;
            synchronized (object) {
                this.connectionMutex.wait(waitingPeriod);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.connected;
    }

    public void communicationFailed(CmSubscription subscription, Node inputNode, String msg) {
    }

    public void moCreated(String fdn, int generationCount) {
    }

    public void moDeleted(String fdn, int generationCount) {
    }

    public void overflowOccurred(String time) {
    }

    public void subscriptionNotActive(CmSubscription subscription, Node inputNode) {
    }

    private Integer getInteger(String attributeName, NameValue[] attributes, Integer defaultValue) {
        Integer value = defaultValue;
        for (int i = 0; i < attributes.length; ++i) {
            if (!attributes[i].getName().equalsIgnoreCase(attributeName)) continue;
            value = attributes[i].getIntegerValue();
            break;
        }
        return value == null ? defaultValue : value;
    }

    private class NotificationCollectingThread
    extends Thread {
        private final IrbsNotificationHandlerImpl irbsNotificationHandlerImpl;
        private boolean keepOnPolling;

        public NotificationCollectingThread(IrbsNotificationHandlerImpl inputIrbsNotificationHandlerImpl) {
            super("Notification Collector Thread");
            this.irbsNotificationHandlerImpl = inputIrbsNotificationHandlerImpl;
            this.keepOnPolling = true;
            this.setPriority(1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void killIt() {
            Object object = IrbsNotificationHandlerImpl.this.connectionMutex;
            synchronized (object) {
                this.keepOnPolling = false;
                IrbsNotificationHandlerImpl.this.connectionMutex.notifyAll();
            }
        }

        public void start() {
            super.start();
            IrbsLogger.logInfo(this.getClass(), "Notification Collector started");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (this.keepOnPolling) {
                    try {
                        this.irbsNotificationHandlerImpl.retrieveRbsConfigurationMoNotifications();
                        if (IrbsNotificationHandlerImpl.this.isConnectedAfterWaitingForNextRetry(2000L)) continue;
                    }
                    catch (SystemException se) {
                        IrbsNotificationHandlerImpl.this.connectionListener.connectedToRbs(false);
                    }
                    catch (Throwable throwable) {
                        if (IrbsNotificationHandlerImpl.this.isConnectedAfterWaitingForNextRetry(2000L)) continue;
                    }
                    break;
                }
            }
            finally {
                IrbsLogger.logInfo(this.getClass(), "Notification Collector terminated");
            }
        }
    }
}

