/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.em.irbs.parser;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.SortedMap;
import java.util.TreeMap;
import se.ericsson.lte.rbs.omf.em.irbs.parser.IntegrationStep;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegrationGroup {
    private String integrationGroupMessage = "";
    private String integrationGroupName = "";
    private String integrationGroupNumber = "";
    private final Map<String, IntegrationStep> integrationStep;
    private final SortedMap<Integer, IntegrationStep> sortedStep;
    private static final ResourceBundle IRBS_BUNDLE = ResourceBundle.getBundle("se.ericsson.lte.rbs.omf.em.resources.Irbs", Locale.getDefault());

    public IntegrationGroup() {
        this.integrationStep = new HashMap<String, IntegrationStep>();
        this.sortedStep = new TreeMap<Integer, IntegrationStep>();
    }

    public IntegrationGroup(String inputIntegrationGroupName, String inputIntegrationGroupMessage, String inputIntegrationGroupNumber) {
        this.integrationGroupName = inputIntegrationGroupName;
        this.integrationGroupMessage = inputIntegrationGroupMessage;
        this.integrationGroupNumber = inputIntegrationGroupNumber;
        this.integrationStep = new HashMap<String, IntegrationStep>();
        this.sortedStep = new TreeMap<Integer, IntegrationStep>();
    }

    public void addIntegrationStep(IntegrationStep newIntegrationStep) {
        this.integrationStep.put(newIntegrationStep.getName(), newIntegrationStep);
        this.sortedStep.put(new Integer(newIntegrationStep.getStepNumber()), newIntegrationStep);
    }

    public String getAllGroupInformation() {
        StringBuffer allGroupInformation = new StringBuffer();
        allGroupInformation.append(IRBS_BUNDLE.getString("groupGroup") + " ");
        allGroupInformation.append(this.integrationGroupName);
        allGroupInformation.append("\n\n");
        allGroupInformation.append(this.integrationGroupMessage);
        allGroupInformation.append("\n\n\n");
        Iterator<Integer> iterator = this.sortedStep.keySet().iterator();
        while (iterator.hasNext()) {
            allGroupInformation.append(((IntegrationStep)this.sortedStep.get(iterator.next())).getAllStepInformation());
            allGroupInformation.append("\n\n");
        }
        return allGroupInformation.toString();
    }

    public String getGroupNumber() {
        return this.integrationGroupNumber;
    }

    public Map<String, IntegrationStep> getIntegrationStep() {
        return this.integrationStep;
    }

    public SortedMap<Integer, IntegrationStep> getIntegrationStepSorted() {
        return this.sortedStep;
    }

    public String getMessage() {
        return this.integrationGroupMessage;
    }

    public String getName() {
        return this.integrationGroupName;
    }

    public void setGroupNumber(String groupNumber) {
        this.integrationGroupNumber = groupNumber;
    }

    public void setMessage(String message) {
        this.integrationGroupMessage = message;
    }

    public void setName(String name) {
        this.integrationGroupName = name;
    }

    public String toString() {
        return this.integrationGroupName;
    }

    public int hashCode() {
        return this.integrationGroupName.hashCode();
    }

    public boolean equals(Object otherObj) {
        boolean theyAreEqual = false;
        if (otherObj instanceof IntegrationGroup) {
            IntegrationGroup otherIntegrationGroup = (IntegrationGroup)otherObj;
            theyAreEqual = otherIntegrationGroup.getName().equals(this.integrationGroupName) && otherIntegrationGroup.getMessage().equals(this.integrationGroupMessage);
        }
        return theyAreEqual;
    }
}

