/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.em.irbs.parser;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.tree.DefaultMutableTreeNode;
import se.ericsson.lte.rbs.omf.em.irbs.parser.IntegrationGroup;
import se.ericsson.lte.rbs.omf.em.irbs.parser.IntegrationStep;
import se.ericsson.lte.rbs.omf.em.irbs.parser.ProgressReportDataIntegrationStep;
import se.ericsson.lte.rbs.omf.em.irbs.parser.ProgressReportDataSmrsError;
import se.ericsson.lte.rbs.omf.em.irbs.parser.ProgressReportDataState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProgressReportData {
    private final Map<String, IntegrationGroup> integrationGroup;
    private final SortedMap<Integer, IntegrationGroup> sortedGroup;
    private final Map<String, IntegrationStep> allIntegrationStep;
    private int progressLevel = -1;
    private final ProgressReportDataState state = new ProgressReportDataState(true, false, false, false, false);
    private final ProgressReportDataSmrsError smrsErrorData = new ProgressReportDataSmrsError("", "", "", "");
    private String ipAddress = "";
    private final ProgressReportDataIntegrationStep integrationStep = new ProgressReportDataIntegrationStep("", "", "", "");
    private DefaultMutableTreeNode treeNodes = null;
    private String revision = "";
    private boolean ricFaulty = false;

    public ProgressReportData() {
        this.integrationGroup = new HashMap<String, IntegrationGroup>();
        this.sortedGroup = new TreeMap<Integer, IntegrationGroup>();
        this.allIntegrationStep = new HashMap<String, IntegrationStep>();
    }

    public void addIntegrationGroup(IntegrationGroup newIntegrationGroup) {
        this.integrationGroup.put(newIntegrationGroup.getName(), newIntegrationGroup);
        this.sortedGroup.put(new Integer(newIntegrationGroup.getGroupNumber()), newIntegrationGroup);
    }

    public void addIntegrationStep(IntegrationStep newIntegrationStep) {
        this.allIntegrationStep.put(newIntegrationStep.getName(), newIntegrationStep);
    }

    public String getDetailedInformationText(String selectedNodeName) {
        String detailedInformationText = "";
        if ("RBS Integration".equalsIgnoreCase(selectedNodeName)) {
            detailedInformationText = this.getAllInformation();
        } else if (this.integrationGroup.containsKey(selectedNodeName)) {
            detailedInformationText = this.integrationGroup.get(selectedNodeName).getAllGroupInformation();
        } else if (this.allIntegrationStep.containsKey(selectedNodeName)) {
            detailedInformationText = this.allIntegrationStep.get(selectedNodeName).getAllStepInformation();
        }
        return detailedInformationText;
    }

    public boolean isRicFaulty() {
        return this.ricFaulty;
    }

    public void setRicFaulty(boolean ricIsFaulty) {
        this.ricFaulty = ricIsFaulty;
    }

    public ProgressReportDataSmrsError getProgressReportDataSmrsError() {
        return this.smrsErrorData;
    }

    public ProgressReportDataState getProgressReportDataState() {
        return this.state;
    }

    public ProgressReportDataIntegrationStep getProgressReportDataIntegrationStep() {
        return this.integrationStep;
    }

    public Map<String, IntegrationGroup> getIntegrationGroup() {
        return this.integrationGroup;
    }

    public Map<String, IntegrationStep> getIntegrationStep() {
        return this.allIntegrationStep;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public int getProgressLevel() {
        return this.progressLevel;
    }

    public DefaultMutableTreeNode getProgressTreeNodes() {
        return this.treeNodes;
    }

    public String getRevision() {
        return this.revision;
    }

    public boolean isLeaf(String nodeName) {
        return this.allIntegrationStep.containsKey(nodeName);
    }

    public void setIpAddress(String newIpAddress) {
        this.ipAddress = newIpAddress;
    }

    public void setProgressLevel(int newProgress) {
        this.progressLevel = newProgress;
    }

    public void setProgressTreeNodes(DefaultMutableTreeNode topNode) {
        this.treeNodes = topNode;
    }

    public void setRevision(String newRevision) {
        this.revision = newRevision;
    }

    private String getAllInformation() {
        StringBuffer allInformation = new StringBuffer();
        Iterator<Integer> iterator = this.sortedGroup.keySet().iterator();
        while (iterator.hasNext()) {
            allInformation.append(((IntegrationGroup)this.sortedGroup.get(iterator.next())).getAllGroupInformation());
            allInformation.append("\n\n\n");
        }
        return allInformation.toString();
    }
}

