/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.em.irbs.util;

import java.io.IOException;
import java.util.Locale;
import java.util.ResourceBundle;
import se.ericsson.cello.neal.Node;
import se.ericsson.cello.neal.NodeAccess;
import se.ericsson.cello.neal.NodeConfig;
import se.ericsson.lte.rbs.omf.em.irbs.HttpNodeClient;
import se.ericsson.lte.rbs.omf.em.irbs.IrbsHelper;
import se.ericsson.lte.rbs.omf.em.irbs.IrbsLogger;
import se.ericsson.lte.rbs.omf.em.irbs.util.NodeResolver;
import se.ericsson.security.login.LoginException;
import se.ericsson.security.login.LoginServices;

public class NodeResolverImpl
implements NodeResolver {
    protected static final String SLSURLS_PROPERTY_NAME = "se.ericsson.security.ssu.slsurls";
    private final NodeConfig nodeConfig;
    private final HttpNodeClient httpNodeClient;
    private final LoginServices loginServices;
    private static final ResourceBundle IRBS_BUNDLE = ResourceBundle.getBundle("se.ericsson.lte.rbs.omf.em.resources.Irbs", Locale.getDefault());

    public NodeResolverImpl(NodeConfig nodeConfigIn, HttpNodeClient httpNodeClientIn, LoginServices loginServicesIn) {
        this.nodeConfig = nodeConfigIn;
        this.httpNodeClient = httpNodeClientIn;
        this.loginServices = loginServicesIn;
    }

    public Node resolveNode(String ipAddress) throws IOException {
        boolean loggedIn = false;
        while (!loggedIn) {
            this.nodeConfig.connectByUrl(IrbsHelper.convertToNameServiceUrlString(ipAddress));
            boolean nodIsSecure = this.httpNodeClient.readSecurityStateFromNode(ipAddress);
            IrbsLogger.logInfo(this.getClass(), "nodIsSecure: " + nodIsSecure);
            if (nodIsSecure) {
                String slsAddresses = this.httpNodeClient.readSlsAddressesFromNode(ipAddress);
                System.setProperty(SLSURLS_PROPERTY_NAME, slsAddresses);
                try {
                    this.loginServices.logout();
                    IrbsLogger.logInfo(this.getClass(), "LoginServices successfully logged out while node is secure");
                    this.loginServices.setTitle(IRBS_BUNDLE.getString("irbsRbsIntegration"));
                    this.loginServices.login();
                    loggedIn = true;
                    IrbsLogger.logInfo(this.getClass(), "LoginServices successfully logged-in while node is secure");
                }
                catch (LoginException lie) {
                    IrbsLogger.logError(this.getClass(), "Failed to after logout \"login()\"", lie);
                }
                continue;
            }
            loggedIn = true;
            IrbsLogger.logInfo(this.getClass(), "Logged in the \"default\" way");
            IrbsLogger.logInfo(this.getClass(), "LoginServices successfully logged in while node is NOT secure");
        }
        IrbsLogger.logInfo(this.getClass(), "Returning from resolveNode()");
        return NodeAccess.getNode((NodeConfig)this.nodeConfig);
    }
}

