/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.em.irbs.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.Timer;
import javax.swing.border.EtchedBorder;
import se.ericsson.lte.rbs.omf.em.ImageHelper;
import se.ericsson.lte.rbs.omf.em.irbs.IrbsHelper;

public class ToolTipScreen {
    protected final Object mutex = new Object();
    private final Component component;
    private final ToolTipScreenFrame permanentToolTipScreenFrame;
    private final ToolTipScreenFrame nonPermanentToolTipScreenFrame;
    private final Timer nonPermanentDisplayTimer;
    private final Timer permanentDisposeTimer;
    private final Timer nonPermanentDisposeTimer;

    public ToolTipScreen(Component inputComponent, String title, String toolTipText) {
        this.component = inputComponent;
        this.permanentToolTipScreenFrame = new ToolTipScreenFrame(title, toolTipText, false);
        this.nonPermanentToolTipScreenFrame = new ToolTipScreenFrame(title, toolTipText, true);
        this.permanentDisposeTimer = new Timer(200, new ActionListener(){

            public void actionPerformed(ActionEvent notUsed) {
                ToolTipScreen.this.disposePermanentToolTipScreenFrame();
            }
        });
        this.permanentDisposeTimer.setRepeats(false);
        this.nonPermanentDisplayTimer = new Timer(500, new ActionListener(){

            public void actionPerformed(ActionEvent notUsed) {
                ToolTipScreen.this.displayNonPermanentToolTipScreenFrame();
            }
        });
        this.nonPermanentDisplayTimer.setRepeats(false);
        this.nonPermanentDisposeTimer = new Timer(1000, new ActionListener(){

            public void actionPerformed(ActionEvent notUsed) {
                ToolTipScreen.this.disposeNonPermanentToolTipScreenFrame();
            }
        });
        this.nonPermanentDisposeTimer.setRepeats(false);
        inputComponent.addMouseListener(this.createComponentMouseListener());
        IrbsHelper.addGlobalKeyListener(new HelpButtonKeyListener(inputComponent));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disposePermanentToolTipScreenFrame() {
        Object object = this.mutex;
        synchronized (object) {
            this.permanentToolTipScreenFrame.setVisible(false);
            this.mutex.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disposeNonPermanentToolTipScreenFrame() {
        Object object = this.mutex;
        synchronized (object) {
            this.nonPermanentToolTipScreenFrame.setVisible(false);
            this.mutex.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void displayNonPermanentToolTipScreenFrame() {
        Object object = this.mutex;
        synchronized (object) {
            try {
                Point tmpLocation = this.component.getLocationOnScreen();
                Dimension componentDimension = this.component.getSize();
                int xPos = tmpLocation.x - this.nonPermanentToolTipScreenFrame.getSize().width;
                int yPos = tmpLocation.y + componentDimension.height;
                Point componentLocation = new Point(xPos, yPos);
                this.nonPermanentToolTipScreenFrame.setLocation(componentLocation);
                this.nonPermanentToolTipScreenFrame.setVisible(!IrbsHelper.testMode);
            }
            catch (Exception exception) {
            }
            finally {
                this.mutex.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void displayPermanentFrame() {
        Object object = this.mutex;
        synchronized (object) {
            try {
                this.nonPermanentDisposeTimer.stop();
                this.nonPermanentDisplayTimer.stop();
                this.nonPermanentToolTipScreenFrame.setVisible(false);
                Point tmpLocation = this.component.getLocationOnScreen();
                Dimension componentDimension = this.component.getSize();
                Point rootPaneLocation = this.permanentToolTipScreenFrame.getRootPane().getLocation();
                int xPos = tmpLocation.x - rootPaneLocation.x - this.nonPermanentToolTipScreenFrame.getSize().width;
                int yPos = tmpLocation.y + componentDimension.height - rootPaneLocation.y;
                Point frameLocation = new Point(xPos, yPos);
                this.permanentToolTipScreenFrame.setLocation(frameLocation);
                this.permanentToolTipScreenFrame.setVisible(!IrbsHelper.testMode);
                this.permanentDisposeTimer.stop();
            }
            catch (Exception exception) {
            }
            finally {
                this.mutex.notifyAll();
            }
        }
    }

    private MouseListener createComponentMouseListener() {
        return new MouseListener(){

            public void mouseClicked(MouseEvent notUsed) {
                ToolTipScreen.this.displayPermanentFrame();
            }

            public void mouseEntered(MouseEvent notUsed) {
                ToolTipScreen.this.displayNonPermanentFrame();
            }

            public void mouseExited(MouseEvent notUsed) {
                ToolTipScreen.this.disposeNonPermanentFrame();
            }

            public void mousePressed(MouseEvent notUsed) {
            }

            public void mouseReleased(MouseEvent notUsed) {
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disposeNonPermanentFrame() {
        Object object = this.mutex;
        synchronized (object) {
            try {
                this.component.setCursor(Cursor.getPredefinedCursor(0));
                this.nonPermanentDisplayTimer.stop();
                if (IrbsHelper.testMode || this.nonPermanentToolTipScreenFrame.isVisible()) {
                    this.nonPermanentDisposeTimer.restart();
                }
            }
            catch (Exception exception) {
            }
            finally {
                this.mutex.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void displayNonPermanentFrame() {
        Object object = this.mutex;
        synchronized (object) {
            try {
                this.component.setCursor(Cursor.getPredefinedCursor(12));
                if (!this.permanentToolTipScreenFrame.isVisible()) {
                    this.nonPermanentDisplayTimer.restart();
                }
            }
            catch (Exception exception) {
            }
            finally {
                this.mutex.notifyAll();
            }
        }
    }

    private class HelpButtonKeyListener
    implements KeyListener {
        private final Component localComponent;

        public HelpButtonKeyListener(Component inputComponent) {
            this.localComponent = inputComponent;
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (this.localComponent.isVisible()) {
                if (keyEvent.getKeyCode() == 112) {
                    if (ToolTipScreen.this.permanentToolTipScreenFrame.isVisible()) {
                        ToolTipScreen.this.permanentToolTipScreenFrame.setVisible(false);
                    } else {
                        ToolTipScreen.this.displayPermanentFrame();
                    }
                } else if (keyEvent.getKeyCode() == 27 && ToolTipScreen.this.permanentToolTipScreenFrame.isVisible()) {
                    ToolTipScreen.this.permanentToolTipScreenFrame.setVisible(false);
                }
            }
        }

        public void keyReleased(KeyEvent notUsed) {
        }

        public void keyTyped(KeyEvent notUsed) {
        }
    }

    private class ToolTipScreenFrame
    extends JFrame {
        private final JTextPane textPane;

        public ToolTipScreenFrame(String title, String toolTipText, boolean undecorated) {
            super(title);
            this.setUndecorated(undecorated);
            this.textPane = new JTextPane();
            this.textPane.setPreferredSize(new Dimension(500, 100));
            this.textPane.setBorder(new EtchedBorder());
            this.textPane.setEditable(false);
            this.textPane.setMargin(new Insets(5, 5, 5, 5));
            this.textPane.setText(toolTipText);
            MouseListener toolTipScreenMouseListener = this.createToolTipScreenMouseListener();
            this.getContentPane().setLayout(new BorderLayout());
            if (undecorated) {
                this.getContentPane().add((Component)this.textPane, "Center");
                this.textPane.addMouseListener(toolTipScreenMouseListener);
            } else {
                JScrollPane scrollPane = new JScrollPane(this.textPane);
                this.getContentPane().add((Component)scrollPane, "Center");
                this.textPane.addMouseListener(toolTipScreenMouseListener);
                this.addWindowFocusListener(this.createWindowFocusListener());
            }
            try {
                this.setIconImage(new ImageIcon(ImageHelper.getImage("icon_LTE_16.gif")).getImage());
            }
            catch (ImageHelper.ResourceException ignore) {
                // empty catch block
            }
            this.pack();
        }

        private WindowFocusListener createWindowFocusListener() {
            return new WindowFocusListener(){

                public void windowGainedFocus(WindowEvent notUsed) {
                }

                public void windowLostFocus(WindowEvent notUsed) {
                    ToolTipScreen.this.permanentDisposeTimer.restart();
                }
            };
        }

        private MouseListener createToolTipScreenMouseListener() {
            return new MouseListener(){

                public void mouseClicked(MouseEvent notUsed) {
                }

                public void mouseEntered(MouseEvent notUsed) {
                    if (!ToolTipScreen.this.permanentToolTipScreenFrame.isVisible()) {
                        ToolTipScreen.this.displayPermanentFrame();
                    }
                }

                public void mouseExited(MouseEvent notUsed) {
                }

                public void mousePressed(MouseEvent notUsed) {
                }

                public void mouseReleased(MouseEvent notUsed) {
                }
            };
        }
    }
}

