/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.em.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.util.StringTokenizer;
import se.ericsson.lte.rbs.omf.em.irbs.IrbsHelper;
import se.ericsson.lte.rbs.omf.em.util.FtpClient;
import se.ericsson.lte.rbs.omf.em.util.FtpConnection;
import se.ericsson.lte.rbs.omf.em.util.FtpConnectionFactory;

public class FtpClientImpl
implements FtpClient {
    private static final String SERVICE_READY_FOR_NEW_USER = "220 ";
    private static final String USER_NAME_OKAY_NEEDS_PASSWORD = "331 ";
    private static final String USER_LOGGED_IN_PROCEED = "230 ";
    private static final String PATH_NAME_CREATED = "257 ";
    private static final String REQUESTED_FILE_ACTION_OKAY_COMPLETED = "250 ";
    private static final String REQUESTED_FILE_ACTION_PENDING_FURTHER_INFORMATION = "350 ";
    private static final String ENTERING_PASSIVE_MODE = "227 ";
    private static final String FILE_STATUS_OKAY_ABOUT_TO_OPEN_DATA_CONNECTION = "150 ";
    private static final String CLOSING_DATA_CONNECTION = "226 ";
    private static final String COMMAND_OKAY = "200 ";
    private static final String REQUESTED_ACTION_NOT_TAKEN = "550 ";
    private static final String USER_NAME = "USER ";
    private static final String PASSWORD = "PASS ";
    private static final String CHANGE_WORKING_DIRECTORY = "CWD ";
    private static final String ABORT = "ABOR";
    private static final String LOGOUT = "QUIT";
    private static final String PRINT_WORKING_DIRECTORY = "PWD";
    private static final String PASSIVE = "PASV";
    private static final String STORE = "STOR ";
    private static final String RENAME_FROM = "RNFR ";
    private static final String RENAME_TO = "RNTO ";
    private static final String MAKE_DIRECTORY = "MKD ";
    private static final String ASCII_MODE = "TYPE A";
    private static final String BINARY_MODE = "TYPE I";
    private static final Object MUTEX_OBJECT = new Object();
    private BufferedReader reader = null;
    private BufferedWriter writer = null;
    private boolean connected = false;
    private final FtpConnection ftpConnection;
    private final String host;
    private final String userName;
    private final String password;

    public FtpClientImpl(String inputHost, String inputUserName, String inputPassword) throws IOException {
        this.ftpConnection = FtpConnectionFactory.getFtpConnection(inputHost);
        this.host = inputHost;
        this.userName = inputUserName;
        this.password = inputPassword;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() throws IOException {
        Object object = MUTEX_OBJECT;
        synchronized (object) {
            if (this.connected) {
                throw new IOException("FtpClient is already connected. Disconnect first.");
            }
            this.reader = this.ftpConnection.getReader();
            this.writer = this.ftpConnection.getWriter();
            String response = this.readResponse();
            if (!response.startsWith(SERVICE_READY_FOR_NEW_USER)) {
                throw new IOException("FtpClient received an unknown response when connecting to the FTP server: " + response);
            }
            this.sendLine(USER_NAME + this.userName);
            response = this.readResponse();
            if (!response.startsWith(USER_NAME_OKAY_NEEDS_PASSWORD)) {
                throw new IOException("Incorrect user name: " + response);
            }
            this.sendLine(PASSWORD + this.password);
            response = this.readResponse();
            if (!response.startsWith(USER_LOGGED_IN_PROCEED)) {
                throw new IOException("Incorrect password: " + response);
            }
            this.connected = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() throws IOException {
        Object object = MUTEX_OBJECT;
        synchronized (object) {
            try {
                this.sendLine(ABORT);
                this.sendLine(LOGOUT);
                this.connected = false;
            }
            finally {
                this.ftpConnection.setSocket(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String pwd() throws IOException {
        Object object = MUTEX_OBJECT;
        synchronized (object) {
            int firstQuote;
            int secondQuote;
            this.sendLine(PRINT_WORKING_DIRECTORY);
            String dir = null;
            String response = this.readResponse();
            if (response.startsWith(PATH_NAME_CREATED) && (secondQuote = response.indexOf(34, (firstQuote = response.indexOf(34)) + 1)) > 0) {
                dir = response.substring(firstQuote + 1, secondQuote);
            }
            return dir;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cwd(String dir) {
        boolean changedDirectory = false;
        Object object = MUTEX_OBJECT;
        synchronized (object) {
            try {
                this.sendLine(CHANGE_WORKING_DIRECTORY + dir);
                String response = this.readResponse();
                changedDirectory = response.startsWith(REQUESTED_FILE_ACTION_OKAY_COMPLETED);
            }
            catch (IOException ignore) {
                changedDirectory = false;
            }
            return changedDirectory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean upload(String filePath, String remoteFileName) throws IOException {
        Object object = MUTEX_OBJECT;
        synchronized (object) {
            File file = new File(filePath);
            if (file.isDirectory()) {
                throw new IOException("FtpClient cannot upload a directory.");
            }
            String filename = file.getName();
            return this.upload(new FileInputStream(file), filename, remoteFileName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean upload(InputStream inputStream, String filePath, String remoteFileName) throws IOException {
        Object object = MUTEX_OBJECT;
        synchronized (object) {
            BufferedInputStream input = new BufferedInputStream(inputStream);
            this.sendLine(PASSIVE);
            String response = this.readResponse();
            if (!response.startsWith(ENTERING_PASSIVE_MODE)) {
                throw new IOException("FtpClient could not request passive mode: " + response);
            }
            String ip = null;
            int port = -1;
            int opening = response.indexOf(40);
            int closing = response.indexOf(41, opening + 1);
            if (closing > 0) {
                String dataLink = response.substring(opening + 1, closing);
                StringTokenizer tokenizer = new StringTokenizer(dataLink, ",");
                try {
                    ip = tokenizer.nextToken() + "." + tokenizer.nextToken() + "." + tokenizer.nextToken() + "." + tokenizer.nextToken();
                    port = Integer.parseInt(tokenizer.nextToken()) * 256 + Integer.parseInt(tokenizer.nextToken());
                }
                catch (Exception e) {
                    throw new IOException("FtpClient received bad data link information: " + response);
                }
            }
            this.sendLine(STORE + filePath);
            Socket dataSocket = new Socket(ip, port);
            response = this.readResponse();
            if (!response.startsWith(FILE_STATUS_OKAY_ABOUT_TO_OPEN_DATA_CONNECTION)) {
                throw new IOException("FtpClient was not allowed to send the file: " + response);
            }
            BufferedOutputStream output = new BufferedOutputStream(dataSocket.getOutputStream());
            byte[] buffer = new byte[4096];
            int bytesRead = 0;
            bytesRead = input.read(buffer);
            while (bytesRead != -1) {
                output.write(buffer, 0, bytesRead);
                bytesRead = input.read(buffer);
            }
            output.flush();
            output.close();
            input.close();
            response = this.readResponse();
            boolean result = response.startsWith(CLOSING_DATA_CONNECTION);
            if (result) {
                File localFile = new File(filePath);
                String currentRemoteFileName = localFile.getName();
                result = this.renameRemoteFile(currentRemoteFileName, remoteFileName);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean renameRemoteFile(String currentRemoteFileName, String remoteFileName) {
        boolean successful = false;
        Object object = MUTEX_OBJECT;
        synchronized (object) {
            try {
                this.sendLine(RENAME_FROM + currentRemoteFileName);
                String response = this.readResponse();
                successful = response.startsWith(REQUESTED_FILE_ACTION_PENDING_FURTHER_INFORMATION);
                this.sendLine(RENAME_TO + remoteFileName);
                response = this.readResponse();
                successful = successful && response.startsWith(REQUESTED_FILE_ACTION_OKAY_COMPLETED);
            }
            catch (IOException ignore) {
                successful = false;
            }
            return successful;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean bin() {
        boolean successful = false;
        Object object = MUTEX_OBJECT;
        synchronized (object) {
            try {
                this.sendLine(BINARY_MODE);
                String response = this.readResponse();
                successful = response.startsWith(COMMAND_OKAY);
            }
            catch (IOException ignore) {
                successful = false;
            }
            return successful;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ascii() {
        boolean successful = false;
        Object object = MUTEX_OBJECT;
        synchronized (object) {
            try {
                this.sendLine(ASCII_MODE);
                String response = this.readResponse();
                successful = response.startsWith(COMMAND_OKAY);
            }
            catch (IOException ignore) {
                successful = false;
            }
            return successful;
        }
    }

    public String toString() {
        return "FTP Client for host: " + IrbsHelper.doubleQuote(this.host);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean mkdirs(String directoryPath) {
        String[] dirParts = IrbsHelper.getUnixDirectoryParts(directoryPath);
        boolean successful = false;
        Object object = MUTEX_OBJECT;
        synchronized (object) {
            try {
                for (int i = 0; i < dirParts.length; ++i) {
                    this.sendLine(MAKE_DIRECTORY + dirParts[i]);
                    String response = this.readResponse();
                    successful = response.startsWith(PATH_NAME_CREATED) || response.startsWith(REQUESTED_ACTION_NOT_TAKEN);
                }
            }
            catch (IOException ignore) {
                successful = false;
            }
            return successful;
        }
    }

    private void sendLine(String line) throws IOException {
        if (this.ftpConnection.getSocket() == null) {
            throw new IOException("FtpClient is not connected.");
        }
        try {
            this.writer.write(line + "\r\n");
            this.writer.flush();
        }
        catch (IOException e) {
            this.ftpConnection.setSocket(null);
            throw e;
        }
    }

    private String readResponse() throws IOException {
        boolean continuedMessage;
        StringBuffer response = new StringBuffer();
        boolean keepLooking = true;
        String firstLine = this.reader.readLine();
        String responseCode = firstLine.substring(0, 3) + " ";
        boolean bl = continuedMessage = firstLine.charAt(3) == '-';
        if (continuedMessage) {
            while (keepLooking) {
                String line = this.reader.readLine();
                if (line == null) {
                    keepLooking = false;
                    continue;
                }
                if (!line.startsWith(responseCode)) continue;
                response.append(line);
                keepLooking = false;
            }
        } else {
            response.append(firstLine);
        }
        return response.toString();
    }
}

