/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.em.validator;

import java.util.Locale;
import java.util.ResourceBundle;
import se.ericsson.lte.rbs.omf.em.validator.Validator;

public class EmptyValidator
implements Validator {
    private static final ResourceBundle irbsBundle = ResourceBundle.getBundle("se.ericsson.lte.rbs.omf.em.resources.Irbs", Locale.getDefault());
    private final transient boolean allowEmptyField;
    private transient String description = "";
    private transient String hint = "";
    private transient String currentInputString = "";
    private transient boolean specificHintInfoSet = false;

    public EmptyValidator(boolean inputAllowEmptyField) {
        this.allowEmptyField = inputAllowEmptyField;
        this.hint = this.getHintInfo();
    }

    public boolean allowEmpty() {
        return this.allowEmptyField;
    }

    public boolean valid(String toBeChecked) {
        this.currentInputString = toBeChecked;
        boolean result = false;
        if (this.allowEmptyField && toBeChecked.equals("")) {
            result = true;
        } else if (!toBeChecked.equals("")) {
            result = true;
        }
        this.hint = this.getHintInfo();
        this.description = result ? " " : this.hint;
        return result;
    }

    public String getInputString() {
        return this.currentInputString;
    }

    public void setHint(String hintInfo) {
        this.hint = hintInfo;
        this.specificHintInfoSet = true;
    }

    private String getHintInfo() {
        String result = this.hint;
        if (!this.specificHintInfoSet) {
            result = this.allowEmptyField ? irbsBundle.getString("emptyEmptyValidatorDesc") : irbsBundle.getString("nonEmptyEmptyValidatorDesc");
        }
        return result;
    }

    public String getDescription() {
        return this.description;
    }

    public String getHint() {
        return this.hint;
    }
}

