/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.em.validator;

import java.io.File;
import java.util.Locale;
import java.util.ResourceBundle;
import se.ericsson.lte.rbs.omf.em.validator.Validator;

public class LocalFilePathValidator
implements Validator {
    private static final ResourceBundle irbsBundle = ResourceBundle.getBundle("se.ericsson.lte.rbs.omf.em.resources.Irbs", Locale.getDefault());
    private static final String NOT_SPECIFIED = irbsBundle.getString("variousNotSpecified");
    private final transient boolean allowEmptyField;
    private final transient String fileExtension;
    private transient String description = "";
    private transient String hint = "";
    private transient String currentInputString = "";

    public LocalFilePathValidator(boolean inputAllowEmptyField) {
        this(inputAllowEmptyField, null);
    }

    public LocalFilePathValidator(boolean inputAllowEmptyField, String inputFileExtension) {
        this.allowEmptyField = inputAllowEmptyField;
        this.fileExtension = inputFileExtension == null || inputFileExtension.length() < 1 ? NOT_SPECIFIED : inputFileExtension.toLowerCase(Locale.getDefault());
        this.hint = this.getHintInfo();
    }

    public boolean allowEmpty() {
        return this.allowEmptyField;
    }

    public boolean valid(String filePath) {
        this.currentInputString = filePath;
        boolean result = false;
        File file = new File(filePath);
        if (this.allowEmptyField && filePath.length() < 1) {
            result = true;
        } else if (file.exists()) {
            result = this.fileExtension.equals(NOT_SPECIFIED) ? true : file.getAbsolutePath().toLowerCase(Locale.getDefault()).endsWith(this.fileExtension);
        }
        this.hint = this.getHintInfo();
        this.description = result ? " " : this.hint;
        return result;
    }

    public String getInputString() {
        return this.currentInputString;
    }

    private String getHintInfo() {
        String result = this.allowEmptyField ? (this.fileExtension.equals(NOT_SPECIFIED) ? irbsBundle.getString("localFileValidatorDesc") + " " + irbsBundle.getString("orBeEmpty") : irbsBundle.getString("localFileExtensionValidatorDesc") + " \"" + this.fileExtension + "\" " + irbsBundle.getString("orBeEmpty")) : (this.fileExtension.equals(NOT_SPECIFIED) ? irbsBundle.getString("localFileValidatorDesc") : irbsBundle.getString("localFileExtensionValidatorDesc") + " \"" + this.fileExtension + "\"");
        return result;
    }

    public String getDescription() {
        return this.description;
    }

    public String getHint() {
        return this.hint;
    }
}

