/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.mimparser.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import se.ericsson.cello.mimparser.MimModel;
import se.ericsson.cello.mimparser.MomEntity;
import se.ericsson.cello.mimparser.model.MomEntityResolvable;
import se.ericsson.cello.mimparser.model.MomEnumRefImpl;

public class ReferenceResolver {
    private HashMap structRefsToResolve = new HashMap(0);
    private HashMap moRefsToResolve = new HashMap(0);
    private HashMap enumRefsToResolve = new HashMap(0);
    private HashMap derivedDataTypeRefsToResolve = new HashMap(0);
    private final int STRUCT_FLAG = 1;
    private final int MO_FLAG = 2;
    private final int ENUM_FLAG = 3;
    private final int DATA_TYPE_FLAG = 4;

    ReferenceResolver() {
    }

    void addStructRef(String string, MomEntityResolvable momEntityResolvable) {
        this.add(string, momEntityResolvable, this.structRefsToResolve);
    }

    void addMoRef(String string, MomEntityResolvable momEntityResolvable) {
        this.add(string, momEntityResolvable, this.moRefsToResolve);
    }

    void addEnumRef(String string, MomEntityResolvable momEntityResolvable) {
        this.add(string, momEntityResolvable, this.enumRefsToResolve);
    }

    void addDerivedDataTypeRef(String string, MomEntityResolvable momEntityResolvable) {
        this.add(string, momEntityResolvable, this.derivedDataTypeRefsToResolve);
    }

    private void add(String string, Object object, HashMap hashMap) {
        ArrayList<Object> arrayList = (ArrayList<Object>)hashMap.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList<Object>(0);
        }
        arrayList.add(object);
        hashMap.put(string, arrayList);
    }

    void resolve(MimModel mimModel) {
        this.resolveMap(mimModel, this.structRefsToResolve, 1);
        this.resolveMap(mimModel, this.moRefsToResolve, 2);
        this.resolveMap(mimModel, this.enumRefsToResolve, 3);
        this.resolveMap(mimModel, this.derivedDataTypeRefsToResolve, 4);
        this.resolveEnumRefDefaultValues(mimModel);
        this.structRefsToResolve = null;
        this.moRefsToResolve = null;
        this.enumRefsToResolve = null;
        this.derivedDataTypeRefsToResolve = null;
    }

    private void resolveMap(MimModel mimModel, HashMap hashMap, int n) {
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            MomEntity momEntity = this.getMomEntity(mimModel, n, string);
            List list = (List)hashMap.get(string);
            for (int i = 0; i < list.size(); ++i) {
                MomEntityResolvable momEntityResolvable = (MomEntityResolvable)list.get(i);
                momEntityResolvable.setResolvedEntity(momEntity);
            }
        }
    }

    private void resolveEnumRefDefaultValues(MimModel mimModel) {
        Iterator iterator = this.enumRefsToResolve.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            List list = (List)this.enumRefsToResolve.get(string);
            for (int i = 0; i < list.size(); ++i) {
                MomEnumRefImpl momEnumRefImpl = (MomEnumRefImpl)list.get(i);
                momEnumRefImpl.resolveDefault();
            }
        }
    }

    private MomEntity getMomEntity(MimModel mimModel, int n, String string) {
        MomEntity momEntity = null;
        String string2 = null;
        if (n == 1) {
            momEntity = mimModel.getStruct(string);
            string2 = "structRef";
        } else if (n == 2) {
            momEntity = mimModel.getClass(string);
            string2 = "moRef (class)";
        } else if (n == 3) {
            momEntity = mimModel.getEnum(string);
            string2 = "enumRef";
        } else if (n == 4) {
            momEntity = mimModel.getDerivedDataType(string);
            string2 = "derivedDataTypeRef";
        }
        if (momEntity == null) {
            String string3 = "Can not resolve reference of type " + string2 + ". The referenced entry can not be found. name=" + string + " method=ReferenceResolver.getMomEntity()";
            throw new RuntimeException(string3);
        }
        return momEntity;
    }
}

