/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.mimparser.parser;

import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import se.ericsson.cello.mimparser.MimModel;
import se.ericsson.cello.mimparser.model.MimModelImpl;
import se.ericsson.cello.mimparser.model.MomBase;
import se.ericsson.cello.mimparser.parser.ParseInfo;
import se.ericsson.cello.mimparser.state.InitialState;
import se.ericsson.cello.mimparser.statemachine.StateHandler;
import se.ericsson.cello.mimparser.statemachine.StateMachine;

public class MomParser {
    private MimModelImpl mimModel = null;
    private final String JAR_FILE_INDICATOR = "jar:file:";
    private final String JAR_HTTP_INDICATOR = "jar:http:";
    private final String JAR_DTD_SUFFIX = "!/mp.dtd";
    private static XMLReader xmlReader = null;

    public MimModel parse(String string, int n, XMLReader xMLReader) {
        this.mimModel = new MimModelImpl(string, n);
        if (xMLReader != null) {
            this.mimModel.setXMLReader(xMLReader);
            xmlReader = xMLReader;
        }
        ParseInfo parseInfo = new ParseInfo(n, this.mimModel);
        return this.parse(string, parseInfo);
    }

    public static void reParseMomBase(MomBase momBase) {
        MimModelImpl mimModelImpl = momBase.getModel();
        MomParser momParser = new MomParser();
        momParser.reparse(momBase, new HashMap(0));
    }

    public static void reParseMomBase(MomBase momBase, Map map) {
        MimModelImpl mimModelImpl = momBase.getModel();
        MomParser momParser = new MomParser();
        momParser.reparse(momBase, map);
    }

    private void reparse(MomBase momBase, Map map) {
        MimModelImpl mimModelImpl = momBase.getModel();
        String string = mimModelImpl.getMomFile();
        XMLReader xMLReader = null;
        if (this.mimModel != null && this.mimModel.getXMLReader() != null) {
            xMLReader = this.mimModel.getXMLReader();
        }
        if (xMLReader == null) {
            xMLReader = xmlReader;
        }
        this.mimModel = new MimModelImpl(string, 2);
        if (xMLReader != null) {
            this.mimModel.setXMLReader(xMLReader);
        }
        ParseInfo parseInfo = new ParseInfo(2, this.mimModel, momBase, map);
        this.parse(string, parseInfo);
    }

    private MimModel parse(String string, ParseInfo parseInfo) {
        this.readMomFile(string, parseInfo);
        if (!parseInfo.isReparse()) {
            this.resolveReferences();
            this.resolveRelationships();
        }
        return this.mimModel;
    }

    private void readMomFile(String string, ParseInfo parseInfo) {
        InputStream inputStream = null;
        StateHandler stateHandler = new StateHandler(new StateMachine(new InitialState(this.mimModel), parseInfo));
        boolean bl = this.checkIfJarFile(string);
        if (bl) {
            inputStream = this.createXmlInputStream(string);
        }
        try {
            XMLReader xMLReader = this.mimModel.getXMLReader();
            if (xMLReader != null) {
                xMLReader.setContentHandler(stateHandler);
                InputSource inputSource = null;
                if (bl) {
                    inputSource = new InputSource(inputStream);
                    this.setDtdStream(string, stateHandler);
                } else {
                    inputSource = new InputSource(new FileReader(new File(string)));
                }
                xMLReader.parse(inputSource);
            } else {
                SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
                SAXParser sAXParser = sAXParserFactory.newSAXParser();
                sAXParser.getXMLReader().setErrorHandler(new ErrorHandler(){

                    public void error(SAXParseException sAXParseException) throws SAXException {
                        MomParser.this.mimModel.addToWarningList("ErrorHandler: " + sAXParseException.toString());
                    }

                    public void fatalError(SAXParseException sAXParseException) throws SAXException {
                        MomParser.this.mimModel.addToWarningList("ErrorHandler: " + sAXParseException.toString());
                    }

                    public void warning(SAXParseException sAXParseException) throws SAXException {
                        MomParser.this.mimModel.addToWarningList("ErrorHandler: " + sAXParseException.toString());
                    }
                });
                if (bl) {
                    this.setDtdStream(string, stateHandler);
                    sAXParser.parse(inputStream, stateHandler, "");
                } else {
                    sAXParser.parse(new File(string), (DefaultHandler)stateHandler);
                }
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
    }

    private void resolveReferences() {
        this.mimModel.resolveReferences();
    }

    private void resolveRelationships() {
        this.mimModel.resolveRelationships();
    }

    private boolean checkIfJarFile(String string) {
        String string2;
        boolean bl = false;
        if (string.length() > "jar:file:".length() && ((string2 = string.substring(0, "jar:file:".length())).equalsIgnoreCase("jar:file:") || string2.equalsIgnoreCase("jar:http:"))) {
            bl = true;
        }
        return bl;
    }

    private InputStream createXmlInputStream(String string) {
        InputStream inputStream = null;
        try {
            URL uRL = new URL(string);
            URLConnection uRLConnection = uRL.openConnection();
            inputStream = uRLConnection.getInputStream();
        }
        catch (Exception exception) {
            String string2 = "MomParser.createXmlInputStream() Can not read jar-xml file. Filename=" + string + "  exception=" + exception.toString();
            throw new RuntimeException(string2);
        }
        return inputStream;
    }

    private InputStream createDtdInputStream(String string) {
        InputStream inputStream = null;
        try {
            URL uRL = new URL(string);
            URLConnection uRLConnection = uRL.openConnection();
            inputStream = uRLConnection.getInputStream();
        }
        catch (Exception exception) {
            String string2 = "MomParser.createDtdInputStream() Can not read dtd file. dtdPath=" + string + "  exception=" + exception.toString();
            throw new RuntimeException(string2);
        }
        return inputStream;
    }

    private void setDtdStream(String string, StateHandler stateHandler) {
        int n = string.indexOf("!");
        if (n == -1) {
            throw new RuntimeException("MomParser.setDtdStream() The jar-xml fileName=" + string + " does not contain a ! character");
        }
        String string2 = string.substring(0, n);
        string2 = string2 + "!/mp.dtd";
        InputStream inputStream = this.createDtdInputStream(string2);
        stateHandler.setDtdStream(inputStream);
    }
}

