/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.mimparser.state;

import org.xml.sax.Attributes;
import se.ericsson.cello.mimparser.model.DerivedDataTypeImpl;
import se.ericsson.cello.mimparser.model.DomainExtensionImpl;
import se.ericsson.cello.mimparser.model.MimModelImpl;
import se.ericsson.cello.mimparser.model.MimPartImpl;
import se.ericsson.cello.mimparser.model.MomClassImpl;
import se.ericsson.cello.mimparser.model.MomEnumImpl;
import se.ericsson.cello.mimparser.model.MomExceptionImpl;
import se.ericsson.cello.mimparser.model.MomMetaDataImpl;
import se.ericsson.cello.mimparser.model.MomRelationshipExtImpl;
import se.ericsson.cello.mimparser.model.MomStructImpl;
import se.ericsson.cello.mimparser.state.ApplicationTagState;
import se.ericsson.cello.mimparser.state.ClassState;
import se.ericsson.cello.mimparser.state.CopyrightState;
import se.ericsson.cello.mimparser.state.DerivedDataTypeState;
import se.ericsson.cello.mimparser.state.DescriptionSettable;
import se.ericsson.cello.mimparser.state.DescriptionState;
import se.ericsson.cello.mimparser.state.DomainExtensionState;
import se.ericsson.cello.mimparser.state.DtdVersionState;
import se.ericsson.cello.mimparser.state.EnumState;
import se.ericsson.cello.mimparser.state.ExceptionState;
import se.ericsson.cello.mimparser.state.MimPartState;
import se.ericsson.cello.mimparser.state.MomBaseState;
import se.ericsson.cello.mimparser.state.MomMetaDataState;
import se.ericsson.cello.mimparser.state.RelationshipState;
import se.ericsson.cello.mimparser.state.StructState;
import se.ericsson.cello.mimparser.statemachine.StateMachine;

class ModelsState
extends MomBaseState
implements DescriptionSettable {
    private MimModelImpl mimModel;
    public static final String MODELS_TAG = "models";

    public ModelsState(MimModelImpl mimModelImpl) {
        super(MODELS_TAG);
        this.mimModel = mimModelImpl;
    }

    public void startElement(StateMachine stateMachine, String string, Attributes attributes) {
        if (string.equals("description")) {
            stateMachine.pushState(new DescriptionState(this));
        } else if (string.equals("applicationTag")) {
            stateMachine.pushState(new ApplicationTagState(this));
        } else if (string.equals("copyright")) {
            stateMachine.pushState(new CopyrightState(this.mimModel));
        } else if (string.equals("dtdVersion")) {
            stateMachine.pushState(new DtdVersionState(this.mimModel));
        } else if (string.equals("momMetaData")) {
            MomMetaDataImpl momMetaDataImpl = new MomMetaDataImpl(string, attributes, stateMachine.getParseInfo().getMimModel(), stateMachine.getParseInfo().getNextId());
            this.mimModel.setMomMetaData(momMetaDataImpl);
            stateMachine.pushState(new MomMetaDataState(momMetaDataImpl));
        } else if (string.equals("class")) {
            MomClassImpl momClassImpl = new MomClassImpl(string, attributes, stateMachine.getParseInfo().getMimModel(), stateMachine.getParseInfo().getNextId());
            this.mimModel.addClass(momClassImpl.getName(), momClassImpl);
            stateMachine.pushState(new ClassState(momClassImpl));
        } else if (string.equals("struct")) {
            MomStructImpl momStructImpl = new MomStructImpl(string, attributes, stateMachine.getParseInfo().getMimModel(), stateMachine.getParseInfo().getNextId());
            this.mimModel.addStruct(momStructImpl.getName(), momStructImpl);
            stateMachine.pushState(new StructState(momStructImpl));
        } else if (string.equals("enum")) {
            MomEnumImpl momEnumImpl = new MomEnumImpl(string, attributes, stateMachine.getParseInfo().getMimModel(), stateMachine.getParseInfo().getNextId());
            this.mimModel.addEnum(momEnumImpl.getName(), momEnumImpl);
            stateMachine.pushState(new EnumState(momEnumImpl));
        } else if (string.equals("relationship")) {
            MomRelationshipExtImpl momRelationshipExtImpl = new MomRelationshipExtImpl(string, attributes, stateMachine.getParseInfo().getMimModel(), stateMachine.getParseInfo().getNextId());
            stateMachine.pushState(new RelationshipState(momRelationshipExtImpl));
        } else if (string.equals("exception")) {
            MomExceptionImpl momExceptionImpl = new MomExceptionImpl(string, attributes, stateMachine.getParseInfo().getMimModel(), stateMachine.getParseInfo().getNextId());
            stateMachine.pushState(new ExceptionState(momExceptionImpl));
        } else if (string.equals("mimPart")) {
            MimPartImpl mimPartImpl = new MimPartImpl(string, attributes, stateMachine.getParseInfo().getMimModel(), stateMachine.getParseInfo().getNextId());
            this.mimModel.addMimParts(mimPartImpl);
            stateMachine.pushState(new MimPartState(mimPartImpl));
        } else if (string.equals("derivedDataType")) {
            DerivedDataTypeImpl derivedDataTypeImpl = new DerivedDataTypeImpl(string, attributes, stateMachine.getParseInfo().getMimModel(), stateMachine.getParseInfo().getNextId());
            this.mimModel.setDerivedDataType(derivedDataTypeImpl);
            this.mimModel.addDerivedDataType(derivedDataTypeImpl.getName(), derivedDataTypeImpl);
            stateMachine.pushState(new DerivedDataTypeState(derivedDataTypeImpl));
        } else if (string.equals("domainExtension")) {
            DomainExtensionImpl domainExtensionImpl = new DomainExtensionImpl(string, attributes, stateMachine.getParseInfo().getMimModel(), stateMachine.getParseInfo().getNextId());
            this.mimModel.setDomain(domainExtensionImpl);
            stateMachine.pushState(new DomainExtensionState(domainExtensionImpl));
        } else if (string.equals("mim")) {
            String string2 = attributes.getValue("name");
            this.mimModel.setName(string2);
            String string3 = attributes.getValue("version");
            this.mimModel.setVersion(string3);
            String string4 = attributes.getValue("release");
            this.mimModel.setRelease(string4);
        }
    }

    public void setDescription(String string) {
        this.mimModel.setDescription(string);
    }

    public void setApplicationTag(String string) {
        this.mimModel.setApplicationTag(string);
    }
}

