/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.mimparser.state;

import org.xml.sax.Attributes;
import se.ericsson.cello.mimparser.MomClass;
import se.ericsson.cello.mimparser.model.MimModelImpl;
import se.ericsson.cello.mimparser.model.MomCardinalityImpl;
import se.ericsson.cello.mimparser.model.MomHasClassImpl;
import se.ericsson.cello.mimparser.model.MomRelationshipEndInfoImpl;
import se.ericsson.cello.mimparser.model.MomRelationshipImpl;
import se.ericsson.cello.mimparser.model.MomSupporterImpl;
import se.ericsson.cello.mimparser.state.ApplicationTagState;
import se.ericsson.cello.mimparser.state.DescriptionSettable;
import se.ericsson.cello.mimparser.state.DescriptionState;
import se.ericsson.cello.mimparser.state.MaxMinSettable;
import se.ericsson.cello.mimparser.state.MaxState;
import se.ericsson.cello.mimparser.state.MinState;
import se.ericsson.cello.mimparser.state.MomBaseState;
import se.ericsson.cello.mimparser.statemachine.StateMachine;

public class SupporterState
extends MomBaseState
implements MaxMinSettable,
DescriptionSettable {
    public static final String SUPPORTER_TAG = "supporter";
    private MomRelationshipImpl momRelationship;
    private MomSupporterImpl momSupporter;
    private MimModelImpl model;

    public SupporterState(MomRelationshipImpl momRelationshipImpl, MomSupporterImpl momSupporterImpl) {
        super(SUPPORTER_TAG);
        this.momRelationship = momRelationshipImpl;
        this.momSupporter = momSupporterImpl;
    }

    public void startElement(StateMachine stateMachine, String string, Attributes attributes) {
        this.model = stateMachine.getParseInfo().getMimModel();
        if (string.equals("description")) {
            stateMachine.pushState(new DescriptionState(this));
        } else if (string.equals("applicationTag")) {
            stateMachine.pushState(new ApplicationTagState(this));
        } else if (string.equals("hasClass")) {
            MomClass momClass = stateMachine.getParseInfo().getMimModel().getClass(attributes.getValue("name"));
            MomHasClassImpl momHasClassImpl = new MomHasClassImpl(attributes, momClass);
            this.momSupporter.setHasClass(momHasClassImpl);
            this.momRelationship.setFromElementName(attributes.getValue("name"));
        } else if (string.equals("cardinality")) {
            this.momSupporter.setCardinality(this.getCardinality());
        } else if (string.equals("min")) {
            stateMachine.pushState(new MinState(this));
        } else if (string.equals("max")) {
            stateMachine.pushState(new MaxState(this));
        }
    }

    public void setDescription(String string) {
        MomRelationshipEndInfoImpl momRelationshipEndInfoImpl = this.getEndInfo();
        momRelationshipEndInfoImpl.setDescription(string);
    }

    public void setApplicationTag(String string) {
        MomRelationshipEndInfoImpl momRelationshipEndInfoImpl = this.getEndInfo();
        momRelationshipEndInfoImpl.setApplicationTag(string);
    }

    public void addMinValue(String string) {
        MomCardinalityImpl momCardinalityImpl = this.getCardinality();
        momCardinalityImpl.setMin(string);
    }

    public void addMaxValue(String string) {
        MomCardinalityImpl momCardinalityImpl = this.getCardinality();
        momCardinalityImpl.setMax(string);
    }

    private MomRelationshipEndInfoImpl getEndInfo() {
        MomRelationshipEndInfoImpl momRelationshipEndInfoImpl = (MomRelationshipEndInfoImpl)this.momRelationship.getFromInfo();
        if (momRelationshipEndInfoImpl == null) {
            momRelationshipEndInfoImpl = new MomRelationshipEndInfoImpl();
            this.momRelationship.setFromInfo(momRelationshipEndInfoImpl);
        }
        return momRelationshipEndInfoImpl;
    }

    private MomCardinalityImpl getCardinality() {
        MomCardinalityImpl momCardinalityImpl = (MomCardinalityImpl)this.momRelationship.getFromCardinality();
        if (momCardinalityImpl == null) {
            momCardinalityImpl = new MomCardinalityImpl(this.model);
            this.momRelationship.setFromCardinality(momCardinalityImpl);
        }
        return momCardinalityImpl;
    }
}

