/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.cppsec.esa;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.cello.security.mom.StructCertSpec;
import se.ericsson.security.cppsec.esa.AATestExecutor;
import se.ericsson.security.cppsec.esa.CertInfo;
import se.ericsson.security.cppsec.esa.EsaDataVerification;
import se.ericsson.security.cppsec.esa.EsaMessageHandler;
import se.ericsson.security.cppsec.esa.EsaReturnVal;
import se.ericsson.security.cppsec.esa.EsaReturnValImpl;
import se.ericsson.security.cppsec.esa.EsaSecurityChecksums;
import se.ericsson.security.cppsec.esa.ExpressSecurityActivation;
import se.ericsson.security.cppsec.esa.NodeSecurityHandler;
import se.ericsson.security.cppsec.esa.NodeSecurityHandlerFactory;
import se.ericsson.security.cppsec.esa.SecurityActivationException;
import se.ericsson.security.cppsec.esa.SecurityActivationInputException;
import se.ericsson.security.cppsec.esa.SecurityCertInfo;
import se.ericsson.security.cppsec.esa.checksum.ChecksumCalculator;
import se.ericsson.security.cppsec.esa.encryptedcontent.EncryptedContentStorage;
import se.ericsson.security.cppsec.esa.encryptedcontent.EncryptedContentStorageMgr;
import se.ericsson.security.cppsec.esa.enrollment.CertEnroller;
import se.ericsson.security.cppsec.esa.enrollment.CertEnrollerFactory;
import se.ericsson.security.cppsec.esa.enrollment.CertEnrollmentException;
import se.ericsson.security.cppsec.esa.logger.EsaMessageSender;
import se.ericsson.security.cppsec.esa.logger.EsaReportLogger;
import se.ericsson.security.cppsec.esa.model.CertFile;
import se.ericsson.security.cppsec.esa.model.Level2Data;
import se.ericsson.security.cppsec.esa.model.Level2Files;
import se.ericsson.security.cppsec.esa.model.Level3Data;
import se.ericsson.security.cppsec.esa.model.Level3Files;
import se.ericsson.security.cppsec.esa.model.MetaData;
import se.ericsson.security.cppsec.esa.model.SecConfData;
import se.ericsson.security.cppsec.esa.model.SecurityConfigurationModel;
import se.ericsson.security.cppsec.esa.model.SecurityData;
import se.ericsson.security.cppsec.esa.model.Validators;
import se.ericsson.security.cppsec.esa.parser.IscfDataFinder;
import se.ericsson.security.cppsec.esa.passwd.PasswordManager;
import se.ericsson.security.cppsec.esa.wrapper.EsaConstantsFactory;
import se.ericsson.security.cppsec.esa.wrapper.MessageLogWrapper;
import se.ericsson.security.cppsec.esa.wrapper.MessageLogWrapperFactory;

public class ExpressSecurityActivationImpl
implements ExpressSecurityActivation {
    private static final String FILENAME_CORBACA = "corbaca";
    private static final String FILENAME_AASERVERCA = "aaserverca";
    private static final String FILENAME_LAADCA = "laadca";
    private static final String FILENAME_SYSLOGSERVERCA = "syslogserverca";
    private static final String LOOPBACK_ADDRESS = "127.0.0.1";
    private static final int DEFAULT_DURATION = 5;
    private static final String DEFAULT_START_TIME = "0";
    private static final String DUMMY_NODE_PASSWORD = "x";
    private static final int SEC_LEVEL_1 = 1;
    private static final int SEC_LEVEL_2 = 2;
    private static final int SEC_LEVEL_3 = 3;
    private static final int SEC_LEVEL_3_UNCONFIRMED = 4;
    private final NodeSecurityHandler nodeSecurityHandler;
    protected Struct[] accountInfo = null;
    private final MessageLogWrapper logger = MessageLogWrapperFactory.getLogger(this.getClass());
    protected String myUsername;
    protected String myIntegrationCode;
    protected final EsaReportLogger reportLogger = EsaReportLogger.getInstance();
    private final EsaDataVerification esaDataVerification;
    protected final EncryptedContentStorageMgr encryptedContentStorageMgr;
    protected int expectedNumberOfCerts = 1;
    protected boolean doCertEnrollment = false;
    protected boolean doInstallLAAD = false;
    private String enrollmentOtp;
    protected SecConfData securityConfData;
    private CertEnroller certEnroller;
    private EsaMessageSender messageSender;
    private PasswordManager passwordManager;

    protected ExpressSecurityActivationImpl(EsaMessageHandler esaMessageHandler) {
        this.reportLogger.logMessage("ExpressSecurityActivationImpl() is called by application.");
        this.messageSender = new EsaMessageSender(esaMessageHandler);
        this.nodeSecurityHandler = NodeSecurityHandlerFactory.getNodeSecurityHandler(this.messageSender);
        this.esaDataVerification = new EsaDataVerification();
        this.certEnroller = CertEnrollerFactory.createSecCertEnroller(this.messageSender);
        this.passwordManager = new PasswordManager();
        this.encryptedContentStorageMgr = new EncryptedContentStorageMgr("security");
        this.reportLogger.logMessage("ExpressSecurityActivationImpl() gracefully returned.");
        this.reportLogger.closeLog();
        this.logger.traceReturn("ExpressSecurityActivationImpl()");
    }

    public EsaReturnVal activateSecurity(String string, String string2, String string3) throws SecurityActivationException, SecurityActivationInputException {
        int n;
        int n2;
        block18: {
            this.reportLogger.logMessage("activateSecurity() called by user " + string3);
            this.reportLogger.setSafeLogging(true);
            this.myIntegrationCode = string2;
            this.myUsername = string3;
            this.nodeSecurityHandler.setUserName(string3);
            this.verifyPreconditions(false);
            this.createLocalAccountInfo();
            if (this.securityConfData == null) {
                this.parseIscf(string);
                this.verifyIscf(this.securityConfData.getValidators(), this.securityConfData.getMetaData(), string);
            }
            SecurityData securityData = this.securityConfData.getSecurityData();
            n2 = securityData.getWantedSecurityLevel();
            n = securityData.getMinimumSecurityLevel();
            int n3 = this.nodeSecurityHandler.adaptAndGetCurrentSecurityLevel();
            this.reportLogger.logMessage("Security level " + n2 + " has been requested. Currently running at " + n3);
            try {
                if (n2 <= n3) {
                    if (n2 != 3) {
                        if ("Secure".equalsIgnoreCase(securityData.getTelnetandFtpServers())) {
                            this.nodeSecurityHandler.shutdownFtpAndTelnet();
                        } else {
                            this.nodeSecurityHandler.startFtpAndTelnet();
                        }
                        this.nodeSecurityHandler.setSecModeFileTransferClient(securityData.getFileTransferClient());
                    }
                    this.messageSender.sendMessage("Wanted security level is already activated.");
                    break block18;
                }
                if (n2 == 2) {
                    this.nodeSecurityHandler.activateSecurityLevel2();
                    if ("Secure".equalsIgnoreCase(securityData.getTelnetandFtpServers())) {
                        this.nodeSecurityHandler.shutdownFtpAndTelnet();
                    } else {
                        this.nodeSecurityHandler.startFtpAndTelnet();
                    }
                    this.nodeSecurityHandler.setSecModeFileTransferClient(securityData.getFileTransferClient());
                    break block18;
                }
                if (n2 != 3) break block18;
                this.nodeSecurityHandler.setSecModeFileTransferClient("Secure");
                this.nodeSecurityHandler.shutdownFtpAndTelnet();
                if (n3 == 1) {
                    this.nodeSecurityHandler.activateSecurityLevel2();
                }
                boolean bl = false;
                try {
                    this.executeAatest();
                    bl = true;
                }
                catch (SecurityActivationException securityActivationException) {
                    if (n != 3) {
                        this.reportLogger.logMessage("SEC: The aatest execution failed. Remaining on minimum SL " + n);
                    }
                    throw securityActivationException;
                }
                if (bl) {
                    this.nodeSecurityHandler.activateSecurityLevel3(securityData.getLevel3Data().getLevel3Configuration().getSecurityLevel3Timeout());
                }
            }
            catch (SecurityActivationException securityActivationException) {
                throw new SecurityActivationException("Security activation failed, cleanup performed.", securityActivationException);
            }
            finally {
                this.cleanup(false);
            }
        }
        this.reportLogger.logMessage("activateSecurity() gracefully returned");
        this.reportLogger.closeLog();
        this.logger.traceReturn("activateSecurity()");
        CertInfo certInfo = this.buildNodeCertInfo();
        return new EsaReturnValImpl(n, n2, certInfo);
    }

    public EsaSecurityChecksums calculateChecksums() throws SecurityActivationException {
        if (this.securityConfData == null) {
            throw new SecurityActivationException("No ISCF model available for checksum calculation");
        }
        ChecksumCalculator checksumCalculator = new ChecksumCalculator(this.securityConfData.getSecurityData());
        return checksumCalculator.calculateChecksums();
    }

    public EsaSecurityChecksums calculateChecksums(String string, String string2, String string3) throws SecurityActivationException, SecurityActivationInputException {
        if (this.securityConfData == null) {
            this.parseIscf(string);
            this.verifyIscf(this.securityConfData.getValidators(), this.securityConfData.getMetaData(), string);
        }
        ChecksumCalculator checksumCalculator = new ChecksumCalculator(this.securityConfData.getSecurityData());
        return checksumCalculator.calculateChecksums();
    }

    public EsaReturnVal install(String string, String string2, String string3, String string4) throws SecurityActivationException, SecurityActivationInputException {
        Object object;
        this.reportLogger.setSafeLogging(false);
        this.reportLogger.logMessage("SEC: install() called by user " + string3 + ". Path to ISCF: " + string);
        this.myIntegrationCode = string2;
        this.myUsername = string3;
        this.nodeSecurityHandler.setUserName(string3);
        this.createLocalAccountInfo();
        this.esaDataVerification.removeInstallIndicator();
        this.verifyPreconditions(true);
        this.parseIscf(string);
        this.verifyCorrectNode(string4, this.securityConfData.getMetaData().getLogicalName());
        this.verifyIscf(this.securityConfData.getValidators(), this.securityConfData.getMetaData(), string);
        this.nodeSecurityHandler.clearPreviousSecurityConfiguration();
        SecurityData securityData = this.securityConfData.getSecurityData();
        Level2Data level2Data = securityData.getLevel2Data();
        Level3Data level3Data = securityData.getLevel3Data();
        try {
            if (level2Data != null) {
                this.certEnroller.setEnrollmentData(level2Data.getEnrollmentData());
                this.certEnroller.setIntegrationCode(this.myIntegrationCode);
                this.certEnroller.enroll();
            } else {
                this.reportLogger.logMessage("No level 2 data defined. Ignoring certificate enrollment");
            }
            try {
                object = new ArrayList();
                if (level2Data != null) {
                    this.collectTrustedCertificates((ArrayList)object, level2Data.getFiles());
                }
                if (level3Data != null) {
                    this.collectTrustedCertificates((ArrayList)object, level3Data.getFiles());
                }
                this.installTrustedCertificates((ArrayList)object);
                String[] stringArray = null;
                if (level3Data != null) {
                    stringArray = this.prepareLocalAADatabase(level3Data.getFiles());
                }
                this.waitForInstallTrustedCerts();
                this.installLocalAADatabase(stringArray);
                this.nodeSecurityHandler.setSecurityMoAttributes(this.securityConfData.getSecurityData());
            }
            catch (SecurityActivationException securityActivationException) {
                this.certEnroller.waitForCertEnrollment();
                throw securityActivationException;
            }
            catch (SecurityActivationInputException securityActivationInputException) {
                this.certEnroller.waitForCertEnrollment();
                throw securityActivationInputException;
            }
            this.certEnroller.waitForCertEnrollment();
            this.waitForInstallLocalAADatabase();
            if (level3Data != null && securityData.getMinimumSecurityLevel() == 3) {
                this.executeAatest();
            }
            this.passwordManager.backupPasswordFile();
        }
        catch (SecurityActivationException securityActivationException) {
            throw new SecurityActivationException("Exception caught during install, cleanup performed.", securityActivationException);
        }
        catch (SecurityActivationInputException securityActivationInputException) {
            throw new SecurityActivationInputException("Exception caught during install, cleanup performed.", securityActivationInputException);
        }
        catch (CertEnrollmentException certEnrollmentException) {
            throw new SecurityActivationException("Exception caught during install, cleanup performed.", certEnrollmentException);
        }
        finally {
            this.cleanup(false);
        }
        this.esaDataVerification.enableReset(string);
        this.esaDataVerification.indicateInstall();
        this.reportLogger.logMessage("SEC: install() gracefully returned.");
        this.reportLogger.closeLog();
        this.logger.traceReturn("install()");
        object = this.buildNodeCertInfo();
        return new EsaReturnValImpl(securityData.getMinimumSecurityLevel(), securityData.getWantedSecurityLevel(), (CertInfo)object);
    }

    public void finalizeActivation() {
        this.reportLogger.logMessage("finalizeActivation() called");
        this.esaDataVerification.removeInstallIndicator();
        this.esaDataVerification.deleteFiles();
        this.reportLogger.logMessage("finalizeActivation() returned");
    }

    public void reset() throws SecurityActivationException {
        this.reportLogger.logMessage("SEC: reset() called");
        if (this.esaDataVerification.checkResetAllowed()) {
            this.reportLogger.logMessage("SEC: reset() allowed");
            if (this.doCertEnrollment) {
                this.messageSender.sendMessage("Certificate enrollment is currently in progress. Waiting for enrollment to finish.");
                this.reportLogger.logMessage("SEC: Waiting for cert enrollment at reset");
                try {
                    this.waitForCertEnrollment();
                }
                catch (SecurityActivationException securityActivationException) {
                    this.messageSender.sendMessage("Certificate enrollment failed while waiting to reset");
                }
            }
        } else {
            this.reportLogger.logMessage("SEC: reset() is not allowed");
            throw new SecurityActivationException("Reset is not allowed at current state.");
        }
        this.cleanup(true);
        this.reportLogger.logMessage("SEC: reset() done");
    }

    protected boolean overwriteCurrentEnrollmentData(String string) {
        boolean bl = true;
        try {
            bl = this.esaDataVerification.checkCurrentEnrollmentData(string, EsaConstantsFactory.getEsaConstants().getEsaStateFilePath());
        }
        catch (SecurityActivationException securityActivationException) {
            this.reportLogger.logMessage("SEC: Could not compare with previous enrollment data due to exception.");
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean cleanup(boolean bl) {
        this.logger.traceEnter("cleanup");
        this.reportLogger.logMessage("SEC: Cleaning up temporary data");
        boolean bl2 = true;
        int n = 0;
        this.encryptedContentStorageMgr.deleteAllFiles();
        this.doCertEnrollment = false;
        this.doInstallLAAD = false;
        this.expectedNumberOfCerts = 1;
        if (bl) {
            try {
                this.passwordManager.restorePasswordFile();
                this.reportLogger.logMessage("SEC: Removing installed security configuration");
                this.nodeSecurityHandler.clearPreviousSecurityConfiguration();
                this.esaDataVerification.removeInstallIndicator();
                n = this.nodeSecurityHandler.adaptAndGetCurrentSecurityLevel();
                if (n != 1) {
                    this.nodeSecurityHandler.setSecurityLevel1();
                    this.nodeSecurityHandler.startFtpAndTelnet();
                    this.nodeSecurityHandler.startTargetMonitor();
                    this.nodeSecurityHandler.startDebugAndUDP();
                    this.nodeSecurityHandler.setSecModeFileTransferClient("Unsecure");
                }
            }
            catch (SecurityActivationException securityActivationException) {
                this.reportLogger.logMessage("SEC: Failed to clean up configuration. Exception with message:" + securityActivationException.getMessage());
                this.logger.trace(2, "Failed to clean up configuration. Exception with message:" + securityActivationException.getMessage());
                bl2 = false;
            }
            finally {
                this.passwordManager.deleteDefaultPasswordFile();
            }
        }
        this.passwordManager.deletebackupPasswordFile();
        this.myUsername = null;
        this.nodeSecurityHandler.setUserName("");
        this.myIntegrationCode = null;
        this.logger.traceReturn("cleanup");
        return bl2;
    }

    protected final void createLocalAccountInfo() {
        String[] stringArray = new String[]{"password", "remoteHost", "userID"};
        Object[] objectArray = new String[]{DUMMY_NODE_PASSWORD, LOOPBACK_ADDRESS, this.myUsername};
        this.accountInfo = new Struct[]{new StructImpl(stringArray, objectArray)};
    }

    protected Struct createCertStruct(CertFile certFile, int n) throws SecurityActivationInputException {
        Struct struct = null;
        if (certFile != null) {
            String string = n == 0 ? FILENAME_LAADCA : (n == 1 ? FILENAME_AASERVERCA : FILENAME_CORBACA);
            EncryptedContentStorage encryptedContentStorage = this.encryptedContentStorageMgr.createEncryptedContentStorage(certFile.getEncryptedContent(), this.myIntegrationCode, string);
            String string2 = encryptedContentStorage.decipher();
            struct = StructCertSpec.createStruct((String)string2, (String)certFile.getCertSerialNumber(), (String)certFile.getCertFingerPrint(), (int)n);
            this.reportLogger.logMessage("SEC: Created CertStruct with filePath: " + string2 + ", serialNumber: " + certFile.getCertSerialNumber() + ", certFingerprint: " + certFile.getCertFingerPrint() + " and category: " + n + ".");
        }
        return struct;
    }

    protected void createCertStructs(List list, int n, List list2, String string) throws SecurityActivationInputException {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Struct struct = this.createCertStruct((CertFile)iterator.next(), n);
            if (struct == null) continue;
            this.reportLogger.logMessage(string);
            list2.add(struct);
        }
    }

    protected void executeAatest() throws SecurityActivationException {
        this.messageSender.sendMessage("Executing AATest for provided user: " + this.myUsername);
        try {
            AATestExecutor.execute(this.myUsername);
        }
        catch (SecurityActivationException securityActivationException) {
            throw new SecurityActivationException("AATest with provided user information failed.", securityActivationException);
        }
        this.messageSender.sendMessage("AATest successfully executed for user: " + this.myUsername);
    }

    protected String[] prepareLocalAADatabase(Level3Files level3Files) throws SecurityActivationInputException {
        String[] stringArray = null;
        this.messageSender.sendMessage("Preparing installation of Local AA Database.");
        this.doInstallLAAD = true;
        EncryptedContentStorage encryptedContentStorage = this.encryptedContentStorageMgr.createEncryptedContentStorage(level3Files.getLocalAuthenticationDB().getEncryptedContent(), this.myIntegrationCode, "authenticationDB");
        this.reportLogger.logMessage("Deciphering the authentication file");
        String string = encryptedContentStorage.decipher();
        EncryptedContentStorage encryptedContentStorage2 = this.encryptedContentStorageMgr.createEncryptedContentStorage(level3Files.getLocalAuthorizationDB().getEncryptedContent(), this.myIntegrationCode, "authorizationDB");
        this.reportLogger.logMessage("Deciphering the authorization file");
        String string2 = encryptedContentStorage2.decipher();
        stringArray = new String[]{string, string2};
        return stringArray;
    }

    protected void installLocalAADatabase(String[] stringArray) throws SecurityActivationException {
        if (stringArray != null) {
            this.messageSender.sendMessage("Installing the Local AA Database.");
            this.reportLogger.logMessage("SEC: Installing the Local AA Database.");
            String string = stringArray[0];
            String string2 = stringArray[1];
            this.nodeSecurityHandler.installLocalAADatabase(string, string2, DEFAULT_START_TIME, 5, this.accountInfo);
            this.messageSender.sendMessage("Installation of Local AA Database initiated.");
            this.reportLogger.logMessage("SEC: Installation of Local AA Database initiated.");
        }
    }

    protected void collectTrustedCertificates(ArrayList arrayList, Level2Files level2Files) throws SecurityActivationException, SecurityActivationInputException {
        if (level2Files != null) {
            this.createCertStructs(level2Files.getCorbaPeerCerts(), 2, arrayList, "Preparing to install trusted certificates for Corba Peers.");
        }
    }

    protected void collectTrustedCertificates(ArrayList arrayList, Level3Files level3Files) throws SecurityActivationException, SecurityActivationInputException {
        if (level3Files != null) {
            this.createCertStructs(level3Files.getLocalAADbFileSignersCerts(), 0, arrayList, "Preparing to install trusted certificates for Local AA Database File Signers.");
            this.createCertStructs(level3Files.getAAServersCerts(), 1, arrayList, "Preparing to install trusted certificates for AA Servers.");
        }
    }

    protected void installTrustedCertificates(ArrayList arrayList) throws SecurityActivationException {
        if (!arrayList.isEmpty()) {
            this.messageSender.sendMessage("Installing trusted certificates.");
            this.reportLogger.logMessage("SEC: Installing trusted certificates.");
            Struct[] structArray = arrayList.toArray(new Struct[0]);
            this.expectedNumberOfCerts = structArray.length + 1;
            this.nodeSecurityHandler.installTrustedCertificates(structArray, DEFAULT_START_TIME, 5, this.accountInfo);
            this.messageSender.sendMessage("Installation of trusted certificates initiated.");
            this.reportLogger.logMessage("SEC: Installation of trusted certificates initiated.");
        }
    }

    protected void parseIscf(String string) throws SecurityActivationInputException {
        this.messageSender.sendMessage("Starting to parse the Initial Security Configuration file.");
        IscfDataFinder iscfDataFinder = new IscfDataFinder();
        SecurityConfigurationModel securityConfigurationModel = iscfDataFinder.createModel(string);
        securityConfigurationModel.checkConsistency();
        this.securityConfData = securityConfigurationModel.getRoot();
        this.messageSender.sendMessage("Finished parsing of the Initial Security Configuration file.");
    }

    protected void waitForCertEnrollment() throws SecurityActivationException {
        if (this.doCertEnrollment) {
            this.nodeSecurityHandler.waitForCertEnrollment();
            this.esaDataVerification.writeStateFile(this.enrollmentOtp);
            this.enrollmentOtp = null;
            this.messageSender.sendMessage("Certificate enrollment is completed.");
            this.reportLogger.logMessage("SEC: Certificate enrollment is completed.");
            this.doCertEnrollment = false;
        }
    }

    protected void waitForInstallLocalAADatabase() throws SecurityActivationException {
        if (this.doInstallLAAD) {
            this.nodeSecurityHandler.waitForInstallLocalAADatabase();
        }
    }

    protected void waitForInstallTrustedCerts() throws SecurityActivationException {
        if (this.expectedNumberOfCerts > 1) {
            this.nodeSecurityHandler.waitForInstallTrustedCerts(this.expectedNumberOfCerts);
        }
    }

    protected void verifyCorrectNode(String string, String string2) throws SecurityActivationInputException {
        if (string != null && !string.equals(string2)) {
            throw new SecurityActivationInputException("The node logical name does not match the logical name in ISCF.");
        }
    }

    protected void verifyIscf(Validators validators, MetaData metaData, String string) throws SecurityActivationException, SecurityActivationInputException {
        this.esaDataVerification.verifyIscf(string, this.myIntegrationCode, validators.getHash(), validators.getHmac(), metaData.getCreationtime(), metaData.getNotValidAfter());
    }

    protected void verifyPreconditions(boolean bl) throws SecurityActivationException, SecurityActivationInputException {
        if (bl) {
            if (this.myIntegrationCode == null || "".equals(this.myIntegrationCode)) {
                throw new SecurityActivationInputException("The activation code is missing.");
            }
            int n = this.nodeSecurityHandler.adaptAndGetCurrentSecurityLevel();
            if (n != 1) {
                throw new SecurityActivationException("The current security level is not 1!");
            }
        } else if (!this.esaDataVerification.installIndicatorIsSet()) {
            throw new SecurityActivationException("The install() method must be executed");
        }
        if (this.myUsername == null || "".equals(this.myUsername)) {
            throw new SecurityActivationInputException("Username  is missing");
        }
        this.nodeSecurityHandler.verifyPreconditions();
    }

    protected CertInfo buildNodeCertInfo() throws SecurityActivationException {
        SecurityCertInfo securityCertInfo = new SecurityCertInfo();
        try {
            int n = 1;
            Struct struct = this.nodeSecurityHandler.getNodeCertInfo();
            String string = (String)struct.getValue("serialNumber");
            String string2 = (String)struct.getValue("fingerprint");
            securityCertInfo.setCertType(n);
            securityCertInfo.setCertFingerPrint(string2);
            securityCertInfo.setCertSerialNumber(string);
        }
        catch (Exception exception) {
            throw new SecurityActivationException("fault when fetching node security certificate info", exception);
        }
        return securityCertInfo;
    }
}

