/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.cppsec.esa.checksum;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import se.ericsson.security.cppsec.esa.wrapper.MessageLogWrapperFactory;

public class Checksum {
    private static final String UTF8 = "UTF-8";
    private static final String SHA1 = "SHA-1";
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private final byte[] myValue = new byte[20];

    protected Checksum() {
    }

    protected void addBoolean(boolean bl) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        byte[] byArray = Checksum.calculateSha1(String.valueOf(bl).getBytes(UTF8));
        this.addWithXor(byArray);
    }

    protected void addInt(int n) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        byte[] byArray = Checksum.calculateSha1(String.valueOf(n).getBytes(UTF8));
        this.addWithXor(byArray);
    }

    protected void addString(String string) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        byte[] byArray = Checksum.calculateSha1(string.getBytes(UTF8));
        this.addWithXor(byArray);
    }

    protected void addStringArray(String[] stringArray) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        for (int i = 0; i < stringArray.length; ++i) {
            this.addString(stringArray[i]);
        }
    }

    protected void addFile(String string) throws IOException, NoSuchAlgorithmException, UnsupportedEncodingException {
        try {
            byte[] byArray = Checksum.extractFileContent(string);
            byte[] byArray2 = Checksum.calculateSha1(byArray);
            this.addWithXor(byArray2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            MessageLogWrapperFactory.getLogger(this.getClass()).info("File: " + string + " is excluded from security checksum. File not found.");
        }
    }

    protected int addCertsFromDir(String string) throws NoSuchAlgorithmException, IOException, UnsupportedEncodingException {
        File file = new File(string);
        int n = 0;
        if (file.isDirectory()) {
            CertFilenameFilter certFilenameFilter = new CertFilenameFilter();
            String[] stringArray = file.list(certFilenameFilter);
            n = stringArray.length;
            for (int i = 0; i < stringArray.length; ++i) {
                this.addFile(string + FILE_SEPARATOR + stringArray[i]);
            }
        }
        return n;
    }

    private void addWithXor(byte[] byArray) {
        for (int i = 0; i < 20; ++i) {
            this.myValue[i] = (byte)(this.myValue[i] ^ byArray[i]);
        }
    }

    protected String getValue() {
        return "SHA1=" + Checksum.toColonHex(this.myValue);
    }

    protected static byte[] calculateSha1(byte[] byArray) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance(SHA1);
        messageDigest.update(byArray);
        return messageDigest.digest();
    }

    protected static byte[] extractFileContent(String string) throws FileNotFoundException, IOException {
        File file = new File(string);
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] byArray = new byte[(int)file.length()];
        int n = fileInputStream.read(byArray);
        if ((long)n != file.length()) {
            throw new IOException("Whole file not read!" + string);
        }
        fileInputStream.close();
        return byArray;
    }

    private static String toColonHex(byte[] byArray) {
        String string;
        if (null == byArray) {
            string = null;
        } else {
            byte[] byArray2 = "0123456789ABCDEF".getBytes();
            byte[] byArray3 = new byte[]{};
            if (byArray.length != 0) {
                byArray3 = new byte[byArray.length * 3 - 1];
            }
            for (int i = 0; i < byArray.length; ++i) {
                if (i != 0) {
                    byArray3[i * 3 + -1] = 58;
                }
                byArray3[i * 3 + 0] = byArray2[byArray[i] >> 4 & 0xF];
                byArray3[i * 3 + 1] = byArray2[byArray[i] & 0xF];
            }
            string = new String(byArray3);
        }
        return string;
    }

    private static class CertFilenameFilter
    implements FilenameFilter {
        private CertFilenameFilter() {
        }

        public boolean accept(File file, String string) {
            return string.endsWith(".trustedCert");
        }
    }
}

