/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.cppsec.esa.model.elements;

import org.xml.sax.Attributes;
import se.ericsson.security.cppsec.esa.SecurityActivationInputException;
import se.ericsson.security.cppsec.esa.model.elements.IpSecElement;
import se.ericsson.security.cppsec.esa.model.elements.MetaDataElement;
import se.ericsson.security.cppsec.esa.model.elements.SecurityElement;
import se.ericsson.security.cppsec.esa.parser.StackElement;

public class BodyElement
extends StackElement {
    public static final String BODY = "body";
    private MetaDataElement metaDataElement = null;
    private IpSecElement ipSecElement = null;
    private SecurityElement securityElement = null;

    protected StackElement createElement(String string, String string2, String string3, Attributes attributes) {
        StackElement stackElement = null;
        if ("metaData".equalsIgnoreCase(string2)) {
            this.metaDataElement = stackElement = new MetaDataElement();
        } else if ("ipSec".equalsIgnoreCase(string2)) {
            stackElement = new IpSecElement();
            this.ipSecElement = (IpSecElement)stackElement;
        } else if ("security".equalsIgnoreCase(string2)) {
            stackElement = new SecurityElement();
            this.securityElement = (SecurityElement)stackElement;
        }
        return stackElement;
    }

    public void checkConsistency() throws SecurityActivationInputException {
        if (this.metaDataElement == null) {
            throw new SecurityActivationInputException("The Body element is not consistent - it must contain a MetaData element");
        }
        if (this.securityElement == null && this.ipSecElement == null) {
            throw new SecurityActivationInputException("The Body element is not consistent - it must contain at least one Security or IpSec element");
        }
        if (this.securityElement != null) {
            this.securityElement.checkConsistency();
        }
        if (this.ipSecElement != null) {
            this.ipSecElement.checkConsistency();
        }
    }

    public MetaDataElement getMetaData() {
        return this.metaDataElement;
    }

    public IpSecElement getIpSecData() {
        return this.ipSecElement;
    }

    public SecurityElement getSecurityData() {
        return this.securityElement;
    }
}

