/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.cppsec.esa.model.elements;

import org.xml.sax.Attributes;
import se.ericsson.security.cppsec.esa.SecurityActivationInputException;
import se.ericsson.security.cppsec.esa.model.DataChallengePassword;
import se.ericsson.security.cppsec.esa.model.IpSecEnrollmentData;
import se.ericsson.security.cppsec.esa.model.elements.EnrollmentDataElement;
import se.ericsson.security.cppsec.esa.parser.StackElement;

public class IpSecEnrollmentDataElement
extends StackElement
implements IpSecEnrollmentData {
    private static final String SUBJECTALTNAMETYPE = "subjectAltNameType";
    private static final String SUBJECTALTNAME = "subjectAltName";
    public static final String IPSECENROLLMENTDATA = "ipsecEnrollmentData";
    private String subjectAltNameType;
    private String subjectAltName;
    private EnrollmentDataElement enrollmentData = null;

    protected void fetchAttributes(Attributes attributes) throws SecurityActivationInputException {
        this.subjectAltNameType = super.getOptionalAttribute(attributes, SUBJECTALTNAMETYPE, "0");
        this.subjectAltName = super.getOptionalAttribute(attributes, SUBJECTALTNAME, "");
        this.validateAttributes();
    }

    protected void validateAttributes() throws SecurityActivationInputException {
        int n = Integer.parseInt(this.subjectAltNameType);
        if (n < 1 || n > 2) {
            throw new SecurityActivationInputException("The IpSecEnrollmentData attribute subjectAltNameType has an invalid value - " + this.subjectAltNameType);
        }
    }

    protected StackElement createElement(String string, String string2, String string3, Attributes attributes) {
        EnrollmentDataElement enrollmentDataElement = null;
        if ("enrollmentData".equalsIgnoreCase(string2)) {
            this.enrollmentData = enrollmentDataElement = new EnrollmentDataElement();
        }
        return enrollmentDataElement;
    }

    public void checkConsistency() throws SecurityActivationInputException {
        if (this.enrollmentData == null) {
            throw new SecurityActivationInputException("The ipsecEnrollment element is not consistent - it must contain the EnrollmentData element");
        }
        this.enrollmentData.checkConsistency();
    }

    public Integer getSubjectAltNameType() {
        return Integer.valueOf(this.subjectAltNameType);
    }

    public String getSubjectAltName() {
        return this.subjectAltName;
    }

    public String getCAFingerprint() {
        return this.enrollmentData.getCAFingerprint();
    }

    public String getDistinguishedName() {
        return this.enrollmentData.getDistinguishedName();
    }

    public String getEnrollmentServerURL() {
        return this.enrollmentData.getEnrollmentServerURL();
    }

    public Integer getKeyLength() {
        return this.enrollmentData.getKeyLength();
    }

    public DataChallengePassword getDataChallengePassword() {
        return this.enrollmentData.getDataChallengePassword();
    }

    public Integer getEnrollmentTimeLimit() {
        return this.enrollmentData.getEnrollmentTimeLimit();
    }

    public Integer getEnrollmentMode() {
        return this.enrollmentData.getEnrollmentMode();
    }

    public String getCertificateAuthorityDn() {
        return this.enrollmentData.getCertificateAuthorityDn();
    }
}

