/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.neal;

import java.io.IOException;
import org.omg.CORBA.ORB;
import org.omg.PortableServer.POA;
import se.ericsson.cello.neal.CelloNodeConfig;
import se.ericsson.cello.neal.IorResolver;

public class NodeConfig {
    private CelloNodeConfig nodeConfiguration = new CelloNodeConfig();

    public NodeConfig() {
    }

    public NodeConfig(String string) {
        this.connectBy(string);
    }

    public String getConnectionInfo() {
        return this.nodeConfiguration.getConnectionInfo();
    }

    public NodeConfig connectBy(String string) {
        this.nodeConfiguration.setConnectionInfo(string);
        return this;
    }

    public NodeConfig connectByIpAddress(String string) {
        this.nodeConfiguration.setConnectionInfo(string);
        return this;
    }

    public NodeConfig connectByIpAddressAndPort(String string, String string2) throws IOException {
        return this.connectByIpAddress(string + ':' + string2);
    }

    public NodeConfig connectByUrl(String string) {
        if (!IorResolver.isUrl(string)) {
            throw new IllegalArgumentException("setIorUrl : Parameter isn't URL : nodeUrl=" + string);
        }
        this.nodeConfiguration.setConnectionInfo(string);
        return this;
    }

    public NodeConfig connectByIor(String string) {
        if (!IorResolver.isIorString(string)) {
            throw new IllegalArgumentException("setIorString : Parameter isn't IOR : nsIOR=" + string);
        }
        this.nodeConfiguration.setConnectionInfo(string);
        return this;
    }

    public NodeConfig connectByFile(String string) {
        if (string.indexOf(58) == -1) {
            string = "file://" + string;
        }
        if (!IorResolver.isIorFile(string)) {
            throw new IllegalArgumentException("setIorFile : Parameter isn't file : file=" + string);
        }
        this.nodeConfiguration.setConnectionInfo(string);
        return this;
    }

    public NodeConfig setExternalOrbAndPoa(ORB oRB, POA pOA, POA pOA2) {
        if (oRB == null && (pOA != null || pOA2 != null)) {
            throw new IllegalArgumentException("setExternalOrbAndPoa : When orb==null, unsecurePoa and securePoa must also be null");
        }
        this.nodeConfiguration.setExternalOrbAndPoa(oRB, pOA, pOA2);
        return this;
    }

    public void setAllServicesRequired(boolean bl) {
        this.nodeConfiguration.setAllServicesRequired(bl);
    }

    CelloNodeConfig getNodeConfiguration() {
        return this.nodeConfiguration;
    }

    public void setAuditIdentity(String string) {
        this.nodeConfiguration.setAuditIdentity(string);
    }

    public String getAuditIdenity() {
        return this.nodeConfiguration.getAuditIdentity();
    }
}

