/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.neal;

import se.ericsson.cello.neal.CelloNode;
import se.ericsson.cello.neal.NodeReader;
import se.ericsson.cello.neal.NodeSecurityReader;
import se.ericsson.cello.neal.NodeSecurityReaderFactory;
import se.ericsson.cello.neal.cm.CmService;
import se.ericsson.cello.neal.internal.NealLog;

class Poller
implements Runnable {
    private static final long FIFTEEN_SECONDS = 15000L;
    static long pollInterval = 15000L;
    static long nodeReadTimeout = 15000L;
    private CelloNode celloNode;
    private CmService cm;
    boolean nodeAccessable = true;
    int nodeSecurityState = 0;
    private Thread readThread = null;
    private Thread readSecThread = null;

    Poller(CelloNode celloNode) {
        this.celloNode = celloNode;
        this.cm = celloNode.getCmService();
    }

    public void run() {
        Thread thread = Thread.currentThread();
        NealLog.finest(thread.getName() + "Starting poller thread");
        while (this.celloNode.getPollerThread() == thread) {
            this.nodeSecurityState = 0;
            this.readAccessibility();
            if (!this.nodeAccessable) {
                this.readSecurity();
            }
            NealLog.finest("nodeStatus = " + this.nodeAccessable + ", nodeSecurityState = " + this.nodeSecurityState);
            this.celloNode.setNodeAccessable(this.nodeAccessable, this.nodeSecurityState);
            try {
                Thread.sleep(pollInterval);
            }
            catch (InterruptedException interruptedException) {}
        }
        NealLog.finest(thread.getName() + ": Node is no longer associated with this poller thread. Going out of scope");
    }

    private void readAccessibility() {
        try {
            NodeReader nodeReader = new NodeReader(this, this.cm);
            this.readThread = new Thread((Runnable)nodeReader, "NodeReader");
            this.readThread.start();
            long l = System.currentTimeMillis();
            this.readThread.join(nodeReadTimeout);
            if (System.currentTimeMillis() - l >= nodeReadTimeout) {
                this.readThread.interrupt();
                this.nodeAccessable = false;
            }
        }
        catch (Exception exception) {
            this.nodeAccessable = false;
        }
        catch (Throwable throwable) {
            this.nodeAccessable = false;
        }
    }

    private void readSecurity() {
        try {
            NodeSecurityReader nodeSecurityReader = NodeSecurityReaderFactory.createNodeSecurityReader(this, this.celloNode);
            this.readSecThread = new Thread((Runnable)nodeSecurityReader, "NodeSecurityReader");
            this.readSecThread.start();
            long l = System.currentTimeMillis();
            this.readSecThread.join(nodeReadTimeout);
            if (System.currentTimeMillis() - l >= nodeReadTimeout) {
                this.readSecThread.interrupt();
            }
        }
        catch (Exception exception) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void setNodeAccessable(boolean bl) {
        this.nodeAccessable = bl;
    }

    void setNodeSecurityState(int n) {
        this.nodeSecurityState = n;
    }

    Thread getReadThread() {
        return this.readThread;
    }

    Thread getReadSecThread() {
        return this.readSecThread;
    }
}

