/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.neal.cm;

import BasicConfig.MIBInfo;
import BasicConfig.NotAccepted;
import BasicConfig.NotDefined;
import BasicConfig.ProcessingFailure;
import BasicConfig.SecurityViolation;
import BasicConfig.UnsupportedQoS;
import ConfigExtended.MIBChangeInfo;
import ConfigExtended.MIBInfoExt;
import ConfigExtended.MOInfo;
import ConfigExtended.NotificationProducerPackage.NoTransactionException;
import ConfigExtended.NotificationProducerPackage.ToOldGenerationCount;
import ConfigExtended.RequestedAttributes;
import ConfigExtended.ReturnedAttributes;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UserException;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import se.ericsson.cello.neal.cm.CelloCmSubscription;
import se.ericsson.cello.neal.cm.CelloManagedObject;
import se.ericsson.cello.neal.cm.CelloNameValue;
import se.ericsson.cello.neal.cm.CelloNameValueFactory;
import se.ericsson.cello.neal.cm.CelloTransaction;
import se.ericsson.cello.neal.cm.CmException;
import se.ericsson.cello.neal.cm.CmNotificationConsumer;
import se.ericsson.cello.neal.cm.CmNotificationConsumerImpl;
import se.ericsson.cello.neal.cm.CmService;
import se.ericsson.cello.neal.cm.CmSubscription;
import se.ericsson.cello.neal.cm.CmSubscriptionFactory;
import se.ericsson.cello.neal.cm.DnAttributes;
import se.ericsson.cello.neal.cm.DnNameValues;
import se.ericsson.cello.neal.cm.EasyNaming;
import se.ericsson.cello.neal.cm.MibChangeInfo;
import se.ericsson.cello.neal.cm.MibInfo;
import se.ericsson.cello.neal.cm.Mo;
import se.ericsson.cello.neal.cm.NameValue;
import se.ericsson.cello.neal.cm.NameValueFactory;
import se.ericsson.cello.neal.cm.Scope;
import se.ericsson.cello.neal.cm.Transaction;
import se.ericsson.cello.neal.internal.OamService;
import se.ericsson.cello.neal.internal.ServiceContext;

class CelloCmService
implements CmService,
OamService {
    private ServiceContext serviceContext;
    private Mo cashedRootMo;
    private boolean isCacheOn = false;

    CelloCmService() {
    }

    public void init(ServiceContext serviceContext) throws NotFound, CannotProceed, InvalidName, SecurityViolation, UnsupportedQoS, ProcessingFailure, NotDefined {
        this.serviceContext = serviceContext;
        CmSubscriptionFactory.init(this, serviceContext);
    }

    public void free() {
        this.serviceContext = null;
        CmSubscriptionFactory.free(this);
    }

    public String toString() {
        return this.getClass().getName() + ":" + "Prefix=" + this.getMibPrefix(null);
    }

    public synchronized Mo getRootMo() {
        if (this.cashedRootMo == null) {
            try {
                MOInfo mOInfo = this.serviceContext.getConfigurationExtended().get_root_MO(null);
                this.cashedRootMo = new CelloManagedObject(this.serviceContext, mOInfo);
            }
            catch (UserException userException) {
                throw new CmException(userException);
            }
        }
        return this.cashedRootMo;
    }

    public Mo getMo(String string) {
        CelloManagedObject celloManagedObject = new CelloManagedObject(this.serviceContext, string);
        return celloManagedObject;
    }

    public Mo[] getMoByType(String string, Transaction transaction) {
        Mo[] moArray = null;
        if (string == null || string.equals("")) {
            throw new CmException("Invalid parameter mo type");
        }
        Mo mo = this.getRootMo();
        moArray = string.equals(mo.getType()) ? new Mo[]{mo} : mo.getChildren(string, "", Scope.ALL_LEVELS, transaction);
        return moArray;
    }

    public Mo[] getMoAndAttributes(DnAttributes[] dnAttributesArray, Transaction transaction) {
        if (dnAttributesArray.length == 0) {
            return new Mo[0];
        }
        Transaction transaction2 = CelloTransaction.startDefaultReadTx(transaction, this.serviceContext.getConfigurationExtended());
        RequestedAttributes[] requestedAttributesArray = new RequestedAttributes[dnAttributesArray.length];
        for (int i = 0; i < dnAttributesArray.length; ++i) {
            requestedAttributesArray[i] = dnAttributesArray[i].getRequestedAttributes();
        }
        try {
            ReturnedAttributes[] returnedAttributesArray = this.serviceContext.getConfigurationExtended().get_MO_attributes(requestedAttributesArray, ((CelloTransaction)transaction2).getBasicConfigSession());
            Mo[] moArray = new Mo[dnAttributesArray.length];
            for (int i = 0; i < dnAttributesArray.length; ++i) {
                moArray[i] = new CelloManagedObject(this.serviceContext, dnAttributesArray[i].getDn(), returnedAttributesArray[i].attributes);
            }
            CelloTransaction.commitDefaultReadTx(transaction2, transaction);
            return moArray;
        }
        catch (NotAccepted notAccepted) {
            CelloTransaction.rollbackDefaultReadTx(transaction2, transaction);
            throw new CmException(notAccepted);
        }
        catch (ProcessingFailure processingFailure) {
            CelloTransaction.rollbackDefaultReadTx(transaction2, transaction);
            throw new CmException(processingFailure);
        }
        catch (SystemException systemException) {
            CelloTransaction.rollbackDefaultReadTx(transaction2, transaction);
            throw systemException;
        }
    }

    public DnNameValues[] getMoAttributes(DnAttributes[] dnAttributesArray, Transaction transaction) {
        if (dnAttributesArray.length == 0) {
            return new DnNameValues[0];
        }
        Transaction transaction2 = CelloTransaction.startDefaultReadTx(transaction, this.serviceContext.getConfigurationExtended());
        RequestedAttributes[] requestedAttributesArray = new RequestedAttributes[dnAttributesArray.length];
        for (int i = 0; i < dnAttributesArray.length; ++i) {
            requestedAttributesArray[i] = dnAttributesArray[i].getRequestedAttributes();
        }
        try {
            ReturnedAttributes[] returnedAttributesArray = this.serviceContext.getConfigurationExtended().get_MO_attributes(requestedAttributesArray, ((CelloTransaction)transaction2).getBasicConfigSession());
            DnNameValues[] dnNameValuesArray = new DnNameValues[dnAttributesArray.length];
            for (int i = 0; i < dnAttributesArray.length; ++i) {
                BasicConfig.NameValue[] nameValueArray = returnedAttributesArray[i].attributes;
                NameValue[] nameValueArray2 = new NameValue[nameValueArray.length];
                for (int j = 0; j < nameValueArray.length; ++j) {
                    nameValueArray2[j] = new CelloNameValue(nameValueArray[j], this.serviceContext);
                }
                dnNameValuesArray[i] = new DnNameValues(dnAttributesArray[i].getDn(), nameValueArray2);
            }
            CelloTransaction.commitDefaultReadTx(transaction2, transaction);
            return dnNameValuesArray;
        }
        catch (NotAccepted notAccepted) {
            CelloTransaction.rollbackDefaultReadTx(transaction2, transaction);
            throw new CmException(notAccepted);
        }
        catch (ProcessingFailure processingFailure) {
            CelloTransaction.rollbackDefaultReadTx(transaction2, transaction);
            throw new CmException(processingFailure);
        }
        catch (SystemException systemException) {
            CelloTransaction.rollbackDefaultReadTx(transaction2, transaction);
            throw systemException;
        }
    }

    public synchronized void setMibPrefix(String string, Transaction transaction) {
        Transaction transaction2 = CelloTransaction.startDefaultWriteTx(transaction, this.serviceContext.getConfigurationExtended());
        this.cashedRootMo = null;
        try {
            this.serviceContext.getConfigurationExtended().set_prefix_MIB(this.serviceContext.getMibRef(), EasyNaming.string2NameComponentArray(string), ((CelloTransaction)transaction2).getBasicConfigSession());
            CelloTransaction.commitDefaultWriteTx(transaction2, transaction);
        }
        catch (ProcessingFailure processingFailure) {
            CelloTransaction.rollbackDefaultWriteTx(transaction2, transaction);
            throw new CmException(processingFailure);
        }
        catch (SecurityViolation securityViolation) {
            CelloTransaction.rollbackDefaultWriteTx(transaction2, transaction);
            throw new CmException(securityViolation);
        }
        catch (NotDefined notDefined) {
            CelloTransaction.rollbackDefaultWriteTx(transaction2, transaction);
            throw new CmException(notDefined);
        }
        catch (UnsupportedQoS unsupportedQoS) {
            CelloTransaction.rollbackDefaultWriteTx(transaction2, transaction);
            throw new CmException(unsupportedQoS);
        }
        catch (NotAccepted notAccepted) {
            CelloTransaction.rollbackDefaultWriteTx(transaction2, transaction);
            throw new CmException(notAccepted);
        }
        catch (SystemException systemException) {
            CelloTransaction.rollbackDefaultWriteTx(transaction2, transaction);
            throw systemException;
        }
    }

    public String getMibPrefix(Transaction transaction) {
        MIBInfo mIBInfo = this.getMibInfo(transaction);
        return EasyNaming.nameComponentArray2String(mIBInfo.prefix);
    }

    public String getMibType(Transaction transaction) {
        MIBInfo mIBInfo = this.getMibInfo(transaction);
        return mIBInfo.type;
    }

    public String getMimVersion(Transaction transaction) {
        MIBInfo mIBInfo = this.getMibInfo(transaction);
        return mIBInfo.version;
    }

    public MibInfo getMibInfo() {
        MIBInfoExt mIBInfoExt = this.getMibInfoExt();
        MibInfo mibInfo = new MibInfo(mIBInfoExt, this.serviceContext.getConfigurationExtended().get_CS_interface_version());
        int n = this.serviceContext.getConfigurationExtended().get_mo_instance_count();
        mibInfo.setMoInstanceCount(n);
        return mibInfo;
    }

    public Transaction createNullTransaction() {
        return new CelloTransaction();
    }

    public Transaction createTransaction() {
        return new CelloTransaction(this.serviceContext.getConfigurationExtended());
    }

    public Transaction createTransaction(int n) {
        return new CelloTransaction(this.serviceContext.getConfigurationExtended(), n);
    }

    public void detachCsNotificationConsumer(CmNotificationConsumer cmNotificationConsumer) {
        CmNotificationConsumerImpl.delete(cmNotificationConsumer, this.serviceContext);
    }

    public NameValueFactory getNameValueFactory() {
        return CelloNameValueFactory.getInstance();
    }

    public boolean isCacheOn() {
        return this.isCacheOn;
    }

    public synchronized void setCacheOn(boolean bl) {
        this.isCacheOn = bl;
        this.cashedRootMo = null;
    }

    public void disableNotification(CmSubscription cmSubscription, Transaction transaction) {
        if (!(cmSubscription instanceof CelloCmSubscription)) {
            throw new CmException("Wrong type of subscription.");
        }
        try {
            this.serviceContext.getNotificationProducer().disable_notifications_for_transaction(((CelloCmSubscription)cmSubscription).getSubscriptionId(), ((CelloTransaction)transaction).getBasicConfigSession());
        }
        catch (NoTransactionException noTransactionException) {
            throw new CmException(noTransactionException);
        }
    }

    public int getGenerationCount() {
        return this.serviceContext.getNotificationProducer().get_generation_count();
    }

    public MibChangeInfo[] getMibChanges(int n) {
        try {
            MIBChangeInfo[] mIBChangeInfoArray = this.serviceContext.getNotificationProducer().get_MIB_changes(n);
            MibChangeInfo[] mibChangeInfoArray = new MibChangeInfo[mIBChangeInfoArray.length];
            for (int i = 0; i < mIBChangeInfoArray.length; ++i) {
                mibChangeInfoArray[i] = new MibChangeInfo(mIBChangeInfoArray[i]);
            }
            return mibChangeInfoArray;
        }
        catch (ToOldGenerationCount toOldGenerationCount) {
            throw new CmException(toOldGenerationCount);
        }
    }

    private MIBInfo getMibInfo(Transaction transaction) {
        Transaction transaction2 = CelloTransaction.startDefaultReadTx(transaction, this.serviceContext.getConfigurationExtended());
        try {
            MIBInfo mIBInfo = this.serviceContext.getConfigurationExtended().get_MIB_info(this.serviceContext.getMibRef(), ((CelloTransaction)transaction2).getBasicConfigSession());
            CelloTransaction.commitDefaultReadTx(transaction2, transaction);
            return mIBInfo;
        }
        catch (ProcessingFailure processingFailure) {
            CelloTransaction.rollbackDefaultReadTx(transaction2, transaction);
            throw new CmException(processingFailure);
        }
        catch (SecurityViolation securityViolation) {
            CelloTransaction.rollbackDefaultReadTx(transaction2, transaction);
            throw new CmException(securityViolation);
        }
        catch (NotDefined notDefined) {
            CelloTransaction.rollbackDefaultReadTx(transaction2, transaction);
            throw new CmException(notDefined);
        }
        catch (UnsupportedQoS unsupportedQoS) {
            CelloTransaction.rollbackDefaultReadTx(transaction2, transaction);
            throw new CmException(unsupportedQoS);
        }
        catch (SystemException systemException) {
            CelloTransaction.rollbackDefaultReadTx(transaction2, transaction);
            throw systemException;
        }
    }

    private MIBInfoExt getMibInfoExt() {
        try {
            MIBInfoExt mIBInfoExt = this.serviceContext.getConfigurationExtended().get_MIB_info_ext(this.serviceContext.getMibRef(), null);
            return mIBInfoExt;
        }
        catch (ProcessingFailure processingFailure) {
            throw new CmException(processingFailure);
        }
        catch (SecurityViolation securityViolation) {
            throw new CmException(securityViolation);
        }
        catch (NotDefined notDefined) {
            throw new CmException(notDefined);
        }
        catch (UnsupportedQoS unsupportedQoS) {
            throw new CmException(unsupportedQoS);
        }
        catch (SystemException systemException) {
            throw systemException;
        }
    }
}

