/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.neal.fm;

import java.util.HashMap;
import java.util.LinkedList;
import org.omg.CORBA.Any;
import se.ericsson.cello.neal.cm.IllegalTypeException;
import se.ericsson.cello.neal.cm.NameValue;
import se.ericsson.cello.neal.cm.Struct;
import se.ericsson.cello.neal.internal.InternalNameValueFactory;
import se.ericsson.cello.neal.internal.NealLog;
import se.ericsson.cello.neal.internal.ServiceContext;
import se.ericsson.cello.neal.internal.omsi_version.PropertyAdapter;
import se.ericsson.cello.neal.internal.omsi_version.StructuredEventAdapter;

class FmNotificationBase {
    private StructuredEventAdapter _se;
    private Struct cachedFilterableData;
    ServiceContext serviceContext;

    protected FmNotificationBase(StructuredEventAdapter structuredEventAdapter, ServiceContext serviceContext) {
        this._se = structuredEventAdapter;
        this.serviceContext = serviceContext;
    }

    public String getDomainNameAbbrev() {
        return this._se.header.fixed_header.event_type.domain_name;
    }

    public String getDomainName() {
        String string = this._se.header.fixed_header.event_type.domain_name;
        String string2 = string.equals("1f1") ? "ALARM_IRP_VERSION_1_1" : (string.equals("1c1") ? "CONFIGURATION_IRP_VERSION_1_1" : (string.equals("1n1") ? "NOTIFICATION_IRP_VERSION_1_1" : "UNKNOWN_IRP_VERSION"));
        return string2;
    }

    public String getEventTypeDef() {
        return this._se.header.fixed_header.event_type.type_name;
    }

    public String getExtendedEventTypeDef() {
        return this._se.header.fixed_header.event_name;
    }

    public NameValue getAttribute(String string) {
        NameValue nameValue = this.getAttributes().getMember(string);
        return nameValue;
    }

    public NameValue getAttribute(String string, NameValue nameValue) {
        NameValue nameValue2 = this.getAttributes().getMember(string);
        if (nameValue2 == null && nameValue != null) {
            nameValue.setName(string);
            return nameValue;
        }
        return nameValue2;
    }

    public synchronized Struct getAttributes() {
        if (this.cachedFilterableData == null) {
            PropertyAdapter[] propertyAdapterArray = this._se.filterable_data;
            NameValue[] nameValueArray = this.toNameValueArray(propertyAdapterArray, "FilterableData");
            this.cachedFilterableData = new Struct(nameValueArray);
        }
        return this.cachedFilterableData;
    }

    public NameValue[] getAdditionalInfo() {
        PropertyAdapter[] propertyAdapterArray = this._se.filterable_data;
        int n = 0;
        LinkedList<NameValue> linkedList = new LinkedList<NameValue>();
        InternalNameValueFactory internalNameValueFactory = this.serviceContext.getNameValueFactory();
        for (int i = 0; i < propertyAdapterArray.length; ++i) {
            String string = propertyAdapterArray[i].name;
            Any any = propertyAdapterArray[i].value;
            if (!this.isNotIrpInfo(string)) continue;
            linkedList.add(internalNameValueFactory.create(string, any));
            ++n;
        }
        NameValue[] nameValueArray = new NameValue[linkedList.size()];
        nameValueArray = linkedList.toArray(nameValueArray);
        return nameValueArray;
    }

    private boolean isNotIrpInfo(String string) {
        boolean bl = false;
        if (!(string.equals("a") || string.equals("b") || string.equals("c") || string.equals("d") || string.equals("e") || string.equals("f") || string.equals("g") || string.equals("h") || string.equals("z") || string.equals("i") || string.equals("j") || string.equals("k") || string.equals("l") || string.equals("m") || string.equals("n") || string.equals("o") || string.equals("p") || string.equals("q") || string.equals("r") || string.equals("s") || string.equals("t") || string.equals("u"))) {
            bl = true;
        }
        return bl;
    }

    private NameValue[] toNameValueArray(PropertyAdapter[] propertyAdapterArray, String string) {
        NameValue nameValue;
        NameValue[] nameValueArray = new NameValue[propertyAdapterArray.length + 3];
        HashMap<String, NameValue> hashMap = new HashMap<String, NameValue>(propertyAdapterArray.length + 3);
        InternalNameValueFactory internalNameValueFactory = this.serviceContext.getNameValueFactory();
        String string2 = "NEAL.fixed_header.domain_name";
        nameValueArray[0] = nameValue = internalNameValueFactory.create(string2, this.getDomainName());
        hashMap.put(string2, nameValue);
        string2 = "NEAL.fixed_header.type_name";
        nameValueArray[1] = nameValue = internalNameValueFactory.create(string2, this.getEventTypeDef());
        hashMap.put(string2, nameValue);
        string2 = "NEAL.fixed_header.event_name";
        nameValueArray[2] = nameValue = internalNameValueFactory.create(string2, this.getExtendedEventTypeDef());
        hashMap.put(string2, nameValue);
        for (int i = 0; i < propertyAdapterArray.length; ++i) {
            NameValue nameValue2;
            string2 = propertyAdapterArray[i].name;
            Any any = propertyAdapterArray[i].value;
            nameValueArray[i + 3] = nameValue2 = this.toNameValue(string2, any, string);
            if (!hashMap.containsKey(string2)) {
                hashMap.put(string2, (NameValue)any);
                continue;
            }
            Object v = hashMap.get("a");
            String string3 = "";
            if (v != null) {
                string3 = " with NotificationId('a')=" + v;
            } else {
                v = hashMap.get("k");
                if (v != null) {
                    string3 = " with AlarmId('k')=" + v;
                }
            }
            NealLog.warning("NEAL received FmNotification" + string3 + " that contains multiple " + string + " SS Attributes with name=" + string2 + "! First value=" + hashMap.get(string2) + ". Second value=" + any + ".");
        }
        return nameValueArray;
    }

    private NameValue toNameValue(String string, Any any, String string2) {
        InternalNameValueFactory internalNameValueFactory = this.serviceContext.getNameValueFactory();
        NameValue nameValue = null;
        try {
            nameValue = internalNameValueFactory.create(string, any, this.serviceContext);
        }
        catch (IllegalTypeException illegalTypeException) {
            NealLog.warning("NEAL received FmNotification with  unsupported value type in CORBA Property named " + string + " in " + string2 + "!", illegalTypeException);
            nameValue = internalNameValueFactory.create(string);
        }
        return nameValue;
    }
}

