/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.neal.internal.orb_version;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import se.ericsson.cello.neal.JarVersionError;
import se.ericsson.cello.neal.NealRuntimeException;
import se.ericsson.cello.neal.internal.JarVersionInfo;
import se.ericsson.cello.neal.internal.NealLog;
import se.ericsson.cello.neal.internal.NealOrb;
import se.ericsson.cello.neal.internal.OverriddenProperties;
import se.ericsson.cello.neal.internal.PoaType;
import se.ericsson.cello.neal.internal.csu_version.CsuVersionInfo;
import se.ericsson.cello.neal.internal.csu_version.ORBInitAdapter;
import se.ericsson.cello.neal.internal.orb_version.JacOrbDefaultOrb;
import se.ericsson.cello.neal.internal.orb_version.JacOrbVersionInfo;
import se.ericsson.cello.neal.internal.orb_version.VisiBrokerDefaultOrb;
import se.ericsson.cello.neal.internal.orb_version.VisiBrokerVersionInfo;

public abstract class NealOrbDefaultFactory {
    private static final Class THIS_CLASS = class$se$ericsson$cello$neal$internal$orb_version$NealOrbDefaultFactory == null ? (class$se$ericsson$cello$neal$internal$orb_version$NealOrbDefaultFactory = NealOrbDefaultFactory.class$("se.ericsson.cello.neal.internal.orb_version.NealOrbDefaultFactory")) : class$se$ericsson$cello$neal$internal$orb_version$NealOrbDefaultFactory;
    protected static final String thisJarFile = JarVersionInfo.getJar(THIS_CLASS);
    protected static boolean celloSecurityState;
    private static NealOrbDefaultFactory theSingleton;
    private static NealOrb theNealOrbFactoryDefault;
    protected ORBInitAdapter csu = NealOrbDefaultFactory.getCsuAdapter();
    private final PoaType SECURE;
    private final PoaType NOT_SECURE;
    private final String orbVendor;
    protected boolean debug = Boolean.getBoolean("se.ericsson.security.debug");
    private List tmpFiles = new Vector();
    private ORB orb = null;
    static /* synthetic */ Class class$se$ericsson$cello$neal$internal$orb_version$NealOrbDefaultFactory;

    protected NealOrbDefaultFactory(int n) {
        this.SECURE = new PoaType(true, n);
        this.NOT_SECURE = new PoaType(false, n);
        this.orbVendor = this.SECURE.getVendor();
    }

    public static synchronized NealOrbDefaultFactory instance() {
        if (theSingleton == null) {
            if (!NealOrbDefaultFactory.isJacOrbPresent() && !NealOrbDefaultFactory.isVisiBrokerPresent()) {
                throw new JarVersionError(null, "Can't create default ORB! No known version of JacORB or VisiBroker on the classpath!");
            }
            if (!NealOrbDefaultFactory.isCsuPresent()) {
                throw new JarVersionError(null, "Can't create default ORB without CSU on the classpath!");
            }
            if (NealOrbDefaultFactory.isJacOrbPresent()) {
                theSingleton = new JacOrbDefaultOrb();
            } else if (NealOrbDefaultFactory.isVisiBrokerPresent()) {
                theSingleton = new VisiBrokerDefaultOrb();
            } else {
                throw new JarVersionError(null, "Can't create default ORB! No known version of JacORB or VisiBroker on the classpath!");
            }
        }
        return theSingleton;
    }

    public synchronized NealOrb getNealOrbFactoryDefault() {
        if (theNealOrbFactoryDefault == null) {
            theNealOrbFactoryDefault = this.createNealOrbDefault();
        }
        return theNealOrbFactoryDefault;
    }

    public static void setSecurityState(boolean bl) {
        celloSecurityState = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NealOrb createNealOrbDefault() {
        Iterator iterator;
        NealOrb nealOrb;
        try {
            NealOrb nealOrb2;
            NealLog.config("Creating NEAL default " + this.orbVendor + " ORB and POAs with CelloSecurityState=" + (this.isCelloSecurityStateOn() ? "ON" : "OFF"));
            this.orb = this.createOrb(this.NOT_SECURE);
            POA pOA = NealOrbDefaultFactory.startRootPoa(this.NOT_SECURE, this.orb);
            POA pOA2 = null;
            if (this.isCelloSecurityStateOn()) {
                this.orb = this.createOrb(this.SECURE);
                pOA2 = NealOrbDefaultFactory.startRootPoa(this.SECURE, this.orb);
            }
            nealOrb = nealOrb2 = new NealOrb(this.orb, pOA2, pOA);
            java.lang.Object var6_5 = null;
            iterator = this.tmpFiles.iterator();
        }
        catch (Throwable throwable) {
            java.lang.Object var6_6 = null;
            Iterator iterator2 = this.tmpFiles.iterator();
            while (iterator2.hasNext()) {
                File file = (File)iterator2.next();
                NealOrbDefaultFactory.tryDelete(file);
            }
            this.tmpFiles.clear();
            throw throwable;
        }
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            NealOrbDefaultFactory.tryDelete(file);
        }
        this.tmpFiles.clear();
        return nealOrb;
    }

    abstract void setProperties(PoaType var1, OverriddenProperties var2);

    protected ORB createOrb(PoaType poaType) {
        OverriddenProperties overriddenProperties = new OverriddenProperties(System.getProperties());
        this.setProperties(poaType, overriddenProperties);
        String string = overriddenProperties.toString();
        NealLog.fine("NealOrbDefaultFactory.createOrb(" + poaType + ") has " + string);
        Properties properties = this.csu.getOrbProperties(poaType.equals(this.SECURE));
        try {
            this.orb = ORB.init((String[])null, (Properties)properties);
        }
        catch (RuntimeException runtimeException) {
            throw new NealRuntimeException("Failed creating NEAL default " + poaType + " ORB!", runtimeException);
        }
        ORB oRB = ORB.init();
        String string2 = oRB.getClass().getName();
        String string3 = this.orb.getClass().getName();
        if (!string2.startsWith(string3)) {
            throw new JarVersionError(null, "Invalid ORBSingleton Class detected! Expected " + string3 + "Singleton" + " but got " + string2 + "!");
        }
        System.setProperties(overriddenProperties.getOriginalProperties());
        return this.orb;
    }

    static synchronized POA startRootPoa(PoaType poaType, ORB oRB) {
        if (oRB == null) {
            return null;
        }
        POA pOA = null;
        try {
            pOA = POAHelper.narrow((Object)oRB.resolve_initial_references("RootPOA"));
        }
        catch (InvalidName invalidName) {
            NealLog.warning("Failed resolving RootPOA for " + poaType + " ORB!", invalidName);
            return null;
        }
        catch (INITIALIZE iNITIALIZE) {
            String string = iNITIALIZE.getMessage();
            if (string.startsWith("Could not create SSL server socket")) {
                NealLog.warning("Is another CPP CORBA application already running on this host?\n  Failed creating SLL socket for " + poaType + " RootPOA!", iNITIALIZE);
                return null;
            }
            NealLog.warning("Failed resolving RootPOA for " + poaType + " ORB!", iNITIALIZE);
            return null;
        }
        try {
            pOA.the_POAManager().activate();
        }
        catch (AdapterInactive adapterInactive) {
            adapterInactive.printStackTrace();
            throw new NealRuntimeException("Failed activating RootPOA for " + poaType + " ORB!", adapterInactive);
        }
        return pOA;
    }

    static void tryDelete(File file) {
        if (file == null) {
            return;
        }
        try {
            file.delete();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected String getTmpFile(URL uRL) {
        File file = null;
        try {
            String string = System.getProperty("java.io.tmpdir");
            String string2 = new File(uRL.getFile()).getName();
            file = new File(string, string2);
            this.tmpFiles.add(file);
            file.deleteOnExit();
            NealOrbDefaultFactory.copyUrl2File(uRL, file);
        }
        catch (Exception exception) {
            throw new NealRuntimeException("NEAL INTERNAL ERROR! Failed writing temp file " + file, exception);
        }
        return file.toString();
    }

    URL getJarResource(String string) {
        String string2 = "/se/ericsson/cello/neal/internal/resources/" + string;
        URL uRL = THIS_CLASS.getResource(string2);
        if (uRL == null) {
            throw new NealRuntimeException("INTERNAL NEAL ERROR!\n   Failed retreiving required file " + string2 + "\n   from " + thisJarFile + "!");
        }
        return uRL;
    }

    static void copyUrl2File(URL uRL, File file) throws IOException {
        int n;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(uRL.openStream());
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        while ((n = bufferedInputStream.read()) != -1) {
            bufferedOutputStream.write(n);
        }
        bufferedOutputStream.flush();
        bufferedOutputStream.close();
        bufferedInputStream.close();
    }

    protected static boolean isCsuPresent() {
        boolean bl = CsuVersionInfo.instance().isJarOnClasspath();
        return bl;
    }

    protected static ORBInitAdapter getCsuAdapter() {
        ORBInitAdapter oRBInitAdapter = CsuVersionInfo.instance().isJarOnClasspath() ? ORBInitAdapter.instance() : null;
        return oRBInitAdapter;
    }

    protected static boolean isJacOrbPresent() {
        boolean bl = JacOrbVersionInfo.instance().isJarOnClasspath();
        return bl;
    }

    protected static boolean isVisiBrokerPresent() {
        boolean bl = VisiBrokerVersionInfo.instance().isJarOnClasspath();
        return bl;
    }

    public static void free() {
        theSingleton = null;
        theNealOrbFactoryDefault = null;
    }

    public static void setExternalNealOrb(NealOrb nealOrb) {
        theNealOrbFactoryDefault = nealOrb;
    }

    private boolean isCelloSecurityStateOn() {
        return celloSecurityState;
    }

    public void shutdownOrb() {
        if (this.orb != null) {
            NealLog.fine("Graceful shutdown of neal orb");
            this.orb.shutdown(true);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

