/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.em.fm.common.model.impl;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import se.ericsson.cello.em.fm.common.model.impl.TableMap;
import se.ericsson.cello.em.fm.common.view.impl.SortedTable;

public class SortedTableModel
extends TableMap {
    private static final long serialVersionUID = 1L;
    private int[] indexes;
    private int indexesLength = 0;
    private Vector<Integer> sortingColumns = new Vector();
    private ListMouseListener listMouseListener = null;
    private JTableHeader tableHeader = null;
    private SortedTable table;
    private boolean setSortOnRowInsertDelete = false;
    private int clickedColumn = 0;
    private boolean ascending = true;

    public SortedTableModel(TableModel model) {
        this.setModel(model);
    }

    void setModel(TableModel model) {
        super.setModel(model);
        this.reallocateIndexes();
    }

    public int getIndex(int row) {
        if (row < this.indexesLength && row >= 0) {
            return this.indexes[row];
        }
        throw new ArrayIndexOutOfBoundsException(row + "not in 0.." + (this.indexesLength - 1));
    }

    public int getPresentedIndex(int originalRow) {
        for (int i = 0; i < this.indexesLength; ++i) {
            if (originalRow != this.indexes[i]) continue;
            int presentedRow = i;
            return presentedRow;
        }
        throw new ArrayIndexOutOfBoundsException(originalRow + " not in 0.." + (this.indexesLength - 1));
    }

    private int compareRowsByColumn(int row1, int row2, int column) {
        Object o2;
        Object o1 = this.model.getValueAt(row1, column);
        if (o1 == (o2 = this.model.getValueAt(row2, column))) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (o1 instanceof Comparable) {
            try {
                return ((Comparable)o1).compareTo(o2);
            }
            catch (ClassCastException e) {
                return o1.toString().compareTo(o2.toString());
            }
        }
        if (o1.getClass() == o2.getClass() && o1.getClass() == Integer.class) {
            return ((Integer)o1).compareTo((Integer)o2);
        }
        if (o1.getClass() == o2.getClass() && o1.getClass() == Boolean.class) {
            if (((Boolean)o1).equals(o2)) {
                return 0;
            }
            if (((Boolean)o1).booleanValue()) {
                return 1;
            }
            return -1;
        }
        return o1.toString().compareTo(o2.toString());
    }

    private int compare(int row1, int row2) {
        for (int level = 0; level < this.sortingColumns.size(); ++level) {
            Integer column = this.sortingColumns.elementAt(level);
            int result = this.compareRowsByColumn(row1, row2, column);
            if (result == 0) continue;
            return this.ascending ? result : -result;
        }
        return 0;
    }

    private void reallocateIndexes() {
        int rowCount = this.model.getRowCount();
        if (this.indexes == null || this.indexes.length < rowCount) {
            this.indexes = new int[rowCount];
        }
        for (int row = 0; row < rowCount; ++row) {
            this.indexes[row] = row;
        }
        this.indexesLength = rowCount;
    }

    public void doSort() {
        boolean temp = this.setSortOnRowInsertDelete;
        this.setSortOnRowInsertDelete = false;
        int column = 0;
        if (!this.sortingColumns.isEmpty()) {
            column = this.sortingColumns.elementAt(0);
        }
        this.sortByColumn(column);
        this.setSortOnRowInsertDelete = temp;
    }

    public void tableChanged(TableModelEvent e) {
        int selectedRow = -1;
        int[] selectedRows = null;
        if (this.table != null) {
            selectedRow = this.table.getOriginalSelectedRow();
            selectedRows = this.table.getOriginalSelectedRows();
        }
        if (e.getType() == 1 || e.getType() == -1 || e.getFirstRow() == -1) {
            this.reallocateIndexes();
            if (this.table != null) {
                this.table.editingStopped(new ChangeEvent(this));
            }
            if (this.setSortOnRowInsertDelete) {
                if (e.getFirstRow() == -1) {
                    this.sortingColumns.removeAllElements();
                }
                int column = 0;
                if (this.sortingColumns.isEmpty()) {
                    column = this.sortingColumns.elementAt(0);
                }
                this.sortByColumn(column);
            }
            this.sortByColumn(this.clickedColumn);
        }
        if (e.getFirstRow() == -1) {
            super.tableChanged(new TableModelEvent(this, -1));
        } else {
            super.tableChanged(new TableModelEvent(this));
        }
        if (this.table != null && selectedRow != -1) {
            if (this.indexesLength < selectedRow + 1 || e.getFirstRow() == selectedRow) {
                this.table.clearSelection();
            } else {
                for (int i = 0; i < this.indexesLength; ++i) {
                    if (this.indexes[i] != selectedRow) continue;
                    selectedRow = i;
                    break;
                }
                this.table.getSelectionModel().setSelectionInterval(selectedRow, selectedRow);
                block1: for (int j = 0; j < selectedRows.length; ++j) {
                    for (int i = 0; i < this.indexesLength; ++i) {
                        if (this.indexes[i] != selectedRows[j]) continue;
                        this.table.getSelectionModel().addSelectionInterval(i, i);
                        continue block1;
                    }
                }
            }
        }
    }

    private void sortByColumn(int column) {
        this.sortingColumns.removeAllElements();
        this.sortingColumns.addElement(column);
        this.sort();
        super.tableChanged(new TableModelEvent(this));
    }

    private void sort() {
        this.checkModel();
        this.shuttlesort((int[])this.indexes.clone(), this.indexes, 0, this.indexesLength);
    }

    protected void checkModel() {
        if (this.indexesLength != this.model.getRowCount()) {
            this.reallocateIndexes();
        }
    }

    private void shuttlesort(int[] from, int[] to, int low, int high) {
        if (high - low < 2) {
            return;
        }
        int middle = (low + high) / 2;
        this.shuttlesort(to, from, low, middle);
        this.shuttlesort(to, from, middle, high);
        int p = low;
        int q = middle;
        if (high - low >= 4 && this.compare(from[middle - 1], from[middle]) <= 0) {
            for (int i = low; i < high; ++i) {
                to[i] = from[i];
            }
            return;
        }
        for (int i = low; i < high; ++i) {
            to[i] = q >= high || p < middle && this.compare(from[p], from[q]) <= 0 ? from[p++] : from[q++];
        }
    }

    public Object getValueAt(int aRow, int aColumn) {
        this.checkModel();
        return this.model.getValueAt(this.indexes[aRow], aColumn);
    }

    public void setValueAt(Object aValue, int aRow, int aColumn) {
        this.checkModel();
        if (aRow < this.getRowCount()) {
            this.model.setValueAt(aValue, this.indexes[aRow], aColumn);
        }
    }

    public void addMouseListenerToHeaderInTable(SortedTable table) {
        this.table = table;
        table.setColumnSelectionAllowed(false);
        this.tableHeader = table.getTableHeader();
        this.listMouseListener = new ListMouseListener(this);
        this.tableHeader.addMouseListener(this.listMouseListener);
    }

    public void removeMouseListenerToHeaderInTable() {
        if (this.listMouseListener != null) {
            this.tableHeader.removeMouseListener(this.listMouseListener);
        }
    }

    public void setSortOnRowInsertDelete(boolean setSortOnRowInsertDelete) {
        this.setSortOnRowInsertDelete = setSortOnRowInsertDelete;
    }

    public void resetClickedColumn() {
        this.clickedColumn = 0;
    }

    private class ListMouseListener
    extends MouseAdapter {
        SortedTableModel sorter = null;

        public ListMouseListener(SortedTableModel s) {
            this.sorter = s;
        }

        public void mouseClicked(MouseEvent e) {
            int row = -1;
            int selectedRow = SortedTableModel.this.table.getSelectedRow();
            if (selectedRow > -1) {
                row = SortedTableModel.this.indexes[selectedRow];
            }
            SortedTableModel.this.table.editingStopped(new ChangeEvent(this));
            TableColumnModel columnModel = SortedTableModel.this.table.getColumnModel();
            int viewColumn = columnModel.getColumnIndexAtX(e.getX());
            int column = SortedTableModel.this.table.convertColumnIndexToModel(viewColumn);
            if (e.getClickCount() == 1 && column != -1) {
                if (SortedTableModel.this.clickedColumn == column) {
                    this.sorter.ascending = !SortedTableModel.this.ascending;
                } else {
                    this.sorter.ascending = true;
                }
                SortedTableModel.this.clickedColumn = column;
                this.sorter.sortByColumn(column);
            }
            if (row > -1) {
                for (int i = 0; i < SortedTableModel.this.indexesLength; ++i) {
                    if (SortedTableModel.this.indexes[i] != row) continue;
                    SortedTableModel.this.table.setRowSelectionInterval(i, i);
                    break;
                }
            }
        }
    }
}

