/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.log;

import java.util.ArrayList;
import java.util.Map;
import java.util.ResourceBundle;
import se.ericsson.cello.faultmanagement.AlarmManager;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandler;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationSubscriber;
import se.ericsson.cello.log.AccountInformation;
import se.ericsson.cello.log.LogMo;
import se.ericsson.cello.log.log_mi;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.maofro.framework.FroData;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.maofro.framework.StringParameter;
import se.ericsson.cello.maofro.proxy.MaoFroGenericEventInd;
import se.ericsson.cello.maofro.proxy.MaoFroGenericParameterChdInd;
import se.ericsson.cello.maofro.proxy.TagNameDictionaries;
import se.ericsson.cello.maofro.proxy.TagNameDictionary;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoCanNotBeCreatedException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;

public class LogMoImpl
extends CelloMao
implements LogMo {
    private MoData data;
    private IntegerAttribute logFroId;
    protected static final int MAX_LOGNAME_LENGTH = 60;
    protected static final int MIN_LOGNAME_LENGTH = 0;
    protected static final int MAX_FILEPATH_LENGTH = 256;
    protected static final int MIN_FILEPATH_LENGTH = 0;
    protected static final int MAX_USERID_LENGTH = 21;
    protected static final int MAX_PASSWORD_LENGTH = 21;
    protected static final int MAX_FRO_USERID_LENGTH = 24;
    protected static final int MAX_FRO_PASSWORD_LENGTH = 24;
    protected static final int MAX_REMOTEHOST_LENGTH = 256;
    private static final int ACTION_PUSH_LOG = 1;
    private static final int PUSH_LOG_FAILED = 2;
    private static final String LOG_FRO_ID = "logFroId";
    private static final int MO_DATA_REVISION_6000 = 6000;
    private static final int MO_DATA_REVISION_LATEST = 6000;
    private FroProxy proxy = null;
    private MaoFroIndicationHandler indicationHandler = null;
    TagNameDictionary tnd = TagNameDictionaries.get((ResourceBundle)ResourceBundle.getBundle(log_mi.class.getName()));
    static /* synthetic */ Class class$java$lang$String;

    public static synchronized ManagedObject create(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkIdentity((String)"Log", (String)string);
        MoAttributeValidator.checkParent((ManagedObject)managedObject, (String)"LogService");
        String string2 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"userLabel", (AttrList)attrList, (boolean)false, (String)"", (String)"Log", (int)128, (int)0);
        String string3 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"logFilePath", (AttrList)attrList, (boolean)true, (String)"", (String)"Log", (int)256, (int)0);
        String string4 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"logName", (AttrList)attrList, (boolean)true, (String)"", (String)"Log", (int)60, (int)0);
        AccountInformation accountInformation = LogMoImpl.checkAndGetAccountInformation(attrList);
        MoAttributeValidator.checkOtherAttributes((AttrList)attrList, (String)"Log");
        return new LogMoImpl(managedObject, string, string2, string3, string4, accountInformation, coordinator, froProxy, maoFroIndicationHandler);
    }

    private LogMoImpl(ManagedObject managedObject, String string, String string2, String string3, String string4, AccountInformation accountInformation, Coordinator coordinator, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoAccessException {
        super(managedObject, "Log", string, coordinator);
        this.proxy = froProxy;
        this.indicationHandler = maoFroIndicationHandler;
        this.checkLogName(string4, coordinator, managedObject);
        this.data = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        this.data.registerPersistentAttr((Attribute)new StringAttribute("userLabel", true, string2));
        int n = this.createLogFro(coordinator, string3, string4, accountInformation);
        this.logFroId = new IntegerAttribute(LOG_FRO_ID, false, n);
        this.data.registerPersistentAttr((Attribute)this.logFroId);
        this.data.setRevision(6000);
        maoFroIndicationHandler.registerForNotifications(coordinator, (MaoFroIndicationSubscriber)this, this.logFroId.getValue(coordinator));
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("userLabel", string, coordinator);
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("userLabel", coordinator);
    }

    public Struct getTransferData(Coordinator coordinator) throws MoAccessException {
        return (Struct)this.getAttribute("transferData", coordinator);
    }

    public void setAccountInfo(Struct struct, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("accountInfo", struct, coordinator);
    }

    public Struct getAccountInfo(Coordinator coordinator) throws MoAccessException {
        return (Struct)this.getAttribute("accountInfo", coordinator);
    }

    public String getLogName(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("logName", coordinator);
    }

    public int getLogSize(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("logSize", coordinator);
    }

    public String getLogFilePath(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("logFilePath", coordinator);
    }

    public void setLogFilePath(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("logFilePath", string, coordinator);
    }

    private int createLogFro(Coordinator coordinator, String string, String string2, AccountInformation accountInformation) throws MoAccessException {
        ArrayList<StringParameter> arrayList = new ArrayList<StringParameter>();
        arrayList.add(new StringParameter("logFilePath", string, 256));
        arrayList.add(new StringParameter("logName", string2, 60));
        arrayList.add(new StringParameter("userID", accountInformation.getUserID(), 24));
        arrayList.add(new StringParameter("password", accountInformation.getPassword(), 24));
        arrayList.add(new StringParameter("remoteHost", accountInformation.getRemoteHost(), 256));
        try {
            FroData froData = this.proxy.create(coordinator, arrayList);
            return froData.getFroId();
        }
        catch (FroRequestFailedException froRequestFailedException) {
            MessageLog.traceError(this.getClass(), (String)"error code proxy.create(c  ", (Throwable)froRequestFailedException);
            throw froRequestFailedException;
        }
    }

    public LogMoImpl(MoData moData, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName());
        this.data = moData;
        this.proxy = froProxy;
        this.indicationHandler = maoFroIndicationHandler;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(6000);
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute(LOG_FRO_ID);
        this.logFroId = (IntegerAttribute)moData.getAttribute(LOG_FRO_ID);
        maoFroIndicationHandler.registerForNotifications(null, (MaoFroIndicationSubscriber)this, this.logFroId.getValue(null));
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.indicationHandler.deregisterForNotifications(coordinator, this.logFroId.getValue(coordinator));
        this.proxy.delete(coordinator, this.logFroId.getValue(coordinator), null);
        super.delete(coordinator);
        this.data.delete(coordinator);
    }

    private void checkLogName(String string, Coordinator coordinator, ManagedObject managedObject) throws MoAccessException {
        MoIterator moIterator = managedObject.getChildren();
        while (moIterator.hasMoreElements()) {
            ManagedObject managedObject2 = moIterator.nextMo();
            if (managedObject2 == this || !managedObject2.getAttribute("logName", coordinator).equals(string)) continue;
            throw new MoCanNotBeCreatedException("A LogMo with the same logName " + string + " already exists");
        }
    }

    public int getFroId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((IntegerAttribute)this.data.getAttribute(LOG_FRO_ID)).getValue(coordinator);
    }

    public String getType() {
        return "Log";
    }

    public Object getAttribute(String string, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = this.getAttributes(stringArray, coordinator);
        return objectArray[0];
    }

    public Object[] getAttributes(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Object[] objectArray = new Object[stringArray.length];
        Map map = null;
        for (int i = 0; i < stringArray.length; ++i) {
            Object[] objectArray2;
            String[] stringArray2;
            StringParameter stringParameter;
            StringParameter stringParameter2;
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                objectArray[i] = ((StringAttribute)this.data.getAttribute("userLabel")).getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("froId")) {
                objectArray[i] = new Integer(((IntegerAttribute)this.data.getAttribute(LOG_FRO_ID)).getValue(coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase(this.getType() + "Id")) {
                objectArray[i] = super.getNamingAttributeValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("logName")) {
                map = this.getAttrFromRes(map, coordinator);
                stringParameter2 = (StringParameter)map.get("logName");
                objectArray[i] = new String(stringParameter2.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("logFilePath")) {
                map = this.getAttrFromRes(map, coordinator);
                stringParameter2 = (StringParameter)map.get("logFilePath");
                objectArray[i] = new String(stringParameter2.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("accountInfo")) {
                map = this.getAttrFromRes(map, coordinator);
                stringParameter2 = (StringParameter)map.get("userID");
                stringParameter = (StringParameter)map.get("remoteHost");
                stringArray2 = (String[])map.get("password");
                objectArray2 = new String[]{"password", "remoteHost", "userID"};
                Object[] objectArray3 = new Object[]{stringArray2.getValue(), stringParameter.getValue(), stringParameter2.getValue()};
                objectArray[i] = new StructImpl((String[])objectArray2, objectArray3);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("transferData")) {
                map = this.getAttrFromRes(map, coordinator);
                stringParameter2 = (StringParameter)map.get("lastSent");
                stringParameter = (StringParameter)map.get("transferInformation");
                stringArray2 = new String[]{"lastSent", "transferInformation"};
                objectArray2 = new Object[]{stringParameter2.getValue(), stringParameter.getValue()};
                objectArray[i] = new StructImpl(stringArray2, objectArray2);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("logSize")) {
                map = this.getAttrFromRes(map, coordinator);
                stringParameter2 = (SignedIntParameter)map.get("logSize");
                objectArray[i] = new Integer(stringParameter2.getValue());
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "Log");
        }
        return objectArray;
    }

    private Map getAttrFromRes(Map map, Coordinator coordinator) throws MoAccessException {
        if (map == null) {
            return this.proxy.getAttributes(coordinator, this.logFroId.getValue(coordinator));
        }
        return map;
    }

    public void setAttribute(String string, Object object, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        this.setAttributes(stringArray, objectArray, coordinator);
    }

    public void setAttributes(String[] stringArray, Object[] objectArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        boolean bl = false;
        String string = null;
        ArrayList<StringParameter> arrayList = new ArrayList<StringParameter>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                if (!objectArray[i].getClass().equals(class$java$lang$String == null ? LogMoImpl.class$("java.lang.String") : class$java$lang$String)) {
                    throw new WrongAttributeTypeException("userLabel", "Log");
                }
                MoAttributeValidator.checkStringWithLength((String)((String)objectArray[i]), (String)"userLabel", (String)"Log", (int)128, (int)0);
                ((StringAttribute)this.data.getAttribute("userLabel")).setValue((String)objectArray[i]);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("accountInfo")) {
                if (!(objectArray[i] instanceof Struct)) {
                    throw new WrongAttributeTypeException("accountInfo", "Log");
                }
                AccountInformation accountInformation = new AccountInformation((Struct)objectArray[i]);
                if (accountInformation.getPassword().length() > 21 || accountInformation.getRemoteHost().length() > 256 || accountInformation.getUserID().length() > 21) {
                    throw new ValueOutOfRangeException("accountInfo", "Log");
                }
                arrayList.add(new StringParameter("password", accountInformation.getPassword(), 24));
                arrayList.add(new StringParameter("remoteHost", accountInformation.getRemoteHost(), 256));
                arrayList.add(new StringParameter("userID", accountInformation.getUserID(), 24));
                String[] stringArray2 = new String[]{"password", "remoteHost", "userID"};
                Object[] objectArray2 = new Object[]{new String("******"), accountInformation.getRemoteHost(), accountInformation.getUserID()};
                Object[] objectArray3 = new Object[]{new StructImpl(stringArray2, objectArray2)};
                String[] stringArray3 = new String[]{new String("accountInfo")};
                NotificationSender.instance().pushAVC((ManagedObject)this, stringArray3, objectArray3);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("logFilePath")) {
                if (!objectArray[i].getClass().equals(class$java$lang$String == null ? LogMoImpl.class$("java.lang.String") : class$java$lang$String)) {
                    throw new WrongAttributeTypeException("logFilePath", "Log");
                }
                string = (String)objectArray[i];
                arrayList.add(new StringParameter("logFilePath", string, 256));
                this.sendNotification("logFilePath", string, coordinator);
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "Log");
        }
        if (arrayList.size() > 0) {
            this.proxy.setAttributes(coordinator, this.logFroId.getValue(coordinator), arrayList);
        }
    }

    private static AccountInformation checkAndGetAccountInformation(AttrList attrList) throws MoAccessException {
        int n = attrList.indexOf("accountInfo");
        if (n == -1) {
            return new AccountInformation();
        }
        if (attrList.getValue(n) == null) {
            throw new ValueOutOfRangeException("accountInfo", "Log");
        }
        if (!(attrList.getValue(n) instanceof Struct)) {
            throw new WrongAttributeTypeException("accountInfo", "Log");
        }
        AccountInformation accountInformation = new AccountInformation((Struct)attrList.getValue(n));
        attrList.removeElementAt(n);
        return accountInformation;
    }

    public void actionPushLog(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Map map = this.proxy.actionWithCfm(coordinator, this.logFroId.getValue(coordinator), 1, null);
    }

    private void sendNotification(String string, Object object, Coordinator coordinator) {
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        if (coordinator == null) {
            NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray);
        } else {
            NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
        }
    }

    public void parameterChanged(MaoFroGenericParameterChdInd maoFroGenericParameterChdInd) {
        try {
            Map map = maoFroGenericParameterChdInd.getParameters(this.tnd);
            StringParameter stringParameter = (StringParameter)map.get("transferInformation");
            StringParameter stringParameter2 = (StringParameter)map.get("lastSent");
            if (stringParameter != null && stringParameter2 != null) {
                String[] stringArray = new String[2];
                Object[] objectArray = new String[2];
                objectArray[0] = new String(stringParameter2.getValue());
                stringArray[0] = new String("lastSent");
                objectArray[1] = new String(stringParameter.getValue());
                stringArray[1] = new String("transferInformation");
                String[] stringArray2 = new String[]{new String("transferData")};
                Object[] objectArray2 = new Object[]{new StructImpl(stringArray, objectArray)};
                NotificationSender.instance().pushAVC((ManagedObject)this, stringArray2, objectArray2);
            } else {
                MessageLog.traceError(this.getClass(), (String)"Unknown attribute in parameterChanged()");
            }
        }
        catch (MoAccessException moAccessException) {
            MessageLog.traceError(this.getClass(), (String)"Attribute tag not in property file");
        }
    }

    public void eventRaised(MaoFroGenericEventInd maoFroGenericEventInd) {
        try {
            Map map = maoFroGenericEventInd.getParameters(TagNameDictionaries.getDefault());
            String string = "";
            StringParameter stringParameter = (StringParameter)map.get("additionalText");
            if (stringParameter != null) {
                string = stringParameter.getValue();
            }
            if (maoFroGenericEventInd.getSpecificEvent() == 2) {
                AlarmManager.getReporter().reportEvent(80, (ManagedObject)this, AlarmManager.Reporter.TIME_NOW, string, null);
            } else {
                MessageLog.traceError(this.getClass(), (String)"Unknown event type sent to Log");
            }
        }
        catch (MoAccessException moAccessException) {
            MessageLog.traceError(this.getClass(), (String)"Attribute tag  not in property file");
        }
    }
}

