/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.common.proxy;

import enea.ose.system.InSignal;
import enea.ose.system.OseProcess;
import enea.ose.system.Signal;
import enea.ose.system.SignalRegistry;
import enea.ose.system.ThisProcess;
import se.ericsson.cello.support.sigutil.OseNameServer;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.common.proxy.OseSenderReceiver;
import se.ericsson.crbs.omf.common.proxy.SignalException;
import se.ericsson.crbs.omf.common.sigutil.SignalHelperWrapperFactory;

public class OseSenderReceiverImpl
implements OseSenderReceiver {
    private static final Class THIS_CLASS = OseSenderReceiverImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());

    public InSignal receiveSignal(SignalRegistry sigReg, int tmo) {
        InSignal receivedSignal = ThisProcess.receive((SignalRegistry)sigReg, (int)tmo);
        if (receivedSignal != null) {
            logger.traceDebug(THIS_CLASS, "Got signal " + Integer.toString(receivedSignal.getSigNo()));
        }
        return receivedSignal;
    }

    public void sendSignal(OseProcess sender, OseProcess receiver, Signal signal) throws SignalException {
        if (signal == null) {
            String errorMsg = "No signal specified !";
            logger.traceError(THIS_CLASS, "No signal specified !");
            throw new SignalException("No signal specified !");
        }
        if (sender == null) {
            String errorMsg = "No sender specified. Failed to send signal [" + signal.getClass().getName() + "]";
            logger.traceError(THIS_CLASS, errorMsg);
            throw new SignalException(errorMsg);
        }
        if (receiver == null) {
            String errorMsg = "No receiver specified. Failed to send signal [" + signal.getClass().getName() + "]";
            logger.traceError(THIS_CLASS, errorMsg);
            throw new SignalException(errorMsg);
        }
        logger.traceGeneral(THIS_CLASS, "Sending signal " + signal.getClass().getName() + " (" + signal.getSigNo() + ") to PID " + receiver.getPID());
        SignalHelperWrapperFactory.getInstance().getSignalHelperWrapper().sendWithSender(receiver, sender, signal);
    }

    public OseProcess getThisProcess() {
        return ThisProcess.getThisProcess();
    }

    public OseProcess getSender(InSignal inSignal) {
        return inSignal.getSender();
    }

    public void addServiceToOseNameServer(String serviceName) {
        OseNameServer.addService((String)serviceName);
    }

    public void removeServiceFromOseNameServer(String serviceName) {
        OseNameServer.removeService((String)serviceName);
    }
}

