/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.mao.commonmo.metadata.supplier;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.IllegalParentException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.NoSuchFieldException;
import se.ericsson.cello.moframework.NotHandledAttributeTypeException;
import se.ericsson.cello.moframework.SourceMoWrongTypeException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.AttrListImpl;
import se.ericsson.crbs.omf.mao.commonmo.ProcessingFailureException;
import se.ericsson.crbs.omf.mao.commonmo.StringHolder;
import se.ericsson.crbs.omf.mao.commonmo.metadata.AttributeMetaData;
import se.ericsson.crbs.omf.mao.commonmo.metadata.finder.MoMetaDataFinder;
import se.ericsson.crbs.omf.mao.commonmo.metadata.supplier.DataSupplier;
import se.ericsson.crbs.omf.mao.commonmo.metadata.supplier.StructDataSupplier;
import se.ericsson.crbs.omf.mao.commonmo.metadata.types.SeqDataType;
import se.ericsson.crbs.omf.mao.commonmo.metadata.types.StructRefType;
import se.ericsson.crbs.omf.mao.commonmo.validation.MoAttrNotSettableException;
import se.ericsson.crbs.omf.mao.genericmo.DeprecatedGenericMaoHelper;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class DataSupplierImpl
implements DataSupplier {
    private static final Class THIS_CLASS = DataSupplierImpl.class;
    private static AbstractLogger logger = LoggingService.getLogger(DataSupplierImpl.class.getName());
    private final String mMoType;
    private final MoMetaDataFinder moMetaDataFinder;
    private final StructDataSupplier structDataSupplier;

    public DataSupplierImpl(String moType, MoMetaDataFinder aMoMetaDataFinder) {
        this.mMoType = moType;
        this.moMetaDataFinder = aMoMetaDataFinder;
        this.structDataSupplier = new StructDataSupplier(this.moMetaDataFinder);
    }

    private void copyAttributes(AttrListImpl attrList, AttrList sourceList) throws NotHandledAttributeTypeException, MoNotFoundException {
        logger.traceEnter(THIS_CLASS, "copyAttributes()");
        for (int idx = 0; idx < sourceList.size(); ++idx) {
            String attrName = sourceList.getName(idx);
            Object attrValue = sourceList.getValue(idx);
            logger.traceGeneral(THIS_CLASS, "Copying attribute: " + attrName);
            attrList.addAttribute(attrName, attrValue);
        }
        logger.traceReturn(THIS_CLASS, "copyAttributes()");
    }

    private void findSiblingsMoIds(List siblingList, String pname, int noOfIds, int[] moIds) {
        String name = pname;
        for (int idx = 0; idx < noOfIds; ++idx) {
            StringTokenizer tkn = new StringTokenizer(((ManagedObject)siblingList.get(idx)).getLocalDistinguishedName(), ",");
            while (tkn.hasMoreTokens()) {
                name = tkn.nextToken();
            }
            name = name.substring(name.indexOf(61) + 1).trim();
            try {
                moIds[idx] = Integer.parseInt(name);
                continue;
            }
            catch (NumberFormatException nfe) {
                moIds[idx] = -1;
            }
        }
        Arrays.sort(moIds);
    }

    private void generateNamingAttribute(StringHolder identity, ManagedObject parent) {
        int candidate;
        logger.traceEnter(this.getClass(), "generateNamingAttribute()");
        MoIterator candSiblingList = parent.getChildren();
        ArrayList<ManagedObject> siblingList = new ArrayList<ManagedObject>();
        String name = "";
        while (candSiblingList.hasMoreElements()) {
            ManagedObject candSibling = candSiblingList.nextMo();
            if (!candSibling.getType().equalsIgnoreCase(this.mMoType)) continue;
            siblingList.add(candSibling);
        }
        int noOfIds = siblingList.size();
        int[] moIds = new int[noOfIds];
        this.findSiblingsMoIds(siblingList, "", noOfIds, moIds);
        if (moIds.length == 0) {
            candidate = 1;
        } else if (moIds[moIds.length - 1] < Integer.MAX_VALUE) {
            candidate = moIds[moIds.length - 1] + 1;
        } else {
            int sortIndex;
            for (sortIndex = 0; sortIndex < noOfIds && moIds[sortIndex] == -1; ++sortIndex) {
            }
            for (candidate = 1; sortIndex < noOfIds && candidate == moIds[sortIndex]; ++candidate, ++sortIndex) {
            }
        }
        identity.setString(String.valueOf(candidate));
        logger.traceReturn(this.getClass(), "generateNamingAttribute()");
    }

    private void setMandatoryAndOptionalAttributesFromSourceObject(AttrListImpl attrList, ManagedObject sourceObject, Coordinator coord) throws ProcessingFailureException, MoAccessException {
        logger.traceEnter(this.getClass(), "setMandatoryAndOptionalAttributesFromSourceObject() " + this.mMoType);
        Iterator attrsIter = this.moMetaDataFinder.getMandatoryAndOptionalAttributes(this.mMoType).values().iterator();
        while (attrsIter.hasNext()) {
            AttributeMetaData attrMetaData = (AttributeMetaData)attrsIter.next();
            if (attrMetaData.isReadOnly() || attrMetaData.getReplacedBy() != null) continue;
            Object attrValue = sourceObject.getAttribute(attrMetaData.getName(), coord);
            attrList.addAttribute(attrMetaData.getName(), attrValue);
            this.removeDeprecatedAttribute(attrMetaData, attrList);
        }
        logger.traceReturn(this.getClass(), "setMandatoryAndOptionalAttributesFromSourceObject() " + this.mMoType);
    }

    private void removeDeprecatedAttribute(AttributeMetaData attrMetaData, AttrListImpl attrList) throws NotHandledAttributeTypeException, NoSuchFieldException, MoNotFoundException {
        int indexOfDeprecatedAttr = this.getIndexOfDeprecatedAttribute(attrMetaData, attrList);
        String replacedAttrName = DeprecatedGenericMaoHelper.getReplacedAttributeName(attrMetaData, this.mMoType);
        if (indexOfDeprecatedAttr != -1) {
            attrList.removeElementAt(indexOfDeprecatedAttr);
        } else if (replacedAttrName != null) {
            AttributeMetaData replacedAttrMetaData = this.moMetaDataFinder.getMoAttributes(this.mMoType, replacedAttrName);
            this.removeDeprecatedAttribute(replacedAttrMetaData, attrList);
        }
    }

    private int getIndexOfDeprecatedAttribute(AttributeMetaData attrMetaData, AttrList attrList) throws NotHandledAttributeTypeException, NoSuchFieldException, MoNotFoundException {
        int replacedIndex;
        int indexOfDeprecatedAttribute = -1;
        String replacedAttrName = DeprecatedGenericMaoHelper.getReplacedAttributeName(attrMetaData, this.mMoType);
        if (replacedAttrName != null && (replacedIndex = attrList.indexOf(replacedAttrName)) != -1) {
            indexOfDeprecatedAttribute = replacedIndex;
        }
        return indexOfDeprecatedAttribute;
    }

    private void addOptionalAttributesDefaultValues(AttrListImpl attrList) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "setOptionalAttributesDefaultValues");
        Iterator optionalAttrsIter = this.moMetaDataFinder.getOptionalAttributes(this.mMoType).values().iterator();
        while (optionalAttrsIter.hasNext()) {
            AttributeMetaData attrMetaData = (AttributeMetaData)optionalAttrsIter.next();
            if (attrMetaData.isReadOnly()) continue;
            int attrIndex = attrList.indexOf(attrMetaData.getName());
            if (attrIndex != -1) {
                Object attrValue = attrList.getValue(attrIndex);
                this.supplyStructDataAtCreate(attrList, attrMetaData, attrIndex, attrValue);
                continue;
            }
            if (attrMetaData.getReplacedBy() != null) continue;
            Object defaultValue = attrMetaData.getData().getDefaultValue(this.moMetaDataFinder);
            if (!this.canGenerateDefaultValue(attrMetaData, attrList)) continue;
            attrList.addAttribute(attrMetaData.getName(), defaultValue);
        }
        logger.traceDebug(THIS_CLASS, " setOptionalAttributesDefaultValues number of attributes in list: " + attrList.size());
        logger.traceReturn(THIS_CLASS, "setOptionalAttributesDefaultValues");
    }

    private boolean canGenerateDefaultValue(AttributeMetaData attrMetaData, AttrListImpl attrList) throws NotHandledAttributeTypeException, NoSuchFieldException, MoNotFoundException {
        boolean canDo = true;
        String replacedAttrName = DeprecatedGenericMaoHelper.getReplacedAttributeName(attrMetaData, this.mMoType);
        int indexOfDeprecatedAttribute = this.getIndexOfDeprecatedAttribute(attrMetaData, attrList);
        if (replacedAttrName != null) {
            if (indexOfDeprecatedAttribute == -1) {
                AttributeMetaData replacedAttrMetaData = this.moMetaDataFinder.getMoAttributes(this.mMoType, replacedAttrName);
                canDo = this.canGenerateDefaultValue(replacedAttrMetaData, attrList);
            } else {
                canDo = false;
            }
        }
        return canDo;
    }

    private void supplyStructDataAtCreate(AttrListImpl attrList, AttributeMetaData attrMetaData, int attrIndex, Object attrValue) throws MoAccessException {
        if (attrValue instanceof Struct && !attrMetaData.isMandatory()) {
            logger.traceDebug(THIS_CLASS, "supplyStructDataAtCreate. An optional struct attribute detected, name: " + attrMetaData.getName());
            Object defaultValue = attrMetaData.getData().getDefaultValue(this.moMetaDataFinder);
            String structRefName = ((StructRefType)attrMetaData.getData()).getReferencedStruct();
            Struct updatedStructAttr = this.structDataSupplier.addMissingStructMembers((Struct)attrValue, (Struct)defaultValue, structRefName);
            attrList.getAttrValues().set(attrIndex, updatedStructAttr);
        } else if (attrValue instanceof Struct[] && !attrMetaData.isMandatory()) {
            logger.traceDebug(THIS_CLASS, "supplyStructDataAtCreate. An optional struct array attribute detected, name: " + attrMetaData.getName());
            String structRefName = ((StructRefType)((SeqDataType)attrMetaData.getData()).getSeqType()).getReferencedStruct();
            Object defaultValue = attrMetaData.getData().getDefaultValue(this.moMetaDataFinder);
            Struct[] updatedStructArray = this.structDataSupplier.addMissingStructMembersInEachElement((Struct[])attrValue, (Struct[])defaultValue, structRefName);
            attrList.getAttrValues().set(attrIndex, updatedStructArray);
        }
    }

    public final AttrList supplyDataAtCreate(ManagedObject sourceObject, AttrList attributeList, ManagedObject parent, StringHolder identity, Coordinator coord, MoRepositoryWrapper moRepositoryWrapper) throws SourceMoWrongTypeException, MoNotFoundException, NotHandledAttributeTypeException, IllegalParentException, ProcessingFailureException, MoAccessException {
        logger.traceEnter(this.getClass(), "supplyDataAtCreate");
        if (identity.getString().equals("")) {
            this.generateNamingAttribute(identity, parent);
        }
        this.checkForMultipleSetsOfDeprecatedAttribute(attributeList);
        AttrListImpl returnList = new AttrListImpl(moRepositoryWrapper);
        this.copyAttributes(returnList, attributeList);
        if (sourceObject == null) {
            this.addOptionalAttributesDefaultValues(returnList);
        } else {
            if (!sourceObject.getType().equalsIgnoreCase(this.mMoType)) {
                throw new SourceMoWrongTypeException(sourceObject.getType());
            }
            this.setMandatoryAndOptionalAttributesFromSourceObject(returnList, sourceObject, coord);
        }
        logger.traceReturn(this.getClass(), "supplyDataAtCreate");
        return returnList;
    }

    private void checkForMultipleSetsOfDeprecatedAttribute(AttrList attributeList) throws NotHandledAttributeTypeException, NoSuchFieldException, MoNotFoundException, MoAttrNotSettableException {
        logger.traceEnter(this.getClass(), "deprectationCheck()");
        for (int a = 0; a < attributeList.size(); ++a) {
            String attrName = attributeList.getName(a);
            AttributeMetaData attrMetaData = this.moMetaDataFinder.getMoAttributes(this.mMoType, attrName);
            this.checkForMultipleSetsOfDeprecatedAttribute(attrMetaData, attributeList);
        }
        logger.traceReturn(this.getClass(), "deprectationCheck()");
    }

    private void checkForMultipleSetsOfDeprecatedAttribute(AttributeMetaData attrMetaData, AttrList attributeList) throws NotHandledAttributeTypeException, NoSuchFieldException, MoNotFoundException, MoAttrNotSettableException {
        int indexOfDeprecatedAttribute = this.getIndexOfDeprecatedAttribute(attrMetaData, attributeList);
        String attributeName = attrMetaData.getName();
        String replacedAttrName = DeprecatedGenericMaoHelper.getReplacedAttributeName(attrMetaData, this.mMoType);
        if (indexOfDeprecatedAttribute != -1) {
            throw new MoAttrNotSettableException(this.mMoType, "(" + attributeName + ") and (" + replacedAttrName + ")", "Duplicated setting for the both values is not allowed!");
        }
        if (replacedAttrName != null) {
            AttributeMetaData replacedAttrMetaData = this.moMetaDataFinder.getMoAttributes(this.mMoType, replacedAttrName);
            this.checkForMultipleSetsOfDeprecatedAttribute(replacedAttrMetaData, attributeList);
        }
    }

    public Object supplyStructDataAtSet(Object currentAttributeValue, Object attrValueInDataBase, AttributeMetaData attrMetaData, Coordinator coordinator) throws MoAccessException {
        if (currentAttributeValue instanceof Struct && !attrMetaData.isMandatory()) {
            logger.traceDebug(THIS_CLASS, "supplyStructDataAtSet. An optional struct attribute detected, name: " + attrMetaData.getName());
            String structRefName = ((StructRefType)attrMetaData.getData()).getReferencedStruct();
            Struct updatedStruct = this.structDataSupplier.addMissingStructMembers((Struct)currentAttributeValue, (Struct)attrValueInDataBase, structRefName);
            currentAttributeValue = updatedStruct;
        } else if (currentAttributeValue instanceof Struct[] && !attrMetaData.isMandatory()) {
            Struct[] updatedStructArray;
            logger.traceDebug(THIS_CLASS, "supplyStructDataAtSet. An optional struct array attribute detected, name: " + attrMetaData.getName());
            Struct[] sourceStructArray = (Struct[])attrValueInDataBase;
            String structRefName = ((StructRefType)((SeqDataType)attrMetaData.getData()).getSeqType()).getReferencedStruct();
            currentAttributeValue = updatedStructArray = this.structDataSupplier.addMissingStructMembersInEachElement(currentAttributeValue, sourceStructArray, structRefName);
        }
        return currentAttributeValue;
    }
}

