/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.mao.commonmo.metadata.supplier;

import java.util.ArrayList;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.NotHandledAttributeTypeException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.StructImpl;
import se.ericsson.crbs.omf.mao.commonmo.metadata.StructMetaData;
import se.ericsson.crbs.omf.mao.commonmo.metadata.finder.MoMetaDataFinder;
import se.ericsson.crbs.omf.mao.commonmo.metadata.types.SeqDataType;
import se.ericsson.crbs.omf.mao.commonmo.metadata.types.StructRefType;

public class StructDataSupplier {
    private static final Class THIS_CLASS = StructDataSupplier.class;
    private static AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());
    private final MoMetaDataFinder moMetaDataFinder;

    public StructDataSupplier(MoMetaDataFinder moMetaDataFinder) {
        this.moMetaDataFinder = moMetaDataFinder;
    }

    public Struct addMissingStructMembers(Struct structValue, Struct sourceStruct, String structRefName) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "addMissingStructMembers");
        if (structValue == null || sourceStruct == null || structRefName == null) {
            throw new IllegalArgumentException("Input parameter is null.");
        }
        StructImpl gmfStructValue = this.convertToGmfStruct(structValue);
        StructMetaData structMetaData = (StructMetaData)this.moMetaDataFinder.getStructmap().get(structRefName);
        for (int i = 0; i < structMetaData.getMemberNames().length; ++i) {
            String currentMemberName = structMetaData.getMemberNames()[i];
            boolean memberfound = false;
            for (int j = 0; j < gmfStructValue.getNames().length && !memberfound; ++j) {
                if (!gmfStructValue.getNames()[j].equalsIgnoreCase(currentMemberName)) continue;
                memberfound = true;
                Object structMemberValue = gmfStructValue.getValue(currentMemberName);
                if (structMemberValue instanceof Struct) {
                    String memberStructRefName = ((StructRefType)structMetaData.getMemberData(currentMemberName)).getReferencedStruct();
                    Struct memberSourceStruct = (Struct)sourceStruct.getValue(currentMemberName);
                    Struct updatedStruct = this.addMissingStructMembers((Struct)structMemberValue, memberSourceStruct, memberStructRefName);
                    gmfStructValue.setValue(currentMemberName, updatedStruct);
                    continue;
                }
                if (!(structMemberValue instanceof Struct[])) continue;
                String arrayStructRefName = ((StructRefType)((SeqDataType)structMetaData.getMemberData(currentMemberName)).getSeqType()).getReferencedStruct();
                Struct[] memberSourceStructArray = (Struct[])sourceStruct.getValue(currentMemberName);
                Struct[] updatedStructArray = this.addMissingStructMembersInEachElement((Struct[])structMemberValue, memberSourceStructArray, arrayStructRefName);
                gmfStructValue.setValue(currentMemberName, updatedStructArray);
            }
            if (memberfound) continue;
            Object missingMemberValue = sourceStruct.getValue(currentMemberName);
            logger.traceDebug(THIS_CLASS, "Adding missing member: " + currentMemberName + ", value: " + missingMemberValue);
            gmfStructValue.addElement(currentMemberName, missingMemberValue);
        }
        return gmfStructValue;
    }

    private StructImpl convertToGmfStruct(Struct structValue) throws NotHandledAttributeTypeException, MoNotFoundException {
        StructImpl gmfStructValue = null;
        gmfStructValue = structValue instanceof StructImpl ? (StructImpl)structValue : new StructImpl(structValue.getNames(), structValue.getValues());
        return gmfStructValue;
    }

    public Struct[] addMissingStructMembersInEachElement(Struct[] structArrayValue, Struct[] sourceStructArray, String structRefName) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "addMissingStructMembersInEachElement");
        if (structArrayValue == null || sourceStructArray == null || structRefName == null) {
            throw new IllegalArgumentException("Input parameter is null.");
        }
        ArrayList<Struct> structArrayElements = new ArrayList<Struct>();
        for (int i = 0; i < structArrayValue.length; ++i) {
            Struct sourceStructArrayElement = null;
            sourceStructArrayElement = i < sourceStructArray.length ? sourceStructArray[i] : this.getDefaultValueFromMom(structRefName);
            Struct updatedStructElement = this.addMissingStructMembers(structArrayValue[i], sourceStructArrayElement, structRefName);
            structArrayElements.add(updatedStructElement);
        }
        Struct[] resultStructArray = structArrayElements.toArray(new Struct[structArrayElements.size()]);
        return resultStructArray;
    }

    private Struct getDefaultValueFromMom(String structRefName) throws MoAccessException {
        StructMetaData structMetaData = (StructMetaData)this.moMetaDataFinder.getStructmap().get(structRefName);
        StructImpl structDefaultValue = new StructImpl();
        for (int i = 0; i < structMetaData.getMemberNames().length; ++i) {
            String currentMemberName = structMetaData.getMemberNames()[i];
            Object memberDefaultValue = structMetaData.getMemberData(currentMemberName).getDefaultValue(this.moMetaDataFinder);
            structDefaultValue.addElement(currentMemberName, memberDefaultValue);
        }
        return structDefaultValue;
    }
}

