/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.mao.commonmo.validation;

import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.AttrMissingAtCreateException;
import se.ericsson.cello.moframework.AttrNotSettableAtCreateException;
import se.ericsson.cello.moframework.AttrNotSettableException;
import se.ericsson.cello.moframework.IllegalParentException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoCardinalityViolationException;
import se.ericsson.cello.moframework.MoHasChildrenException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NotHandledAttributeTypeException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.ProcessingFailureException;
import se.ericsson.crbs.omf.mao.commonmo.metadata.AttributeMetaData;
import se.ericsson.crbs.omf.mao.commonmo.metadata.MoMetaData;
import se.ericsson.crbs.omf.mao.commonmo.metadata.finder.MoMetaDataFinder;
import se.ericsson.crbs.omf.mao.commonmo.mo.GenericManagedObject;
import se.ericsson.crbs.omf.mao.commonmo.validation.AttributeMetaDataValidator;
import se.ericsson.crbs.omf.mao.commonmo.validation.MoMetaDataValidator;
import se.ericsson.crbs.omf.mao.commonmo.validation.MoValidator;
import se.ericsson.crbs.omf.mao.commonmo.validation.MoValidatorFactory;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

class MoValidatorImpl
implements MoValidator {
    private static final Class THIS_CLASS = MoValidatorImpl.class;
    private static AbstractLogger logger = LoggingService.getLogger(MoValidatorImpl.class.getName());
    private static final String LONG_TYPE = "long";
    private final MoMetaDataValidator moMetaDataValidator;
    private final MoMetaDataFinder moMetaDataFinder;
    private final AttributeMetaDataValidator attribMetaDataValidator;
    private final MoRepositoryWrapper theMoRepositoryWrapper;
    private final String mMoType;

    MoValidatorImpl(String moType, MoValidatorFactory aMoValidatorFactory, MoRepositoryWrapper aMoRepositoryWrapper, MoMetaDataFinder aMoMetaDataFinder) {
        this.mMoType = moType;
        MoMetaData aMoMetaData = null;
        aMoMetaData = aMoMetaDataFinder.getMoData(this.mMoType);
        this.moMetaDataFinder = aMoMetaDataFinder;
        this.theMoRepositoryWrapper = aMoRepositoryWrapper;
        this.moMetaDataValidator = new MoMetaDataValidator(aMoMetaData, this.mMoType, aMoMetaDataFinder, aMoValidatorFactory, aMoRepositoryWrapper);
        this.attribMetaDataValidator = aMoValidatorFactory.createAttributeMetaDataValidator(moType);
    }

    public boolean checkUniquenessInNode(String moType, String attributeName, Object attributeValue, String attributeType, Coordinator coord, String moLdn) throws NoSuchAttributeException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "checkUniquenessInNode(" + moType + ", " + attributeName + ")");
        boolean result = true;
        MoIterator iterator = this.theMoRepositoryWrapper.lookupType(moType);
        if (iterator == null) {
            result = true;
        } else {
            if (!attributeValue.getClass().equals(Long.TYPE)) {
                logger.traceAbnormal(this.getClass(), "Attribute value to check is not of type long!");
            }
            while (iterator.hasMoreElements()) {
                ManagedObject managedObject = (ManagedObject)iterator.nextElement();
                Object attributeValueToCompare = managedObject.getAttribute(attributeName, coord);
                int attToCompare = -1;
                int attValue = -1;
                if (attributeType.indexOf(LONG_TYPE) != -1) {
                    attToCompare = (Integer)attributeValueToCompare;
                    attValue = (Integer)attributeValue;
                    logger.traceGeneral(THIS_CLASS, "Attribute type and value are " + attributeType + " " + attToCompare);
                }
                if (attToCompare != attValue || managedObject.getLocalDistinguishedName().equalsIgnoreCase(moLdn)) continue;
                logger.traceReturn(THIS_CLASS, "checkUniquenessInNode(" + moType + ", " + attributeName + ") = false");
                result = false;
                break;
            }
        }
        logger.traceReturn(THIS_CLASS, "checkUniquenessInNode(" + moType + ", " + attributeName + ") = true");
        return result;
    }

    public final void verifyAtCreate(ManagedObject parent, AttrList attributes, boolean isAutoTriggered, Coordinator coordinator) throws IllegalParentException, ValueOutOfRangeException, AttrMissingAtCreateException, NoSuchAttributeException, WrongAttributeTypeException, MoNotFoundException, NotHandledAttributeTypeException, MoCardinalityViolationException, AttrNotSettableAtCreateException, MoAccessException {
        logger.traceEnter(this.getClass(), "verifyAtCreate() " + this.mMoType);
        this.moMetaDataValidator.checkParent(parent);
        this.moMetaDataValidator.verifyAtCreate(attributes, isAutoTriggered, coordinator);
        MoIterator siblings = this.moMetaDataValidator.checkCardinality(parent);
        logger.traceDebug(this.getClass(), "Number of siblings: " + siblings.size());
        logger.traceReturn(this.getClass(), "verifyAtCreate() " + this.mMoType);
    }

    public final void verifyAtDelete(boolean isAutoTriggered, ManagedObject managedObject) throws ProcessingFailureException, MoHasChildrenException {
        logger.traceEnter(this.getClass(), "verifyAtDelete() " + this.mMoType);
        this.moMetaDataValidator.verifyAtDelete(isAutoTriggered, managedObject);
        logger.traceReturn(this.getClass(), "verifyAtDelete() " + this.mMoType);
    }

    public final void verifyAtGet(String moName, String attributeName) throws NoSuchAttributeException, ProcessingFailureException {
        logger.traceEnter(this.getClass(), "verifyAtGet() " + moName + ", " + attributeName);
        this.attribMetaDataValidator.verifyAtGet(moName, attributeName);
        logger.traceReturn(this.getClass(), "verifyAtGet() " + moName + ", " + attributeName);
    }

    public final void verifyAtSet(String name, Object value, boolean isSystemWriteableOnly, GenericManagedObject myMo, Coordinator coordinator) throws ValueOutOfRangeException, NoSuchAttributeException, WrongAttributeTypeException, MoNotFoundException, AttrNotSettableException, ProcessingFailureException, MoAccessException {
        logger.traceEnter(this.getClass(), "verifyAtSet() " + this.mMoType + ", " + name);
        AttributeMetaData attrMetaData = this.moMetaDataFinder.getMoAttributes(this.mMoType, name);
        if (attrMetaData == null) {
            throw new NoSuchAttributeException(name, this.mMoType);
        }
        this.attribMetaDataValidator.verifyAtSet(this.mMoType, name, value, attrMetaData, isSystemWriteableOnly);
        this.attribMetaDataValidator.checkUniqueInNode(this.mMoType, name, value, attrMetaData, myMo, coordinator);
        logger.traceReturn(this.getClass(), "verifyAtSet() " + this.mMoType + ", " + name);
    }
}

