/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.mao.commonmo.validation;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import se.ericsson.cello.mao.MoNotPossibleToReserveException;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.NoSuchFieldException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.swmanagement.mom.LoadModule;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.ProcessingFailureException;
import se.ericsson.crbs.omf.mao.commonmo.metadata.EnumMemberMetaData;
import se.ericsson.crbs.omf.mao.commonmo.metadata.IntegerRange;
import se.ericsson.crbs.omf.mao.commonmo.metadata.LongRange;
import se.ericsson.crbs.omf.mao.commonmo.metadata.MoMetaData;
import se.ericsson.crbs.omf.mao.commonmo.metadata.StringRange;
import se.ericsson.crbs.omf.mao.commonmo.metadata.StructMetaData;
import se.ericsson.crbs.omf.mao.commonmo.metadata.finder.MoMetaDataFinder;
import se.ericsson.crbs.omf.mao.commonmo.metadata.types.AttributeDataType;
import se.ericsson.crbs.omf.mao.commonmo.metadata.types.BooleanDataType;
import se.ericsson.crbs.omf.mao.commonmo.metadata.types.EnumDataType;
import se.ericsson.crbs.omf.mao.commonmo.metadata.types.IntegerDataType;
import se.ericsson.crbs.omf.mao.commonmo.metadata.types.LongDataType;
import se.ericsson.crbs.omf.mao.commonmo.metadata.types.MoRefType;
import se.ericsson.crbs.omf.mao.commonmo.metadata.types.SeqDataType;
import se.ericsson.crbs.omf.mao.commonmo.metadata.types.StringDataType;
import se.ericsson.crbs.omf.mao.commonmo.metadata.types.StructRefType;
import se.ericsson.crbs.omf.mao.commonmo.validation.AttributeMetaDataValidatorImpl;
import se.ericsson.crbs.omf.mao.commonmo.validation.AttributeVisitor;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class ValidatorAttributeVisitor
implements AttributeVisitor {
    private static final Class THIS_CLASS = ValidatorAttributeVisitor.class;
    private static AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());
    private final String myMoType;
    private final MoMetaDataFinder moMetaDataFinder;
    private final MoRepositoryWrapper moRepositoryWrapper;

    public ValidatorAttributeVisitor(String moType, MoMetaDataFinder aMoMetaDataFinder, MoRepositoryWrapper aMoRepositoryWrapper) {
        this.myMoType = moType;
        this.moMetaDataFinder = aMoMetaDataFinder;
        this.moRepositoryWrapper = aMoRepositoryWrapper;
    }

    private final boolean checkIntegerRange(Object attrValue, int minValue, int maxValue) throws ValueOutOfRangeException {
        boolean valueInRange = true;
        int intValue = (Integer)attrValue;
        if (intValue < minValue || intValue > maxValue) {
            valueInRange = false;
        }
        return valueInRange;
    }

    private final void checkIntegerResolution(String attrName, Object attrValue, int minValue, int resolution) throws WrongAttributeTypeException, ValueOutOfRangeException {
        int intValue = (Integer)attrValue;
        if ((intValue - minValue) % resolution != 0) {
            String msg = "Parameter " + attrName + " = " + intValue + " is out of range (resolution).";
            logger.traceAbnormal(THIS_CLASS, msg);
            throw new ValueOutOfRangeException(attrName, msg);
        }
    }

    private void checkIntegerType(String attrName, Object attrValue) throws WrongAttributeTypeException {
        if (!(attrValue instanceof Integer)) {
            String msg = "Parameter " + attrName + " is of wrong type: " + attrValue.getClass();
            logger.traceAbnormal(THIS_CLASS, msg);
            throw new WrongAttributeTypeException(attrName, msg);
        }
    }

    private final boolean checkStringRange(Object attrValue, int minValue, int maxValue) throws ValueOutOfRangeException {
        boolean valueInRange = true;
        int stringLength = ((String)attrValue).length();
        if (stringLength < minValue || stringLength > maxValue) {
            valueInRange = false;
        }
        return valueInRange;
    }

    private void checkStringType(String attrName, Object attrValue) throws WrongAttributeTypeException {
        if (!(attrValue instanceof String)) {
            String msg = "Parameter " + attrName + " is of wrong type: " + attrValue.getClass();
            logger.traceAbnormal(THIS_CLASS, msg);
            throw new WrongAttributeTypeException(attrName, msg);
        }
    }

    private void checkStructRefType(String attributeName, Object attributeValue) throws WrongAttributeTypeException {
        if (!(attributeValue instanceof Struct)) {
            String msg = "Parameter is of wrong type: " + attributeValue.getClass();
            logger.traceAbnormal(THIS_CLASS, msg);
            throw new WrongAttributeTypeException(attributeName, msg);
        }
    }

    public void visitBoolean(String attributeName, Object attributeValue, BooleanDataType dataType) throws WrongAttributeTypeException {
        if (!(attributeValue instanceof Boolean)) {
            String msg = "Parameter is of wrong type: " + attributeValue.getClass();
            logger.traceAbnormal(THIS_CLASS, msg);
            throw new WrongAttributeTypeException(attributeName, msg);
        }
    }

    public void visitEnum(String attributeName, Object attributeValue, EnumDataType dataType) throws WrongAttributeTypeException, ProcessingFailureException, ValueOutOfRangeException {
        String enumName = dataType.getEnumName();
        this.checkIntegerType(attributeName, attributeValue);
        Integer newValue = (Integer)attributeValue;
        Map enumMembers = null;
        enumMembers = (Map)this.moMetaDataFinder.getEnumMap().get(enumName);
        Iterator enumValueIter = enumMembers.values().iterator();
        boolean valueInRange = false;
        while (enumValueIter.hasNext()) {
            EnumMemberMetaData currentEnumMemberMetaData = (EnumMemberMetaData)enumValueIter.next();
            Integer currentEnumMemberValue = new Integer(currentEnumMemberMetaData.getValue());
            if (newValue.intValue() != currentEnumMemberValue.intValue()) continue;
            valueInRange = true;
            break;
        }
        if (!valueInRange) {
            throw new ValueOutOfRangeException(attributeName, "Value passed " + newValue);
        }
    }

    public void visitInteger(String attributeName, Object attributeValue, IntegerDataType dataType) throws WrongAttributeTypeException, ValueOutOfRangeException {
        this.checkIntegerType(attributeName, attributeValue);
        boolean valueInRange = false;
        if (dataType.hasRanges()) {
            List ranges = dataType.getRanges();
            if (dataType.getResolution() > 0) {
                this.checkIntegerResolution(attributeName, attributeValue, (Integer)((IntegerRange)ranges.get(0)).getMin(), dataType.getResolution());
            }
            Iterator rangeIter = ranges.iterator();
            while (rangeIter.hasNext()) {
                IntegerRange currentRange = (IntegerRange)rangeIter.next();
                Integer currentMax = (Integer)currentRange.getMax();
                Integer currentMin = (Integer)currentRange.getMin();
                if (!this.checkIntegerRange(attributeValue, currentMin, currentMax)) continue;
                valueInRange = true;
                break;
            }
        } else {
            valueInRange = true;
        }
        if (!valueInRange) {
            String msg = "Parameter " + attributeName + " = " + attributeValue + " is out of range (boundary).";
            logger.traceAbnormal(THIS_CLASS, msg);
            throw new ValueOutOfRangeException(msg, this.myMoType);
        }
    }

    public void visitLong(String attributeName, Object attributeValue, LongDataType dataType) throws WrongAttributeTypeException, ValueOutOfRangeException {
        this.checkLongType(attributeName, attributeValue);
        boolean valueInRange = false;
        if (dataType.hasRanges()) {
            List ranges = dataType.getRanges();
            if (dataType.getResolution() > 0) {
                this.checkLongResolution(attributeName, attributeValue, (Long)((LongRange)ranges.get(0)).getMin(), dataType.getResolution());
            }
            Iterator rangeIter = ranges.iterator();
            while (rangeIter.hasNext()) {
                LongRange currentRange = (LongRange)rangeIter.next();
                Long currentMax = (Long)currentRange.getMax();
                Long currentMin = (Long)currentRange.getMin();
                if (!this.checkLongRange(attributeValue, currentMin, currentMax)) continue;
                valueInRange = true;
                break;
            }
        } else {
            valueInRange = true;
        }
        if (!valueInRange) {
            String msg = "Parameter " + attributeName + " = " + attributeValue + " is out of range (boundary).";
            logger.traceAbnormal(THIS_CLASS, msg);
            throw new ValueOutOfRangeException(msg, this.myMoType);
        }
    }

    private boolean checkLongRange(Object attributeValue, long minValue, long maxValue) throws ValueOutOfRangeException {
        boolean valueInRange = true;
        long longValue = (Long)attributeValue;
        if (longValue < minValue || longValue > maxValue) {
            valueInRange = false;
        }
        return valueInRange;
    }

    private void checkLongResolution(String attributeName, Object attributeValue, long minValue, int resolution) throws WrongAttributeTypeException, ValueOutOfRangeException {
        long longValue = (Long)attributeValue;
        if ((longValue - minValue) % (long)resolution != 0L) {
            String msg = "Parameter " + attributeName + " = " + longValue + " is out of range (resolution).";
            logger.traceAbnormal(THIS_CLASS, msg);
            throw new ValueOutOfRangeException(attributeName, "");
        }
    }

    private void checkLongType(String attributeName, Object attributeValue) throws WrongAttributeTypeException {
        if (!(attributeValue instanceof Long)) {
            String msg = "Parameter " + attributeName + " is of wrong type: " + attributeValue.getClass();
            logger.traceAbnormal(THIS_CLASS, msg);
            throw new WrongAttributeTypeException(attributeName, msg);
        }
    }

    public void visitMoRef(String attributeName, Object attributeValue, MoRefType dataType) throws MoAccessException, MoNotFoundException {
        if (attributeValue != null) {
            if (!(attributeValue instanceof Reservable) && !(attributeValue instanceof LoadModule)) {
                String msg = "Parameter " + attributeName + " is of wrong type or does not exist (Not Reservable or LoadModule): " + attributeValue.getClass() + ".";
                logger.traceAbnormal(THIS_CLASS, msg);
                throw new WrongAttributeTypeException(attributeName, msg);
            }
            ManagedObject moToReference = (ManagedObject)attributeValue;
            if (!"ManagedObject".equals(dataType.getReferencedType()) && !dataType.getReferencedType().equals(moToReference.getType())) {
                String msg = "Parameter " + attributeName + " is of wrong type: " + attributeValue.getClass();
                logger.traceAbnormal(THIS_CLASS, msg);
                throw new WrongAttributeTypeException(attributeName, msg);
            }
            String distName = moToReference.getLocalDistinguishedName();
            if (this.moRepositoryWrapper.lookup(distName) == null) {
                String msg = "MO: " + attributeName + " cannot be found!";
                logger.traceAbnormal(THIS_CLASS, msg);
                throw new MoNotFoundException(distName);
            }
            MoMetaData moMetaData = this.moMetaDataFinder.getMoData(moToReference.getType());
            if (moMetaData != null && moMetaData.getReplacedBy() != null) {
                String msg = "Reference to deprecatet MO: " + moToReference.getType() + " is not allowed";
                logger.traceAbnormal(THIS_CLASS, msg);
                throw new MoNotPossibleToReserveException(msg, moToReference.getType());
            }
        }
    }

    public void visitSeq(String attributeName, Object attributeValue, boolean isMandatory, SeqDataType dataType) throws MoAccessException {
        String msg = "checkAttribute()";
        logger.traceEnter(THIS_CLASS, "checkAttribute()");
        Object[] objArray = null;
        objArray = attributeValue instanceof Object[] ? (Object[])attributeValue : dataType.getSeqType().convertPrimArrayToObjArray(attributeValue, attributeName);
        if (!(objArray instanceof Object[])) {
            String errMsg = "Parameter " + attributeName + " is of wrong type: " + objArray.getClass();
            logger.traceAbnormal(THIS_CLASS, errMsg);
            throw new WrongAttributeTypeException(attributeName, errMsg);
        }
        Object[] attributeArray = objArray;
        if (isMandatory && attributeArray.length < 1) {
            throw new ProcessingFailureException("Parameter " + attributeName + " is mandatory but has an empty sequence.");
        }
        if (attributeArray.length < dataType.getMinLength()) {
            throw new ProcessingFailureException("Parameter " + attributeName + " sequence length of " + attributeArray.length + " is under the minimum length (" + dataType.getMinLength() + ")");
        }
        if (attributeArray.length > dataType.getMaxLength()) {
            throw new ProcessingFailureException("Parameter " + attributeName + " sequence length of " + attributeArray.length + " exceeds the maximum length (" + dataType.getMaxLength() + ")");
        }
        AttributeMetaDataValidatorImpl amdv = new AttributeMetaDataValidatorImpl(this.myMoType, this.moMetaDataFinder, this.moRepositoryWrapper);
        AttributeDataType seqEltType = dataType.getSeqType();
        for (int i = 0; i < attributeArray.length; ++i) {
            amdv.checkAttribute(seqEltType, attributeName, attributeArray[i], isMandatory);
        }
        if (dataType.getSeqType() instanceof MoRefType && !dataType.isNonUnique()) {
            String genMsg = "checking for duplicate elements in sequence: " + attributeName;
            logger.traceGeneral(THIS_CLASS, genMsg);
            if (this.checkIfAttributeArrayHasDuplicates(attributeArray)) {
                throw new ProcessingFailureException("The sequence of references in " + attributeName + " must not contain duplicate elements.");
            }
        }
        this.checkIfArrayHasOneNull(attributeName, attributeArray, attributeValue, dataType);
        logger.traceReturn(THIS_CLASS, "checkAttribute()");
    }

    private void checkIfArrayHasOneNull(String attributeName, Object[] attributeArray, Object attributeValue, SeqDataType dataType) throws WrongAttributeTypeException {
        if (dataType.getSeqType() instanceof MoRefType && attributeArray.length == 1 && attributeArray[0] == null) {
            String errmsg = "Parameter " + attributeName + " is of wrong type or does not exist (Not Reservable or LoadModule): " + attributeValue.getClass() + ".";
            logger.traceAbnormal(THIS_CLASS, errmsg);
            throw new WrongAttributeTypeException(attributeName, errmsg);
        }
    }

    private boolean checkIfAttributeArrayHasDuplicates(Object[] attributeArray) {
        for (int i = 0; i < attributeArray.length - 1; ++i) {
            if (attributeArray[i] == null) continue;
            for (int j = i + 1; j < attributeArray.length; ++j) {
                if (!attributeArray[i].equals(attributeArray[j])) continue;
                return true;
            }
        }
        return false;
    }

    public void visitString(String attributeName, Object attributeValue, StringDataType dataType) throws WrongAttributeTypeException, ValueOutOfRangeException {
        this.checkStringType(attributeName, attributeValue);
        boolean valueInRange = false;
        if (dataType.hasRanges()) {
            List ranges = dataType.getRanges();
            Iterator rangeIter = ranges.iterator();
            while (rangeIter.hasNext()) {
                StringRange currentRange = (StringRange)rangeIter.next();
                String currentMax = (String)currentRange.getMax();
                String currentMin = (String)currentRange.getMin();
                if (!this.checkStringRange(attributeValue, currentMin.length(), currentMax.length())) continue;
                valueInRange = true;
                break;
            }
        }
        if (!valueInRange && dataType.hasRanges()) {
            String msg = "Parameter " + attributeName + " = " + attributeValue + " is out of range (boundary).";
            logger.traceAbnormal(THIS_CLASS, msg);
            throw new ValueOutOfRangeException(msg, "");
        }
    }

    private String[] extractAttributeNamesFromStructRefMom(StructMetaData structMetaData) {
        Iterator structMemberNameIter = structMetaData.getMembers().values().iterator();
        String[] structMemberNames = new String[structMetaData.getMembers().size()];
        int structMemberNamesIndex = 0;
        while (structMemberNameIter.hasNext()) {
            Object obj = structMemberNameIter.next();
            if (!(obj instanceof AttributeDataType)) continue;
            AttributeDataType currentMemberData = (AttributeDataType)obj;
            structMemberNames[structMemberNamesIndex++] = currentMemberData.getAttributeName();
        }
        return structMemberNames;
    }

    private boolean checkIfStringExistsInArray(String[] stringArray, String string) {
        boolean stringExists = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].compareTo(string) != 0) continue;
            stringExists = true;
            break;
        }
        return stringExists;
    }

    private void checkIfStructAttributesExistInMom(String refStructName, Struct newStruct, StructMetaData structMetaData) throws NoSuchFieldException {
        String[] moStructAttributeNames = this.extractAttributeNamesFromStructRefMom(structMetaData);
        String[] newStructMemberNames = newStruct.getNames();
        for (int i = 0; i < newStructMemberNames.length; ++i) {
            if (this.checkIfStringExistsInArray(moStructAttributeNames, newStructMemberNames[i])) continue;
            String msg = "Field with name " + newStructMemberNames[i] + " does not exist in struct " + refStructName;
            logger.traceAbnormal(THIS_CLASS, msg);
            NoSuchFieldException nsf = new NoSuchFieldException(newStructMemberNames[i]);
            throw nsf;
        }
    }

    public void visitStructRef(String attributeName, Object attributeValue, boolean isMandatory, StructRefType dataType) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "visitStructRef attr:" + attributeName);
        String refStructName = dataType.getReferencedStruct();
        this.checkStructRefType(attributeName, attributeValue);
        Struct newValue = (Struct)attributeValue;
        StructMetaData structMetaData = null;
        structMetaData = (StructMetaData)this.moMetaDataFinder.getStructmap().get(refStructName);
        if (newValue.getNames().length > structMetaData.getMembers().size()) {
            String msg = refStructName + ": Too many fields in struct parameter " + this.getClass();
            logger.traceAbnormal(THIS_CLASS, msg);
            throw new ProcessingFailureException(msg);
        }
        this.checkIfStructAttributesExistInMom(refStructName, newValue, structMetaData);
        Iterator structMemberIter = structMetaData.getMembers().values().iterator();
        AttributeMetaDataValidatorImpl amdv = new AttributeMetaDataValidatorImpl(this.myMoType, this.moMetaDataFinder, this.moRepositoryWrapper);
        while (structMemberIter.hasNext()) {
            AttributeDataType currentMemberData = (AttributeDataType)structMemberIter.next();
            try {
                Object currentMemberValue = newValue.getValue(currentMemberData.getAttributeName());
                amdv.checkAttribute(currentMemberData, currentMemberData.getAttributeName(), currentMemberValue, isMandatory);
            }
            catch (NoSuchFieldException nsf) {
                if (!isMandatory && currentMemberData.hasDefaultValue()) continue;
                String msg = "No field with name " + currentMemberData.getAttributeName() + " exists in struct " + refStructName;
                logger.traceAbnormal(THIS_CLASS, msg);
                throw nsf;
            }
        }
        logger.traceReturn(THIS_CLASS, "visitStructRef attr:" + attributeName);
    }
}

