/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.mao.genericmo;

import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.DeprecatedGenericMao;
import se.ericsson.crbs.omf.mao.genericmo.DeprecatedGenericMaoHelper;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.genericmo.MaoFactory;
import se.ericsson.crbs.omf.mao.wrappers.MoDataWrapper;
import se.ericsson.crbs.omf.mao.wrappers.MoDataWrapperFactory;

public class DeprecatedGenericMaoFactory
implements MaoFactory {
    private static final Class THIS_CLASS = DeprecatedGenericMaoFactory.class;
    private static final AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());
    private final MoDataWrapperFactory moDataWrapperFactory;
    private final GenericMaoContext genericMaoContext;
    private InitialMaoContext initMaocontext;
    private final String moType;

    protected DeprecatedGenericMaoFactory(String aMoType, GenericMaoContext aGenericMaoContext) {
        logger.traceEnter(THIS_CLASS, "GenericMaoFactory() - " + aMoType);
        this.moType = aMoType;
        this.genericMaoContext = aGenericMaoContext;
        this.moDataWrapperFactory = aGenericMaoContext.getMoDataWrapperFactory();
        logger.traceReturn(THIS_CLASS, "GenericMaoFactory() - " + aMoType);
    }

    public void init() {
        logger.traceEnter(THIS_CLASS, "init() - " + this.moType);
        this.genericMaoContext.getMoFactoryMgrWrapper().register(this.moType, (MoFactory)this);
        logger.traceReturn(THIS_CLASS, "init() - " + this.moType);
    }

    public void start() {
    }

    public void setMaoContext(InitialMaoContext initialmaocontext) {
        this.initMaocontext = initialmaocontext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ManagedObject createMo(ManagedObject parent, AttrList attributes, String identity, ManagedObject source, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "createMo() - " + this.moType);
        String replacingMo = DeprecatedGenericMaoHelper.getReplacingMoName(this.moType, this.genericMaoContext);
        if (replacingMo == null) {
            throw new MoNotFoundException("Missing replacing MO in meta data for deprecated MO " + this.moType + ".");
        }
        MoFactory factory = this.genericMaoContext.getMoFactoryMgrWrapper().lookup(replacingMo);
        if (factory == null) {
            throw new MoNotFoundException("Could not find MO factory for " + replacingMo + ".");
        }
        ManagedObject managedObject = parent;
        synchronized (managedObject) {
            factory.createMo(parent, attributes, identity, source, coordinator);
        }
        String ldn = parent.getLocalDistinguishedName() + "," + this.moType + "=" + identity;
        ManagedObject deprecatedMo = this.genericMaoContext.getMoRepositoryWrapper().lookup(ldn);
        if (deprecatedMo == null) {
            throw new MoNotFoundException("Failed to find deprecated MO with LDN " + ldn + ".");
        }
        logger.traceReturn(THIS_CLASS, "createMo() - " + this.moType);
        return deprecatedMo;
    }

    public ManagedObject recoverMo(MoData recoveredData) throws MoNameAlreadyTakenException {
        logger.traceEnter(THIS_CLASS, "recoverMo() - " + this.moType);
        MoDataWrapper moDataWrapper = this.moDataWrapperFactory.createMoDataWrapper(recoveredData);
        ManagedObject recoveredMo = this.recoverMo(moDataWrapper);
        logger.traceEnter(THIS_CLASS, "recoverMo() - " + this.moType);
        return recoveredMo;
    }

    public ManagedObject recoverMo(MoDataWrapper recoveredDataWrapper) throws MoNameAlreadyTakenException {
        logger.traceEnter(THIS_CLASS, "recoverMo() - " + this.moType);
        DeprecatedGenericMao recoveredMo = null;
        try {
            recoveredMo = new DeprecatedGenericMao(recoveredDataWrapper, this.moType, this.genericMaoContext, this.initMaocontext);
        }
        catch (MoAccessException e) {
            logger.traceError(this.getClass(), "Could not recover MO instance for MO Type " + this.moType + " and LDN " + recoveredDataWrapper.getLocalDistinguishedName() + ".", e);
            throw new MoNameAlreadyTakenException(e.getReasonTag());
        }
        logger.traceEnter(THIS_CLASS, "recoverMo() - " + this.moType);
        return recoveredMo;
    }
}

