/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.mao.genericmo;

import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.NoSuchFieldException;
import se.ericsson.cello.moframework.NotHandledAttributeTypeException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.metadata.AttributeMetaData;
import se.ericsson.crbs.omf.mao.commonmo.metadata.MoMetaData;
import se.ericsson.crbs.omf.mao.genericmo.GenericMao;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;

public class DeprecatedGenericMaoHelper {
    private static final Class THIS_CLASS = DeprecatedGenericMaoHelper.class;
    private static final AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());

    public static ManagedObject lookupReplacedMo(String moType, String identity, String ldn, String parentLdn, GenericMaoContext genericMaoContext) throws MoNotFoundException, NotHandledAttributeTypeException, NoSuchFieldException {
        logger.traceEnter(THIS_CLASS, "lookupReplacedMo()");
        ManagedObject replacedMo = null;
        String replacedMoName = DeprecatedGenericMaoHelper.getReplacedMoName(moType, genericMaoContext);
        if (replacedMoName != null) {
            String replacedLdn = parentLdn + "," + replacedMoName + "=" + identity;
            replacedMo = genericMaoContext.getMoRepositoryWrapper().lookup(replacedLdn);
            if (replacedMo == null) {
                throw new MoNotFoundException("Failed to lookup the deprecated MO with LDN=" + replacedLdn + ", that is replaced by the MO with LDN=" + ldn);
            }
        }
        logger.traceReturn(THIS_CLASS, "lookupReplacedMo()");
        return replacedMo;
    }

    public static GenericMao lookupReplacingMo(String moType, String identity, String parentLdn, GenericMaoContext genericMaoContext) throws NotHandledAttributeTypeException, NoSuchFieldException, MoNotFoundException {
        logger.traceEnter(THIS_CLASS, "lookupReplacingMo()");
        String replacingMoName = DeprecatedGenericMaoHelper.getReplacingMoName(moType, genericMaoContext);
        if (replacingMoName == null) {
            throw new MoNotFoundException("Missing replacing MO name in meta data for deprecated MO " + moType + ".");
        }
        MoFactory factory = genericMaoContext.getMoFactoryMgrWrapper().lookup(replacingMoName);
        if (factory == null) {
            throw new MoNotFoundException("Could not find MO factory for " + replacingMoName + ".");
        }
        String ldn = parentLdn + "," + replacingMoName + "=" + identity;
        GenericMao replacingMo = (GenericMao)genericMaoContext.getMoRepositoryWrapper().lookup(ldn);
        logger.traceReturn(THIS_CLASS, "lookupReplacingMo()");
        return replacingMo;
    }

    public static String getReplacedMoName(String moType, GenericMaoContext genericMaoContext) throws NotHandledAttributeTypeException, NoSuchFieldException, MoNotFoundException {
        logger.traceEnter(THIS_CLASS, "getReplacedMoName()");
        String replacedMoName = null;
        MoMetaData moMetaData = genericMaoContext.getMoMetaDataFinder().getMoData(moType);
        Struct replacingValue = moMetaData.getReplacing();
        if (replacingValue != null) {
            try {
                replacedMoName = (String)replacingValue.getValue("moName");
            }
            catch (NoSuchFieldException nsfe) {
                logger.traceAbnormal(THIS_CLASS, "Failed to get replaced MO name for MO " + moType + ".");
                throw nsfe;
            }
        }
        logger.traceReturn(THIS_CLASS, "getReplacedMoName()");
        return replacedMoName;
    }

    public static String getReplacingMoName(String moType, GenericMaoContext genericMaoContext) throws NotHandledAttributeTypeException, NoSuchFieldException, MoNotFoundException {
        logger.traceEnter(THIS_CLASS, "getReplacingMo()");
        String replacingMo = null;
        MoMetaData moMetaData = genericMaoContext.getMoMetaDataFinder().getMoData(moType);
        Struct replacedByValue = moMetaData.getReplacedBy();
        if (replacedByValue != null) {
            try {
                replacingMo = (String)replacedByValue.getValue("moName");
            }
            catch (NoSuchFieldException nsfe) {
                logger.traceAbnormal(THIS_CLASS, "Failed to get replacing MO name for MO " + moType + ".");
                throw nsfe;
            }
        }
        logger.traceReturn(THIS_CLASS, "getReplacingMo()");
        return replacingMo;
    }

    public static String getReplacedAttributeName(AttributeMetaData attributeMetaData, String moType) throws NotHandledAttributeTypeException, NoSuchFieldException, MoNotFoundException {
        logger.traceEnter(THIS_CLASS, "getReplacedAttributeName()");
        String replacedAttrName = null;
        Struct replacingValue = attributeMetaData.getReplacing();
        if (replacingValue != null) {
            try {
                replacedAttrName = (String)replacingValue.getValue("attributeName");
            }
            catch (NoSuchFieldException nsfe) {
                logger.traceAbnormal(THIS_CLASS, "Failed to get replacing attribute name for attribute " + attributeMetaData.getName() + " in MO " + moType + ".");
                throw nsfe;
            }
        }
        logger.traceReturn(THIS_CLASS, "getReplacedAttributeName()");
        return replacedAttrName;
    }

    public static String getReplacingAttributeName(AttributeMetaData attributeMetaData, String moType) throws NotHandledAttributeTypeException, NoSuchFieldException, MoNotFoundException {
        logger.traceEnter(THIS_CLASS, "getReplacingAttributeName()");
        String replacingAttrName = null;
        Struct replacedByValue = attributeMetaData.getReplacedBy();
        if (replacedByValue != null) {
            try {
                replacingAttrName = (String)replacedByValue.getValue("attributeName");
            }
            catch (NoSuchFieldException nsfe) {
                logger.traceAbnormal(THIS_CLASS, "Failed to get replacing attribute name for attribute " + attributeMetaData.getName() + " in MO " + moType + ".");
                throw nsfe;
            }
        }
        logger.traceReturn(THIS_CLASS, "getReplacingAttributeName()");
        return replacingAttrName;
    }
}

