/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.mao.genericmo.attributes.manager;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.AttrNotSettableException;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoRemovedException;
import se.ericsson.cello.moframework.NoPermissionException;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.ResourceLockedException;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.AttrListImpl;
import se.ericsson.crbs.omf.mao.commonmo.ProcessingFailureException;
import se.ericsson.crbs.omf.mao.commonmo.ResourceUnavailableException;
import se.ericsson.crbs.omf.mao.commonmo.metadata.AttributeMetaData;
import se.ericsson.crbs.omf.mao.commonmo.metadata.finder.MoMetaDataFinder;
import se.ericsson.crbs.omf.mao.commonmo.metadata.types.AbstractAttributeDataType;
import se.ericsson.crbs.omf.mao.commonmo.metadata.types.AttributeDataType;
import se.ericsson.crbs.omf.mao.commonmo.metadata.types.BiDirectionalAssociationDataType;
import se.ericsson.crbs.omf.mao.commonmo.metadata.types.SingleRefBiDirectionalAssociationDataType;
import se.ericsson.crbs.omf.mao.commonmo.mo.GenericManagedObject;
import se.ericsson.crbs.omf.mao.commonmo.validation.AttributeMetaDataValidator;
import se.ericsson.crbs.omf.mao.commonmo.validation.MoValidatorFactory;
import se.ericsson.crbs.omf.mao.genericmo.attributes.manager.LocalAttributeManager;
import se.ericsson.crbs.omf.mao.genericmo.attributes.type.LocalAttribute;
import se.ericsson.crbs.omf.mao.genericmo.attributes.type.MaoAttributeFactory;
import se.ericsson.crbs.omf.mao.genericmo.attributes.type.MaoIntegerAttribute;
import se.ericsson.crbs.omf.mao.genericmo.attributes.type.MaoSequenceAttribute;
import se.ericsson.crbs.omf.mao.genericmo.attributes.type.MaoStringAttribute;
import se.ericsson.crbs.omf.mao.wrappers.MoDataWrapper;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

class LocalAttributeManagerImpl
implements LocalAttributeManager {
    private static AbstractLogger logger = LoggingService.getLogger(LocalAttributeManagerImpl.class.getName());
    private static final Class THIS_CLASS = LocalAttributeManagerImpl.class;
    private static final String FRO_ID = "froId";
    private final Map locallyStoredAttributes;
    private final GenericManagedObject myMo;
    private final String myMoType;
    private IntegerAttribute mFroId;
    private MoDataWrapper mMoData = null;
    private final MoMetaDataFinder moMetaDataFinder;
    private final MoValidatorFactory moValidatorFactory;
    private final MoRepositoryWrapper moRepositoryWrapper;

    LocalAttributeManagerImpl(GenericManagedObject managedObject, MaoAttributeFactory anMaoAttributeFactory, MoMetaDataFinder moMetaDataFinder, MoValidatorFactory aMoValidatorFactory, MoRepositoryWrapper moRepositoryWrapper) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "Constructor for LocalAttributeManager()");
        this.locallyStoredAttributes = anMaoAttributeFactory.getMaoStoredAttributes(managedObject.getType(), moRepositoryWrapper);
        this.myMo = managedObject;
        this.moMetaDataFinder = moMetaDataFinder;
        this.moValidatorFactory = aMoValidatorFactory;
        this.moRepositoryWrapper = moRepositoryWrapper;
        this.myMoType = this.myMo.getType();
        logger.traceReturn(THIS_CLASS, "Constructor for LocalAttributeManager() - " + this.myMoType);
    }

    public void addReservedBy(ManagedObject moToReference, Coordinator coordinator) throws TransactionRequiredException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "addReservedBy - " + this.myMoType);
        if (this.locallyStoredAttributes.containsKey("reservedBy")) {
            AbstractAttributeDataType reservedByMetaData;
            if (this.locallyStoredAttributes.get("reservedBy") instanceof MaoSequenceAttribute) {
                MaoSequenceAttribute mReservedBy = (MaoSequenceAttribute)this.locallyStoredAttributes.get("reservedBy");
                try {
                    BiDirectionalAssociationDataType reservedByMetaData2 = (BiDirectionalAssociationDataType)this.moMetaDataFinder.getMoAttributes(this.myMo.getType(), "reservedBy").getData();
                    Object[] reservedMos = (Object[])mReservedBy.getValue(coordinator);
                    try {
                        reservedByMetaData2.checkAttribute("reservedBy", moToReference, reservedMos);
                    }
                    catch (ProcessingFailureException pfe) {
                        try {
                            logger.traceGeneral(THIS_CLASS, "Marked rollback Only.");
                            coordinator.rollbackOnly();
                        }
                        catch (InactiveTransactionException e) {
                            throw pfe;
                        }
                        throw pfe;
                    }
                    if (reservedMos.length > 0) {
                        for (int i = 0; i < reservedMos.length; ++i) {
                            if (!((ManagedObject)reservedMos[i]).getFullDistinguishedName().equals(moToReference.getFullDistinguishedName())) continue;
                            logger.traceAbnormal(this.getClass(), "The " + moToReference.getType() + " reference is already stored in " + this.myMo.getType() + " " + "reservedBy");
                            return;
                        }
                    }
                    ReferenceAttribute newMoRefValue = new ReferenceAttribute("reservedBy", moToReference.getLocalDistinguishedName(), true);
                    newMoRefValue.setValue(moToReference);
                    Attribute[] oldValue = mReservedBy.getValueAsAttributeArray(coordinator);
                    Attribute[] newValue = new Attribute[oldValue.length + 1];
                    System.arraycopy(oldValue, 0, newValue, 0, oldValue.length);
                    newValue[oldValue.length] = newMoRefValue;
                    mReservedBy.setValueAsAttributeArray(newValue);
                }
                catch (MoRemovedException e) {
                    StringBuffer buf = new StringBuffer("Error reading ");
                    buf.append(moToReference.getType()).append(" reference from reservedBy in ").append(this.myMo.getType()).append(" MO");
                    logger.traceError(this.getClass(), buf.toString());
                    throw new ProcessingFailureException(buf.toString());
                }
            }
            LocalAttribute mReservedBy = (LocalAttribute)this.locallyStoredAttributes.get("reservedBy");
            AttributeMetaData amData = this.moMetaDataFinder.getMoAttributes(this.myMo.getType(), "reservedBy");
            AttributeDataType adType = amData.getData();
            if (adType instanceof BiDirectionalAssociationDataType) {
                reservedByMetaData = (BiDirectionalAssociationDataType)adType;
                Object reservedMo = mReservedBy.getValue(coordinator);
                ((BiDirectionalAssociationDataType)reservedByMetaData).checkAttribute("reservedBy", moToReference, new Object[]{reservedMo});
            } else {
                reservedByMetaData = (SingleRefBiDirectionalAssociationDataType)adType;
                Object reservedMo = mReservedBy.getValue(coordinator);
                AttributeMetaDataValidator amdv = this.moValidatorFactory.createAttributeMetaDataValidator(this.myMo.getType());
                amdv.checkSingleRefAttribute(reservedByMetaData, "reservedBy", moToReference, reservedMo, amData.isMandatory());
            }
            ReferenceAttribute newMoRefValue = new ReferenceAttribute("reservedBy", moToReference.getLocalDistinguishedName(), true);
            newMoRefValue.setValue(moToReference);
            mReservedBy.setValue(moToReference, coordinator, this.myMo);
        } else {
            String msg = "No attribute reservedBy found on this MO! Can not reserve this MO type!" + this.myMoType;
            throw new ProcessingFailureException(msg);
        }
        logger.traceReturn(THIS_CLASS, "addReservedBy - " + this.myMoType);
    }

    public void delete(Coordinator coordinator) throws MoAccessException, ProcessingFailureException {
        logger.traceEnter(THIS_CLASS, "delete - " + this.myMoType);
        Iterator localAttributesIter = this.locallyStoredAttributes.values().iterator();
        while (localAttributesIter.hasNext()) {
            LocalAttribute currentLocalAttribute = (LocalAttribute)localAttributesIter.next();
            currentLocalAttribute.delete(this.myMo, coordinator);
        }
        this.mMoData.delete(coordinator);
        logger.traceReturn(THIS_CLASS, "delete - " + this.myMoType);
    }

    public void deleteAdditionalAttribute(String attributeName, Coordinator coordinator) {
        Attribute attribute;
        logger.traceEnter(THIS_CLASS, "deleteAdditionalAttribute(" + attributeName + ") - " + this.myMoType);
        if (!this.isLocal(attributeName) && (attribute = this.mMoData.getAttribute(attributeName)) != null) {
            this.mMoData.deregisterAttribute(attribute);
        }
        logger.traceReturn(THIS_CLASS, "deleteAdditionalAttribute(" + attributeName + ") - " + this.myMoType);
    }

    public Object getAdditionalAttribute(String attributeName, Coordinator coordinator) throws TransactionRequiredException, ProcessingFailureException, ResourceUnavailableException, MoAccessException {
        Attribute attribute;
        logger.traceEnter(THIS_CLASS, "getAdditionalAttribute(" + attributeName + ") - " + this.myMoType);
        Object attributeValue = null;
        if (!this.isLocal(attributeName) && (attribute = this.mMoData.getAttribute(attributeName)) != null) {
            try {
                IntegerAttribute iAttribute = (IntegerAttribute)attribute;
                attributeValue = new Integer(iAttribute.getValue(coordinator));
            }
            catch (RuntimeException e) {
                try {
                    StringAttribute sAttribute = (StringAttribute)attribute;
                    attributeValue = sAttribute.getValue(coordinator);
                }
                catch (RuntimeException ree) {
                    logger.traceGeneral(THIS_CLASS, "getAdditionalAttribute(" + attributeName + ") - " + this.myMoType + "runtimeException");
                }
            }
        }
        logger.traceReturn(THIS_CLASS, "getAdditionalAttribute(" + attributeName + ") - " + this.myMoType);
        return attributeValue;
    }

    public Object getAttribute(String attributeName, Coordinator coordinator) throws TransactionRequiredException, ProcessingFailureException, ResourceUnavailableException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "getAttribute(" + attributeName + ") - " + this.myMoType);
        Object attributeValue = null;
        if (attributeName.equalsIgnoreCase(FRO_ID)) {
            attributeValue = new Integer(this.mFroId.getValue(coordinator));
        } else if (this.locallyStoredAttributes.containsKey(attributeName)) {
            LocalAttribute attribute = (LocalAttribute)this.locallyStoredAttributes.get(attributeName);
            attributeValue = attribute.getValue(coordinator);
        }
        logger.traceReturn(THIS_CLASS, "getAttribute(" + attributeName + ") - " + this.myMoType);
        return attributeValue;
    }

    public int getFroId(Coordinator coordinator) throws MoAccessException, TransactionRequiredException {
        logger.traceEnter(THIS_CLASS, "getFroId - " + this.myMoType);
        int res = -1;
        if (this.mFroId != null) {
            res = this.mFroId.getValue(coordinator);
        }
        logger.traceReturn(THIS_CLASS, "getFroId - " + this.myMoType);
        return res;
    }

    public void handleTransaction(Coordinator coordinator, MoData.AccessType accesstype) throws TransactionRequiredException, NoPermissionException, ResourceLockedException {
        logger.traceEnter(THIS_CLASS, "handleTransaction - " + this.myMoType);
        if (this.mMoData != null) {
            this.mMoData.handleTransaction(coordinator, accesstype);
        }
        logger.traceReturn(THIS_CLASS, "handleTransaction - " + this.myMoType);
    }

    public void initFroId(int froId) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "initFroId - " + this.myMoType);
        this.mFroId = new IntegerAttribute(FRO_ID, false, froId);
        this.mMoData.registerPersistentAttr((Attribute)this.mFroId);
        logger.traceReturn(THIS_CLASS, "initFroId - " + this.myMoType);
    }

    public void initMoData(AttrList attributes, MoDataWrapper inMMoData, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "initMoData - " + this.myMoType);
        this.mMoData = inMMoData;
        Iterator localAttributesIter = this.locallyStoredAttributes.values().iterator();
        logger.traceDebug(THIS_CLASS, "Attributes (size: " + attributes.size() + ")\n" + attributes.toString());
        while (localAttributesIter.hasNext()) {
            LocalAttribute currentLocalAttribute = (LocalAttribute)localAttributesIter.next();
            currentLocalAttribute.init(attributes, inMMoData, this.myMo, coordinator);
            logger.traceDebug(THIS_CLASS, "Attribute: " + currentLocalAttribute.toString() + " with value " + currentLocalAttribute.getValue(coordinator) + " stored locally.");
        }
        logger.traceReturn(THIS_CLASS, "initMoData - " + this.myMoType);
    }

    public boolean isLocal(String attributeName) {
        logger.traceEnter(THIS_CLASS, "isLocal(" + attributeName + ") - " + this.myMoType);
        boolean res = FRO_ID.equalsIgnoreCase(attributeName) || this.locallyStoredAttributes.containsKey(attributeName);
        logger.traceReturn(THIS_CLASS, "isLocal - " + this.myMoType);
        return res;
    }

    public void recover(MoDataWrapper recoveredData) {
        logger.traceEnter(THIS_CLASS, "recover - " + this.myMoType);
        this.mMoData = recoveredData;
        this.mFroId = (IntegerAttribute)recoveredData.getAttribute(FRO_ID);
        Iterator localAttributeIter = this.locallyStoredAttributes.keySet().iterator();
        while (localAttributeIter.hasNext()) {
            String currentAttributeName = (String)localAttributeIter.next();
            Attribute currentAttribute = recoveredData.getAttribute(currentAttributeName);
            LocalAttribute currentLocalAttribute = (LocalAttribute)this.locallyStoredAttributes.get(currentAttributeName);
            currentLocalAttribute.recover(currentAttribute);
        }
        logger.traceGeneral(this.getClass(), "Version Attribute in MoData = " + recoveredData.getRevision());
        logger.traceReturn(THIS_CLASS, "recover - " + this.myMoType);
    }

    public void removeReservedBy(ManagedObject moToRemove, Coordinator coordinator) throws TransactionRequiredException, MoAccessException {
        String ref = moToRemove.getType();
        logger.traceEnter(THIS_CLASS, "removeReservedBy(" + ref + ") - " + this.myMoType);
        if (this.locallyStoredAttributes.containsKey("reservedBy")) {
            if (this.locallyStoredAttributes.get("reservedBy") instanceof MaoSequenceAttribute) {
                MaoSequenceAttribute mReservedBy = (MaoSequenceAttribute)this.locallyStoredAttributes.get("reservedBy");
                String moToRemoveName = moToRemove.getLocalDistinguishedName();
                ManagedObject[] oldValue = (ManagedObject[])mReservedBy.getValue(coordinator);
                ArrayList<ManagedObject> resByList = new ArrayList<ManagedObject>(Arrays.asList(oldValue));
                boolean isFound = false;
                for (int i = 0; i < resByList.size(); ++i) {
                    if (!moToRemoveName.equals(resByList.get(i).getLocalDistinguishedName())) continue;
                    resByList.remove(i);
                    isFound = true;
                    break;
                }
                if (isFound) {
                    ManagedObject[] newValue = resByList.toArray(new ManagedObject[resByList.size()]);
                    mReservedBy.setValue(newValue, coordinator, this.myMo);
                }
            } else {
                LocalAttribute mReservedBy = (LocalAttribute)this.locallyStoredAttributes.get("reservedBy");
                mReservedBy.setValue(null, coordinator, this.myMo);
            }
        }
        logger.traceReturn(THIS_CLASS, "removeReservedBy - " + this.myMoType);
    }

    public void setAdditionalAttribute(String attributeName, Object attributeValue, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "setAdditionalAttribute(" + attributeName + ", " + attributeValue + ") - " + this.myMoType);
        if (!this.isLocal(attributeName)) {
            Attribute attribute = this.mMoData.getAttribute(attributeName);
            if (attribute != null) {
                this.mMoData.deregisterAttribute(attribute);
            }
            LocalAttribute lAttribute = null;
            if (attributeValue instanceof String) {
                lAttribute = new MaoStringAttribute(attributeName, false);
            } else if (attributeValue instanceof Integer) {
                lAttribute = new MaoIntegerAttribute(attributeName, false);
            } else {
                throw new AttrNotSettableException((ManagedObject)this.myMo, "This attribute type is not supported as Additional Attribute.");
            }
            lAttribute.init(new AttrListImpl(new String[]{attributeName}, new Object[]{attributeValue}, this.moRepositoryWrapper), this.mMoData, this.myMo, coordinator);
        }
        logger.traceReturn(THIS_CLASS, "setAdditionalAttribute(" + attributeName + ", " + attributeValue + ") - " + this.myMoType);
    }

    public void setAttribute(String attributeName, Object attributeValue, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "setAttribute(" + attributeName + ") - " + this.myMoType);
        if (this.locallyStoredAttributes.containsKey(attributeName)) {
            LocalAttribute attribute = (LocalAttribute)this.locallyStoredAttributes.get(attributeName);
            attribute.setValue(attributeValue, coordinator, this.myMo);
        }
        logger.traceReturn(THIS_CLASS, "setAttribute(" + attributeName + ") - " + this.myMoType);
    }

    public void setAttributes(Map attributes, Coordinator coordinator) throws MoAccessException {
        Iterator iterator = attributes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String attributeName = (String)entry.getKey();
            Object attributeValue = entry.getValue();
            this.setAttribute(attributeName, attributeValue, coordinator);
        }
    }

    public void validateReferencesAtDelete(Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "checkForReferencesToMO - " + this.myMoType);
        if (this.locallyStoredAttributes.containsKey("reservedBy")) {
            LocalAttribute currentLocalAttribute = (LocalAttribute)this.locallyStoredAttributes.get("reservedBy");
            Object value = currentLocalAttribute.getValue(coordinator);
            if (value == null) {
                logger.traceGeneral(this.getClass(), "reservedBy was null when validating references at delete!");
            } else if (value.getClass().isArray()) {
                ManagedObject[] refs = (ManagedObject[])currentLocalAttribute.getValue(coordinator);
                if (refs != null && refs.length > 0) {
                    logger.traceGeneral(this.getClass(), "Cannot remove " + this.myMo.getType() + " until the references are removed!");
                    throw new ProcessingFailureException(this.myMo.getType() + " could not be deleted, there are still references to the MO");
                }
            } else {
                logger.traceGeneral(this.getClass(), "Cannot remove " + this.myMo.getType() + "until the references are removed!");
                throw new ProcessingFailureException(this.myMo.getType() + " could not be deleted, there are still references to the MO");
            }
        }
        logger.traceReturn(THIS_CLASS, "checkForReferencesToMO - " + this.myMoType);
    }

    public Object getLocalAttribute(String attributeName, Coordinator coordinator) {
        logger.traceEnter(THIS_CLASS, "getLocalAttribute(" + attributeName + ") - " + this.myMoType);
        if (this.locallyStoredAttributes.containsKey(attributeName)) {
            LocalAttribute attribute = (LocalAttribute)this.locallyStoredAttributes.get(attributeName);
            return attribute;
        }
        logger.traceReturn(THIS_CLASS, "getLocalAttribute(" + attributeName + ") - " + this.myMoType);
        return null;
    }
}

