/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.mao.genericmo.attributes.type;

import java.util.ArrayList;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.BooleanAttribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.NotHandledAttributeTypeException;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructAttribute;
import se.ericsson.cello.swmanagement.LoadModuleMoImpl;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.omf.mao.commonmo.metadata.finder.MoMetaDataFinder;
import se.ericsson.crbs.omf.mao.genericmo.attributes.type.LocalAttribute;
import se.ericsson.crbs.omf.mao.wrappers.MoDataWrapper;

public class MaoStructureAttribute
implements LocalAttribute {
    private StructAttribute attributeValue = null;
    private final String attributeName;
    private final boolean isAvcNotifier;

    public MaoStructureAttribute(String moName, String attributeName, boolean isAvcNotifier, MoMetaDataFinder aFinder) throws MoAccessException {
        this.attributeName = attributeName;
        this.isAvcNotifier = isAvcNotifier;
    }

    public void delete(ManagedObject myMo, Coordinator coordinator) throws MoAccessException {
        Attribute[] attributes = this.attributeValue.getElements(coordinator);
        for (int i = 0; i < attributes.length; ++i) {
            if (attributes[i] instanceof ReferenceAttribute) {
                ManagedObject referencedMo = ((ReferenceAttribute)attributes[i]).getValue(coordinator);
                if (referencedMo == null) continue;
                ((Reservable)referencedMo).release(myMo, coordinator);
                continue;
            }
            if (!(attributes[i] instanceof SequenceAttribute)) continue;
            Attribute[] sequenceAttributes = ((SequenceAttribute)attributes[i]).getValue(coordinator);
            for (int j = 0; j < sequenceAttributes.length; ++j) {
                ReferenceAttribute referenceAttribute;
                ManagedObject referencedMo;
                if (!(sequenceAttributes[j] instanceof ReferenceAttribute) || (referencedMo = (referenceAttribute = (ReferenceAttribute)sequenceAttributes[j]).getValue(coordinator)) == null) continue;
                ((Reservable)referencedMo).release(myMo, coordinator);
            }
        }
    }

    public Object getValue(Coordinator coord) throws MoAccessException {
        return this.attributeValue.getValue(coord);
    }

    public void init(AttrList attributes, MoDataWrapper mMoData, ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        Struct structValues;
        this.attributeValue = new StructAttribute(this.attributeName, this.isAvcNotifier);
        mMoData.registerPersistentAttr((Attribute)this.attributeValue);
        if (attributes.contains(new String[]{this.attributeName}) && (structValues = (Struct)attributes.getValue(attributes.indexOf(this.attributeName))) != null) {
            String[] structName = structValues.getNames();
            Object[] structValuesArray = structValues.getValues();
            for (int i = 0; i < structValuesArray.length; ++i) {
                this.attributeValue.addElement(this.objectToAttribute(structValuesArray[i], structName[i], managedObject, coordinator));
            }
        }
    }

    private Attribute objectToAttribute(Object structIndexValue, String structName, ManagedObject myMo, Coordinator coordinator) throws MoAccessException {
        IntegerAttribute requiredAttribute = null;
        if (structIndexValue.getClass().toString().equals("class java.lang.Integer")) {
            requiredAttribute = new IntegerAttribute(structName, this.isAvcNotifier);
            requiredAttribute.setValue((Integer)structIndexValue);
        } else if (structIndexValue.getClass().toString().equals("class java.lang.String")) {
            requiredAttribute = new StringAttribute(structName, this.isAvcNotifier);
            ((StringAttribute)requiredAttribute).setValue((String)structIndexValue);
        } else if (structIndexValue.getClass().toString().equals("class java.lang.Boolean")) {
            requiredAttribute = new BooleanAttribute(structName, this.isAvcNotifier, ((Boolean)structIndexValue).booleanValue());
        } else if (structIndexValue instanceof ManagedObject) {
            requiredAttribute = new ReferenceAttribute(structName, this.isAvcNotifier);
            ((ReferenceAttribute)requiredAttribute).setValue((ManagedObject)structIndexValue);
            if (!(structIndexValue instanceof LoadModuleMoImpl) && structIndexValue != null) {
                ((Reservable)structIndexValue).reserve(myMo, coordinator);
            }
        } else if (structIndexValue instanceof Object[]) {
            SequenceAttribute seqAttribute = new SequenceAttribute(structName, false);
            Object[] newArray = (Object[])structIndexValue;
            for (int i = 0; i < ((Object[])structIndexValue).length; ++i) {
                Attribute newAttribute = this.objectToAttribute(newArray[i], structName, myMo, coordinator);
                seqAttribute.addElement(newAttribute);
            }
            requiredAttribute = seqAttribute;
        } else if (structIndexValue instanceof int[]) {
            SequenceAttribute seqAttribute = new SequenceAttribute(structName, false);
            int[] newArray = (int[])structIndexValue;
            for (int i = 0; i < newArray.length; ++i) {
                Attribute newAttribute = this.objectToAttribute(new Integer(newArray[i]), structName, myMo, coordinator);
                seqAttribute.addElement(newAttribute);
            }
            requiredAttribute = seqAttribute;
        } else if (structIndexValue instanceof boolean[]) {
            SequenceAttribute seqAttribute = new SequenceAttribute(structName, false);
            boolean[] newArray = (boolean[])structIndexValue;
            for (int i = 0; i < newArray.length; ++i) {
                Attribute newAttribute = this.objectToAttribute(newArray[i], structName, myMo, coordinator);
                seqAttribute.addElement(newAttribute);
            }
            requiredAttribute = seqAttribute;
        } else {
            throw new NotHandledAttributeTypeException();
        }
        return requiredAttribute;
    }

    public void recover(Attribute newValue) {
        this.attributeValue = (StructAttribute)newValue;
    }

    public void setValue(Object newValue, Coordinator coord, ManagedObject myMo) throws MoAccessException {
        Struct structValues = (Struct)newValue;
        String[] structNames = structValues.getNames();
        Object[] newValues = structValues.getValues();
        Attribute[] newValueAttributes = new Attribute[newValues.length];
        if (this.attributeValue.getElement(structNames[0], coord) == null) {
            for (int i = 0; i < newValues.length; ++i) {
                newValueAttributes[i] = this.objectToAttribute(newValues[i], structNames[i], myMo, coord);
                this.attributeValue.addElement(newValueAttributes[i]);
            }
        } else {
            for (int i = 0; i < newValues.length; ++i) {
                this.setTypeOfValue(newValues[i], structNames[i], coord, myMo);
            }
        }
    }

    private void setTypeOfValue(Object newValue, String structName, Coordinator coord, ManagedObject myMo) throws MoAccessException {
        if (newValue instanceof Integer) {
            IntegerAttribute structElement = (IntegerAttribute)this.attributeValue.getElement(structName, coord);
            structElement.setValue((Integer)newValue);
        } else if (newValue instanceof String) {
            StringAttribute structElement = (StringAttribute)this.attributeValue.getElement(structName, coord);
            structElement.setValue((String)newValue);
        } else if (newValue instanceof Boolean) {
            BooleanAttribute structElement = (BooleanAttribute)this.attributeValue.getElement(structName, coord);
            structElement.setValue((Boolean)newValue);
        } else if (newValue instanceof ManagedObject) {
            ReferenceAttribute structElement = (ReferenceAttribute)this.attributeValue.getElement(structName, coord);
            ManagedObject referencedMO = structElement.getValue(coord);
            if (referencedMO != null) {
                ((Reservable)referencedMO).release(myMo, coord);
            }
            ((Reservable)newValue).reserve(myMo, coord);
            structElement.setValue((ManagedObject)newValue);
        } else if (newValue instanceof Object[]) {
            SequenceAttribute structElement = (SequenceAttribute)this.attributeValue.getElement(structName, coord);
            ArrayList<Attribute> newAttributeArray = new ArrayList<Attribute>();
            Object[] newArray = (Object[])newValue;
            for (int j = 0; j < newArray.length; ++j) {
                Attribute newAttribute = this.objectToAttribute(newArray[j], structName, myMo, coord);
                newAttributeArray.add(newAttribute);
            }
            Attribute[] tmp = newAttributeArray.toArray(new Attribute[newAttributeArray.size()]);
            structElement.setValue(tmp);
        } else if (newValue instanceof int[]) {
            SequenceAttribute structElement = (SequenceAttribute)this.attributeValue.getElement(structName, coord);
            int[] newArray = (int[])newValue;
            ArrayList<Attribute> newAttributeArray = new ArrayList<Attribute>();
            for (int j = 0; j < newArray.length; ++j) {
                Attribute newAttribute = this.objectToAttribute(new Integer(newArray[j]), structName, myMo, coord);
                newAttributeArray.add(newAttribute);
            }
            Attribute[] tmp = newAttributeArray.toArray(new Attribute[newAttributeArray.size()]);
            structElement.setValue(tmp);
        } else if (newValue instanceof boolean[]) {
            SequenceAttribute structElement = (SequenceAttribute)this.attributeValue.getElement(structName, coord);
            boolean[] newArray = (boolean[])newValue;
            ArrayList<Attribute> newAttributeArray = new ArrayList<Attribute>();
            for (int j = 0; j < newArray.length; ++j) {
                Attribute newAttribute = this.objectToAttribute(newArray[j], structName, myMo, coord);
                newAttributeArray.add(newAttribute);
            }
            Attribute[] tmp = newAttributeArray.toArray(new Attribute[newAttributeArray.size()]);
            structElement.setValue(tmp);
        } else {
            if (newValue instanceof Struct) {
                throw new NotHandledAttributeTypeException();
            }
            throw new NotHandledAttributeTypeException();
        }
    }

    public String toString() {
        return "Name: " + this.attributeName + " Value: " + this.attributeValue + " AVCNotifier " + this.isAvcNotifier;
    }
}

