/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.mao.genericmo.froproxy;

import java.util.HashMap;
import java.util.ListResourceBundle;
import java.util.Map;
import java.util.ResourceBundle;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.proxy.TagNameDictionaries;
import se.ericsson.cello.maofro.proxy.TagNameDictionary;
import se.ericsson.cello.maofro.proxy.TagNameDictionaryException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.metadata.MoMetaData;
import se.ericsson.crbs.omf.mao.commonmo.metadata.finder.MoMetaDataFinder;
import se.ericsson.crbs.omf.mao.genericmo.froproxy.CppMaoFroProxyAdaptor;
import se.ericsson.crbs.omf.mao.genericmo.froproxy.FroProxyFactory;

public class FroProxyFactoryImpl
implements FroProxyFactory {
    private static final Map proxyMap = new HashMap();
    private static final Class THIS_CLASS = FroProxyFactoryImpl.class;
    private static FroProxy testProxy = null;
    private static boolean testMode = false;
    private static AbstractLogger logger = LoggingService.getLogger(FroProxyFactoryImpl.class.getName());
    private final MoMetaDataFinder aFinder;

    private static ListResourceBundle createBundle(final MoMetaData moData) {
        logger.traceEnter(THIS_CLASS, "createBundle");
        ListResourceBundle bundle = new ListResourceBundle(){
            final Object[][] CONTENTS;
            {
                this.CONTENTS = new Object[][]{{"data", "21"}, {"zipData", "22"}, {"serviceName", moData.getServiceName()}, {"pvFirstWanted", moData.getFroProtocolVersion()}, {"pvSecondWanted", moData.getFroProtocolVersion()}, {"pvThirdWanted", moData.getFroProtocolVersion()}, {"froType", moData.getFroType()}};
            }

            protected Object[][] getContents() {
                return this.CONTENTS;
            }
        };
        logger.traceReturn(THIS_CLASS, "createBundle");
        return bundle;
    }

    public static void setProxyInstance(FroProxy instance) {
        logger.traceEnter(THIS_CLASS, "setproxyInstance()");
        testProxy = instance;
        testMode = true;
        logger.traceReturn(THIS_CLASS, "setproxyInstance()");
    }

    public static void setProxyInstance(String interfaceName, FroProxy instance) {
        logger.traceEnter(THIS_CLASS, "setproxyInstance(" + interfaceName + ")");
        proxyMap.put(interfaceName, instance);
        logger.traceReturn(THIS_CLASS, "setproxyInstance(" + interfaceName + ")");
    }

    public static void resetProxyMapBasicForTest() {
        logger.traceEnter(THIS_CLASS, "resetProxyMapBasicForTest");
        proxyMap.clear();
        testMode = false;
        logger.traceReturn(THIS_CLASS, "resetProxyMapBasicForTest");
    }

    public FroProxyFactoryImpl(MoMetaDataFinder aFinder) {
        this.aFinder = aFinder;
    }

    private FroProxy createInstance(String moType) {
        logger.traceEnter(THIS_CLASS, "createInstance");
        ListResourceBundle bundle = null;
        MoMetaData moData = this.aFinder.getMoData(moType);
        bundle = FroProxyFactoryImpl.createBundle(moData);
        TagNameDictionary tagnamedictionary = TagNameDictionaries.create((ResourceBundle)bundle);
        CppMaoFroProxyAdaptor instance = null;
        try {
            instance = new CppMaoFroProxyAdaptor(tagnamedictionary, moType);
        }
        catch (TagNameDictionaryException e) {
            logger.traceError(THIS_CLASS, "Cannot create CppMaoFroProxyAdaptor for " + moType, e);
        }
        proxyMap.put(moType, instance);
        logger.traceReturn(THIS_CLASS, "createInstance");
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FroProxy getInstance(String moType) {
        Class clazz = FroProxyFactoryImpl.class;
        synchronized (clazz) {
            logger.traceEnter(THIS_CLASS, "getInstance");
            FroProxy res = null;
            res = testMode ? testProxy : (proxyMap.containsKey(moType) ? (FroProxy)proxyMap.get(moType) : this.createInstance(moType));
            logger.traceReturn(THIS_CLASS, "getInstance");
            return res;
        }
    }
}

