/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.mao.genericmo.systemcreatedmos;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoHasChildrenException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.session.ServiceSubscriber;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionFactory;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.crbs.common.ExceptionHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.StringHolder;
import se.ericsson.crbs.omf.mao.commonmo.metadata.MoMetaData;
import se.ericsson.crbs.omf.mao.commonmo.metadata.finder.MoMetaDataFinder;
import se.ericsson.crbs.omf.mao.commonmo.metadata.supplier.DataSupplierImpl;
import se.ericsson.crbs.omf.mao.commonmo.transactions.TransactionServicesFactoryImpl;
import se.ericsson.crbs.omf.mao.commonmo.validation.MoValidator;
import se.ericsson.crbs.omf.mao.genericmo.GenericMao;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoFactory;
import se.ericsson.crbs.omf.mao.genericmo.MaoFactoryFactory;
import se.ericsson.crbs.omf.mao.genericmo.SpecialisedMaoImplClassHelper;
import se.ericsson.crbs.omf.mao.genericmo.systemcreatedmos.Detector;
import se.ericsson.crbs.omf.mao.genericmo.systemcreatedmos.MoInstanceData;
import se.ericsson.crbs.omf.mao.genericmo.systemcreatedmos.ReferenceNotYetAvailableException;
import se.ericsson.crbs.omf.mao.genericmo.systemcreatedmos.SynchObserver;
import se.ericsson.crbs.omf.mao.genericmo.systemcreatedmos.SystemCreatedMaoFactory;
import se.ericsson.crbs.omf.mao.genericmo.systemcreatedmos.SystemCreatedMosHandler;
import se.ericsson.crbs.omf.mao.indications.ServiceHandler;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class SystemCreatedMaoFactoryImpl
extends GenericMaoFactory
implements SystemCreatedMaoFactory,
SynchObserver,
Detector,
ServiceSubscriber {
    private static AbstractLogger logger = LoggingService.getLogger(SystemCreatedMaoFactoryImpl.class.getName());
    private MoMetaDataFinder finder;
    private static final Class THIS_CLASS = SystemCreatedMaoFactoryImpl.class;
    private static final Map waitingFactories = new TreeMap();
    private static final Object SYNCH_MUTEX = new Object();
    private final MoRepositoryWrapper aWrapper;
    private ServiceHandler serviceHandler;
    private final MaoFactoryFactory maoFactoryFactory;
    private List myDetectors = new ArrayList();
    private final List myObservers = new ArrayList();
    private boolean synched = false;
    private final List detectorsReady = new ArrayList();
    private final String MOINFO;
    private final GenericMaoContext myGenericMaoContext;
    private boolean notifymyobserver = false;
    private final List createdMoList = new LinkedList();
    private final Object serviceAddedInternalMutex = new Object();

    public SystemCreatedMaoFactoryImpl(String moType, GenericMaoContext aGenericMaoContext) {
        super(moType, aGenericMaoContext);
        this.MOINFO = " - MO Type: " + moType;
        logger.traceEnter(THIS_CLASS, "SystemCreatedMaoFactory(moType, GenericMaoContext)" + this.MOINFO);
        this.myGenericMaoContext = aGenericMaoContext;
        this.finder = this.getFinder();
        this.registerIndications();
        this.aWrapper = aGenericMaoContext.getMoRepositoryWrapper();
        this.maoFactoryFactory = aGenericMaoContext.getMaoFactoryFactory();
        logger.traceReturn(THIS_CLASS, "SystemCreatedMaoFactory()");
    }

    public void addSynchObserver(SynchObserver obs) {
        logger.traceEnter(THIS_CLASS, "addSynchObserver(SynchObserver), synchObserver = " + obs.getClass() + this.MOINFO);
        this.myObservers.add(obs);
        logger.traceReturn(THIS_CLASS, "addSynchObserver()");
    }

    private void startTxAndCreateMyMos(SystemCreatedMosHandler handler) {
        logger.traceEnter(THIS_CLASS, "createMyMos(handler), handler = " + handler.toString() + this.MOINFO);
        try {
            TransactionFactory transFact = TransactionServicesFactoryImpl.getInstance().getCppTransactionFactory();
            Control control = transFact.create(59);
            Coordinator coordinator = control.getCoordinator();
            logger.traceGeneral(THIS_CLASS, "TransactionId for create Mo: " + coordinator.getTransactionID() + this.MOINFO);
            try {
                this.createMyMos(handler, coordinator);
                control.getTerminator().commit();
                logger.traceGeneral(THIS_CLASS, "Transaction is committed. TransactionId: " + coordinator.getTransactionID() + this.MOINFO);
            }
            catch (MoAccessException mae) {
                logger.traceError(THIS_CLASS, "Unable to create MO of type " + this.myMoType + " due to exception: " + ExceptionHelper.getExceptionMessage(mae));
                control.getTerminator().rollback();
                logger.traceGeneral(THIS_CLASS, "Transaction is rolled back. TransactionId: " + coordinator.getTransactionID() + this.MOINFO);
            }
        }
        catch (InactiveTransactionException ite) {
            logger.traceError(THIS_CLASS, "InactiveTransactionException in create. " + this.MOINFO, ite);
        }
        catch (TransactionRolledBackException trbe) {
            logger.traceError(THIS_CLASS, "TransactionRolledBackException in " + this.MOINFO, trbe);
        }
        logger.traceReturn(THIS_CLASS, "createMyMos(handler), handler = " + handler.toString() + this.MOINFO);
    }

    private void createMyMos(SystemCreatedMosHandler handler, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "createMyMos(handler, coordinator), handler = " + handler.toString() + this.MOINFO);
        try {
            Iterator myMaoData = handler.getMoInstanceDataList().iterator();
            while (myMaoData.hasNext()) {
                MoInstanceData maoData = (MoInstanceData)myMaoData.next();
                ManagedObject parent = maoData.getParent();
                String rdnId = maoData.getRdnId();
                String ldn = parent.getLocalDistinguishedName() + "," + this.myMoType + "=" + rdnId;
                if (this.moAlreadyExists(ldn)) continue;
                this.createSystemMo(parent, maoData.getAttributes(), rdnId, null, coordinator);
                this.createdMoList.add(ldn);
            }
            this.notifymyobserver = true;
        }
        catch (ReferenceNotYetAvailableException rnyae) {
            waitingFactories.put(rnyae.getMissingReferenceAsLdn(), this);
        }
        logger.traceReturn(THIS_CLASS, "createMyMos(handler, coordinator), handler = " + handler.toString() + this.MOINFO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ManagedObject createSystemMo(ManagedObject parent, AttrList attributes, String identity, ManagedObject source, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "createSystemMo(parent, attributes, id, source, coordinator), parent = " + parent.toString() + " attributes = " + attributes.toString() + " id = " + identity + this.MOINFO);
        MoValidator validator = this.moValidatorFactory.createMoValidatorImpl(this.myMoType);
        validator.verifyAtCreate(parent, attributes, true, coordinator);
        DataSupplierImpl dataSupplier = new DataSupplierImpl(this.myMoType, this.genericMaoContext.getMoMetaDataFinder());
        AttrList attrList = dataSupplier.supplyDataAtCreate(source, attributes, parent, new StringHolder(identity), coordinator, this.aWrapper);
        logger.traceGeneral(THIS_CLASS, "Attributes validated for MO" + identity);
        Object requiredObject = null;
        int swRevision = -1;
        ManagedObject managedObject = parent;
        synchronized (managedObject) {
            Class specialClass = SpecialisedMaoImplClassHelper.getSpecialisedMaoClass(this.myMoType, this.genericMaoContext);
            swRevision = this.finder.getMoData(this.myMoType).getSwRevision();
            if (specialClass == null) {
                logger.traceGeneral(THIS_CLASS, "Special class is null.");
                requiredObject = new GenericMao(parent, attrList, identity, this.myMoType, this.getGenericMaoContext(), new Integer(swRevision), coordinator, this.initMaocontext);
            } else {
                logger.traceGeneral(THIS_CLASS, "Special class found.");
                requiredObject = SpecialisedMaoImplClassHelper.createSpecialisedMaoImplClass(this.myMoType, specialClass, parent, attrList, identity, coordinator, this.getGenericMaoContext(), this.initMaocontext);
            }
        }
        logger.traceReturn(THIS_CLASS, "createSystemMo()" + this.MOINFO);
        return (ManagedObject)requiredObject;
    }

    public void deleteInternalMo(ManagedObject child, Coordinator coordinator) throws MoHasChildrenException, UndeletableMoException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "deleteInternalMo(child, coordinator), child LDN =: " + child.getLocalDistinguishedName() + ", child = " + child.toString() + this.MOINFO);
        try {
            logger.traceGeneral(THIS_CLASS, "Trying to remove a system created MO");
            GenericMao myChild = (GenericMao)child;
            myChild.deleteInternal(coordinator);
        }
        catch (MoHasChildrenException childEx) {
            logger.traceError(THIS_CLASS, "Cannot remove a system created MO which itself has children");
            throw childEx;
        }
        logger.traceReturn(THIS_CLASS, "deleteInternalMo(child, coordinator)" + this.MOINFO);
    }

    private MoMetaDataFinder getFinder() {
        if (this.finder == null) {
            this.finder = this.myGenericMaoContext.getMoMetaDataFinder();
        }
        return this.finder;
    }

    protected String getMyMoType() {
        return this.myMoType;
    }

    private String getServiceName() {
        String serviceName = "NO_SERVICE";
        MoMetaData moData = this.getFinder().getMoData(this.myMoType);
        serviceName = moData.getServiceName();
        return serviceName;
    }

    private boolean isAllMosCreated() {
        logger.traceEnter(THIS_CLASS, "isAllMosCreated()" + this.MOINFO);
        boolean result = false;
        MoIterator moIter = this.aWrapper.lookupType(this.myMoType);
        try {
            MoMetaData moMetaData = this.getFinder().getMoData(this.myMoType);
            int absoluteCardinality = moMetaData.getAbsoluteCardinality(this.getFinder());
            logger.traceGeneral(THIS_CLASS, "For MO " + this.myMoType + " max cardinality is " + absoluteCardinality);
            if (moIter != null && moIter.size() == absoluteCardinality) {
                result = true;
            }
        }
        catch (IOException ie) {
            logger.traceError(THIS_CLASS, "IOException in check cardinality for " + this.myMoType, ie);
        }
        catch (MoAccessException mae) {
            logger.traceError(THIS_CLASS, "MoAccessException in check cardinality for " + this.myMoType, mae);
        }
        logger.traceReturn(THIS_CLASS, "isAllMosCreated() = " + result + this.MOINFO);
        return result;
    }

    private boolean isAllMosCreated(String parentType) {
        logger.traceEnter(THIS_CLASS, "isAllMosCreated(parentType), parentType = " + parentType + this.MOINFO);
        boolean result = false;
        MoIterator moIter = this.aWrapper.lookupType(this.myMoType);
        int noOfMoInstances = 0;
        if (moIter != null) {
            while (moIter.hasMoreElements()) {
                ManagedObject currentMo = moIter.nextMo();
                if (!currentMo.getParent().getType().equals(parentType)) continue;
                ++noOfMoInstances;
            }
        }
        logger.traceGeneral(THIS_CLASS, "Number of " + this.myMoType + " instances found for parent " + parentType + " is " + noOfMoInstances);
        try {
            MoMetaData moMetaData = this.getFinder().getMoData(this.myMoType);
            int absoluteCardinalityPerParent = moMetaData.getAbsoluteCardinalityPerParent(parentType, this.getFinder());
            logger.traceGeneral(THIS_CLASS, "For MO " + this.myMoType + " under current parent, max cardinality is " + absoluteCardinalityPerParent);
            if (noOfMoInstances == absoluteCardinalityPerParent) {
                result = true;
            }
        }
        catch (IOException ie) {
            logger.traceError(THIS_CLASS, "IOException in check cardinality for " + this.myMoType, ie);
        }
        catch (MoAccessException mae) {
            logger.traceError(THIS_CLASS, "MoAccessException in check cardinality for " + this.myMoType, mae);
        }
        logger.traceReturn(THIS_CLASS, "isAllMosCreated(parentType) = " + result + this.MOINFO);
        return result;
    }

    private boolean isAllParentMosCreated(String parentType) {
        logger.traceEnter(THIS_CLASS, "isAllParentMosCreated(parentType), parentType = " + parentType + this.MOINFO);
        boolean result = false;
        int noOfParentMoInstances = 0;
        MoIterator moIter = this.aWrapper.lookupType(parentType);
        if (moIter != null) {
            noOfParentMoInstances = moIter.size();
        }
        logger.traceGeneral(THIS_CLASS, "Number of created " + parentType + " instances are " + noOfParentMoInstances);
        try {
            MoMetaData moMetaData = this.getFinder().getMoData(parentType);
            if (noOfParentMoInstances == moMetaData.getAbsoluteCardinality(this.getFinder())) {
                result = true;
            }
        }
        catch (IOException ie) {
            logger.traceError(this.getClass(), "IOException in check cardinality for " + parentType, ie);
        }
        catch (MoAccessException mae) {
            logger.traceError(this.getClass(), "MoAccessException in check cardinality for " + parentType, mae);
        }
        logger.traceReturn(THIS_CLASS, "isAllParentMosCreated(parentType) = " + result + this.MOINFO);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSynch() {
        Object object = SYNCH_MUTEX;
        synchronized (object) {
            return this.synched;
        }
    }

    private boolean moAlreadyExists(String ldn) {
        logger.traceEnter(THIS_CLASS, "moAlreadyExists( " + ldn + " )");
        ManagedObject mo = this.aWrapper.lookup(ldn);
        boolean result = mo != null;
        logger.traceReturn(THIS_CLASS, "moAlreadyExists( " + ldn + " ) = " + result);
        return result;
    }

    private void notifyMyObservers() {
        logger.traceEnter(THIS_CLASS, "notifyMyObservers()" + this.MOINFO);
        if (this.notifymyobserver || this.isAllMosCreated()) {
            Iterator observers = this.myObservers.iterator();
            SynchObserver synchObs = null;
            while (observers.hasNext()) {
                synchObs = (SynchObserver)observers.next();
                if (synchObs == null) continue;
                synchObs.synchReady(this.myMoType);
            }
            Iterator createdMoIter = this.createdMoList.iterator();
            while (createdMoIter.hasNext()) {
                String ldn = (String)createdMoIter.next();
                if (!waitingFactories.containsKey(ldn)) continue;
                SystemCreatedMaoFactoryImpl scmf = (SystemCreatedMaoFactoryImpl)waitingFactories.get(ldn);
                scmf.synchReady(this.myMoType);
            }
        }
        logger.traceReturn(THIS_CLASS, "notifyMyObservers()" + this.MOINFO);
    }

    private void registerIndications() {
        this.serviceHandler = this.serviceHandlerFactory.getServiceHandler(this.getServiceName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serviceAddedInternal() {
        logger.traceEnter(THIS_CLASS, "serviceAddedInternal()" + this.MOINFO);
        logger.traceDebug(THIS_CLASS, "serviceAddedInternal is waiting for the monitor");
        Object object = this.serviceAddedInternalMutex;
        synchronized (object) {
            logger.traceDebug(THIS_CLASS, "serviceAddedInternal got the monitor");
            if (!this.isAllMosCreated()) {
                String parent = "";
                if (this.myDetectors.isEmpty()) {
                    SystemCreatedMosHandler handler = new SystemCreatedMosHandler(this.myMoType, this.genericMaoContext);
                    this.startTxAndCreateMyMos(handler);
                } else {
                    Iterator detectorsReadyIterator = this.detectorsReady.iterator();
                    while (detectorsReadyIterator.hasNext()) {
                        parent = (String)detectorsReadyIterator.next();
                        logger.traceGeneral(THIS_CLASS, "Trying to create MO's for parent type: " + parent);
                        if (!this.isAllParentMosCreated(parent)) continue;
                        SystemCreatedMosHandler handler = new SystemCreatedMosHandler(this.myMoType, parent, this.genericMaoContext);
                        this.startTxAndCreateMyMos(handler);
                    }
                }
            }
            this.notifyMyObservers();
            this.serviceHandler.removeListener(this);
        }
        logger.traceReturn(THIS_CLASS, "serviceAddedInternal()" + this.MOINFO);
    }

    public void serviceAdded() {
        logger.traceEnter(THIS_CLASS, "serviceAdded()" + this.MOINFO);
        this.serviceAddedInternal();
        logger.traceReturn(THIS_CLASS, "serviceAdded()" + this.MOINFO);
    }

    public void serviceRemoved() {
        logger.traceEnter(THIS_CLASS, "serviceRemoved()" + this.MOINFO);
        logger.traceReturn(THIS_CLASS, "serviceRemoved()" + this.MOINFO);
    }

    public void start() {
        logger.traceEnter(THIS_CLASS, "start()" + this.MOINFO);
        if (!this.mStarted) {
            this.serviceHandler.subscribeService(this.myMoType);
            SystemCreatedMosHandler handler = new SystemCreatedMosHandler(this.myMoType, this.genericMaoContext);
            this.myDetectors = handler.getDetectors();
            Iterator detectors = this.myDetectors.iterator();
            while (detectors.hasNext()) {
                String moType = (String)detectors.next();
                MoMetaData meta = this.genericMaoContext.getMoMetaDataFinder().getMoData(moType);
                SystemCreatedMaoFactoryImpl detectorFactory = (SystemCreatedMaoFactoryImpl)this.maoFactoryFactory.getMoFactory(meta);
                detectorFactory.addSynchObserver(this);
            }
            this.mStarted = true;
        }
        logger.traceReturn(THIS_CLASS, "start()" + this.MOINFO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void synch() {
        logger.traceEnter(THIS_CLASS, "synch()" + this.MOINFO);
        Object object = SYNCH_MUTEX;
        synchronized (object) {
            if (this.synched) {
                logger.traceGeneral(THIS_CLASS, "synch() has already been called!");
            } else if (this.serviceHandler.isSessionCreated()) {
                this.serviceAddedInternal();
                this.synched = true;
                this.notifyMyObservers();
            } else {
                this.serviceHandler.addListener(this);
            }
        }
        logger.traceReturn(THIS_CLASS, "synch()" + this.MOINFO);
    }

    public void synchReady(String detectorType) {
        logger.traceEnter(THIS_CLASS, "synchReady(detectorType), detectortype = " + detectorType + this.MOINFO);
        this.detectorsReady.add(detectorType);
        if (this.serviceHandler.isSessionCreated() && this.isAllParentMosCreated(detectorType) && !this.isAllMosCreated(detectorType)) {
            SystemCreatedMosHandler handler = new SystemCreatedMosHandler(this.myMoType, detectorType, null, this.genericMaoContext);
            this.startTxAndCreateMyMos(handler);
        }
        this.notifyMyObservers();
        logger.traceReturn(THIS_CLASS, "synchReady(detectorType)" + this.MOINFO);
    }
}

