/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.mao.genericmo.xml;

import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import se.ericsson.cello.maofro.framework.ArrayParameter;
import se.ericsson.cello.maofro.framework.IllegalParameterValueException;
import se.ericsson.cello.maofro.framework.Parameter;
import se.ericsson.cello.maofro.framework.ParameterVisitor;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.maofro.framework.StringParameter;
import se.ericsson.cello.maofro.framework.StructParameter;
import se.ericsson.cello.maofro.framework.UnsignedIntParameter;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.xml.AbstractXmlHandler;
import se.ericsson.crbs.omf.mao.genericmo.xml.LongParameter;
import se.ericsson.crbs.omf.mao.genericmo.xml.MoRefParameter;

public class XmlHandlerImplR1B
extends AbstractXmlHandler
implements ErrorHandler {
    private static final String COMPLEX = "complex";
    private static final String NAME = "name";
    private static final String ATTR = "attr";
    private static final String MOREF = "moref";
    private static final String SEQ = "seq";
    private static final String STRCT = "strct";
    private static final String DATA = "data";
    private static final String TYPE = "type";
    private static final String VALUE = "value";
    private static final String U32 = "U32";
    private static final String S32 = "S32";
    private static final String S64 = "S64";
    private static final String STRING = "STRING";
    private static final Class THIS_CLASS = XmlHandlerImplR1B.class;
    private static final AbstractLogger logger = LoggingService.getLogger();
    private List complexList = new ArrayList();
    private StringBuffer rawData = new StringBuffer();
    private List data = new ArrayList();
    private boolean withinData = false;
    private int dataIndex = 0;
    private int typeIndex = 0;

    public void startDocument() throws SAXException {
        String msg = "startDocument()";
        logger.traceEnter(THIS_CLASS, "startDocument()");
        this.attributeList = new ArrayList();
        logger.traceReturn(THIS_CLASS, "startDocument()");
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes attributes) throws SAXException {
        String msg = "startElement() ";
        logger.traceEnter(THIS_CLASS, "startElement() " + qName);
        if (qName.equals(ATTR)) {
            if (this.complexList.isEmpty()) {
                this.attributeList.add(this.getAttr(attributes.getValue(NAME), attributes.getValue(TYPE), attributes.getValue(VALUE)));
            } else {
                this.complexList.add(new AttrParameter(attributes.getValue(NAME), attributes.getValue(TYPE)));
            }
        } else if (qName.equals(STRCT)) {
            String attrName = attributes.getValue(NAME);
            this.complexList.add(this.attributeStack.push(new StructParameter(attrName == null ? STRCT : attrName)));
        } else if (qName.equals(SEQ)) {
            String attrName = attributes.getValue(NAME);
            this.complexList.add(this.attributeStack.push(new SeqParameter(attrName == null ? SEQ : attrName, attributes.getValue(TYPE))));
        } else if (qName.equals(MOREF)) {
            String attrName = attributes.getValue(NAME);
            this.complexList.add(this.attributeStack.push(new MoRefParameter(attrName == null ? MOREF : attrName)));
        } else if (qName.equals(DATA)) {
            this.withinData = true;
        }
        logger.traceReturn(THIS_CLASS, "startElement() " + qName);
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        String msg = "endElement() ";
        logger.traceEnter(THIS_CLASS, "endElement() " + qName);
        if (qName.equals(SEQ) || qName.equals(STRCT) || qName.equals(MOREF)) {
            if (this.attributeStack.isEmpty()) {
                String errMsg = "Attribute stack is empty at end of element: " + qName;
                logger.traceAbnormal(THIS_CLASS, errMsg);
                return;
            }
            this.complexList.add(new EndParameter((Parameter)this.attributeStack.pop()));
        } else if (qName.equals(DATA)) {
            this.withinData = false;
        } else if (qName.equals(COMPLEX)) {
            this.handleData();
        }
        logger.traceReturn(THIS_CLASS, "endElement() " + qName);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.withinData) {
            this.rawData.append(ch, start, length);
        }
    }

    public void error(SAXParseException saxparseexception) throws SAXException {
        String msg = "error()";
        logger.traceEnter(THIS_CLASS, "error()");
        logger.traceAbnormal(THIS_CLASS, saxparseexception.getMessage());
        logger.traceReturn(THIS_CLASS, "error()");
    }

    public void fatalError(SAXParseException saxparseexception) throws SAXException {
        String msg = "fatalError()";
        logger.traceEnter(THIS_CLASS, "fatalError()");
        logger.traceAbnormal(THIS_CLASS, saxparseexception.getMessage());
        logger.traceReturn(THIS_CLASS, "fatalError()");
    }

    private void handleData() throws SAXException {
        String msg = "handleData()";
        logger.traceEnter(THIS_CLASS, "handleData()");
        try {
            this.data = this.split(this.rawData.toString());
            Object currentElement = this.complexList.get(this.typeIndex);
            if (currentElement instanceof AttrParameter) {
                this.attributeList.add(this.getAttr());
            } else if (currentElement instanceof SeqParameter) {
                this.attributeList.add((ArrayParameter)this.getSeq());
            } else if (currentElement instanceof StructParameter) {
                this.attributeList.add((StructParameter)this.getStrct());
            } else if (currentElement instanceof MoRefParameter) {
                this.attributeList.add((MoRefParameter)this.getMoRef());
            }
            if (this.data.size() != this.dataIndex) {
                throw new SAXException(" Wrong size of data tag, expected size=" + this.data.size() + ", but real size=" + this.dataIndex);
            }
        }
        catch (SAXException saxe) {
            throw new SAXException(THIS_CLASS + saxe.getMessage());
        }
        catch (IllegalParameterValueException e) {
            throw new SAXException(" Illegal Parameter Value. Original Exception message : " + (Object)((Object)e));
        }
        catch (IndexOutOfBoundsException e) {
            throw new SAXException(" Index Out of bounds. Original Exception message : " + e);
        }
        finally {
            this.flushData();
        }
        logger.traceReturn(THIS_CLASS, "handleData()");
    }

    private void flushData() {
        this.rawData = new StringBuffer();
        this.attributeStack.clear();
        this.complexList.clear();
        this.data.clear();
        this.withinData = false;
        this.dataIndex = 0;
        this.typeIndex = 0;
    }

    private Parameter getAttr() throws SAXException {
        AttrParameter currentElement = (AttrParameter)((Object)this.complexList.get(this.typeIndex));
        return this.getAttr(currentElement.getName(), currentElement.getType());
    }

    private Parameter getAttr(String attrName, String attrType) throws SAXException {
        return this.getAttr(attrName, attrType, (String)this.data.get(this.dataIndex++));
    }

    private Parameter getAttr(String attrName, String attrType, String attrData) throws SAXException {
        logger.traceDebug(THIS_CLASS, "AttrParameter: " + attrData + " ; " + attrType);
        try {
            if (attrType.equalsIgnoreCase(U32)) {
                return new UnsignedIntParameter(attrName == null ? U32 : attrName, (long)Integer.parseInt(attrData));
            }
            if (attrType.equalsIgnoreCase(S32)) {
                return new SignedIntParameter(attrName == null ? S32 : attrName, Integer.parseInt(attrData));
            }
            if (attrType.equalsIgnoreCase(S64)) {
                return new LongParameter(attrName == null ? S64 : attrName, Long.parseLong(attrData));
            }
            if (attrType.equalsIgnoreCase(STRING)) {
                return new StringParameter(attrName == null ? STRING : attrName, attrData);
            }
            throw new SAXException("Illegal Parameter Type: " + attrType);
        }
        catch (NumberFormatException e) {
            throw new SAXException("Wrong number format. Original Exception message: " + e);
        }
        catch (IllegalParameterValueException e) {
            throw new SAXException("Illegal Parameter Value. Original Exception message: " + (Object)((Object)e));
        }
    }

    private Parameter getStrct() throws IndexOutOfBoundsException, SAXException, IllegalParameterValueException {
        StructParameter parent = (StructParameter)this.complexList.get(this.typeIndex);
        return this.getStrct(parent);
    }

    private Parameter getStrct(StructParameter result) throws IndexOutOfBoundsException, SAXException, IllegalParameterValueException {
        String msg = "getStruct()";
        logger.traceEnter(THIS_CLASS, "getStruct()");
        do {
            ++this.typeIndex;
            Parameter currentElement = (Parameter)this.complexList.get(this.typeIndex);
            if (currentElement instanceof AttrParameter) {
                result.add(this.getAttr());
                continue;
            }
            if (currentElement instanceof SeqParameter) {
                result.add((Parameter)((ArrayParameter)this.getSeq()));
                continue;
            }
            if (!(currentElement instanceof MoRefParameter)) continue;
            result.add((Parameter)((MoRefParameter)this.getMoRef()));
        } while (this.typeIndex < this.complexList.size() - 1);
        logger.traceReturn(THIS_CLASS, "getStruct()");
        return result;
    }

    private Parameter getSeq() throws IndexOutOfBoundsException, SAXException, IllegalParameterValueException {
        String msg = "getSeq()";
        logger.traceEnter(THIS_CLASS, "getSeq()");
        int size = Integer.parseInt((String)this.data.get(this.dataIndex++));
        String attrName = ((SeqParameter)((Object)this.complexList.get(this.typeIndex))).getName();
        String attrType = ((SeqParameter)((Object)this.complexList.get(this.typeIndex))).getType();
        if (attrType.equals(SEQ)) {
            ++this.typeIndex;
        }
        int startingIndex = this.typeIndex;
        ArrayParameter result = new ArrayParameter(attrName);
        for (int i = 0; i < size; ++i) {
            Object parent;
            if (attrType.equals(STRCT)) {
                parent = new StructParameter(STRCT);
                this.typeIndex = startingIndex;
                result.add((Parameter)((StructParameter)this.getStrct((StructParameter)parent)));
                continue;
            }
            if (attrType.equals(MOREF)) {
                parent = new MoRefParameter(MOREF);
                this.typeIndex = startingIndex;
                result.add((Parameter)((MoRefParameter)this.getMoRef((MoRefParameter)((Object)parent))));
                continue;
            }
            if (attrType.equals(SEQ)) {
                result.add((Parameter)((ArrayParameter)this.getSeq()));
                this.typeIndex = startingIndex;
                continue;
            }
            result.add(this.getAttr(null, attrType));
        }
        ++this.typeIndex;
        logger.traceReturn(THIS_CLASS, "getSeq()");
        return result;
    }

    private Parameter getMoRef() throws IllegalParameterValueException {
        MoRefParameter parent = (MoRefParameter)((Object)this.complexList.get(this.typeIndex));
        return this.getMoRef(parent);
    }

    private Parameter getMoRef(MoRefParameter moRefParameter) throws IllegalParameterValueException {
        String msg = "getMoRef()";
        logger.traceEnter(THIS_CLASS, "getMoRef()");
        String ldn = (String)this.data.get(this.dataIndex++);
        String froType = (String)this.data.get(this.dataIndex++);
        String froId = this.data.size() == this.dataIndex ? "" : (String)this.data.get(this.dataIndex++);
        String debugMsg = "MoRefParameter: " + moRefParameter.getName();
        if (!ldn.equals("")) {
            debugMsg = debugMsg + " ; ldn: " + ldn;
            moRefParameter.setLdn(ldn);
            if (!froType.equals("") && !froId.equals("")) {
                debugMsg = debugMsg + " ; froType: " + froType + "  ; froId: " + froId;
                moRefParameter.setFroType(Integer.parseInt(froType));
                moRefParameter.setFroId(Integer.parseInt(froId));
            }
        } else if (!froType.equals("") && !froId.equals("")) {
            debugMsg = debugMsg + " ; froType: " + froType + "  ; froId: " + froId;
            moRefParameter.setFroType(Integer.parseInt(froType));
            moRefParameter.setFroId(Integer.parseInt(froId));
        } else {
            throw new IllegalParameterValueException("Illegal parameters of MoRef");
        }
        logger.traceDebug(THIS_CLASS, debugMsg);
        logger.traceReturn(THIS_CLASS, "getMoRef()");
        return moRefParameter;
    }

    private List split(String input) {
        ArrayList<String> result = new ArrayList<String>();
        if (input.length() == 0) {
            result.add("");
            return result;
        }
        int start = 0;
        for (int i = 0; i < input.length(); ++i) {
            if (input.charAt(i) != ',' || i > 0 && input.charAt(i - 1) == '\\') continue;
            result.add(this.replaceAll(this.replaceAll(input.substring(start, i), "\\,", ","), "\\\\", "\\"));
            start = i + 1;
        }
        if (start < input.length()) {
            result.add(this.replaceAll(this.replaceAll(input.substring(start, input.length()), "\\,", ","), "\\\\", "\\"));
        }
        return result;
    }

    private String replaceAll(String inputString, String findWhat, String replaceTo) {
        int idx;
        int start = 0;
        StringBuffer sb = new StringBuffer();
        do {
            if ((idx = inputString.indexOf(findWhat, start)) == -1) continue;
            sb.append(inputString.substring(start, idx));
            sb.append(replaceTo);
            start = idx + findWhat.length();
        } while (idx != -1);
        sb.append(inputString.substring(start, inputString.length()));
        String result = sb.toString();
        return result;
    }

    protected class SeqParameter
    extends ArrayParameter {
        protected String type;

        public SeqParameter(String name, String type) {
            super(name);
            this.type = type;
        }

        public String getType() {
            return this.type;
        }
    }

    protected class AttrParameter
    extends Parameter {
        protected String type;

        public AttrParameter(String name, String type) {
            super(name);
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        public void accept(ParameterVisitor arg0) throws Exception {
        }

        public String getValueAsString() {
            return this.getName();
        }
    }

    protected class EndParameter
    extends Parameter {
        protected Parameter startingElement;

        public EndParameter(Parameter element) {
            super("EndOf: " + element.getName());
            this.startingElement = element;
        }

        public Parameter getParameter() {
            return this.startingElement;
        }

        public void accept(ParameterVisitor arg0) throws Exception {
        }

        public String getValueAsString() {
            return "EndParameter: " + this.startingElement.getValueAsString();
        }
    }
}

