/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.mao.indications;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListResourceBundle;
import java.util.Map;
import java.util.ResourceBundle;
import se.ericsson.cello.ConstDefs.EventTypeValue;
import se.ericsson.cello.ConstDefs.PerceivedSeverityValue;
import se.ericsson.cello.ConstDefs.PerceivedSeverityValueOperations;
import se.ericsson.cello.ConstDefs.ProbableCauseValue;
import se.ericsson.cello.ConstDefs.ProbableCauseValueOperations;
import se.ericsson.cello.faultmanagement.AdditionalInfo;
import se.ericsson.cello.faultmanagement.AlarmDuplicatedException;
import se.ericsson.cello.faultmanagement.AlarmManager;
import se.ericsson.cello.maofro.framework.IllegalParameterValueException;
import se.ericsson.cello.maofro.framework.Parameter;
import se.ericsson.cello.maofro.framework.StringParameter;
import se.ericsson.cello.maofro.proxy.TagNameDictionaries;
import se.ericsson.cello.maofro.proxy.TagNameDictionaryException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.Resource;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.ProcessingFailureException;
import se.ericsson.crbs.omf.mao.commonmo.metadata.finder.MoMetaDataFinder;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.genericmo.attributes.manager.ParameterConverter;
import se.ericsson.crbs.omf.mao.genericmo.xml.XmlPack;
import se.ericsson.crbs.omf.mao.genericmo.xml.XmlPackImpl;
import se.ericsson.crbs.omf.mao.indications.ExternalAlarmEventType;
import se.ericsson.crbs.omf.mao.indications.FaultHandler;
import se.ericsson.crbs.omf.mao.indications.FmEventSender;
import se.ericsson.crbs.omf.mao.indications.MaoFroAlarmObject;
import se.ericsson.crbs.omf.mao.indications.wrappers.AlarmWrapper;
import se.ericsson.crbs.omf.mao.indications.wrappers.MaoFroGenericFaultCeasedIndWrapper;
import se.ericsson.crbs.omf.mao.indications.wrappers.MaoFroGenericFaultIndWrapper;

public class FaultHandlerImpl
implements FaultHandler,
Resource {
    private static final String EXTERNAL_ALARM_DEFAULT_PERCEIVED_SEVERITY = "MINOR";
    private static final String EXTERNAL_ALARM_DEFAULT_PROBABLE_CAUSE = "EXTERNAL_EQUIPMENT_FAILURE";
    private static final String EXTERNAL_ALARM_DEFAULT_EVENT_TYPE = "UNKNOWN_EVENT_TYPE";
    private static final String EXTERNAL_ALARM_DEFAULT_ALARM_SLOGAN = "ExternalAlarm";
    private static final String EXTERNAL_ALARM_CLASSIFICATION = "EXTERNAL";
    private static final String EXTERNAL_ALARM_SPECIFIC_PROBLEM = "ExternalAlarm";
    private static final Class THIS_CLASS = FaultHandlerImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());
    private static final String ALARM_PORT = "AlarmPort";
    private static final String ALARM_SLOGAN = "alarmSlogan";
    private static final String PERCEIVED_SEVERITY = "perceivedSeverity";
    private static final String PROBABLE_CAUSE = "probableCause";
    private static final String ACTIVE_EXTERNAL_ALARM = "activeExternalAlarm";
    private static final String SEVERITY_MINOR = "MINOR";
    private static final String SEVERITY_LOW = "LOW";
    private static final String SEVERITY_MAJOR = "MAJOR";
    private static final String SEVERITY_HIGH = "HIGH";
    private static final String SEVERITY = "severity";
    private static final String EVENT_ID = "eventId";
    private static final String ADDITIONAL_DATA = "additionalData";
    private static final String FAULT_DESCRIPTION = "faultDescription";
    private static final String DATA = "data";
    private static final String FAULT_ID = "faultId";
    private static final String FM_EVENT = "FM_EVENT";
    private static final ListResourceBundle BUNDLE = new ListResourceBundle(){
        final Object[][] CONTENTS = new Object[][]{{"data", "21"}};

        protected Object[][] getContents() {
            return this.CONTENTS;
        }
    };
    private final ParameterConverter paramConv;
    private final XmlPack xmlPack;
    private final List alarmTable = new ArrayList();
    private final GenericMaoContext genericMaoContext;
    private MoMetaDataFinder finder;

    public FaultHandlerImpl(GenericMaoContext aGenericMaoContext) {
        this.paramConv = new ParameterConverter();
        this.genericMaoContext = aGenericMaoContext;
        this.xmlPack = this.genericMaoContext.getXmlPackFactory().getXmlPack();
    }

    public synchronized void handleFault(MaoFroGenericFaultIndWrapper sig, ManagedObject fMo, String serviceName, String eventTime) {
        MaoFroAlarmObject faultInfo = null;
        try {
            String ldn;
            AlarmWrapper anAlarm;
            faultInfo = this.getFaultInfo(sig, fMo);
            if (faultInfo == null) {
                logger.traceReturn(THIS_CLASS, "addAlarm()");
                return;
            }
            if (this.xmlPack instanceof XmlPackImpl) {
                this.convertFaultInfo(fMo, faultInfo);
            }
            if ((anAlarm = this.getAlarmWrapper(faultInfo.specificProblem, ldn = fMo.getLocalDistinguishedName())) == null) {
                AdditionalInfo[] additionalInfoList = this.getAdditionalInfo(faultInfo);
                if (FM_EVENT.equalsIgnoreCase(faultInfo.perceivedSeverity)) {
                    String msg = "Create FM event; moType = " + fMo.getType() + ", moFullDistinguishedName = " + fMo.getFullDistinguishedName() + ", eventType = " + faultInfo.eventType + ", eventTime = " + eventTime + ", specificEvent = " + faultInfo.specificProblem + ", additionalText = " + faultInfo.additionalText + ", additionalInfo = " + additionalInfoList + ", froType = " + sig.getFroType();
                    logger.traceGeneral(THIS_CLASS, msg);
                    FmEventSender.create(fMo.getType(), fMo.getFullDistinguishedName(), faultInfo.eventType, eventTime, faultInfo.specificProblem, faultInfo.additionalText, additionalInfoList);
                } else {
                    int[] eventIds = new int[]{faultInfo.eventId};
                    String msg = "Create alarm; moType = " + fMo.getType() + ", moFullDistinguishedName = " + fMo.getFullDistinguishedName() + ", alarmEventType = " + faultInfo.eventType + ", eventTime = " + eventTime + ", probableCause = " + faultInfo.probableCause + ", perceivedSeverity = " + faultInfo.perceivedSeverity + ", specificProblem = " + faultInfo.specificProblem + ", additionalText = " + faultInfo.additionalText + ", additionalInfo = " + additionalInfoList + ", eventIds = " + eventIds + ", secondaryAlarm = " + faultInfo.secondaryAlarm + ", serviceName = " + serviceName + ", froType = " + sig.getFroType();
                    logger.traceGeneral(THIS_CLASS, msg);
                    logger.traceGeneral(THIS_CLASS, "handleFault()  id=" + faultInfo.eventId + "  mo=" + fMo.getFullDistinguishedName());
                    logger.traceGeneral(THIS_CLASS, "handleFault() serviceName = " + serviceName + " specificProblem=" + faultInfo.specificProblem);
                    AlarmWrapper alarm = this.genericMaoContext.getAlarmWrapperFactory().create(fMo.getType(), fMo.getFullDistinguishedName(), faultInfo.eventType, eventTime, faultInfo.probableCause, faultInfo.perceivedSeverity, faultInfo.specificProblem, faultInfo.additionalText, additionalInfoList, eventIds, faultInfo.secondaryAlarm);
                    AlarmRecord alarmRecord = new AlarmRecord(faultInfo.specificProblem, fMo.getLocalDistinguishedName(), alarm, serviceName, faultInfo.faultId, fMo);
                    this.alarmTable.add(alarmRecord);
                }
            } else {
                this.setPerceivedSeverityIfNeeded(faultInfo.perceivedSeverity, anAlarm);
                this.setAdditionalTextIfNeeded(faultInfo.additionalText, anAlarm);
                this.setAdditionalInfoIfNeeded(this.getAdditionalInfo(faultInfo), anAlarm);
                logger.traceGeneral(THIS_CLASS, "The alarm with specific problem: " + faultInfo.specificProblem + " and froType: " + sig.getFroType() + " to ManagedObject: " + fMo.getFullDistinguishedName() + " is already active and was not sent to alarm service. alarm has been updated " + "with new perceivedSeverity, additionalText, and/or additionalInfo if needed.");
            }
        }
        catch (AlarmDuplicatedException e) {
            logger.traceError(fMo.getClass(), "The alarm with specific problem: " + faultInfo.specificProblem + " and froType: " + sig.getFroType() + " to fMo: " + fMo.getFullDistinguishedName() + " is already sent to alarm service", e);
        }
        catch (ProcessingFailureException e) {
            logger.traceError(fMo.getClass(), "Can not get alarm info for MO: " + fMo.getFullDistinguishedName() + " with froType: " + sig.getFroType(), (Throwable)((Object)e));
        }
    }

    protected MaoFroAlarmObject getFaultInfo(MaoFroGenericFaultIndWrapper sig, ManagedObject fMo) throws ProcessingFailureException {
        logger.traceEnter(THIS_CLASS, "getFaultInfo()");
        StringParameter froData = null;
        MaoFroAlarmObject faultInfo = null;
        HashMap<String, Object> faultInfoMap = new HashMap<String, Object>();
        try {
            Map parameters = sig.getParameters(TagNameDictionaries.create((ResourceBundle)BUNDLE));
            froData = (StringParameter)parameters.get(DATA);
            Iterator iterator = this.xmlPack.extractAttributes(froData, this.genericMaoContext.getMoMetaDataFinder().getMoData(fMo.getType()).getFroProtocolVersion()).iterator();
            while (iterator.hasNext()) {
                Parameter parameter = (Parameter)iterator.next();
                Object attributeValue = this.paramConv.convertFroParameterToJavaType(fMo.getType(), fMo.getId(), parameter, null, null, null, null);
                faultInfoMap.put(parameter.getName(), attributeValue);
            }
            faultInfo = this.getFaultInfo(sig, fMo, faultInfoMap);
            if (faultInfo == null) {
                logger.traceError(THIS_CLASS, "No alarm, with froType = " + sig.getFroType() + ", and matching faultId = " + faultInfoMap.get(FAULT_ID) + " is defined for MO " + fMo.getType());
            } else {
                String msg = "Fault info: " + faultInfo.toString();
                logger.traceDebug(THIS_CLASS, msg);
            }
        }
        catch (TagNameDictionaryException e) {
            logger.traceError(fMo.getClass(), "Can not get parameters found for MO: " + fMo.toString(), e);
            throw new ProcessingFailureException("Can not get parameters found for MO, " + (Object)((Object)e));
        }
        catch (IllegalParameterValueException e) {
            logger.traceError(fMo.getClass(), "Can not get parameters for MO  " + fMo.toString(), e);
            throw new ProcessingFailureException("Can not get parameters found for MO, " + (Object)((Object)e));
        }
        catch (MoAccessException e) {
            logger.traceError(fMo.getClass(), "Can not get parameters for MO  " + fMo.toString(), e);
            throw new ProcessingFailureException("Can not get parameters found for MO, " + (Object)((Object)e));
        }
        catch (IOException e) {
            logger.traceError(THIS_CLASS, "Could not get the MoMetaDataFinder for the MAO meta data");
            throw new ProcessingFailureException("Can not get parameters found for MO, " + e);
        }
        logger.traceReturn(THIS_CLASS, "getFaultInfo()");
        return faultInfo;
    }

    private MaoFroAlarmObject getFaultInfo(MaoFroGenericFaultIndWrapper sig, ManagedObject fMo, Map faultInfoMap) throws MoAccessException, NoSuchAttributeException, IOException {
        MaoFroAlarmObject localFaultInfo = null;
        if (ALARM_PORT.equals(fMo.getType())) {
            String msg = "The fault with froType = " + sig.getFroType() + " and faultId = " + faultInfoMap.get(FAULT_ID) + " is an external fault";
            logger.traceDebug(THIS_CLASS, msg);
            localFaultInfo = this.getExternalFaultInfo(fMo, faultInfoMap);
        } else {
            String msg = "The fault with froType = " + sig.getFroType() + " and faultId = " + faultInfoMap.get(FAULT_ID) + " is an internal fault";
            logger.traceDebug(THIS_CLASS, msg);
            try {
                MaoFroAlarmObject faultInfoToClone = this.getMoMetaDataFinder().getMoData(fMo.getType()).getAlarm((Integer)faultInfoMap.get(FAULT_ID));
                if (faultInfoToClone == null) {
                    localFaultInfo = null;
                } else {
                    localFaultInfo = (MaoFroAlarmObject)faultInfoToClone.clone();
                    localFaultInfo.additionalText = (String)faultInfoMap.get(FAULT_DESCRIPTION);
                    String severity = (String)faultInfoMap.get(SEVERITY);
                    if (severity != null) {
                        this.setSeverity(localFaultInfo, severity);
                    }
                }
            }
            catch (CloneNotSupportedException e) {
                logger.traceError(THIS_CLASS, e.getMessage());
            }
        }
        if (localFaultInfo != null) {
            localFaultInfo.additionalInfo = null;
            if (faultInfoMap.get(ADDITIONAL_DATA) instanceof String[]) {
                localFaultInfo.additionalInfo = (String[])faultInfoMap.get(ADDITIONAL_DATA);
            }
            localFaultInfo.eventId = (Integer)faultInfoMap.get(EVENT_ID);
        }
        return localFaultInfo;
    }

    private MaoFroAlarmObject getExternalFaultInfo(ManagedObject fMo, Map faultInfoMap) throws MoAccessException, NoSuchAttributeException {
        MaoFroAlarmObject localFaultInfo = null;
        String msg = "Check for an external fault";
        logger.traceDebug(THIS_CLASS, "Check for an external fault");
        Boolean externalFaultHasBeenSent = Boolean.FALSE;
        Object objectToCast = fMo.getAttribute(ACTIVE_EXTERNAL_ALARM, null);
        if (objectToCast instanceof Boolean) {
            externalFaultHasBeenSent = (Boolean)objectToCast;
        } else {
            String debMsg0 = "Couldn't cast " + objectToCast + " to boolean";
            logger.traceDebug(THIS_CLASS, debMsg0);
        }
        if (externalFaultHasBeenSent == null) {
            String debMsg = "External fault has not been sent";
            logger.traceDebug(THIS_CLASS, "External fault has not been sent");
        } else {
            String debMsg1;
            MaoFroAlarmObject externalFault;
            String[] attributes = new String[]{PROBABLE_CAUSE, PERCEIVED_SEVERITY, ALARM_SLOGAN};
            Object[] attributeObjects = fMo.getAttributes(attributes, null);
            List<String> attributeNames = Arrays.asList(attributes);
            String probableCauseString = this.getProbableCauseString(fMo, attributeObjects, attributeNames);
            String perceivedSeverityString = this.getPerceivedSeverityString(fMo, attributeObjects, attributeNames);
            String alarmSloganString = this.getAlarmSloganString(attributeObjects, attributeNames);
            String eventTypeString = this.getEventTypeString(probableCauseString);
            if (externalFaultHasBeenSent.booleanValue()) {
                externalFault = new MaoFroAlarmObject((Integer)faultInfoMap.get(FAULT_ID), eventTypeString, probableCauseString, perceivedSeverityString, "ExternalAlarm", alarmSloganString, null, 0, false, EXTERNAL_ALARM_CLASSIFICATION);
                debMsg1 = "External fault has been sent";
            } else {
                externalFault = new MaoFroAlarmObject((Integer)faultInfoMap.get(FAULT_ID), eventTypeString, probableCauseString, perceivedSeverityString, "InconsistentConfiguration", alarmSloganString, null, 0, false, EXTERNAL_ALARM_CLASSIFICATION);
                debMsg1 = "InconsistentConfiguration fault has been sent";
            }
            localFaultInfo = externalFault;
            logger.traceDebug(THIS_CLASS, debMsg1);
        }
        return localFaultInfo;
    }

    protected AdditionalInfo[] getAdditionalInfo(MaoFroAlarmObject faultInfo) {
        ArrayList<AdditionalInfo> list = new ArrayList<AdditionalInfo>();
        if (faultInfo.additionalInfo != null) {
            for (int i = 0; i < faultInfo.additionalInfo.length; ++i) {
                String nvPair = faultInfo.additionalInfo[i];
                if (nvPair == null) continue;
                int index = nvPair.indexOf(61);
                if (index == -1) {
                    if ("".equals(nvPair)) continue;
                    logger.traceAbnormal(THIS_CLASS, "additional info: \"" + nvPair + "\" skipped due to incorrect format.");
                    continue;
                }
                String name = nvPair.substring(0, index);
                String value = nvPair.substring(index + 1);
                list.add(new AdditionalInfo(name, value));
            }
        }
        return list.toArray(new AdditionalInfo[list.size()]);
    }

    private void convertFaultInfo(ManagedObject fMo, MaoFroAlarmObject faultInfo) throws ProcessingFailureException {
        logger.traceEnter(THIS_CLASS, "convertFaultInfo()");
        try {
            String eventTypeIdentifier = faultInfo.eventType;
            faultInfo.eventType = (String)EventTypeValue.class.getField(eventTypeIdentifier).get(null);
            String probableCauseIdentifier = faultInfo.probableCause;
            faultInfo.probableCause = (String)ProbableCauseValue.class.getField(probableCauseIdentifier).get(null);
            String perceivedSeverityIdentifier = faultInfo.perceivedSeverity;
            if (!perceivedSeverityIdentifier.equalsIgnoreCase(FM_EVENT)) {
                faultInfo.perceivedSeverity = (String)PerceivedSeverityValue.class.getField(perceivedSeverityIdentifier).get(null);
            }
        }
        catch (NoSuchFieldException e) {
            logger.traceError(fMo.getClass(), "Can not get fault info parameters for " + fMo.toString(), e);
            throw new ProcessingFailureException("Can not get parameters found for MO, " + e);
        }
        catch (IllegalAccessException e) {
            logger.traceError(fMo.getClass(), "Can not get fault info parameters for " + fMo.toString(), e);
            throw new ProcessingFailureException("Can not get parameters found for MO, " + e);
        }
        logger.traceReturn(THIS_CLASS, "convertFaultInfo()");
    }

    private String getEventTypeString(String probableCauseString) {
        ExternalAlarmEventType event = new ExternalAlarmEventType();
        String eventType = event.getEventType(probableCauseString);
        if (eventType == null) {
            eventType = EXTERNAL_ALARM_DEFAULT_EVENT_TYPE;
            String debMsg2 = "Couldn't get any event type mapping to probable cause " + probableCauseString + ", set event type to " + EXTERNAL_ALARM_DEFAULT_EVENT_TYPE + " as default";
            logger.traceDebug(THIS_CLASS, debMsg2);
        }
        return eventType;
    }

    private String getAlarmSloganString(Object[] attributeObjects, List attributesNames) {
        String alarmSlogan = "ExternalAlarm";
        int alarmSloganIndex = attributesNames.indexOf(ALARM_SLOGAN);
        if (alarmSloganIndex > -1 && alarmSloganIndex < attributeObjects.length) {
            Object fetchedAlarmSloganFromAttr = attributeObjects[alarmSloganIndex];
            if (fetchedAlarmSloganFromAttr instanceof String) {
                alarmSlogan = (String)fetchedAlarmSloganFromAttr;
            } else {
                String debMsg2 = "Failed to cast object " + fetchedAlarmSloganFromAttr + " to String and couldn't get alarm slogan, set alarm slogan to " + "ExternalAlarm" + " as default";
                logger.traceDebug(THIS_CLASS, debMsg2);
            }
        } else {
            String debMsg2 = "Failed to fetch index of attribute, set alarm slogan to ExternalAlarm as default";
            logger.traceDebug(THIS_CLASS, "Failed to fetch index of attribute, set alarm slogan to ExternalAlarm as default");
        }
        return alarmSlogan;
    }

    private String getPerceivedSeverityString(ManagedObject fMo, Object[] attributeObjects, List attributesNames) {
        String perceivedSeverityString = "MINOR";
        int precSevIndex = attributesNames.indexOf(PERCEIVED_SEVERITY);
        if (precSevIndex > -1 && precSevIndex < attributeObjects.length) {
            Object fetchedperceivedSeverityIntFromAttr = attributeObjects[precSevIndex];
            if (fetchedperceivedSeverityIntFromAttr instanceof Integer) {
                Integer perceivedSeverityInt = (Integer)fetchedperceivedSeverityIntFromAttr;
                perceivedSeverityString = this.getValueOperations(PERCEIVED_SEVERITY, perceivedSeverityInt);
                if (perceivedSeverityString == null) {
                    perceivedSeverityString = "MINOR";
                    String debMsg2 = "Couldn't find any perceived severity for Mo " + fMo + ", set perceived severity to " + "MINOR" + " as default";
                    logger.traceDebug(THIS_CLASS, debMsg2);
                }
            } else {
                String debMsg2 = "Failed to cast object " + fetchedperceivedSeverityIntFromAttr + " to Integer and couldn't get perceived severity" + ", set perceived severity to " + "MINOR" + " as default";
                logger.traceDebug(THIS_CLASS, debMsg2);
            }
        } else {
            String debMsg2 = "Failed to fetch index of attribute, set perceived severity to MINOR as default";
            logger.traceDebug(THIS_CLASS, "Failed to fetch index of attribute, set perceived severity to MINOR as default");
        }
        return perceivedSeverityString;
    }

    private String getProbableCauseString(ManagedObject aMo, Object[] attributeObjects, List attributesNames) {
        String probableCauseString = EXTERNAL_ALARM_DEFAULT_PROBABLE_CAUSE;
        int probCauseIndex = attributesNames.indexOf(PROBABLE_CAUSE);
        if (probCauseIndex > -1 && probCauseIndex < attributeObjects.length) {
            Object fetchedprobableCauseIntFromAttr = attributeObjects[probCauseIndex];
            if (fetchedprobableCauseIntFromAttr instanceof Integer) {
                Integer probableCauseInt = (Integer)fetchedprobableCauseIntFromAttr;
                probableCauseString = this.getValueOperations(PROBABLE_CAUSE, probableCauseInt);
                if (probableCauseString == null) {
                    probableCauseString = EXTERNAL_ALARM_DEFAULT_PROBABLE_CAUSE;
                    String debMsg2 = "Couldn't find any probable cause for Mo " + aMo + ", set probable cause to " + EXTERNAL_ALARM_DEFAULT_PROBABLE_CAUSE + " as default";
                    logger.traceDebug(THIS_CLASS, debMsg2);
                }
            } else {
                String debMsg2 = "Failed to cast object " + fetchedprobableCauseIntFromAttr + " to Integer and couldn't get probable cause, set probable cause to " + EXTERNAL_ALARM_DEFAULT_PROBABLE_CAUSE + " as default";
                logger.traceDebug(THIS_CLASS, debMsg2);
            }
        } else {
            String debMsg2 = "Failed to fetch index of attribute, set probable cause to EXTERNAL_EQUIPMENT_FAILURE as default";
            logger.traceDebug(THIS_CLASS, "Failed to fetch index of attribute, set probable cause to EXTERNAL_EQUIPMENT_FAILURE as default");
        }
        return probableCauseString;
    }

    private String getValueOperations(String valueOperation, int value) {
        Field[] fields = null;
        String valueOperationName = "Unknown";
        if (valueOperation.equals(PROBABLE_CAUSE)) {
            ProbableCauseValueOperations probableCauseValueOperationsClass = new ProbableCauseValueOperations(){};
            fields = probableCauseValueOperationsClass.getClass().getFields();
            valueOperationName = "probable cause";
        } else if (valueOperation.equals(PERCEIVED_SEVERITY)) {
            PerceivedSeverityValueOperations perceivedSeverityOperationsClass = new PerceivedSeverityValueOperations(){};
            fields = perceivedSeverityOperationsClass.getClass().getFields();
            valueOperationName = "perceived severity";
        }
        String valueOperationReturn = null;
        for (int i = 0; i < fields.length; ++i) {
            String debMsg;
            try {
                Object stringObject = fields[i].get(null);
                if (stringObject instanceof String) {
                    String currentString = (String)stringObject;
                    int currentInt = Integer.parseInt(currentString);
                    if (currentInt != value) continue;
                    valueOperationReturn = fields[i].getName();
                    break;
                }
                debMsg = "Failed to cast object " + stringObject + " to String";
                logger.traceDebug(THIS_CLASS, debMsg);
                continue;
            }
            catch (IllegalArgumentException e) {
                debMsg = "Failed to get " + valueOperationName + " with value " + value + ", " + e.getMessage();
                logger.traceDebug(THIS_CLASS, debMsg);
                continue;
            }
            catch (IllegalAccessException e) {
                debMsg = "Failed to get " + valueOperationName + " with value " + value + ", " + e.getMessage();
                logger.traceDebug(THIS_CLASS, debMsg);
            }
        }
        return valueOperationReturn;
    }

    private void setSeverity(MaoFroAlarmObject alarmInfo, String severity) {
        alarmInfo.perceivedSeverity = SEVERITY_HIGH.equalsIgnoreCase(severity) ? SEVERITY_MAJOR : (SEVERITY_LOW.equalsIgnoreCase(severity) ? "MINOR" : severity);
    }

    public synchronized void clearAlarm(MaoFroGenericFaultCeasedIndWrapper sig, ManagedObject aMo) {
        logger.traceEnter(THIS_CLASS, "clearAlarm()");
        try {
            boolean foundInRecord = false;
            MaoFroAlarmObject alarmInfo = this.getAlarmInfo(sig, aMo);
            if (alarmInfo == null) {
                logger.traceReturn(THIS_CLASS, "clearAlarm()");
                return;
            }
            for (int i = 0; i < this.alarmTable.size(); ++i) {
                AlarmRecord alarmRecord = (AlarmRecord)this.alarmTable.get(i);
                if (!alarmRecord.getLdn().equals(aMo.getLocalDistinguishedName()) || !alarmRecord.getMo().getType().equals(ALARM_PORT) && !alarmRecord.getSpecificProblem().equals(alarmInfo.specificProblem)) continue;
                alarmRecord.getAlarm().clear();
                this.alarmTable.remove(i);
                foundInRecord = true;
                break;
            }
            if (!foundInRecord) {
                if (aMo.isRemoved()) {
                    logger.traceAbnormal(THIS_CLASS, "An attempt to cease an alarm with froType = " + sig.getFroType() + " and specificProblem = " + alarmInfo.specificProblem + " failed, because MO " + aMo.getLocalDistinguishedName() + " was already deleted.");
                } else if (alarmInfo.faultId != 273 && alarmInfo.faultId != 1291) {
                    logger.traceError(THIS_CLASS, "An attempt to cease an alarm with froType = " + sig.getFroType() + " and specificProblem = " + alarmInfo.specificProblem + " failed, because no such alarm was raised.");
                }
            }
        }
        catch (ProcessingFailureException e) {
            logger.traceError(aMo.getClass(), "Can not get alarm info for MO: " + aMo.getFullDistinguishedName() + " with froType: " + sig.getFroType(), (Throwable)((Object)e));
        }
        logger.traceReturn(THIS_CLASS, "clearAlarm()");
    }

    public void clearAllAlarms(Coordinator coordinator) {
        logger.traceEnter(THIS_CLASS, "clearAllAlarms()");
        try {
            coordinator.registerResource((Resource)this);
        }
        catch (InactiveTransactionException e) {
            this.rollback();
        }
        logger.traceReturn(THIS_CLASS, "clearAllAlarms()");
    }

    public synchronized void clearAllAlarms(String serviceName) {
        logger.traceEnter(THIS_CLASS, "clearAllAlarms()");
        logger.traceGeneral(THIS_CLASS, "clearAllAlarms() alarmList.size()=" + this.alarmTable.size() + "  serviceName=" + serviceName);
        Iterator iter = this.alarmTable.iterator();
        AlarmWrapper alarm = null;
        AlarmRecord alarmRecord = null;
        while (iter.hasNext()) {
            alarmRecord = (AlarmRecord)iter.next();
            logger.traceGeneral(THIS_CLASS, "clearAllAlarms() alarmRecord.getServiceName()=" + alarmRecord.getServiceName() + " SpecificProblem=" + alarmRecord.getSpecificProblem() + " ldn=" + alarmRecord.getLdn());
            if (!alarmRecord.getServiceName().equals(serviceName)) continue;
            int faultId = alarmRecord.getFaultId();
            ManagedObject fMo = alarmRecord.getMo();
            logger.traceGeneral(THIS_CLASS, "clearAllAlarms() faultId=" + faultId + "  mo=" + fMo.getLocalDistinguishedName());
            if (AlarmManager.getReporter() != null) {
                AlarmManager.getReporter().ceaseAlarm(faultId, fMo);
                logger.traceGeneral(THIS_CLASS, "cleared in Cello faultId=" + faultId + "  mo=" + fMo.getLocalDistinguishedName());
            }
            alarm = alarmRecord.getAlarm();
            alarm.clear();
        }
        this.alarmTable.clear();
        logger.traceReturn(THIS_CLASS, "clearAllAlarms()");
    }

    public synchronized void commit() {
        logger.traceEnter(THIS_CLASS, "commit()");
        for (int i = 0; i < this.alarmTable.size(); ++i) {
            ((AlarmRecord)this.alarmTable.get(i)).getAlarm().clear();
        }
        this.alarmTable.clear();
        logger.traceReturn(THIS_CLASS, "commit()");
    }

    public boolean doAlarmExist(int faultId, ManagedObject mo, String specificProblem, String serviceName) {
        boolean result = false;
        for (int i = 0; i < this.alarmTable.size(); ++i) {
            AlarmRecord alarmRecord = (AlarmRecord)this.alarmTable.get(i);
            if (alarmRecord.getFaultId() != faultId || alarmRecord.getMo() != mo || alarmRecord.getLdn() != mo.getLocalDistinguishedName() || alarmRecord.getSpecificProblem() != specificProblem || alarmRecord.getServiceName() != serviceName) continue;
            result = true;
            break;
        }
        return result;
    }

    public boolean hasAlarm(ManagedObject mo) {
        boolean result = false;
        for (int i = 0; i < this.alarmTable.size(); ++i) {
            AlarmRecord alarmRecord = (AlarmRecord)this.alarmTable.get(i);
            if (alarmRecord.getMo() != mo) continue;
            result = true;
            break;
        }
        return result;
    }

    synchronized AlarmWrapper getAlarmWrapper(String specificProblem, String ldn) {
        logger.traceEnter(THIS_CLASS, "getAlarm()");
        AlarmWrapper alarmWrapper = null;
        for (int i = 0; i < this.alarmTable.size(); ++i) {
            if (!((AlarmRecord)this.alarmTable.get(i)).getLdn().equals(ldn) || !((AlarmRecord)this.alarmTable.get(i)).getSpecificProblem().equals(specificProblem)) continue;
            alarmWrapper = ((AlarmRecord)this.alarmTable.get(i)).getAlarm();
            break;
        }
        logger.traceReturn(THIS_CLASS, "getAlarm()");
        return alarmWrapper;
    }

    public MaoFroAlarmObject getAlarmInfo(MaoFroGenericFaultCeasedIndWrapper sig, ManagedObject aMo) throws ProcessingFailureException {
        logger.traceEnter(THIS_CLASS, "getAlarmInfo()");
        MaoFroAlarmObject alarmInfo = null;
        StringParameter froData = null;
        try {
            Map parameters = sig.getParameters(TagNameDictionaries.create((ResourceBundle)BUNDLE));
            froData = (StringParameter)parameters.get(DATA);
            Iterator iterator = this.xmlPack.extractAttributes(froData, this.genericMaoContext.getMoMetaDataFinder().getMoData(aMo.getType()).getFroProtocolVersion()).iterator();
            while (iterator.hasNext()) {
                Parameter parameter = (Parameter)iterator.next();
                if (!parameter.getName().equals(FAULT_ID)) continue;
                Object attributeValue = this.paramConv.convertFroParameterToJavaType(aMo.getType(), aMo.getId(), parameter, null, null, null, null);
                int faultId = (Integer)attributeValue;
                alarmInfo = this.getAlarmInfo(sig, aMo, faultId);
                if (alarmInfo == null) {
                    logger.traceAbnormal(THIS_CLASS, "An attempt to cease an alarm with froType = " + sig.getFroType() + " and faultId = " + faultId + " failed, because no such alarm was raised.");
                }
                break;
            }
        }
        catch (TagNameDictionaryException e) {
            logger.traceError(aMo.getClass(), "Can not get parameters found for MO: " + aMo.toString(), e);
            throw new ProcessingFailureException("Can not get parameters found for MO, " + (Object)((Object)e));
        }
        catch (IllegalParameterValueException e) {
            logger.traceError(aMo.getClass(), "Can not get parameters for MO  " + aMo.toString(), e);
            throw new ProcessingFailureException("Can not get parameters found for MO, " + (Object)((Object)e));
        }
        catch (MoAccessException e) {
            logger.traceError(aMo.getClass(), "Can not get parameters for MO  " + aMo.toString(), e);
            throw new ProcessingFailureException("Can not get parameters found for MO, " + (Object)((Object)e));
        }
        catch (IOException e) {
            logger.traceError(THIS_CLASS, "Could not get the MoMetaDataFinder for the MAO meta data");
        }
        logger.traceReturn(THIS_CLASS, "getAlarmInfo(): ");
        return alarmInfo;
    }

    private MaoFroAlarmObject getAlarmInfo(MaoFroGenericFaultCeasedIndWrapper sig, ManagedObject aMo, int faultId) throws MoAccessException, NoSuchAttributeException, IOException {
        MaoFroAlarmObject localAlarmInfo = null;
        if (ALARM_PORT.equals(aMo.getType())) {
            String msg = "The alarm with froType = " + sig.getFroType() + " and faultId = " + faultId + " is an external alarm";
            logger.traceDebug(THIS_CLASS, msg);
            localAlarmInfo = new MaoFroAlarmObject();
            localAlarmInfo.faultId = faultId;
            localAlarmInfo.specificProblem = "ExternalAlarm";
            localAlarmInfo.additionalText = (String)aMo.getAttribute(ALARM_SLOGAN, null);
        } else {
            String msg = "The alarm with froType = " + sig.getFroType() + " and faultId = " + faultId + " is an internal alarm";
            logger.traceDebug(THIS_CLASS, msg);
            try {
                MaoFroAlarmObject alarmInfoToClone = this.getMoMetaDataFinder().getMoData(aMo.getType()).getAlarm(faultId);
                localAlarmInfo = alarmInfoToClone == null ? null : (MaoFroAlarmObject)alarmInfoToClone.clone();
            }
            catch (CloneNotSupportedException e) {
                logger.traceError(THIS_CLASS, e.getMessage());
            }
        }
        return localAlarmInfo;
    }

    public boolean prepare() {
        return true;
    }

    public void rollback() {
        logger.traceAbnormal(THIS_CLASS, "Rollback due to inactive transaction");
    }

    private MoMetaDataFinder getMoMetaDataFinder() {
        if (this.finder == null) {
            this.finder = this.genericMaoContext.getMoMetaDataFinder();
        }
        return this.finder;
    }

    private void setPerceivedSeverityIfNeeded(String perceivedSeverity, AlarmWrapper alarm) {
        if (alarm.getPerceivedSeverity().equals(perceivedSeverity)) {
            logger.traceGeneral(THIS_CLASS, "PerceivedSeverity is the same as in the already existing alarm, no update will be done");
        } else {
            alarm.setPerceivedSeverity(perceivedSeverity);
        }
    }

    private void setAdditionalTextIfNeeded(String additionalText, AlarmWrapper alarm) {
        if (alarm.getAdditionalText().equals(additionalText)) {
            logger.traceGeneral(THIS_CLASS, "AdditionalText is the same as in the already existing alarm, no update will be done");
        } else {
            alarm.setAdditionalText(additionalText);
        }
    }

    private void setAdditionalInfoIfNeeded(AdditionalInfo[] additionalInfo, AlarmWrapper alarm) {
        if (this.isAdditionalInfoSameAsExisting(additionalInfo, alarm)) {
            logger.traceGeneral(THIS_CLASS, "AdditionalInfo is the same as in the already existing alarm, no update will be done");
        } else {
            alarm.setAdditionalInfo(additionalInfo);
        }
    }

    private boolean isAdditionalInfoSameAsExisting(AdditionalInfo[] additionalInfo, AlarmWrapper alarm) {
        AdditionalInfo[] additionalInfoFromExistingAlarm = alarm.getAdditionalInfo();
        boolean result = true;
        if (additionalInfo.length == additionalInfoFromExistingAlarm.length) {
            for (int i = 0; i < additionalInfo.length; ++i) {
                if (additionalInfo[i].getName().equals(additionalInfoFromExistingAlarm[i].getName()) && additionalInfo[i].getValue().equals(additionalInfoFromExistingAlarm[i].getValue())) continue;
                result = false;
                break;
            }
        } else {
            result = false;
        }
        return result;
    }

    private static class AlarmRecord {
        private final String ldn;
        private final AlarmWrapper alarm;
        private final String specificProblem;
        private final String serviceName;
        private final int faultId;
        private final ManagedObject fMo;

        public AlarmRecord(String specificProblem, String ldn, AlarmWrapper alarm, String serviceName, int faultId, ManagedObject fMo) {
            logger.traceEnter(THIS_CLASS, "AlarmRecord()");
            this.specificProblem = specificProblem;
            this.ldn = ldn;
            this.alarm = alarm;
            this.serviceName = serviceName;
            this.faultId = faultId;
            this.fMo = fMo;
            logger.traceReturn(THIS_CLASS, "AlarmRecord()");
        }

        public AlarmWrapper getAlarm() {
            return this.alarm;
        }

        public String getLdn() {
            return this.ldn;
        }

        public String getSpecificProblem() {
            return this.specificProblem;
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public int getFaultId() {
            return this.faultId;
        }

        public ManagedObject getMo() {
            return this.fMo;
        }
    }
}

