/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.mao.indications.wrappers;

import se.ericsson.cello.faultmanagement.AdditionalInfo;
import se.ericsson.cello.faultmanagement.Alarm;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.indications.wrappers.AlarmWrapper;

public class AlarmWrapperImpl
implements AlarmWrapper {
    private static final AbstractLogger logger = LoggingService.getLogger(AlarmWrapperImpl.class.getName());
    private static final Class THIS_CLASS = AlarmWrapperImpl.class;
    private final Alarm alarm;

    protected AlarmWrapperImpl(Alarm alarm) {
        this.alarm = alarm;
    }

    public void clear() {
        if (this.alarm != null) {
            this.alarm.clear();
        }
    }

    public void setPerceivedSeverity(String perceivedSeverity) {
        logger.traceEnter(THIS_CLASS, "setPerceivedSeverity( " + perceivedSeverity + " )");
        this.alarm.setPerceivedSeverity(perceivedSeverity);
    }

    public void setAdditionalText(String additionalText) {
        logger.traceEnter(THIS_CLASS, "setAdditionalText( " + additionalText + " )");
        this.alarm.setAdditionalText(additionalText);
    }

    public void setAdditionalInfo(AdditionalInfo[] additionalInfo) {
        logger.traceEnter(THIS_CLASS, "SetAdditionalInfo");
        this.alarm.setAdditionalInfo(additionalInfo);
    }

    public String getPerceivedSeverity() {
        return String.valueOf(this.alarm.getPerceivedSeverity());
    }

    public String getAdditionalText() {
        return this.alarm.getAdditionalText();
    }

    public AdditionalInfo[] getAdditionalInfo() {
        return this.alarm.getAdditionalInfoList();
    }
}

