/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.mao.pi;

import se.ericsson.cello.mao.ConvertWeekOfYearToDate;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.productinventory.HardwareProductData;
import se.ericsson.cello.productinventory.ProductRepository;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.mo.GenericManagedObject;
import se.ericsson.crbs.omf.mao.pi.CrbsHardwareProductData;

public class CrbsHardwareProductDataImpl
implements CrbsHardwareProductData {
    private static final String PRODUCT_REVISION = "productRevision";
    private static final String PRODUCT_NUMBER = "productNumber";
    private static final String PRODUCT_NAME = "productName";
    private static final String SERIAL_NUMBER = "serialNumber";
    private static final String PRODUCTION_DATE = "productionDate";
    private static final Class THIS_CLASS = CrbsHardwareProductDataImpl.class;
    private final transient GenericManagedObject genericMao;
    private static AbstractLogger logger = LoggingService.getLogger(CrbsHardwareProductDataImpl.class.getName());
    private ProductData productData = null;

    public CrbsHardwareProductDataImpl(GenericManagedObject genericMao, Coordinator coordinator) {
        logger.traceEnter(THIS_CLASS, "CrbsHardwareProductDataImpl( " + genericMao.getLocalDistinguishedName() + ", coordinator)");
        this.genericMao = genericMao;
        ProductRepository.instance().registerHw((HardwareProductData)this, coordinator);
        logger.traceReturn(THIS_CLASS, "CrbsHardwareProductDataImpl( " + genericMao.getLocalDistinguishedName() + ", coordinator)");
    }

    public CrbsHardwareProductDataImpl(GenericManagedObject genericMao) {
        logger.traceEnter(THIS_CLASS, "CrbsHardwareProductDataImpl( " + genericMao.getLocalDistinguishedName() + ")");
        this.genericMao = genericMao;
        ProductRepository.instance().registerHw((HardwareProductData)this);
        logger.traceReturn(THIS_CLASS, "CrbsHardwareProductDataImpl( " + genericMao.getLocalDistinguishedName() + ")");
    }

    public void delete(Coordinator coordinator) {
        logger.traceEnter(THIS_CLASS, "delete()");
        ProductRepository.instance().deregisterHw((HardwareProductData)this, coordinator);
        logger.traceReturn(THIS_CLASS, "delete()");
    }

    public String getProductionDate(Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "getProductionDate()");
        String productionDate = this.getPid(coordinator, PRODUCTION_DATE);
        if (productionDate.length() != 8) {
            productionDate = ConvertWeekOfYearToDate.WeekOfYearToDate((String)productionDate);
        }
        logger.traceReturn(THIS_CLASS, "getProductionDate(): " + productionDate);
        return productionDate;
    }

    public String getSerialNumber(Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "getSerialNumber()");
        String serialNumber = this.getPid(coordinator, SERIAL_NUMBER);
        logger.traceReturn(THIS_CLASS, "getSerialNumber(): " + serialNumber);
        return serialNumber;
    }

    public int getSlotPosition(Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "getSlotPosition()");
        boolean slotPosistion = false;
        logger.traceReturn(THIS_CLASS, "getSlotPosition(): 0");
        return 0;
    }

    public String getSubrackId(Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "getSubrackId()");
        String subrackId = "";
        logger.traceReturn(THIS_CLASS, "getSubrackId(): ");
        return "";
    }

    public String getProductName(Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "getProductName()");
        String productName = this.getPid(coordinator, PRODUCT_NAME);
        logger.traceReturn(THIS_CLASS, "getProductName(): " + productName);
        return productName;
    }

    public String getProductNumber(Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "getProductNumber()");
        String productNumber = this.getPid(coordinator, PRODUCT_NUMBER);
        logger.traceReturn(THIS_CLASS, "getProductNumber(): " + productNumber);
        return productNumber;
    }

    public String getRState(Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "getRState()");
        String productRevision = this.getPid(coordinator, PRODUCT_REVISION);
        logger.traceReturn(THIS_CLASS, "getRState(): " + productRevision);
        return productRevision;
    }

    private Struct getProductData(Coordinator coordinator) throws MoAccessException {
        Struct productDataAtr;
        logger.traceEnter(THIS_CLASS, "getProductData()");
        try {
            productDataAtr = (Struct)this.genericMao.getAttribute("productData", coordinator);
        }
        catch (MoAccessException e) {
            logger.traceAbnormal(THIS_CLASS, "No attribute with name productData found, try with enclosureProductData instead.");
            productDataAtr = (Struct)this.genericMao.getAttribute("enclosureProductData", coordinator);
        }
        logger.traceReturn(THIS_CLASS, "getProductData(): " + productDataAtr);
        return productDataAtr;
    }

    private String getPid(Coordinator coordinator, String pidName) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "getPid( " + pidName + ")");
        if (this.productData == null || this.productData.getValue(pidName) == null) {
            Struct data = this.getProductData(coordinator);
            this.productData = new ProductData((String)data.getValue(PRODUCTION_DATE), (String)data.getValue(PRODUCT_NAME), (String)data.getValue(PRODUCT_NUMBER), (String)data.getValue(PRODUCT_REVISION), (String)data.getValue(SERIAL_NUMBER));
        }
        String pidValue = new String(this.productData.getValue(pidName));
        this.productData.setValue(pidName, null);
        logger.traceReturn(THIS_CLASS, "getPid( " + pidName + "): " + pidValue);
        return pidValue;
    }

    private class ProductData {
        private String productionDate = null;
        private String productName = null;
        private String productNumber = null;
        private String productRevision = null;
        private String serialNumber = null;

        protected ProductData(String productionDate, String productName, String productNumber, String productRevision, String serialNumber) {
            this.productionDate = productionDate;
            this.productName = productName;
            this.productNumber = productNumber;
            this.productRevision = productRevision;
            this.serialNumber = serialNumber;
        }

        protected String getValue(String name) {
            String value = "";
            if (name.equals(CrbsHardwareProductDataImpl.PRODUCTION_DATE)) {
                value = this.productionDate;
            } else if (name.equals(CrbsHardwareProductDataImpl.PRODUCT_NAME)) {
                value = this.productName;
            } else if (name.equals(CrbsHardwareProductDataImpl.PRODUCT_NUMBER)) {
                value = this.productNumber;
            } else if (name.equals(CrbsHardwareProductDataImpl.PRODUCT_REVISION)) {
                value = this.productRevision;
            } else if (name.equals(CrbsHardwareProductDataImpl.SERIAL_NUMBER)) {
                value = this.serialNumber;
            }
            return value;
        }

        protected void setValue(String name, String value) {
            if (name.equals(CrbsHardwareProductDataImpl.PRODUCTION_DATE)) {
                this.productionDate = value;
            } else if (name.equals(CrbsHardwareProductDataImpl.PRODUCT_NAME)) {
                this.productName = value;
            } else if (name.equals(CrbsHardwareProductDataImpl.PRODUCT_NUMBER)) {
                this.productNumber = value;
            } else if (name.equals(CrbsHardwareProductDataImpl.PRODUCT_REVISION)) {
                this.productRevision = value;
            } else if (name.equals(CrbsHardwareProductDataImpl.SERIAL_NUMBER)) {
                this.serialNumber = value;
            }
        }
    }
}

