/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.aue.step2.actions;

import com.polyhedra.sql.ResultSet;
import com.polyhedra.sql.SQLException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import se.ericsson.cello.aueframework.common.AueException;
import se.ericsson.cello.aueframework.converter.ConverterContext;
import se.ericsson.cello.aueframework.converter.MoDataAction;
import se.ericsson.cello.aueframework.converter.MoDataWrapper;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.omf.aue.common.db.DbWrapper;
import se.ericsson.crbs.omf.aue.common.db.DbWrapperFactory;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;

public class GetTableTestAction
implements MoDataAction {
    private static final String DEFAULT_PATH = "/c/usr/tabledata/";
    private static final String PARAM_TABLE_NAMES = "tableNames";
    private static final String TABLE_NAMES_SEPARATOR = ",";
    private static final String PARAM_PATH = "path";
    private static final Class THIS_CLASS = GetTableTestAction.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private DbWrapper dbWrapper = null;

    public void perform(MoDataWrapper moDataWrapper, ConverterContext converterContext, Coordinator coordinator) throws AueException {
        logger.traceEnter(THIS_CLASS, "perform()");
        logger.traceError(THIS_CLASS, "Test action '" + THIS_CLASS.getName() + "' for step 2 is included in modification file!");
        try {
            this.dbWrapper = DbWrapperFactory.getInstance().getDbWrapper();
            this.dbWrapper.openConnection();
            Map map = (Map)converterContext.getAttribute("moActionArgMap");
            List list = this.getTableNames(map);
            String string = this.getPath(map);
            this.writeTableDataToFile(string, list);
        }
        catch (Exception exception) {
            String string = "The " + THIS_CLASS.getName() + " failed!";
            logger.traceError(THIS_CLASS, AueUtil.appendReason((String)string, (Throwable)exception), (Throwable)exception);
            throw new AueException(AueUtil.appendReason((String)string, (Throwable)exception), (Throwable)exception);
        }
        finally {
            try {
                this.dbWrapper.closeConnection(2);
            }
            catch (Exception exception) {}
        }
        logger.traceReturn(THIS_CLASS, "perform()");
    }

    private String getPath(Map map) {
        String string = DEFAULT_PATH;
        try {
            string = this.getAndCheckParamMapString(PARAM_PATH, map, "");
        }
        catch (AueException aueException) {
            // empty catch block
        }
        return string;
    }

    private List getTableNames(Map map) throws AueException {
        String string = this.getAndCheckParamMapString(PARAM_TABLE_NAMES, map, "The tableNames is not specified in " + AueUtil.doubleQuote((String)this.getClass().getName()));
        StringTokenizer stringTokenizer = new StringTokenizer(string, TABLE_NAMES_SEPARATOR);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTableDataToFile(String string, List list) throws IOException, SQLException {
        BufferedWriter bufferedWriter = null;
        ResultSet resultSet = null;
        new File(string).mkdir();
        try {
            for (int i = 0; i < list.size(); ++i) {
                FileWriter fileWriter = new FileWriter(string + list.get(i).toString() + "_" + this.getDate() + ".txt");
                bufferedWriter = new BufferedWriter(fileWriter);
                String string2 = "SELECT * FROM " + list.get(i).toString();
                resultSet = this.dbWrapper.executeQuery(string2);
                if (resultSet == null) continue;
                this.writeResultSetToFile(bufferedWriter, resultSet);
            }
        }
        finally {
            if (bufferedWriter != null) {
                bufferedWriter.close();
            }
            if (resultSet != null) {
                resultSet.close();
            }
        }
    }

    private void writeResultSetToFile(BufferedWriter bufferedWriter, ResultSet resultSet) throws SQLException, IOException {
        int n = resultSet.getMetaData().getColumnCount();
        while (resultSet.next()) {
            for (int i = 0; i < n; ++i) {
                if (i <= 0) continue;
                Object object = resultSet.getObject(i + 1);
                if (object == null || resultSet.wasNull()) {
                    bufferedWriter.write("NULL");
                } else {
                    bufferedWriter.write(object.toString());
                }
                bufferedWriter.write("\t");
            }
            bufferedWriter.write("\n");
        }
    }

    private String getDate() {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss");
        String string = simpleDateFormat.format(calendar.getTime());
        return string;
    }

    private String getAndCheckParamMapString(String string, Map map, String string2) throws AueException {
        String string3 = (String)map.get(string);
        if (string3 == null || string3.equals("")) {
            throw new AueException(string2);
        }
        return string3;
    }
}

