/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.aue.step2.actions.it12;

import se.ericsson.cello.equipment.PlugInUnitMoInternal;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.step2.mao.MoRepositoryWrapper;
import se.ericsson.crbs.omf.aue.step2.mao.MoRepositoryWrapperFactory;

public class TriggerReconfigurationOfPlugInUnit {
    private static final String PLUG_IN_UNIT = "PlugInUnit";
    private static final Class THIS_CLASS = TriggerReconfigurationOfPlugInUnit.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final Coordinator coordinator;

    public TriggerReconfigurationOfPlugInUnit(Coordinator coordinator) {
        this.coordinator = coordinator;
    }

    public void execute() {
        logger.traceEnter(THIS_CLASS, "execute()");
        MoRepositoryWrapper moRepositoryWrapper = MoRepositoryWrapperFactory.getInstance().getMoRepositoryWrapper();
        MoIterator moIterator = moRepositoryWrapper.lookupType(PLUG_IN_UNIT);
        if (moIterator != null) {
            while (moIterator.hasMoreElements()) {
                PlugInUnitMoInternal plugInUnitMoInternal = (PlugInUnitMoInternal)moIterator.nextMo();
                try {
                    plugInUnitMoInternal.updateMoConfiguration(this.coordinator);
                    logger.traceGeneral(THIS_CLASS, "Configuration updated for: " + plugInUnitMoInternal);
                }
                catch (MoAccessException moAccessException) {
                    logger.traceError(THIS_CLASS, "Unable to update configuration for: " + plugInUnitMoInternal + ", due to: " + (Object)((Object)moAccessException));
                }
            }
        }
        logger.traceReturn(THIS_CLASS, "execute()");
    }
}

