/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.aue.step2.actions.it12;

import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.step2.mao.MoRepositoryWrapper;
import se.ericsson.crbs.omf.aue.step2.mao.MoRepositoryWrapperFactory;

public class UpdateDuRecoverySettings {
    private static final Class THIS_CLASS = UpdateDuRecoverySettings.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final Integer RESTARTS_WITH_WARM = new Integer(3);
    private static final Integer PIU_GROUP_NUMBER_1 = new Integer(1);
    private static final Integer ROLLBACK_INIT_COUNTER_VALUE_5 = new Integer(5);
    private static final String CONFIGURATION_VERSION_TYPE_NAME = "ConfigurationVersion";
    private static final String CONFIGURATION_VERSION_ROLLBACK_INIT_COUNTER_VALUE = "rollbackInitCounterValue";
    private final Coordinator coordinator;

    public UpdateDuRecoverySettings(Coordinator coordinator) {
        this.coordinator = coordinator;
    }

    public void execute() {
        logger.traceEnter(THIS_CLASS, "execute()");
        MoRepositoryWrapper moRepositoryWrapper = MoRepositoryWrapperFactory.getInstance().getMoRepositoryWrapper();
        this.setAttributes("PlugInUnit", new String[]{"allowedSeqRestarts", "piuGroupNumber"}, new Integer[]{RESTARTS_WITH_WARM, PIU_GROUP_NUMBER_1}, moRepositoryWrapper);
        this.setAttributes(CONFIGURATION_VERSION_TYPE_NAME, new String[]{CONFIGURATION_VERSION_ROLLBACK_INIT_COUNTER_VALUE}, new Integer[]{ROLLBACK_INIT_COUNTER_VALUE_5}, moRepositoryWrapper);
        logger.traceReturn(THIS_CLASS, "execute()");
    }

    private void setAttributes(String string, String[] stringArray, Integer[] integerArray, MoRepositoryWrapper moRepositoryWrapper) {
        MoIterator moIterator = moRepositoryWrapper.lookupType(string);
        if (moIterator != null) {
            while (moIterator.hasMoreElements()) {
                ManagedObject managedObject = moIterator.nextMo();
                for (int i = 0; i < stringArray.length; ++i) {
                    try {
                        managedObject.setAttribute(stringArray[i], (Object)integerArray[i], this.coordinator);
                        logger.traceDebug(THIS_CLASS, string + "::" + stringArray[i] + " set to " + integerArray[i]);
                        continue;
                    }
                    catch (MoAccessException moAccessException) {
                        logger.traceError(THIS_CLASS, "Exception caught when setting attribute " + string + "::" + stringArray[i] + " to " + integerArray[i] + ".", (Throwable)moAccessException);
                    }
                }
            }
        }
    }
}

