/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.aue.step2.actions.it20;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import se.ericsson.cello.aueframework.common.AueException;
import se.ericsson.cello.aueframework.converter.ConverterContext;
import se.ericsson.cello.aueframework.converter.FindMoDataByLDNFilter;
import se.ericsson.cello.aueframework.converter.MoDataAccessor;
import se.ericsson.cello.aueframework.converter.MoDataAction;
import se.ericsson.cello.aueframework.converter.MoDataFilter;
import se.ericsson.cello.aueframework.converter.MoDataWrapper;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.LongAttribute;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StructAttribute;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.lte.rbs.omf.aue.step2.AuePersistencyUtilWrapper;

public class SetEUtranFreqToQciProfileRelationAttributeAction
implements MoDataAction {
    private static final Class THIS_CLASS = SetEUtranFreqToQciProfileRelationAttributeAction.class;
    private static final String QCI_1_LDN = "ManagedElement=1,ENodeBFunction=1,QciTable=default,QciProfilePredefined=qci1";
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    public void perform(MoDataWrapper moDataWrapper, ConverterContext converterContext, Coordinator coordinator) throws AueException {
        logger.traceEnter(THIS_CLASS, "perform()");
        List list = AuePersistencyUtilWrapper.getAuePersistencyUtil().retrieveFromAuePersistency(converterContext, "SetEUtranFreqToQciProfileRelationAttributeAction");
        logger.traceDebug(THIS_CLASS, "Found " + list.size() + " rows in AuePersistency.");
        Iterator iterator = list.iterator();
        String string = null;
        if (iterator.hasNext()) {
            MoDataAccessor moDataAccessor = converterContext.getMoDataAccessor();
            Collection collection = moDataAccessor.getByType("QciProfilePredefined");
            if (collection == null) {
                throw new CrbsAueException("Could not get any QciProfilePredefined MOs.");
            }
            string = this.getQciProfilePredefinedQci1Ldn(collection);
            logger.traceDebug(THIS_CLASS, "QciProfilePredefined QCI1 LDN: " + string);
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                logger.traceDebug(THIS_CLASS, "EUtranFreqRelation LDN: " + string2);
                MoDataAccessor moDataAccessor2 = converterContext.getMoDataAccessor();
                MoDataWrapper moDataWrapper2 = moDataAccessor2.findFirst((MoDataFilter)new FindMoDataByLDNFilter(string2));
                if (moDataWrapper2 == null) {
                    throw new CrbsAueException("Could not find the EUtranFreqRelation MO mentioned in AuePersistency table: " + string2);
                }
                SequenceAttribute sequenceAttribute = (SequenceAttribute)moDataWrapper2.getAttribute("eutranFreqToQciProfileRelation");
                StructAttribute structAttribute = new StructAttribute("eutranFreqToQciProfileRelation", false);
                LongAttribute longAttribute = new LongAttribute("lbA4ThresholdRsrpOffset", false);
                longAttribute.setValue(0L);
                LongAttribute longAttribute2 = new LongAttribute("lbQciProfileHandling", false);
                longAttribute2.setValue(1L);
                ReferenceAttribute referenceAttribute = new ReferenceAttribute("qciProfileRef", string, false);
                structAttribute.addElement((Attribute)longAttribute);
                structAttribute.addElement((Attribute)longAttribute2);
                structAttribute.addElement((Attribute)referenceAttribute);
                sequenceAttribute.addElement((Attribute)structAttribute);
                logger.traceDebug(THIS_CLASS, "EUtranFreqRelation add to sequence.");
            }
        }
        logger.traceReturn(THIS_CLASS, "perform()");
    }

    private String getQciProfilePredefinedQci1Ldn(Collection collection) throws CrbsAueException {
        String string = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            MoDataWrapper moDataWrapper = (MoDataWrapper)iterator.next();
            String string2 = moDataWrapper.getLocalDistinguishedName();
            logger.traceError(THIS_CLASS, "QciProfilePredefined LDN: " + string2);
            if (!QCI_1_LDN.equalsIgnoreCase(string2)) continue;
            logger.traceError(THIS_CLASS, "Find right ManagedObject matching ldn: " + string2);
            string = string2;
            break;
        }
        if (string == null) {
            throw new CrbsAueException("Could not get QciProfilePredefined MO with LDN: ManagedElement=1,ENodeBFunction=1,QciTable=default,QciProfilePredefined=qci1");
        }
        return string;
    }
}

