/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.aue.step2.actions.it23;

import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.step2.mao.MoRepositoryWrapper;
import se.ericsson.crbs.omf.aue.step2.mao.MoRepositoryWrapperFactory;

public class ChangeFeatureInactTrigPUCCHRelAtHighLoadUserLabel {
    private static final Class THIS_CLASS = ChangeFeatureInactTrigPUCCHRelAtHighLoadUserLabel.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String MO_TYPE_OPTIONAL_FEATURE_LICENSE = "OptionalFeatureLicense";
    private static final String RDN_INACTIVITY_TRIGGERED_PUCCH_RELEASE_AT_HIGH_LOAD = "OptionalFeatureLicense=InactTrigPUCCHRelAtHighLoad";
    private static final String RDN_LOAD_BASED_UL_TAT_ADJUSTMENT = "OptionalFeatureLicense=LoadBasedUlTatAdjustment";
    private static final String OLD_USER_LABEL = "Load-based Uplink Time Alignment Timer Adjustment";
    private static final String NEW_USER_LABEL = "Inactivity-Triggered PUCCH Release at High Load";
    private static final String ATTR_NAME_USER_LABEL = "userLabel";
    private static final String ATTR_NAME_KEY_ID = "keyId";
    private static final String INACTIVITY_TRIGGERED_PUCCH_RELEASE_AT_HIGH_LOAD_KEY_ID = "CXC4011941";
    private final Coordinator coordinator;

    public ChangeFeatureInactTrigPUCCHRelAtHighLoadUserLabel(Coordinator coordinator) {
        this.coordinator = coordinator;
    }

    public void execute() throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "execute()");
        MoRepositoryWrapper moRepositoryWrapper = MoRepositoryWrapperFactory.getInstance().getMoRepositoryWrapper();
        MoIterator moIterator = moRepositoryWrapper.lookupType(MO_TYPE_OPTIONAL_FEATURE_LICENSE);
        if (moIterator != null) {
            while (moIterator.hasMoreElements()) {
                this.checkAndModifyOptionalFeatureLicenseMo(moIterator.nextMo());
            }
        }
        logger.traceReturn(THIS_CLASS, "execute()");
    }

    private void checkAndModifyOptionalFeatureLicenseMo(ManagedObject managedObject) throws CrbsAueException {
        try {
            String string = managedObject.getRelativeDistinguishedName();
            if ((RDN_INACTIVITY_TRIGGERED_PUCCH_RELEASE_AT_HIGH_LOAD.equals(string) || RDN_LOAD_BASED_UL_TAT_ADJUSTMENT.equals(string)) && INACTIVITY_TRIGGERED_PUCCH_RELEASE_AT_HIGH_LOAD_KEY_ID.equals(managedObject.getAttribute(ATTR_NAME_KEY_ID, this.coordinator)) && OLD_USER_LABEL.equals(managedObject.getAttribute(ATTR_NAME_USER_LABEL, this.coordinator))) {
                managedObject.setAttribute(ATTR_NAME_USER_LABEL, (Object)NEW_USER_LABEL, this.coordinator);
            }
        }
        catch (NoSuchAttributeException noSuchAttributeException) {
            throw new CrbsAueException("Attribute userLabel or keyId is not found on OptionalFeatureLicense", (Throwable)noSuchAttributeException);
        }
        catch (MoAccessException moAccessException) {
            throw new CrbsAueException("Failed to update attribute userLabel on OptionalFeatureLicense", (Throwable)moAccessException);
        }
    }
}

