/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.omf.aue.step2.actions;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import se.ericsson.cello.aueframework.common.AueException;
import se.ericsson.cello.aueframework.converter.ConverterContext;
import se.ericsson.cello.aueframework.converter.FindMoDataByLDNFilter;
import se.ericsson.cello.aueframework.converter.MoDataAccessor;
import se.ericsson.cello.aueframework.converter.MoDataAction;
import se.ericsson.cello.aueframework.converter.MoDataFilter;
import se.ericsson.cello.aueframework.converter.MoDataWrapper;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.StructAttribute;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.FindMoDataByParentLDNFilter;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.step2.actions.AddStructAttributeAction;
import se.ericsson.crbs.omf.aue.step2.actions.DeleteAllMoInstancesAction;
import se.ericsson.crbs.omf.aue.step2.actions.util.Step2Handler;

public class CompleteIruMaoConfigurationAction
implements MoDataAction {
    private static final Class THIS_CLASS = CompleteIruMaoConfigurationAction.class;
    private static Step2Handler step2Handler;
    private static MoDataAccessor moDataAccessor;
    private static final AbstractLogger logger;
    private static final String IRU_CONF_TO_BE_COMPLETED = "irusMoToBeCompleted";
    private static final int NB_OF_RD_PER_IRU = 8;
    private static final String AUX_PIU_MO_TYPE_NAME = "AuxPlugInUnit";
    private static final String DEV_GRP_MO_TYPE_NAME = "DeviceGroup";
    private static final String RDI_PORT_MO_TYPE_NAME = "RdiPort";
    private static final String RDI_DEV_SET_MO_TYPE_NAME = "RdicDeviceSet";
    private static final String AUX_PIU_IDENTITY_ATTR_NAME = "AuxPlugInUnitId";
    private static final String DEV_GRP_IDENTITY_ATTR_NAME = "DeviceGroupId";
    private static final String DEV_SET_IDENTITY_ATTR_NAME = "RdicDeviceSetId";
    private static final String RDI_PORT_IDENTITY_ATTR_NAME = "rdiPortId";
    private static final String REMOTE_RDI_PORT_REF_ATTR_NAME = "remoteRdiPortRef";
    private static final String RESERVED_BY_ATTR_NAME = "reservedBy";
    private static final String AUX_PIU_POSITION_ATTR_NAME = "position";
    private static final String AUX_PIU_POS_REF_ATTR_NAME = "positionRef";
    private static final String AUX_PIU_POS_INFO_ATTR_NAME = "positionInformation";
    private static final String AUX_PIU_POS_COORD_ATTR_NAME = "positionCoordinates";
    private static final String AUX_PIU_TYPE_REF_ATTR_NAME = "piuType";
    private static final String AUX_PIU_TYPE_REF_ATTR_VALUE = "ManagedElement=1,SwManagement=1,PiuType=INITIALRBSRD_*";
    private static final String XML_STRING_FRO_ID = "froId";
    private static int dotId;
    private static int rdiPortId;
    private static int auxPiuRdiFroIdGen;
    private static int deviceGrpFroIdGen;
    private static int rdiPortFroIdGen;
    private static int rdicDevSetFroIdGen;
    private static final String DEV_GRP_IDENTITY = "rd";
    private static final String DEV_SET_IDENTITY = "rdic";
    private static final int RDI_PORT_IDENTITY = 1;
    private static final int RDI_PORT_IRU_IDENTITY = 1;

    public void perform(MoDataWrapper dummyDataWrapper, ConverterContext converterContext, Coordinator coordinator) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "perform()");
        String iruLdns = "";
        String tmpAuxPiuLdn = "";
        moDataAccessor = converterContext.getMoDataAccessor();
        step2Handler = (Step2Handler)converterContext.getAttribute("CURRENT_STEP2_HANDLER");
        logger.traceGeneral(THIS_CLASS, "AUE2: Starting to check if any pre-existing RD already configured on node.");
        if (this.checkExistingRdsInConfiguration(converterContext)) {
            logger.traceGeneral(THIS_CLASS, "AUE2: Pre-existing RD already configured on node (matched on piuType). RD-related AUE will NOT be executed on this node.");
            return;
        }
        logger.traceGeneral(THIS_CLASS, "AUE2: No pre-existing RD on node, continuing AUE2 action.");
        this.deleteExistingConfig(converterContext, coordinator);
        iruLdns = step2Handler.retrieveFromAuePersistency("", IRU_CONF_TO_BE_COMPLETED);
        int totalNbOfAuxPiu = this.checkTotalNumberOfExistingAuxPiu(converterContext);
        int totalNbOfDevGrp = this.checkTotalNumberOfExistingDevGrp(converterContext);
        auxPiuRdiFroIdGen += totalNbOfAuxPiu;
        deviceGrpFroIdGen += totalNbOfDevGrp;
        if (iruLdns != null && iruLdns.length() > 0) {
            BufferedReader reader = new BufferedReader(new StringReader(iruLdns));
            try {
                while ((tmpAuxPiuLdn = reader.readLine()) != null) {
                    logger.traceDebug(THIS_CLASS, "AuxPlugInUnit type IRU found" + tmpAuxPiuLdn);
                    String parentLdn = this.fetchIruDeviceGroupLdn(tmpAuxPiuLdn, converterContext);
                    this.createRadioDotsConnctedToThisIru(converterContext, tmpAuxPiuLdn, coordinator);
                    this.createRdicDeviceSet(parentLdn, coordinator);
                    this.createIruRdiPorts(tmpAuxPiuLdn, coordinator);
                }
            }
            catch (IOException ioex) {
                logger.traceError(THIS_CLASS, "AUE 2 Action Upgrade CompleteIruMaoConfigurationAction failed");
                CrbsAueException cae = new CrbsAueException(ioex.getMessage());
                throw cae;
            }
        }
        logger.traceReturn(THIS_CLASS, "perform() executed");
    }

    private boolean checkExistingRdsInConfiguration(ConverterContext converterContext) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "checkExistingRdsInConfig");
        MoDataAccessor accessor = converterContext.getMoDataAccessor();
        String rdPiuType = "PiuType=INITIALRBSRD_*";
        if (accessor == null) {
            logger.traceAbnormal(THIS_CLASS, "MoDataAccessor accessor is null");
        } else {
            Collection AuxPlugInUnitMos = converterContext.getMoDataAccessor().getByType(AUX_PIU_MO_TYPE_NAME);
            Iterator AuxPlugInUnitMosMoIter = AuxPlugInUnitMos.iterator();
            while (AuxPlugInUnitMosMoIter.hasNext()) {
                MoDataWrapper realMoDataWrapper = (MoDataWrapper)AuxPlugInUnitMosMoIter.next();
                String ldn = realMoDataWrapper.getLocalDistinguishedName();
                logger.traceGeneral(THIS_CLASS, "AUE2: AUXPIU LDN: " + ldn);
                String AuxPlugInUnitPiuType = ((ReferenceAttribute)realMoDataWrapper.getAttribute(AUX_PIU_TYPE_REF_ATTR_NAME)).getReferenceAsLDN();
                int start = AuxPlugInUnitPiuType.lastIndexOf("PiuType=");
                String inputPiuType = AuxPlugInUnitPiuType.substring(start);
                logger.traceGeneral(THIS_CLASS, "AUE2: AUXPIU PIUTYPE: " + inputPiuType);
                if (!"PiuType=INITIALRBSRD_*".equals(inputPiuType)) continue;
                logger.traceGeneral(THIS_CLASS, "RD PiuType found!");
                return true;
            }
        }
        logger.traceReturn(THIS_CLASS, "checkExistingRdsInConfig() executed");
        return false;
    }

    private void deleteExistingConfig(ConverterContext converterContext, Coordinator coordinator) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "deleteExistingRdiPorts()");
        MoDataAccessor accessor = converterContext.getMoDataAccessor();
        DeleteAllMoInstancesAction deleteAllMoInstancesAction = new DeleteAllMoInstancesAction();
        if (accessor == null) {
            logger.traceAbnormal(THIS_CLASS, "MoDataAccessor accessor is null");
        } else {
            try {
                MoDataWrapper realMoDataWrapper;
                Collection rdiPortsMos = converterContext.getMoDataAccessor().getByType(RDI_PORT_MO_TYPE_NAME);
                Collection rdiDevSetMos = converterContext.getMoDataAccessor().getByType(RDI_DEV_SET_MO_TYPE_NAME);
                Iterator rdiPortsMosMoIter = rdiPortsMos.iterator();
                Iterator rdiDevSetMosMoIter = rdiDevSetMos.iterator();
                while (rdiPortsMosMoIter.hasNext()) {
                    realMoDataWrapper = (MoDataWrapper)rdiPortsMosMoIter.next();
                    deleteAllMoInstancesAction.perform(realMoDataWrapper, converterContext, coordinator);
                }
                while (rdiDevSetMosMoIter.hasNext()) {
                    realMoDataWrapper = (MoDataWrapper)rdiDevSetMosMoIter.next();
                    deleteAllMoInstancesAction.perform(realMoDataWrapper, converterContext, coordinator);
                }
            }
            catch (AueException ae) {
                this.throwException(ae);
            }
        }
        logger.traceReturn(THIS_CLASS, "deleteExistingRdiPorts() executed");
    }

    private int checkTotalNumberOfExistingAuxPiu(ConverterContext converterContext) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "checkTotalNumberOfExistingAuxPiu() ");
        Collection mos = converterContext.getMoDataAccessor().getByType(AUX_PIU_MO_TYPE_NAME);
        logger.traceReturn(THIS_CLASS, "checkTotalNumberOfExistingAuxPiu() executed");
        return mos.size();
    }

    private int checkTotalNumberOfExistingDevGrp(ConverterContext converterContext) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "checkTotalNumberOfExistingDevGrp() ");
        Collection mos = converterContext.getMoDataAccessor().getByType(DEV_GRP_MO_TYPE_NAME);
        logger.traceReturn(THIS_CLASS, "checkTotalNumberOfExistingAuxPiu() executed");
        return mos.size();
    }

    private void createRadioDotsConnctedToThisIru(ConverterContext context, String iruAuxPiuLdn, Coordinator coordinator) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "createRadioDotsConnctedToThisIru()");
        String auxPiuDotLdn = "";
        String rdiLdn = "";
        String devGrpDotLdn = "";
        int rdiId = 1;
        String remoteIruRdiRefLdn = "";
        for (int i = 0; i < 8; ++i) {
            try {
                auxPiuDotLdn = "ManagedElement=1,Equipment=1,AuxPlugInUnit=RD-" + Integer.toString(dotId);
                devGrpDotLdn = auxPiuDotLdn + ",DeviceGroup=" + DEV_GRP_IDENTITY;
                rdiLdn = auxPiuDotLdn + "," + RDI_PORT_MO_TYPE_NAME + "=1";
                remoteIruRdiRefLdn = iruAuxPiuLdn + "," + RDI_PORT_MO_TYPE_NAME + "=" + rdiId;
                MoDataWrapper radDotMo = moDataAccessor.create(auxPiuDotLdn, coordinator);
                radDotMo.handleTransaction(coordinator, MoData.WRITE_ACCESS);
                this.addFroIdAttribute(radDotMo, Integer.toString(auxPiuRdiFroIdGen));
                this.addStringAttribute(radDotMo, AUX_PIU_IDENTITY_ATTR_NAME, "RD-" + Integer.toString(dotId));
                this.addIntegerAttribute(radDotMo, AUX_PIU_POSITION_ATTR_NAME);
                this.addStringAttribute(radDotMo, AUX_PIU_POS_INFO_ATTR_NAME, "");
                this.addReferenceAttribute(radDotMo, AUX_PIU_POS_REF_ATTR_NAME, "EMPTY");
                this.addReferenceAttribute(radDotMo, AUX_PIU_TYPE_REF_ATTR_NAME, AUX_PIU_TYPE_REF_ATTR_VALUE);
                this.addReservedByAttribute(radDotMo, "", coordinator);
                this.addPositionStructAttribute(iruAuxPiuLdn, radDotMo, context, coordinator);
                this.updatePiuTypeReservedBy(auxPiuDotLdn, coordinator, context);
                ++auxPiuRdiFroIdGen;
                MoDataWrapper devGrpMo = moDataAccessor.create(devGrpDotLdn, coordinator);
                devGrpMo.handleTransaction(coordinator, MoData.WRITE_ACCESS);
                this.addFroIdAttribute(devGrpMo, Integer.toString(deviceGrpFroIdGen));
                this.addStringAttribute(devGrpMo, DEV_GRP_IDENTITY_ATTR_NAME, DEV_GRP_IDENTITY);
                ++deviceGrpFroIdGen;
                MoDataWrapper rdiPortMo = moDataAccessor.create(rdiLdn, coordinator);
                rdiPortMo.handleTransaction(coordinator, MoData.WRITE_ACCESS);
                this.addFroIdAttribute(rdiPortMo, Integer.toString(rdiPortFroIdGen));
                this.addStringAttribute(rdiPortMo, RDI_PORT_IDENTITY_ATTR_NAME, Integer.toString(1));
                this.addReferenceAttribute(rdiPortMo, REMOTE_RDI_PORT_REF_ATTR_NAME, remoteIruRdiRefLdn);
                this.addReservedByAttribute(rdiPortMo, remoteIruRdiRefLdn, coordinator);
                ++dotId;
                ++rdiId;
                ++rdiPortFroIdGen;
                continue;
            }
            catch (AueException ae) {
                this.throwException(ae);
            }
        }
        logger.traceReturn(THIS_CLASS, "createRadioDotsConnctedToThisIru() executed");
    }

    private void createRdicDeviceSet(String parentLdn, Coordinator coordinator) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "createRdicDeviceSet() belongning to IRU:" + parentLdn);
        String devSetLdn = parentLdn + ",RdicDeviceSet=" + DEV_SET_IDENTITY;
        try {
            MoDataWrapper devSetMo = moDataAccessor.create(devSetLdn, coordinator);
            devSetMo.handleTransaction(coordinator, MoData.WRITE_ACCESS);
            this.addFroIdAttribute(devSetMo, Integer.toString(rdicDevSetFroIdGen));
            this.addStringAttribute(devSetMo, DEV_SET_IDENTITY_ATTR_NAME, DEV_SET_IDENTITY);
            ++rdicDevSetFroIdGen;
        }
        catch (AueException ae) {
            this.throwException(ae);
        }
        logger.traceReturn(THIS_CLASS, "createRdicDeviceSet() executed");
    }

    private void createIruRdiPorts(String iruAuxPiuLdn, Coordinator coordinator) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "createIruRdiPorts() port belongning to IRU:" + iruAuxPiuLdn);
        try {
            for (int i = 0; i < 8; ++i) {
                String iruRdiPortLdn = iruAuxPiuLdn + "," + RDI_PORT_MO_TYPE_NAME + "=" + Integer.toString(i + 1);
                String remoteRdRdiRefLdn = "ManagedElement=1,Equipment=1,AuxPlugInUnit=RD-" + rdiPortId + ",RdiPort=1";
                MoDataWrapper iruRdiPortMo = moDataAccessor.create(iruRdiPortLdn, coordinator);
                iruRdiPortMo.handleTransaction(coordinator, MoData.WRITE_ACCESS);
                this.addFroIdAttribute(iruRdiPortMo, Integer.toString(rdiPortFroIdGen));
                this.addStringAttribute(iruRdiPortMo, RDI_PORT_IDENTITY_ATTR_NAME, Integer.toString(1));
                this.addReferenceAttribute(iruRdiPortMo, REMOTE_RDI_PORT_REF_ATTR_NAME, remoteRdRdiRefLdn);
                this.addReservedByAttribute(iruRdiPortMo, remoteRdRdiRefLdn, coordinator);
                ++rdiPortFroIdGen;
                ++rdiPortId;
                logger.traceReturn(THIS_CLASS, "createRdicDeviceSet() executed");
            }
        }
        catch (AueException ae) {
            this.throwException(ae);
        }
    }

    private String fetchIruDeviceGroupLdn(String auxPiuLdn, ConverterContext converterContext) throws CrbsAueException {
        String devGroupLdn;
        block5: {
            logger.traceEnter(THIS_CLASS, "fetchIruDeviceGroupLdn() belongning to IRU:" + auxPiuLdn);
            devGroupLdn = "";
            try {
                MoDataAccessor moDataAccessor = converterContext.getMoDataAccessor();
                Collection children = moDataAccessor.find((MoDataFilter)new FindMoDataByParentLDNFilter(auxPiuLdn));
                if (children != null) {
                    Iterator childIter = children.iterator();
                    while (childIter.hasNext()) {
                        MoDataWrapper moDataWrapper = (MoDataWrapper)childIter.next();
                        if (moDataWrapper.getMoTypeName().compareTo(DEV_GRP_MO_TYPE_NAME) == 0) {
                            devGroupLdn = moDataWrapper.getLocalDistinguishedName();
                            break block5;
                        }
                        logger.traceGeneral(THIS_CLASS, "Got child " + devGroupLdn);
                    }
                    break block5;
                }
                logger.traceAbnormal(THIS_CLASS, " IRUI has No device group: " + auxPiuLdn);
            }
            catch (AueException ae) {
                this.throwException(ae);
            }
        }
        logger.traceReturn(THIS_CLASS, "fetchIruDeviceGroupLdn() executed");
        return devGroupLdn;
    }

    private void addFroIdAttribute(MoDataWrapper dummyDataWrapper, String froId) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "addFroIdAttribute()");
        IntegerAttribute froIdAttribute = new IntegerAttribute(XML_STRING_FRO_ID, false, Integer.parseInt(froId));
        dummyDataWrapper.registerPersistentAttr((Attribute)froIdAttribute);
        logger.traceReturn(THIS_CLASS, "addFroIdAttribute() executed");
    }

    private void addIntegerAttribute(MoDataWrapper dummyDataWrapper, String attributeName) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "addIntegerAttribute()");
        IntegerAttribute intAttribute = new IntegerAttribute(attributeName, false);
        intAttribute.setValue(0);
        dummyDataWrapper.registerPersistentAttr((Attribute)intAttribute);
        logger.traceReturn(THIS_CLASS, "addIntegerAttribute() executed");
    }

    private void addStringAttribute(MoDataWrapper dummyDataWrapper, String attributeName, String attributeValue) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "addStringAttribute()");
        StringAttribute stringAttribute = new StringAttribute(attributeName, false, attributeValue);
        dummyDataWrapper.registerPersistentAttr((Attribute)stringAttribute);
        logger.traceReturn(THIS_CLASS, "addStringAttribute() executed");
    }

    private void addReferenceAttribute(MoDataWrapper moData, String attributeName, String refValue) throws CrbsAueException {
        ReferenceAttribute refAttr;
        logger.traceEnter(THIS_CLASS, "addReferenceAttribute()");
        if (refValue.compareTo("EMPTY") == 0) {
            refAttr = new ReferenceAttribute(attributeName, false);
            refAttr.setValue(null);
        } else {
            refAttr = new ReferenceAttribute(attributeName, refValue, false);
        }
        moData.registerPersistentAttr((Attribute)refAttr);
        logger.traceReturn(THIS_CLASS, "addReferenceAttribute()");
    }

    private void addReservedByAttribute(MoDataWrapper moData, String refLdn, Coordinator coordinator) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "addReservedByAttribute()");
        SequenceAttribute seqAttr = new SequenceAttribute(RESERVED_BY_ATTR_NAME, false);
        if (refLdn.compareTo("") != 0) {
            ReferenceAttribute refAttr = new ReferenceAttribute("", refLdn, false);
            seqAttr.addElement((Attribute)refAttr);
        }
        try {
            moData.registerPersistentAttr((Attribute)seqAttr);
            moData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        }
        catch (AueException ae) {
            this.throwException(ae);
        }
        logger.traceReturn(THIS_CLASS, "addReservedByAttribute()");
    }

    private void addPositionStructAttribute(String iruAuxPiuLdn, MoDataWrapper moData, ConverterContext converterContext, Coordinator coordinator) throws CrbsAueException {
        StructAttribute positionStructAttr = this.fetchRadioPosition(iruAuxPiuLdn, converterContext);
        String NAME_ELEMENT = "nameElement";
        String TYPE_ELEMENT = "typeElement";
        String DEFAULT_VALUE_ELEMENT = "defaultValueElement";
        HashMap<String, String> actionMap = new HashMap<String, String>();
        actionMap.put("name", AUX_PIU_POS_COORD_ATTR_NAME);
        actionMap.put("isAvcNotifier", "false");
        int index = 1;
        IntegerAttribute altitudeAttr = (IntegerAttribute)positionStructAttr.getElement("altitude", coordinator);
        int altitude = altitudeAttr.getValue(coordinator);
        IntegerAttribute latitudeAttr = (IntegerAttribute)positionStructAttr.getElement("latitude", coordinator);
        int latitude = latitudeAttr.getValue(coordinator);
        IntegerAttribute longitudeAttr = (IntegerAttribute)positionStructAttr.getElement("longitude", coordinator);
        int longitude = longitudeAttr.getValue(coordinator);
        StringAttribute geoDatumAttr = (StringAttribute)positionStructAttr.getElement("geoDatum", coordinator);
        String geoDatum = geoDatumAttr.getValue(coordinator);
        actionMap.put("nameElement" + index, "altitude");
        actionMap.put("typeElement" + index, "Integer");
        actionMap.put("defaultValueElement" + index, Integer.toString(altitude));
        actionMap.put("nameElement" + ++index, "latitude");
        actionMap.put("typeElement" + index, "Integer");
        actionMap.put("defaultValueElement" + index, Integer.toString(latitude));
        actionMap.put("nameElement" + ++index, "longitude");
        actionMap.put("typeElement" + index, "Integer");
        actionMap.put("defaultValueElement" + index, Integer.toString(longitude));
        actionMap.put("nameElement" + ++index, "geoDatum");
        actionMap.put("typeElement" + index, "String");
        actionMap.put("defaultValueElement" + index, geoDatum);
        AddStructAttributeAction structAction = new AddStructAttributeAction(actionMap);
        structAction.perform(moData, converterContext, null);
    }

    private StructAttribute fetchRadioPosition(String auxPlugInUnitLdn, ConverterContext converterContext) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "fetchRadioPosition()");
        StructAttribute positionStructAttr = null;
        MoDataAccessor accessor = converterContext.getMoDataAccessor();
        if (accessor == null) {
            logger.traceAbnormal(THIS_CLASS, "MoDataAccessor accessor is null");
        } else {
            try {
                Collection mos = accessor.find((MoDataFilter)new FindMoDataByLDNFilter(auxPlugInUnitLdn));
                Iterator moIter = mos.iterator();
                if (moIter.hasNext()) {
                    MoDataWrapper realMoDataWrapper = (MoDataWrapper)moIter.next();
                    positionStructAttr = (StructAttribute)realMoDataWrapper.getAttribute(AUX_PIU_POS_COORD_ATTR_NAME);
                }
            }
            catch (AueException ae) {
                this.throwException(ae);
            }
        }
        logger.traceReturn(THIS_CLASS, "fetchRadioPosition() executed");
        return positionStructAttr;
    }

    private void updatePiuTypeReservedBy(String auxPlugInUnitLdn, Coordinator coordinator, ConverterContext converterContext) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "updatePiuTypeReservedBy()");
        String reservedByAttrName = RESERVED_BY_ATTR_NAME;
        MoDataAccessor accessor = converterContext.getMoDataAccessor();
        if (accessor == null) {
            logger.traceAbnormal(THIS_CLASS, "MoDataAccessor accessor is null");
        } else {
            try {
                Collection mos = accessor.find((MoDataFilter)new FindMoDataByLDNFilter(AUX_PIU_TYPE_REF_ATTR_VALUE));
                ReferenceAttribute theNewRefAttribute = new ReferenceAttribute("", auxPlugInUnitLdn, false);
                Iterator moIter = mos.iterator();
                while (moIter.hasNext()) {
                    MoDataWrapper realMoDataWrapper = (MoDataWrapper)moIter.next();
                    SequenceAttribute seqAttribute = (SequenceAttribute)realMoDataWrapper.getAttribute(RESERVED_BY_ATTR_NAME);
                    if (seqAttribute == null) {
                        throw new CrbsAueException("Attribute reservedBy do not exist");
                    }
                    seqAttribute.addElement((Attribute)theNewRefAttribute);
                    realMoDataWrapper.handleTransaction(coordinator, MoData.WRITE_ACCESS);
                }
            }
            catch (AueException ae) {
                this.throwException(ae);
            }
        }
        logger.traceReturn(THIS_CLASS, "updatePiuTypeReservedBy() executed");
    }

    private void throwException(AueException ae) throws CrbsAueException {
        CrbsAueException cae = new CrbsAueException(ae.getMessage());
        cae.setStackTrace(ae.getStackTrace());
        throw cae;
    }

    static {
        logger = LoggingService.getLogger((String)THIS_CLASS.getName());
        dotId = 1;
        rdiPortId = 1;
        auxPiuRdiFroIdGen = 0;
        deviceGrpFroIdGen = 0;
        rdiPortFroIdGen = 0;
        rdicDevSetFroIdGen = 0;
    }
}

