/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.omf.aue.step2.actions;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import se.ericsson.cello.aueframework.common.AueException;
import se.ericsson.cello.aueframework.converter.ConverterContext;
import se.ericsson.cello.aueframework.converter.FindMoDataByLDNFilter;
import se.ericsson.cello.aueframework.converter.MoDataAccessor;
import se.ericsson.cello.aueframework.converter.MoDataAction;
import se.ericsson.cello.aueframework.converter.MoDataFilter;
import se.ericsson.cello.aueframework.converter.MoDataWrapper;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.step2.actions.util.Step2Handler;

public class ConvertRiPortRefToRiLinkMao
implements MoDataAction {
    private static final Class THIS_CLASS = ConvertRiPortRefToRiLinkMao.class;
    private static Step2Handler step2Handler;
    private static final AbstractLogger logger;
    private static final String FRO_ID = "froId";
    private static final int RI_LINK_CARDINALITY = 40;
    private static final String RI_LINK_DATA = "riLinkData";
    private static final String RI_LINK_IDENTITY_ATTR = "riLinkId";
    private static final String RI_LINK_RI_PORT_REF1_ATTR = "riPortRef1";
    private static final String RI_LINK_RI_PORT_REF2_ATTR = "riPortRef2";
    private static final String RILINK_LDN = "ManagedElement=1,Equipment=1,RiLink=";

    public void perform(MoDataWrapper dummyDataWrapper, ConverterContext converterContext, Coordinator coordinator) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "perform()");
        String riLinkData = "";
        String tmpRef1Ldn = "";
        String tmpRef2Ldn = "";
        step2Handler = (Step2Handler)converterContext.getAttribute("CURRENT_STEP2_HANDLER");
        for (int riLinkIndex = 1; riLinkIndex < 40; ++riLinkIndex) {
            riLinkData = step2Handler.retrieveFromAuePersistency("", RI_LINK_DATA + riLinkIndex);
            if (riLinkData == null || riLinkData.length() == 0) continue;
            logger.traceDebug(THIS_CLASS, "Ri Link required FOUND");
            tmpRef1Ldn = riLinkData.substring(0, riLinkData.lastIndexOf(38));
            tmpRef2Ldn = riLinkData.substring(riLinkData.lastIndexOf(38) + 1, riLinkData.length());
            boolean ref1MaoExist = this.checkRef1MaoExist(tmpRef1Ldn, converterContext);
            boolean ref2MaoExist = this.checkRef1MaoExist(tmpRef2Ldn, converterContext);
            if (!ref1MaoExist || !ref2MaoExist) {
                throw new CrbsAueException("One of the references ref1 or 2 does not exist");
            }
            String riLinkLdn = RILINK_LDN + riLinkIndex;
            String IdStr = Integer.toString(riLinkIndex);
            String froIdSttr = Integer.toString(riLinkIndex - 1);
            this.createMo(converterContext, IdStr, froIdSttr, tmpRef1Ldn, tmpRef2Ldn, coordinator);
            this.replaceReservedBy(riLinkLdn, tmpRef1Ldn, coordinator, converterContext);
            this.replaceReservedBy(riLinkLdn, tmpRef2Ldn, coordinator, converterContext);
        }
        logger.traceReturn(THIS_CLASS, "perform() executed");
    }

    private void createMo(ConverterContext context, String riLinkId, String riLinkFroId, String ref1Ldn, String ref2Ldn, Coordinator coordinator) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "createMo()");
        MoDataAccessor moDataAccessor = context.getMoDataAccessor();
        try {
            String ldn = RILINK_LDN + riLinkId;
            MoDataWrapper newMo = moDataAccessor.create(ldn, coordinator);
            newMo.handleTransaction(coordinator, MoData.WRITE_ACCESS);
            this.addFroIdAttribute(newMo, riLinkFroId);
            this.addStringAttribute(newMo, RI_LINK_IDENTITY_ATTR, riLinkId);
            this.addReferenceAttribute(newMo, RI_LINK_RI_PORT_REF1_ATTR, ref1Ldn);
            this.addReferenceAttribute(newMo, RI_LINK_RI_PORT_REF2_ATTR, ref2Ldn);
        }
        catch (AueException ae) {
            CrbsAueException cae = new CrbsAueException(ae.getMessage());
            cae.setStackTrace(ae.getStackTrace());
            throw cae;
        }
        logger.traceReturn(THIS_CLASS, "createMo() executed");
    }

    private void addFroIdAttribute(MoDataWrapper moData, String froId) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "addFroIdAttribute()");
        IntegerAttribute froIdAttribute = new IntegerAttribute(FRO_ID, false, Integer.parseInt(froId));
        moData.registerPersistentAttr((Attribute)froIdAttribute);
        logger.traceReturn(THIS_CLASS, "addFroIdAttribute() executed");
    }

    private void addStringAttribute(MoDataWrapper dummyDataWrapper, String attributeName, String attributeValue) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "addStringAttribute()");
        StringAttribute stringAttribute = new StringAttribute(attributeName, false, attributeValue);
        dummyDataWrapper.registerPersistentAttr((Attribute)stringAttribute);
        logger.traceReturn(THIS_CLASS, "addStringAttribute() executed");
    }

    private void addReferenceAttribute(MoDataWrapper moData, String attributeName, String refLdn) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "addReferenceAttribute()");
        ReferenceAttribute refAttr = new ReferenceAttribute(attributeName, refLdn, false);
        moData.registerPersistentAttr((Attribute)refAttr);
        logger.traceReturn(THIS_CLASS, "addReferenceAttribute()");
    }

    private boolean checkRef1MaoExist(String refLdn, ConverterContext converterContext) throws CrbsAueException {
        boolean ref1MaoExist = true;
        logger.traceEnter(THIS_CLASS, "checkRef1MaoExist()");
        MoDataAccessor accessor = converterContext.getMoDataAccessor();
        if (accessor == null) {
            logger.traceAbnormal(THIS_CLASS, "MoDataAccessor accessor is null");
        } else {
            try {
                Collection mos = accessor.find((MoDataFilter)new FindMoDataByLDNFilter(refLdn));
                if (mos != null) {
                    if (mos.size() > 1) {
                        throw new CrbsAueException("More than 1 (" + mos.size() + ") children of " + refLdn);
                    }
                    if (mos.size() == 0) {
                        ref1MaoExist = false;
                    }
                }
            }
            catch (AueException ae) {
                CrbsAueException cae = new CrbsAueException(ae.getMessage());
                cae.setStackTrace(ae.getStackTrace());
                throw cae;
            }
        }
        logger.traceReturn(THIS_CLASS, "addReferenceAttribute()");
        return ref1MaoExist;
    }

    private void replaceReservedBy(String riLinkLdn, String riPortRefLdn, Coordinator coordinator, ConverterContext converterContext) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "replaceReservedBy()");
        String reservedByAttrName = "reservedBy";
        MoDataAccessor accessor = converterContext.getMoDataAccessor();
        if (accessor == null) {
            logger.traceAbnormal(THIS_CLASS, "MoDataAccessor accessor is null");
        } else {
            try {
                Collection mos = accessor.find((MoDataFilter)new FindMoDataByLDNFilter(riPortRefLdn));
                ReferenceAttribute theNewRefAttribute = new ReferenceAttribute("", riLinkLdn, false);
                Iterator moIter = mos.iterator();
                while (moIter.hasNext()) {
                    MoDataWrapper realMoDataWrapper = (MoDataWrapper)moIter.next();
                    SequenceAttribute seqAttribute = (SequenceAttribute)realMoDataWrapper.getAttribute("reservedBy");
                    if (seqAttribute == null) {
                        throw new CrbsAueException("Attribute reservedBy do not exist");
                    }
                    Enumeration enumeration = seqAttribute.elements();
                    while (enumeration.hasMoreElements()) {
                        ReferenceAttribute theOldRefAttribute = (ReferenceAttribute)enumeration.nextElement();
                        seqAttribute.removeElement((Attribute)theOldRefAttribute);
                    }
                    seqAttribute.addElement((Attribute)theNewRefAttribute);
                    realMoDataWrapper.handleTransaction(coordinator, MoData.WRITE_ACCESS);
                }
            }
            catch (AueException ae) {
                CrbsAueException cae = new CrbsAueException(ae.getMessage());
                cae.setStackTrace(ae.getStackTrace());
                throw cae;
            }
        }
        logger.traceReturn(THIS_CLASS, "replaceReservedBy() executed");
    }

    static {
        logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    }
}

