/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.security;

import se.ericsson.cello.mao.Ipv6Address;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;

public class AccountInfo {
    private String remoteHost = null;
    private String userID = null;
    private String password = null;
    public static final String REMOTE_HOST = "remoteHost";
    public static final String USER_ID = "userID";
    public static final String PASSWORD = "password";

    public AccountInfo() throws MoAccessException {
        this.check();
    }

    public AccountInfo(Struct struct) throws MoAccessException {
        String[] stringArray = struct.getNames();
        if (stringArray.length != 3) {
            throw new ValueOutOfRangeException("Missing member in accountInfo", "Security");
        }
        if (!(struct.getValue(USER_ID) instanceof String)) {
            throw new WrongAttributeTypeException(USER_ID, "Security");
        }
        this.userID = (String)struct.getValue(USER_ID);
        if (!(struct.getValue(REMOTE_HOST) instanceof String)) {
            throw new WrongAttributeTypeException(REMOTE_HOST, "Security");
        }
        this.remoteHost = (String)struct.getValue(REMOTE_HOST);
        if (!(struct.getValue(PASSWORD) instanceof String)) {
            throw new WrongAttributeTypeException(PASSWORD, "Security");
        }
        this.password = (String)struct.getValue(PASSWORD);
        this.check();
    }

    protected String getRemoteHost() {
        return this.remoteHost;
    }

    protected String getUserID() {
        return this.userID;
    }

    protected String getPassword() {
        return this.password;
    }

    private void check() throws MoAccessException {
        if (this.remoteHost == null) {
            throw new ValueOutOfRangeException("remoteHost String is NULL", "Security");
        }
        Ipv6Address.validateHostName((String)this.remoteHost, (String)"Security");
        if (this.userID == null || this.userID.length() > 21 || this.userID.length() < 1) {
            throw new ValueOutOfRangeException("userID String too long/empty", "Security");
        }
        if (this.password == null || this.password.length() > 21 || this.password.length() < 1) {
            throw new ValueOutOfRangeException("password String too long/empty", "Security");
        }
    }
}

